#! /bin/bash

##################################################################################
#                                                                                #
#  Counter-Strike : 1.6 Launcher		                                 #
#                                                                                #
#  Author remake: neygomon							 #
#  Original Code: Cr@zy                                                          #
#  Contact: http://www.unserver.ru                                               #
#                                                                                #
#  This program is free software: you can redistribute it and/or modify it       #
#  under the terms of the GNU General Public License as published by the Free    #
#  Software Foundation, either version 3 of the License, or (at your option)     #
#  any later version.                                                            #
#                                                                                #
#  This program is distributed in the hope that it will be useful, but WITHOUT   #
#  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS #
#  FOR A PARTICULAR PURPOSE. See the GNU General Public License for more         #
#  details.                                                                      #
#                                                                                #
#  You should have received a copy of the GNU General Public License along       #
#  with this program.  If not, see http://www.gnu.org/licenses/.                 #
#                                                                                #
#  Usage: /etc/init.d/hlds_launcher {start|stop|status|restart|console|update}   #
#    - start: start the server                                                   #
#    - stop: stop the server                                                     #
#    - status: display the status of the server (down or up)                     #
#    - restart: restart the server                                               #
#    - console: display the server console where you can enter commands.         #
#     To exit the console without stopping the server, press CTRL + A then D.    #
#    - update: update the server                                                 #
#    - apt-get install net-tools htop mc screen original-awk qstat lib32gcc1 lib32z1 sudo unzip lib32stdc++6  #
##################################################################################

### BEGIN INIT INFO
# Provides:          hlds
# Required-Start:    $syslog $local_fs $network
# Required-Stop:     $syslog $local_fs $network
# Should-Start:      $remote_fs $named
# Should-Stop:       $remote_fs $named
# Default-Start:     2 3 4 5
# Default-Stop:      0 1 6
# Short-Description: Start hlds Server
# Description:       hlds Start Script
### END INIT INFO

# Game config
STEAM_LOGIN="anonymous"			#Не менять:) HL1 сервера выкачиваются и с анонимуса:)
SCREEN_NAME="gameserver"		#Название screen-сессии
USER=""							#Пользователь, от которого будем запускать сервер. !!!От root запускать сервера не стоит!!!
DIR_STEAMCMD="/home/$USER/steamcmd"	#root Директория steamCMD
DIR_ROOT="/home/$USER/rehlds"			#root Директория HLDS
DIR_GAME="$DIR_ROOT/cstrike"				#Это не менять:)
DIR_LOG="/home/$USER"
DAEMON_GAME="hlds_run"					#HLDS скрипт | Не менять:)

#Start Распределение серверов по ядрам процессора
USE_CORE="0"						#Ядро, на котором запускать HLDS. 0 - первое ядро, 1 - второе ядро и тд. all - все ядра (дефолт значение)
									#По умолчанию используются все ядра системы, но HLDS - однопроцессорное приложение. 
									#Поэтому данную настройку следует использовать в случае нескольких серверов, чтобы все сервера не легли на одно ядро.
#End Распределение серверов по ядрам процессора
				
MAXPLAYERS="18"					#Количество слотов - 32 максимум ( HL1 limit:c )
SYS_TICRATE="1100"				#sys_ticrate
IP=""								#IP адрес сервера
PORT="27015"						#Порт сервера
EXTRAPARAMS="-pingboost 2 -secure -master"	#Дополнительные параметры запуска

PARAM_START="-game cstrike -port $PORT +ip $IP -maxplayers ${MAXPLAYERS} +sys_ticrate $SYS_TICRATE +map de_dust2 ${EXTRAPARAMS}"
PARAM_UPDATE="+login ${STEAM_LOGIN} +force_install_dir ${DIR_ROOT} +app_update 90 validate +quit"

function start {
  if [ ! -d $DIR_ROOT ]; then echo "ERROR: $DIR_ROOT is not a directory"; exit 1; fi
  if [ ! -x $DIR_ROOT/$DAEMON_GAME ]; then echo "ERROR: $DIR_ROOT/$DAEMON_GAME does not exist or is not executable"; exit 1; fi
  if status; then echo "$SCREEN_NAME is already running"; exit 1; fi

  # Start game
  echo "Start command : ${PARAM_START}"
  if [ $USE_CORE = "all" ]
  then
    echo "HLDS use full proc"
  else
    echo "HLDS use $USE_CORE"
   fi    
	  
  if [ `whoami` = root ]
  then
    cd $DIR_ROOT
	if [ $USE_CORE = "all" ]
	then
	  INIT="screen -AmdS $SCREEN_NAME"
	else
	  INIT="taskset -c $USE_CORE screen -AmdS $SCREEN_NAME"
	fi
	$INIT sudo -u $USER ./$DAEMON_GAME $PARAM_START  
 else
    cd $DIR_ROOT
        if [ $USE_CORE = "all" ]
	then
	  screen -AmdS $SCREEN_NAME ./$DAEMON_GAME $PARAM_START
	else
	  taskset -c $USE_CORE screen -AmdS $SCREEN_NAME ./$DAEMON_GAME $PARAM_START
	fi
  fi
}

function stop {
  if ! status; then echo "$SCREEN_NAME could not be found. Probably not running."; exit 1; fi

  screen -p 0 -S $SCREEN_NAME -X eval 'stuff "quit"\015'
}

function status {
  screen -ls | grep [.]$SCREEN_NAME[[:space:]] > /dev/null
}

function console {
  if ! status; then echo "$SCREEN_NAME could not be found. Probably not running."; exit 1; fi

    screen -r $(ps -ef | grep SCREEN | grep "$SCREEN_NAME" | grep -v grep | awk '{ print $2}')
}

function update {
# Create the game root
   if [ ! -d $DIR_ROOT ]
  then
    echo "$DIR_ROOT does not exist, creating..."
    if [ `whoami` = root ]
    then
      su - $USER -c "mkdir -p $DIR_ROOT";
    else
      mkdir -p "$DIR_ROOT"
    fi
  fi	
# Update or install server
  if [ `whoami` = root ]
  then
    su - $USER -c "cd $DIR_STEAMCMD ; ./steamcmd.sh $PARAM_UPDATE 2>&1"
  else
    cd $DIR_STEAMCMD
    ./steamcmd.sh $PARAM_UPDATE 2>&1
  fi
# Check install server  
  if [ ! -d $DIR_GAME ]; then update; else echo "$SCREEN_NAME update or install successfully"; exit 1; fi

  exit 1
}

function checker {
  checktag="[Checker HLDS]"
  checkresp=`quakestat -P -a2s $IP:$PORT | grep response`
  if [ -n "$checkresp" ] 
  then
    echo "$checktag Server $SCREEN_NAME *[No Response]*"
    cd $DIR_LOG
    time=`date +%X`
    date=`date +%D`
    printf "[$time - $date] Server $SCREEN_NAME *[No response]*\n" >> checker.log  
    #stop
    kill -9 `screen -list | grep "SCREEN_NAME" | awk {'print $1'} | cut -d . -f1`
    screen -wipe > /dev/null
    #sleep 2
    killall hlds_linux
    sleep 2
    start
    exit 1
  fi
  
  checkdown=`quakestat -P -a2s $IP:$PORT | grep DOWN`
  if [ -n "$checkdown" ] 
  then
    echo "$checktag Server $SCREEN_NAME *[DOWN]*"
    cd $DIR_LOG
    time=`date +%X`
    date=`date +%D`
    printf "[$time - $date] Server $SCREEN_NAME *[DOWN]*\n" >> checker.log
    #stop
    if status; then kill -9 `screen -list | grep "SCREEN_NAME" | awk {'print $1'} | cut -d . -f1`; screen -wipe > /dev/null; fi
    sleep 2
    start
    exit 1
  fi

  checkup=`quakestat -P -a2s $IP:$PORT | grep cstrike`
  if [ -n "$checkup" ]
  then
    echo "$checktag Server $SCREEN_NAME *[RUN]*"
    exit 1
  fi
}

function usage {
  echo "Usage: $0 {start|stop|status|restart|console|update|checker}"
  echo "On console, press CTRL+A then D to stop the screen without stopping the server."
}

case "$1" in

  start)
    echo "Starting $SCREEN_NAME..."
    start
    sleep 5
    echo "$SCREEN_NAME started successfully"
  ;;

  stop)
    echo "Stopping $SCREEN_NAME..."
    stop
    sleep 5
    echo "$SCREEN_NAME stopped successfully"
  ;;
 
  restart)
    echo "Restarting $SCREEN_NAME..."
    status && stop
    sleep 5
    start
    sleep 5
    echo "$SCREEN_NAME restarted successfully"
  ;;

  status)
    if status
    then echo "$SCREEN_NAME is UP"
    else echo "$SCREEN_NAME is DOWN"
    fi
  ;;
 
  console)
    echo "Open console on $SCREEN_NAME..."
    console
  ;;
  update)
    echo "Starting the $SCREEN_NAME update..."
    update
  ;;
  checker)
    echo "Check running $SCREEN_NAME..."
    checker
  ;;

  *)
    usage
    exit 1
  ;;

esac

exit 0

