#include "precompiled.h"


enginefuncs_t g_EngineFunctionsTable =
{
	NULL,		// pfnPrecacheModel()
	NULL,		// pfnPrecacheSound()
	NULL,		// pfnSetModel()
	NULL,		// pfnModelIndex()
	NULL,		// pfnModelFrames()
	NULL,		// pfnSetSize()
	NULL,		// pfnChangeLevel()
	NULL,		// pfnGetSpawnParms()
	NULL,		// pfnSaveSpawnParms()
	NULL,		// pfnVecToYaw()
	NULL,		// pfnVecToAngles()
	NULL,		// pfnMoveToOrigin()
	NULL,		// pfnChangeYaw()
	NULL,		// pfnChangePitch()
	NULL,		// pfnFindEntityByString()
	NULL,		// pfnGetEntityIllum()
	NULL,		// pfnFindEntityInSphere()
	NULL,		// pfnFindClientInPVS()
	NULL,		// pfnEntitiesInPVS()
	NULL,		// pfnMakeVectors()
	NULL,		// pfnAngleVectors()
	NULL,		// pfnCreateEntity()
	NULL,		// pfnRemoveEntity()
	NULL,		// pfnCreateNamedEntity()
	NULL,		// pfnMakeStatic()
	NULL,		// pfnEntIsOnFloor()
	NULL,		// pfnDropToFloor()
	NULL,		// pfnWalkMove()
	NULL,		// pfnSetOrigin()
	NULL,		// pfnEmitSound()
	NULL,		// pfnEmitAmbientSound()
	NULL,		// pfnTraceLine()
	NULL,		// pfnTraceToss()
	NULL,		// pfnTraceMonsterHull()
	NULL,		// pfnTraceHull()
	NULL,		// pfnTraceModel()
	NULL,		// pfnTraceTexture()
	NULL,		// pfnTraceSphere()
	NULL,		// pfnGetAimVector()
	NULL,		// pfnServerCommand()
	NULL,		// pfnServerExecute()
	NULL,		// pfnClientCommand()
	NULL,		// pfnParticleEffect()
	NULL,		// pfnLightStyle()
	NULL,		// pfnDecalIndex()
	NULL,		// pfnPointContents()
	NULL,		// pfnMessageBegin()
	NULL,		// pfnMessageEnd()
	NULL,		// pfnWriteByte()
	NULL,		// pfnWriteChar()
	NULL,		// pfnWriteShort()
	NULL,		// pfnWriteLong()
	NULL,		// pfnWriteAngle()
	NULL,		// pfnWriteCoord()
	NULL,		// pfnWriteString()
	NULL,		// pfnWriteEntity()
	NULL,		// pfnCVarRegister()
	NULL,		// pfnCVarGetFloat()
	NULL,		// pfnCVarGetString()
	NULL,		// pfnCVarSetFloat()
	NULL,		// pfnCVarSetString()
	NULL,		// pfnAlertMessage()
	NULL,		// pfnEngineFprintf()
	NULL,		// pfnPvAllocEntPrivateData()
	NULL,		// pfnPvEntPrivateData()
	NULL,		// pfnFreeEntPrivateData()
	NULL,		// pfnSzFromIndex()
	NULL,		// pfnAllocString()
	NULL,		// pfnGetVarsOfEnt()
	NULL,		// pfnPEntityOfEntOffset()
	NULL,		// pfnEntOffsetOfPEntity()
	NULL,		// pfnIndexOfEdict()
	NULL,		// pfnPEntityOfEntIndex()
	NULL,		// pfnFindEntityByVars()
	NULL,		// pfnGetModelPtr()
	NULL,		// pfnRegUserMsg()
	NULL,		// pfnAnimationAutomove()
	NULL,		// pfnGetBonePosition()
	NULL,		// pfnFunctionFromName()
	NULL,		// pfnNameForFunction()
	NULL,		// pfnClientPrintf()
	NULL,		// pfnServerPrint()
	NULL,		// pfnCmd_Args()
	NULL,		// pfnCmd_Argv()
	NULL,		// pfnCmd_Argc()
	NULL,		// pfnGetAttachment()
	NULL,		// pfnCRC32_Init()
	NULL,		// pfnCRC32_ProcessBuffer()
	NULL,		// pfnCRC32_ProcessByte()
	NULL,		// pfnCRC32_Final()
	NULL,		// pfnRandomLong()
	NULL,		// pfnRandomFloat()
	NULL,		// pfnSetView()
	NULL,		// pfnTime()
	NULL,		// pfnCrosshairAngle()
	NULL,		// pfnLoadFileForMe()
	NULL,		// pfnFreeFile()
	NULL,		// pfnEndSection()
	NULL,		// pfnCompareFileTime()
	NULL,		// pfnGetGameDir()
	NULL,		// pfnCvar_RegisterVariable()
	NULL,		// pfnFadeClientVolume()
	NULL,		// pfnSetClientMaxspeed()
	NULL,		// pfnCreateFakeClient()
	NULL,		// pfnRunPlayerMove()
	NULL,		// pfnNumberOfEntities()
	NULL,		// pfnGetInfoKeyBuffer()
	NULL,		// pfnInfoKeyValue()
	NULL,		// pfnSetKeyValue()
	NULL,		// pfnSetClientKeyValue()
	NULL,		// pfnIsMapValid()
	NULL,		// pfnStaticDecal()
	NULL,		// pfnPrecacheGeneric()
	NULL,		// pfnGetPlayerUserId()
	NULL,		// pfnBuildSoundMsg()
	NULL,		// pfnIsDedicatedServer()
	NULL,		// pfnCVarGetPointer()
	NULL,		// pfnGetPlayerWONId()
	NULL,		// pfnInfo_RemoveKey()
	NULL,		// pfnGetPhysicsKeyValue()
	NULL,		// pfnSetPhysicsKeyValue()
	NULL,		// pfnGetPhysicsInfoString()
	NULL,		// pfnPrecacheEvent()
	NULL,		// pfnPlaybackEvent()
	NULL,		// pfnSetFatPVS()
	NULL,		// pfnSetFatPAS()
	NULL,		// pfnCheckVisibility()
	NULL,		// pfnDeltaSetField()
	NULL,		// pfnDeltaUnsetField()
	NULL,		// pfnDeltaAddEncoder()
	NULL,		// pfnGetCurrentPlayer()
	NULL,		// pfnCanSkipPlayer()
	NULL,		// pfnDeltaFindField()
	NULL,		// pfnDeltaSetFieldByIndex()
	NULL,		// pfnDeltaUnsetFieldByIndex()
	NULL,		// pfnSetGroupMask()
	NULL,		// pfnCreateInstancedBaseline()
	NULL,		// pfnCvar_DirectSet()
	NULL,		// pfnForceUnmodified()
	NULL,		// pfnGetPlayerStats()
	NULL,		// pfnAddServerCommand()

	// Added in SDK 2.2:
	NULL,		// pfnVoice_GetClientListening()
	NULL,		// pfnVoice_SetClientListening()

	// Added for HL 1109 (no SDK update):
	NULL,		// pfnGetPlayerAuthId()

	// Added 2003/11/10 (no SDK update):
	NULL,		// pfnSequenceGet()
	NULL,		// pfnSequencePickSentence()
	NULL,		// pfnGetFileSize()
	NULL,		// pfnGetApproxWavePlayLen()
	NULL,		// pfnIsCareerMatch()
	NULL,		// pfnGetLocalizedStringLength()
	NULL,		// pfnRegisterTutorMessageShown()
	NULL,		// pfnGetTimesTutorMessageShown()
	NULL,		// pfnProcessTutorMessageDecayBuffer()
	NULL,		// pfnConstructTutorMessageDecayBuffer()
	NULL,		// pfnResetTutorMessageDecayData()

	// Added Added 2005-08-11 (no SDK update)
	NULL,		// pfnQueryClientCvarValue()
	// Added Added 2005-11-22 (no SDK update)
	NULL,		// pfnQueryClientCvarValue2()
	// Added 2009-06-17 (no SDK update)
	NULL,	// pfnEngCheckParm()			// s1lent: comment out this, for compatibility with older versions metamod
};

enginefuncs_t g_EngineFunctionsTable_Post =
{
	NULL,		// pfnPrecacheModel()
	NULL,		// pfnPrecacheSound()
	NULL,		// pfnSetModel()
	NULL,		// pfnModelIndex()
	NULL,		// pfnModelFrames()
	NULL,		// pfnSetSize()
	NULL,		// pfnChangeLevel()
	NULL,		// pfnGetSpawnParms()
	NULL,		// pfnSaveSpawnParms()
	NULL,		// pfnVecToYaw()
	NULL,		// pfnVecToAngles()
	NULL,		// pfnMoveToOrigin()
	NULL,		// pfnChangeYaw()
	NULL,		// pfnChangePitch()
	NULL,		// pfnFindEntityByString()
	NULL,		// pfnGetEntityIllum()
	NULL,		// pfnFindEntityInSphere()
	NULL,		// pfnFindClientInPVS()
	NULL,		// pfnEntitiesInPVS()
	NULL,		// pfnMakeVectors()
	NULL,		// pfnAngleVectors()
	NULL,		// pfnCreateEntity()
	NULL,		// pfnRemoveEntity()
	NULL,		// pfnCreateNamedEntity()
	NULL,		// pfnMakeStatic()
	NULL,		// pfnEntIsOnFloor()
	NULL,		// pfnDropToFloor()
	NULL,		// pfnWalkMove()
	NULL,		// pfnSetOrigin()
	NULL,		// pfnEmitSound()
	NULL,		// pfnEmitAmbientSound()
	NULL,		// pfnTraceLine()
	NULL,		// pfnTraceToss()
	NULL,		// pfnTraceMonsterHull()
	NULL,		// pfnTraceHull()
	NULL,		// pfnTraceModel()
	NULL,		// pfnTraceTexture()
	NULL,		// pfnTraceSphere()
	NULL,		// pfnGetAimVector()
	NULL,		// pfnServerCommand()
	NULL,		// pfnServerExecute()
	NULL,		// pfnClientCommand()
	NULL,		// pfnParticleEffect()
	NULL,		// pfnLightStyle()
	NULL,		// pfnDecalIndex()
	NULL,		// pfnPointContents()
	NULL,		// pfnMessageBegin()
	NULL,		// pfnMessageEnd()
	NULL,		// pfnWriteByte()
	NULL,		// pfnWriteChar()
	NULL,		// pfnWriteShort()
	NULL,		// pfnWriteLong()
	NULL,		// pfnWriteAngle()
	NULL,		// pfnWriteCoord()
	NULL,		// pfnWriteString()
	NULL,		// pfnWriteEntity()
	NULL,		// pfnCVarRegister()
	NULL,		// pfnCVarGetFloat()
	NULL,		// pfnCVarGetString()
	NULL,		// pfnCVarSetFloat()
	NULL,		// pfnCVarSetString()
	NULL,		// pfnAlertMessage()
	NULL,		// pfnEngineFprintf()
	NULL,		// pfnPvAllocEntPrivateData()
	NULL,		// pfnPvEntPrivateData()
	NULL,		// pfnFreeEntPrivateData()
	NULL,		// pfnSzFromIndex()
	NULL,		// pfnAllocString()
	NULL,		// pfnGetVarsOfEnt()
	NULL,		// pfnPEntityOfEntOffset()
	NULL,		// pfnEntOffsetOfPEntity()
	NULL,		// pfnIndexOfEdict()
	NULL,		// pfnPEntityOfEntIndex()
	NULL,		// pfnFindEntityByVars()
	NULL,		// pfnGetModelPtr()
	NULL,		// pfnRegUserMsg()
	NULL,		// pfnAnimationAutomove()
	NULL,		// pfnGetBonePosition()
	NULL,		// pfnFunctionFromName()
	NULL,		// pfnNameForFunction()
	NULL,		// pfnClientPrintf()
	NULL,		// pfnServerPrint()
	NULL,		// pfnCmd_Args()
	NULL,		// pfnCmd_Argv()
	NULL,		// pfnCmd_Argc()
	NULL,		// pfnGetAttachment()
	NULL,		// pfnCRC32_Init()
	NULL,		// pfnCRC32_ProcessBuffer()
	NULL,		// pfnCRC32_ProcessByte()
	NULL,		// pfnCRC32_Final()
	NULL,		// pfnRandomLong()
	NULL,		// pfnRandomFloat()
	NULL,		// pfnSetView()
	NULL,		// pfnTime()
	NULL,		// pfnCrosshairAngle()
	NULL,		// pfnLoadFileForMe()
	NULL,		// pfnFreeFile()
	NULL,		// pfnEndSection()
	NULL,		// pfnCompareFileTime()
	NULL,		// pfnGetGameDir()
	NULL,		// pfnCvar_RegisterVariable()
	NULL,		// pfnFadeClientVolume()
	NULL,		// pfnSetClientMaxspeed()
	NULL,		// pfnCreateFakeClient()
	NULL,		// pfnRunPlayerMove()
	NULL,		// pfnNumberOfEntities()
	NULL,		// pfnGetInfoKeyBuffer()
	NULL,		// pfnInfoKeyValue()
	NULL,		// pfnSetKeyValue()
	NULL,		// pfnSetClientKeyValue()
	NULL,		// pfnIsMapValid()
	NULL,		// pfnStaticDecal()
	NULL,		// pfnPrecacheGeneric()
	NULL,		// pfnGetPlayerUserId()
	NULL,		// pfnBuildSoundMsg()
	NULL,		// pfnIsDedicatedServer()
	NULL,		// pfnCVarGetPointer()
	NULL,		// pfnGetPlayerWONId()
	NULL,		// pfnInfo_RemoveKey()
	NULL,		// pfnGetPhysicsKeyValue()
	NULL,		// pfnSetPhysicsKeyValue()
	NULL,		// pfnGetPhysicsInfoString()
	NULL,		// pfnPrecacheEvent()
	NULL,		// pfnPlaybackEvent()
	NULL,		// pfnSetFatPVS()
	NULL,		// pfnSetFatPAS()
	NULL,		// pfnCheckVisibility()
	NULL,		// pfnDeltaSetField()
	NULL,		// pfnDeltaUnsetField()
	NULL,		// pfnDeltaAddEncoder()
	NULL,		// pfnGetCurrentPlayer()
	NULL,		// pfnCanSkipPlayer()
	NULL,		// pfnDeltaFindField()
	NULL,		// pfnDeltaSetFieldByIndex()
	NULL,		// pfnDeltaUnsetFieldByIndex()
	NULL,		// pfnSetGroupMask()
	NULL,		// pfnCreateInstancedBaseline()
	NULL,		// pfnCvar_DirectSet()
	NULL,		// pfnForceUnmodified()
	NULL,		// pfnGetPlayerStats()
	NULL,		// pfnAddServerCommand()

	// Added in SDK 2.2:
	NULL,		// pfnVoice_GetClientListening()
	NULL,		// pfnVoice_SetClientListening()

	// Added for HL 1109 (no SDK update):
	NULL,		// pfnGetPlayerAuthId()

	// Added 2003/11/10 (no SDK update):
	NULL,		// pfnSequenceGet()
	NULL,		// pfnSequencePickSentence()
	NULL,		// pfnGetFileSize()
	NULL,		// pfnGetApproxWavePlayLen()
	NULL,		// pfnIsCareerMatch()
	NULL,		// pfnGetLocalizedStringLength()
	NULL,		// pfnRegisterTutorMessageShown()
	NULL,		// pfnGetTimesTutorMessageShown()
	NULL,		// pfnProcessTutorMessageDecayBuffer()
	NULL,		// pfnConstructTutorMessageDecayBuffer()
	NULL,		// pfnResetTutorMessageDecayData()

	// Added Added 2005-08-11 (no SDK update)
	NULL,		// pfnQueryClientCvarValue()
	// Added Added 2005-11-22 (no SDK update)
	NULL,		// pfnQueryClientCvarValue2()
	// Added 2009-06-17 (no SDK update)
	NULL,	// pfnEngCheckParm()			// s1lent: comment out this, for compatibility with older versions metamod
};

C_DLLEXPORT int GetEngineFunctions(enginefuncs_t *pengfuncsFromEngine, int *interfaceVersion)
{
	if (!pengfuncsFromEngine) {
		ALERT(at_logged, "%s called with null pengfuncsFromEngine", __FUNCTION__);
		return FALSE;
	}
	if (*interfaceVersion != ENGINE_INTERFACE_VERSION) {
		ALERT(at_logged, "%s version mismatch; requested=%d ours=%d", __FUNCTION__, *interfaceVersion, ENGINE_INTERFACE_VERSION);
		*interfaceVersion = ENGINE_INTERFACE_VERSION;
		return FALSE;
	}

	memcpy(pengfuncsFromEngine, &g_EngineFunctionsTable, sizeof(enginefuncs_t));
	return TRUE;
}

C_DLLEXPORT int GetEngineFunctions_Post(enginefuncs_t *pengfuncsFromEngine, int *interfaceVersion)
{
	if (!pengfuncsFromEngine) {
		ALERT(at_logged, "%s called with null pengfuncsFromEngine", __FUNCTION__);
		return FALSE;
	}
	if (*interfaceVersion != ENGINE_INTERFACE_VERSION) {
		ALERT(at_logged, "%s version mismatch; requested=%d ours=%d", __FUNCTION__, *interfaceVersion, ENGINE_INTERFACE_VERSION);
		*interfaceVersion = ENGINE_INTERFACE_VERSION;
		return FALSE;
	}
	
	memcpy(pengfuncsFromEngine, &g_EngineFunctionsTable_Post, sizeof(enginefuncs_t));
	return TRUE;
}
