///save///
/*------------------ > CREDITS < ------------------\\
//	Arkshine - unstuck method 
//	ConnorMcLeod - Opening / Closing Doors & Team Damage
//	Exolent - For Mic System & Help & striping weapons & returning them
// 	xGamer - Original Coder 
//	joaquimandrade - For Viewable ct
// 	XxAvalanchexX - For striping weapons 
// 	MPNumB - For arrow nades on nade war day / Chat tag
// 	wrecked - Usp Ninjas
//-------------------------------------------------*/

#include <amxmisc>
#include <fakemeta>
#include <fun>
#include <cstrike>
#include <hamsandwich>
#include <engine>
#include <nvault>
#include <xs>

#pragma semicolon 1;

/*================================================================================
 [Defines & Variables]
=================================================================================*/
#define get_bit(%1,%2) 		(%1 & 1<<(%2&31))
#define set_bit(%1,%2)	 	%1 |= (1<<(%2&31))
#define clear_bit(%1,%2)	%1 &= ~(1<<(%2&31))

#define get_bit2(%1,%2) 	(%1 & 0<<(%2&31))
#define set_bit2(%1,%2)	 	%1 |= (0<<(%2&31))
#define clear_bit2(%1,%2)	%1 &= ~(0<<(%2&31))

new g_iMaxPlayers;
#define FIRST_PLAYER_ID	1
#define IsPlayer(%1) (FIRST_PLAYER_ID <= %1 <= g_iMaxPlayers)

#define PLUGIN_NAME "Jailbreak - MAIN"
#define PLUGIN_VERS "1.7.1"
#define PLUGIN_AUTH "Pastout!"
#define PLUGIN_CVAR "JailBreakMod"

#define GetPlayerHullSize(%1)  ( ( pev ( %1, pev_flags ) & FL_DUCKING ) ? HULL_HEAD : HULL_HUMAN )

// --| The first search distance for finding a free location in the map.
#define START_DISTANCE    32   
// --| How many times to search in an area for a free space.
#define MAX_ATTEMPTS      128  

// --| Just for readability.
enum Coord_e { Float:x, Float:y, Float:z }

// Tasks ID's
enum (+= 1000) {
	TASKID = 1000,
	TASK_DAYTIMER,
	TASK_HNS,
	TASK_BEAM,
	TASK_MATH,
	TASK_SIMONBEAM,
	TASK_TIMER
};

// Offsets (FM)
//#define OFFSET_CLIPAMMO 51	// Clip Ammo Offset 
#define OFFSET_LINUX 4		// Weapons Linux Offset
#define OFFSET_CSMONEY 115
//#define OFFSET_PRIMWEAPON 116	// Primary Weapon Fix
//#define OFFSET_SECWEAPON 117	// Secondary Weapon Fix

#if cellbits == 32
    #define OFFSET_BUYZONE 235
#else
    #define OFFSET_BUYZONE 268
#endif

// Offsets (Ham)
#define m_pPlayer 41		// Ham_Item_Deploy (Weapon Owner)
#define m_flNextSecondaryAttack        47
#define OFFSET_SILENCER_FIREMODE       74
#define set_usp_silent(%1)    set_pdata_int(%1, OFFSET_SILENCER_FIREMODE, USP_SILENCED, OFFSET_LINUX)
#define get_weapon_owner(%1)  get_pdata_cbase(%1, m_pPlayer, OFFSET_LINUX) 

const USP_SILENCED = (1<<0);

#define HITGROUP_HEAD 1

// damage of explode, required for fm_radius_damage
#define EXPLODE_DAMAGE 100.0

// radius of damage (required for fm_radius damage )
#define EXPLODE_RADIUS 300.0

#define TEAM_T	1
#define TEAM_CT	2

#define XO_PLAYER  5
#define m_flWait   44 		// Offset for button delay
#define m_bitsDamageInflict 71
#define m_iJuice   75
#define m_iTeam    114
#define cs_get_user_team_index(%0)	get_pdata_int(%0, m_iTeam, XO_PLAYER)
#define cs_set_user_team_index(%0,%1)	set_pdata_int(%0, m_iTeam, %1, XO_PLAYER)

#define m_iFlashBattery  244
#define m_pActiveItem    373
#define m_iUserPrefs     510

#define DAMAGE_NO                       0.0
#define SF_TRIGGER_HURT_NO_CLIENTS      8

const HAS_SHIELD = 1<<24;
#define HasShield(%0)    ( get_pdata_int(%0, m_iUserPrefs, XO_PLAYER) & HAS_SHIELD )

new const g_szPluginPrefix[] = "JailBreak-Mod";		// Plugin g_szPluginPrefix (Tag)

#define DAY_ACCESS 		ADMIN_BAN	// access to start a day
#define VOTEDAY_ACCESS 		ADMIN_KICK	// access to start a vote day.
#define SPRAY_ACCESS 		ADMIN_MENU	// access to turn message on/off
#define ADMIN_CLASS 		ADMIN_BAN 	// access to the speical guard classes
#define ADMIN_MIC 		ADMIN_MENU 	// access to talk on there mic as prisoners
#define ADMIN_POINTS 		ADMIN_IMMUNITY	// access to give/take/set points
#define ADMIN_SIMON 		ADMIN_BAN 	// access to all simon items
#define ADMIN_DOORS 		ADMIN_BAN	// access to open/close doors as a prisoner
#define ADMIN_RANDOM_CT_SWITCH	ADMIN_MENU	// access to switch a prisoner to guard
#define ADMIN_BOXDAY 		ADMIN_BAN	// access to open/close doors as a prisoner
#define ADMIN_FREEFORALL 	ADMIN_BAN	// access to open/close doors as a prisoner

//The weight of players votes
#define WEIGHT_PLAYER 1
#define WEIGHT_ADMIN 2
//This is for rebel options They must be 3 guards alive to choose this option in /lr unless you are a head admin
#define NUMBER_OF_GUARDS 3
//Max Simons allowed at ounce
#define MAX_SIMONS 1
//The value of this takes away hp from a user if they get a math question wrong
#define DMG_MATHQ 		50
#define ZOMBIE_SPEED 		400.0
#define NIGHTCRAWLER_SPEED 	400.0
#define REZOMBIE_SPEED 		325.0
#define RENIGHTCRAWLER_SPEED 	325.0
#define GRAVITY_DAY 		200
#define FREEZETAG_GRAVITY 	400
#define SCOUTDUAL_GRAVITY 	300
//This is the timer that gives the prisoners to hide on HNS day
#define HIDE_N_SEEK_TIMER 	60

#define SPEAK_TEAM  4
new g_iSpeakFlags[33];

#define RACE_TIMER 5 // Last request for race timer count down...
#define CELL_TIMER 60.0 //Time before cells open automacticly if guards do not open cells themselfs

// Do NOT uncomment all 3 will not work... either uncomment SAVE_METHOD_NICK OR SAVE_METHOD_IP OR SAVE_METHOD_ID
// To save player data by nick, change "//#define SAVE_METHOD_NICK" to "#define SAVE_METHOD_NICK"
//#define SAVE_METHOD_NICK
// To save player data by ip, change "//#define SAVE_METHOD_IP" to "#define SAVE_METHOD_IP"
//#define SAVE_METHOD_IP
// To save player data by id, change "//#define SAVE_METHOD_ID" to "#define SAVE_METHOD_ID"
#define SAVE_METHOD_ID

#define ENG_NULLENT -1

static const g_iZombieDayLights[] = "a"; 	// Change this for the darkness of map when its a zombie/reverse day || You can choose abcdefghijklmnopqrstuvwxyz || a = PitchBlack z = Brightest
static const g_iGrenadeDayLights[] = "c"; 	// Change this for the darkness of map when its a Midnight Nade Wars day || You can choose abcdefghijklmnopqrstuvwxyz || a = PitchBlack z = Brightest
static const g_iNightCrawlerDayLights[] = "d";	// Change this for the darkness of map when its a Nightcrawler/reverse day || You can choose abcdefghijklmnopqrstuvwxyz || a = PitchBlack z = Brightest

const WEAPONS_PISTOLS = (1<<CSW_P228)|(1<<CSW_ELITE)|(1<<CSW_FIVESEVEN)|(1<<CSW_USP)|(1<<CSW_GLOCK18)|(1<<CSW_DEAGLE);
const WEAPONS_SHOTGUNS = (1<<CSW_XM1014)|(1<<CSW_M3);
const WEAPONS_SUBMACHINEGUNS = (1<<CSW_MAC10)|(1<<CSW_UMP45)|(1<<CSW_MP5NAVY)|(1<<CSW_TMP)|(1<<CSW_P90);
const WEAPONS_RIFLES = (1<<CSW_SCOUT)|(1<<CSW_AUG)|(1<<CSW_SG550)|(1<<CSW_GALIL)|(1<<CSW_FAMAS)|(1<<CSW_AWP)|(1<<CSW_M4A1)|(1<<CSW_G3SG1)|(1<<CSW_SG552)|(1<<CSW_AK47);
const WEAPONS_MACHINEGUNS = (1<<CSW_M249);

const VALID_WEAPONS = WEAPONS_PISTOLS|WEAPONS_SHOTGUNS|WEAPONS_SUBMACHINEGUNS|WEAPONS_RIFLES|WEAPONS_MACHINEGUNS;
#define PRIMARY_WEAPONS_BIT    (WEAPONS_SHOTGUNS|WEAPONS_SUBMACHINEGUNS|WEAPONS_RIFLES|WEAPONS_MACHINEGUNS)
#define SECONDARY_WEAPONS_BIT    (WEAPONS_PISTOLS)

#define IsPrimaryWeapon(%1) ( (1<<%1) & PRIMARY_WEAPONS_BIT )
#define IsSecondaryWeapon(%1) ( (1<<%1) & WEAPONS_PISTOLS )

#define IsWeaponInBits(%1,%2) (((1<<%1) & %2) > 0)

const MAX_PLAYERS = 32;

new g_iWeaponBits[MAX_PLAYERS+1];
new g_iWeaponClip[MAX_PLAYERS+1][CSW_P90+1];
new g_iWeaponAmmo[MAX_PLAYERS+1][CSW_P90+1];
new g_iTagCount[MAX_PLAYERS+1];
new g_bIsTag;
new g_iDeaths[MAX_PLAYERS+1];
new bool:g_IsChilled[MAX_PLAYERS+1];
new Float:g_iMaxSpeed[MAX_PLAYERS+1];
new Float:g_ChillySpeed[MAX_PLAYERS+1];
new g_GonnaBeHurt[MAX_PLAYERS+1] = {-1, ...};

new g_bHasVoted;
new g_iRockTheDay[MAX_PLAYERS+1];
new bool:g_bVoteLocked;

#define print_chat_colored 5

new g_iOldMessage[192];
new g_iLastMsg[192];
new g_iLastText[192];

new g_iUserName[33][32];
new g_iUserTagName[33][55];
new g_bHide;
new nVault;

enum _:SayCommands
{
	Say_NameChange,
	Say_ChatCT,
	Say_ChatT,
	Say_ChatCT_Dead,
	Say_ChatT_Dead,
	Say_ChatSpec,
	Say_ChatAll,
	Say_ChatAll_Dead,
	Say_ChatAll_Spec
};

new const g_szSayCommands[SayCommands][] =
{
	"#Cstrike_Name_Change",
	"#Cstrike_Chat_CT",
	"#Cstrike_Chat_T",
	"#Cstrike_Chat_CT_Dead",
	"#Cstrike_Chat_T_Dead",
	"#Cstrike_Chat_Spec",
	"#Cstrike_Chat_All",
	"#Cstrike_Chat_AllDead",
	"#Cstrike_Chat_AllSpec"
};

new Trie:g_tSayCommands;

static const g_szWeaponNames[CSW_P90+1][] = {
	"","weapon_p228","","weapon_scout",
	"weapon_hegrenade","weapon_xm1014",
	"","weapon_mac10","weapon_aug",
	"weapon_smokegrenade","weapon_elite",
	"weapon_fiveseven","weapon_ump45",
	"weapon_sg550","weapon_galil",
	"weapon_famas","weapon_usp",
	"weapon_glock18","weapon_awp",
	"weapon_mp5navy","weapon_m249",
	"weapon_m3","weapon_m4a1","weapon_tmp",
	"weapon_g3sg1","weapon_flashbang","weapon_deagle",
	"weapon_sg552","weapon_ak47","","weapon_p90"
};

new iRandom;
new g_fwid, g_iGunEvent_IDsBitsum;

static const szWeapons[][] = {
	"weapon_p228", "weapon_scout", "weapon_hegrenade",
	"weapon_xm1014", "weapon_mac10", "weapon_aug",
	"weapon_elite", "weapon_fiveseven", "weapon_ump45",
	"weapon_sg550", "weapon_galil", "weapon_famas",
	"weapon_usp", "weapon_glock18", "weapon_awp",
	"weapon_mp5navy", "weapon_m249", "weapon_m3",
	"weapon_m4a1", "weapon_tmp", "weapon_g3sg1",
	"weapon_deagle", "weapon_sg552", "weapon_ak47",
	"weapon_p90"
}; 

static const szWeapons2[][] = {
	"weapon_p228", "weapon_scout", "weapon_xm1014", 
	"weapon_mac10", "weapon_aug", "weapon_elite", 
	"weapon_fiveseven", "weapon_ump45", "weapon_sg550", 
	"weapon_galil", "weapon_famas", "weapon_usp", 
	"weapon_glock18", "weapon_awp", "weapon_mp5navy", 
	"weapon_m249", "weapon_m3", "weapon_m4a1", 
	"weapon_tmp", "weapon_g3sg1", "weapon_deagle", 
	"weapon_sg552", "weapon_ak47", "weapon_p90"
};

static const iBpAmmo[] = {
	52, 90, 90,
	32, 100, 90,
	120, 100, 100,
	90, 90, 90,
	100, 120, 30,
	120, 200, 32,
	90, 120, 90,
	35, 90, 90,
	100
};

static const g_szWeaponList1[][] = { 	
	"weapon_galil", "weapon_famas", 
	"weapon_ak47", "weapon_m4a1"
};

// Button Classnames
static const g_szButtonClasses[][] = {
	"func_button",
	"func_rot_button",
	"button_target"
};

new const g_szClassNameCrowbar[] = "class_crowbar";

enum _:g_iStartDay
{
	DAY_NONE, DAY_GRAVITY, DAY_FREEDAY,
	DAY_ZOMBIE, DAY_LAVA, DAY_SHARK,
	DAY_CAGE, DAY_DEATHMATCH, DAY_NIGHT,
	DAY_SPARTAN, DAY_HIDENSEEK, DAY_REZOMBIE,
	DAY_RESHARK, DAY_RENIGHT, DAY_FREEZETAG, DAY_GANG, DAY_GRENADE, DAY_USPNINJAS
};
	
new bool:g_bVoteDayUsed[g_iStartDay];
//Example remove the days you do NOT want from the vote menu 
// Right now freeday and cade day are removed from the menu
//new const SKIP_DAYS = ( 1 << DAY_NONE );

new const SKIP_DAYS = ( 1 << DAY_NONE ) | ( 1 << DAY_FREEDAY ) | ( 1 << DAY_CAGE);


#define TOTAL_DAYS 15

new gVoteMenu;
new gVotes[g_iStartDay];
new gVoting;
new bool:g_iAreWeInaVote;
new g_DayTimer = 0;
new g_iAutoStartVote = 0;
new g_iWaitUnlock = 0;

new const g_iStartDayNames[g_iStartDay][] =
{
	"", "JB_DAYNAME_GRAVITY", "JB_DAYNAME_FREEDAY",
	"JB_DAYNAME_ZOMBIE", "JB_DAYNAME_LAVA", "JB_DAYNAME_SHARK",
	"JB_DAYNAME_CAGE", "JB_DAYNAME_DM", "JB_DAYNAME_NC",
	"JB_DAYNAME_SPARTAN", "JB_DAYNAME_HIDENSEEK", "JB_DAYNAME_RZOMBIE",
	"JB_DAYNAME_RSHARK", "JB_DAYNAME_RNC",
	"JB_DAYNAME_FREEZETAG", "JB_DAYNAME_GANG", "JB_DAYNAME_GRENADE", "JB_DAYNAME_USPNINJAS"
};

new g_iDay[ g_iStartDay ];

// Precache
new const CrowbarModels[][] = { "models/p_crowbar.mdl", "models/v_crowbar.mdl", "models/w_crowbar.mdl" };
new const ZombieModels[][] = { "models/jb_claws.mdl" };
new const CrowbarSounds[][] = { "weapons/cbar_hitbod2.wav",
	"weapons/cbar_hitbod1.wav", "weapons/bullet_hit1.wav", "weapons/bullet_hit2.wav",
	"weapons/knife_slash1.wav", "weapons/cbar_miss1.wav",  "weapons/cbar_hit1.wav",
	"debris/metal2.wav", "items/gunpickup2.wav"
};

new const NightCrawlerModels[][] = { "models/v_nightcrawler-sword.mdl", "models/player/nightcrawler/nightcrawler.mdl" };
new const NightCrawlerSounds[][] = {"nightcrawlerday.wav", "teleport.wav", 
	"sword_strike1.wav", "sword_strike2.wav", "sword_strike3.wav",
	"sword_strike4.wav"
};

new const SnowballWarModels[][] = { "models/p_snowball.mdl", "models/v_snowball.mdl", 
	"models/w_snowball.mdl", "models/p_snowknife.mdl", "models/v_snowknife.mdl" 
};

new const SnowballWarSounds[][] = { "unchill.wav", "chill.wav" };

new const g_szLaserSprite[ ] = "sprites/zbeam4.spr";
new g_iLaserSprite;

new g_iSpriteLine;
new g_iSpriteArrow;
new g_iGlass;
new g_iSpray;
new g_iDrop;

new const BoxingModels[][] = { "models/v_box_blue.mdl", "models/v_box_red.mdl" };

new const BoxingSounds[][] = { "boxing_deploy1.wav", "boxing_hit1.wav", "boxing_hit2.wav",    
	"boxing_hit3.wav", "boxing_hit4.wav", "boxing_hitwall1.wav", "boxing_slash1.wav",    
	"boxing_slash2.wav", "boxing_stab.wav"    
};

new const GunGameSounds[][] = { "powerdown.wav", "powerup.wav", "knife_level.wav",    
	"levelup.wav"
};

new const g_szSound_Bell[] = "buttons/bell1.wav";

new Float:DetectionMaxDistance = 1000.0;
new Ham:Ham_Player_ResetMaxSpeed = Ham_Item_PreFrame;
new g_bIsLast;			// It's the last terrorist?
new g_bIsGlowing;		// Is the user glowing?
new g_bHasFreeday;		// Do they have a freeday?
new g_bHasCrowbar;		// Does he own a crowbar?
new g_bHasSpeed;		// Does he own speed?
new g_bHasInvis;		// Does he own invisibility?
new g_bHasNadepack;		// Does he own a nadepack?
new g_bHasArmor;		// Does he own armor?
new g_bHasDisguise;		// Does he own a disguise?
new g_bHasCellKeys;		// Does he own a cell key?
new g_bHasFootstep;		// Does he own no footstep?
new g_bIsChosen;		// It's the chosen ct for the battle?
new g_bIsAlive;			// Are we alive?
new g_bIsConnected;		// Are we connected?
new g_bIsSimon;			// Are we simon?
new g_bHasMenuOpen;		// Has a menu open
new g_bInDisguise;		// Are they in disguise
new g_bInMathProblem;		// Are we in math problem
new g_bHasVotedAlready;		// Did we vote already?
new g_bHasClosedMenu;		// Did we close the vote menu?
new g_bUserHasTag; 		// Has custom tag?
new g_bUserHasTagDay; 		// Has custom tag from day?
new g_HasBeenHit;
new g_bTeleport;
new g_bTeleportUsed[33];
new g_bSetFakeGodmode;		// For gun game respawn 3 secs with godmode xd
new bool:g_bBoxMatch;		// Are we in a box match?
new bool:g_bSnowballWar;	// Are we in a box match?
new bool:g_bGunGame;		// Are we in a box match?
new bool:g_bHeadshotEnabled;
new bool:g_bAutoOpened;		// Did the cells open at 8:00?
new bool:g_bAlreadyOpened;	// If the cells have been opened before 8:00
new bool:g_bInLr;		// Is the terrorist in an Lr?
new bool:g_bCanBuy;		// Can they use the shop?
new bool:g_bDayHasStarted;
//new bool:g_bFrozenTime;	
new bool:g_bTeamDivided;
new bool:g_bSprayMessages;
new bool:g_bBufferDoors;
new g_bHeadShot[MAX_PLAYERS+1][MAX_PLAYERS+1];
new g_iFinalCT;		
new g_iRingSprite;			// ShockWave Sprite
new g_iCrowbars;			// number of players with crowbars
new g_iDisguise;			// number of players with disguise
new g_iCellKeys;			// number of players with cell keys
new g_iSpeed;				// number of players with speed
new g_iInvis;				// number of players with invisibility
new g_iFootstep;			// number of players with no footsteps
new g_iMsgSayText;			// SayText (ColorPrint)
new g_iMsgTextMsg;
new g_iMsgId_ScreenFade;
new g_iMsgFog;
new g_iMsgDeath;
new g_iMsgScoreInfo;
new g_iBlockLastRequest;		// Block Last Request Command (BugFix)
new g_iGameType;			// Last Request Game Type
new g_iPoints[MAX_PLAYERS+1];		// Amount of Points a player has
//new g_iAdminDay = 0;
new g_iVictimTeam;

#if defined SAVE_METHOD_NICK
new g_iAuth[MAX_PLAYERS+1][32];
#endif
#if defined SAVE_METHOD_IP
new g_iAuthIP[MAX_PLAYERS+1][32];
#endif
#if defined SAVE_METHOD_ID
new g_iAuthID[MAX_PLAYERS+1][32];
#endif

//new bool:g_bFFA;
new g_vault;				// Open a new vault to store a players points.
new g_buttonvault;			// Open a new vault to store the cell door button.
new iEnt;				// This is the button
new explosion_sprite;			// Suicide bomber sprite
new szMap[33];
new szClass[33];
new szModel[33];
new g_ThermalOn[MAX_PLAYERS+1];
new HamHook:g_iHhTakeDamagePost;
new g_Timer;
new g_FrozenT;
new g_10HP = 10;
new g_25HP = 25;
new g_50HP = 50;
new g_100HP = 100;
new g_200HP = 200;
new g_400HP = 400;
new mathAnswer[MAX_PLAYERS+1];
new mathEquations[MAX_PLAYERS+1][128];
new g_pRoundTime;
new check_blueteam = 0;
new check_redteam = 0;
new check_bteam;
new check_rteam;
new check_gteam;

new const g_iWeaponLevel[] =
{
	CSW_GLOCK18,
	CSW_USP,
	CSW_DEAGLE,
	CSW_FIVESEVEN,
	CSW_ELITE,
	CSW_UMP45,
	CSW_MAC10,
	CSW_TMP,
	CSW_MP5NAVY,
	CSW_XM1014,
	CSW_M3,
	CSW_FAMAS,
	CSW_M4A1,
	CSW_AK47,
	CSW_SCOUT,
	CSW_AWP,
	CSW_KNIFE
};

new const g_iWeaponLevelRefillammo[] =
{
	20,
	12,
	7,
	20,
	30,
	25,
	30,
	30,
	30,
	7,
	8,
	25,
	30,
	30,
	10,
	10,
	0
};

new const g_szGunGameNames[][] =
{
	"Glock18",
	"USP",
	"Deagle",
	"Five-Seven",
	"Elite",
	"UMP45",
	"Mac10",
	"TMP",
	"MP5 Navy",
	"Auto Shotgun",
	"Pump Shotgun",
	"Famas",
	"M4A1",
	"AK47",
	"Scout",
	"AWP",
	"Knife"
};

new const g_szWeaponModels[][] =
{
	"models/w_glock18.mdl",
	"models/w_usp.mdl",
	"models/w_deagle.mdl",
	"models/w_fiveseven.mdl",
	"models/w_elite.mdl",
	"models/w_ump45.mdl",
	"models/w_mac10.mdl",
	"models/w_tmp.mdl",
	"models/w_mp5navy.mdl",
	"models/w_xm1014.mdl",
	"models/w_sg550.mdl",
	"models/w_famas.mdl",
	"models/w_m4a1.mdl",
	"models/w_ak47.mdl",
	"models/w_scout.mdl",
	"models/w_awp.mdl",
	"models/w_knife.mdl"
};
new level;
new g_iGunGameLevel[MAX_PLAYERS+1][17];
new g_iGunGameLevelNext[MAX_PLAYERS+1];
//Thanks to exo
new Float:g_fRoundStartTime;
new Float:g_fRoundTime;

new const g_iOperators[4][2] = {
	"+", 
	"-", 
	"*", 
	"/"
};

new const g_iSpeakNames[][] = {
	"",
	"Normal Talk", 
	"All Talk",
	"Muted", 
	"Team Talk"
};

new g_iTimerEntity;
new checkWeapon;

new const SayClientCmds[][64] = {
	"lr", "ClCmd_LastRequest", "spray",   "CmdSprayMessage", "status", "status", "box", "ClCmd_boxmatch", "boxmatch", "ClCmd_boxmatch",
	"day", "specialday_check", "days", "specialday_check", "voteday", "CheckStartVote", "endday", "specialday_ends",
	"glow", "JBGlowMenu", "freeday", "JBGlowMenu", "unglow", "JBUnglowMenu", 
	"class", "ClassMenu", "shop", "ClCmd_shop", "point", "ClCmd_points", "points", "ClCmd_points", "simon", "ClCmd_simon",
	"talkchannel", "ClCmd_channel", "talk", "ClCmd_channel", "channel", "ClCmd_channel", "mic", "ClCmd_channel",
	"close", "ClCmd_closedoors", "closedoors", "ClCmd_closedoors", "open", "ClCmd_opendoors", "opendoors", "ClCmd_opendoors",
	"random", "ClCmd_randomct", "next", "ClCmd_nextproblem", "rtd", "CmdRockTheDay", "rocktheday", "CmdRockTheDay", "ffa", "CmdFreeForAll", "freeforall", "CmdFreeForAll",
	"hide", "ClCmd_HideTag"
};

new const g_iGunEvents[][] = {
	"events/awp.sc",
	"events/g3sg1.sc",
	"events/ak47.sc",
	"events/scout.sc",
	"events/m249.sc",
	"events/m4a1.sc",
	"events/sg552.sc",
	"events/aug.sc",
	"events/sg550.sc",
	"events/m3.sc",
	"events/xm1014.sc",
	"events/usp.sc",
	"events/mac10.sc",
	"events/ump45.sc",
	"events/fiveseven.sc",
	"events/p90.sc",
	"events/deagle.sc",
	"events/p228.sc",
	"events/glock18.sc",
	"events/mp5n.sc",
	"events/tmp.sc",
	"events/elite_left.sc",
	"events/elite_right.sc",
	"events/galil.sc",
	"events/famas.sc"
};

new g_iGetUserWeapon;

enum _:Cvars 
{
	cvar_shop,
	cvar_killpoints,
	cvar_headshotpoints,
	cvar_crowbarprice,
	cvar_armorprice,
	cvar_disguiseprice,
	cvar_nadepackprice,
	cvar_speedprice,
	cvar_invisprice,
	cvar_footstepprice,
	cvar_crowbarlimit,
	cvar_invislimit,
	cvar_footsteplimit,
	cvar_speedlimit,
	cvar_disguiselimit,
	cvar_alphavalue,
	cvar_shopspeed,
	//cvar_admindaywait,
	cvar_autostartvote,
	cvar_blockvoice,
	cvar_fogeffect,
	cvar_sprayenable,
	cvar_shootbuttons,
	cvar_cellkeyslimit,
	cvar_cellkeysprice,
	cvar_timeunlockrtd,
	cvar_rockthedaypercent//,
//	cvar_headshot_only
};

new const cvar_names[Cvars][] = {
	"jb_shop",		// Enable/disable shop
	"jb_points_kill",	// Points per kill
	"jb_points_headshot",	// Additional points per headshot
	"jb_shop_crowbar",	// price for crowbar
	"jb_shop_armor",	// price for armor
	"jb_shop_disguise",	// price for armor
	"jb_shop_nadepack",	// price for nade pack
	"jb_shop_speed",	// price for speed
	"jb_shop_invisibility",	// price for stealth
	"jb_shop_footstep",	// price for footstep
	"jb_crowbar_limit",	// crowbar limit
	"jb_invisibility_limit",// stealth limit
	"jb_footstep_limit",	// footstep limit
	"jb_speed_limit",	// speed limit
	"jb_disguise_limit",	// disguise limit
	"jb_shop_alpha_value",	// alpha value
	"jb_shop_speed_value",	// speed value
	//"jb_admin_daywait",	// How many days an non admin has to wait before starting a day
	//////////////////////////////////////////////////////////////////////////////////////////////////////
	// If set to 0 It will enable rock the day where people can type rtd to start a vote                //
	"jb_startvote_wait",	// How many days/rounds to wait before automaticly starting a day vote      //
	//                                                                                                  //
	//////////////////////////////////////////////////////////////////////////////////////////////////////
	"jb_blockvoice",	// 0- Alltalk 1- Guards can't hear prisoners 2- Prisoners can't talk 
	"jb_fogeffect",		// Enable Fog (1 = Enable) (2 = Disable)
	"jb_enablespray",	// Enable spray (1 = Enable) (2 = Disable)
	"jb_shootbuttons",	// Allow button press by bullets
	"jb_cellkey_limit",	// call keys limit
	"jb_shop_cellkeys",	// price for cell keys
	"jb_unlockvote",	// 1 == one round 2 == two rounds etc...
	"jb_rockthedaypercent"//, // percent needed to start a vote day
	//"jb_headshot_only"	// Head shot only during last request
};

new const cvar_defaults[Cvars][] = {
	"1",		// Enable/disable shop
	"1",		// Points per kill
	"2",		// Additional points per headshot
	"20",		// price for crowbar
	"10",		// price for armor
	"50",		// price for armor
	"10",		// price for nade pack
	"10",		// price for speed
	"10",		// price for stealth
	"10",		// price for footstep
	"2",		// crowbar limit
	"5",		// stealth limit
	"5",		// footstep limit
	"5",		// speed limit
	"1",		// disguise limit
	"120",		// alpha value
	"300",		// speed value
	//"2",		// How many days an non admin has to wait before starting a day
	//////////////////////////////////////////////////////////////////////////////////////////////////////
	// If set to 0 It will enable rock the day where people can type rtd to start a vote                //
	"0",	       // How many days/rounds to wait before automaticly starting a day vote                //
	//                                                                                                  //
	//////////////////////////////////////////////////////////////////////////////////////////////////////
	"1",		// 0- Alltalk 1- Guards can't hear prisoners 2- Prisoners can't talk 
	"1",		// Enable Fog (1 = Enable) (2 = Disable)
	"1",		// Enable spray (1 = Enable) (2 = Disable)
	"1",		// Allow button press by bullets
	"2",		// call keys limit
	"45",		// price for cell keys
	"4",		// rounds waiting before rocking the day again...
	"90"//,		// 90% of the players will need to type rtd inorder to start a voteday....
	//"1"		// 1 = Enable 0 = disabled.
};

new cvar_pointer[Cvars];

/*================================================================================
 [Init]
=================================================================================*/
public plugin_init() 
{
	register_plugin(PLUGIN_NAME, PLUGIN_VERS, PLUGIN_AUTH);
	register_cvar(PLUGIN_CVAR, PLUGIN_VERS, FCVAR_SERVER|FCVAR_SPONLY);
	
	register_dictionary("jailbreakmod.txt");

	// Variables
	g_iMaxPlayers	 	= get_maxplayers();
	g_iMsgSayText	 	= get_user_msgid("SayText");
	g_iMsgTextMsg 	 	= get_user_msgid("TextMsg");
	g_iMsgId_ScreenFade 	= get_user_msgid("ScreenFade");
	g_iMsgFog		= get_user_msgid("Fog");
	g_iMsgDeath		= get_user_msgid("DeathMsg");
	g_iMsgScoreInfo		= get_user_msgid("ScoreInfo");

	g_bCanBuy        = true;
	g_bAutoOpened	= false;
	
	// HAM Forwards
	RegisterHam(Ham_Spawn, "player", "Fwd_PlayerSpawn_Post", 1);
	RegisterHam(Ham_Killed, "player", "Fwd_PlayerKilled_Pre", 0);
	RegisterHam(Ham_TraceAttack, "player", "Fwd_TraceAttack_Player_Post", 1);
	RegisterHam(Ham_TraceAttack, "player", "Fwd_TraceAttack_Player_Pre", 0);
	RegisterHam(Ham_TraceAttack, "func_button", "Fwd_ButtonAttack");
	RegisterHam(Ham_TraceAttack, "func_door", "Fwd_DoorAttack");
	RegisterHam(Ham_Touch, "player", "Fwd_PlayerTouch");
	RegisterHam(Ham_Touch, "weaponbox", "Fwd_PlayerWeaponTouch"); 
	RegisterHam(Ham_Touch, "armoury_entity", "Fwd_PlayerWeaponTouch");
	RegisterHam(Ham_AddPlayerItem, "player", "Player_AddPlayerItem", 0);
	RegisterHam(Ham_Player_ResetMaxSpeed, "player", "Player_ResetMaxSpeed", 1);
	RegisterHam(Ham_TakeHealth, "player", "Player_TakeHealth");
	RegisterHam(Ham_Use, "func_healthcharger", "Fwd_ChargerUse");
	RegisterHam(Ham_Use, "func_recharge", "Fwd_ChargerUse");
	RegisterHam(Ham_TakeDamage, "player", "Fwd_PlayerDamage", 0);
	g_iHhTakeDamagePost = RegisterHam(Ham_TakeDamage, "player", "Player_TakeDamage_Post", 1);
	DisableHamForward(g_iHhTakeDamagePost);
	
	//new szWeaponName[32];
	//for(new i=CSW_P228; i<=CSW_P90; i++)
		//if( get_weaponname(i, szWeaponName, charsmax(szWeaponName)) )
			//RegisterHam(Ham_Item_Deploy, szWeaponName, "Fwd_ItemDeploy_Post", 1);
		
	RegisterHam(Ham_Item_Deploy, "weapon_knife", "Fwd_ItemDeploy2_Post", 1);
	RegisterHam(Ham_Item_Deploy, "weapon_smokegrenade", "Fwd_ItemDeploy_Post", 1);
	RegisterHam(Ham_Item_Deploy, "weapon_usp", "Fwd_Usp_Deploy", 1);
	RegisterHam(Ham_Weapon_SecondaryAttack, "weapon_usp", "Fwd_Usp_SecondaryAttack", 1);

	for (new i = 0; i < sizeof(g_szButtonClasses); i++)
		RegisterHam(Ham_Use, g_szButtonClasses[i], "Fwd_Use_Pre", 0);
        
	register_forward(FM_EmitSound, "sound_emit");
	register_forward(FM_Voice_SetClientListening, "Fwd_SetVoice");
	register_forward(FM_Think, "Fwd_Entity_Think");
	register_forward(FM_SetModel,"Fwd_Model_Think");
	register_forward(FM_AddToFullPack, "Fwd_AddToFullPack", 1);
	
	register_touch(g_szClassNameCrowbar, "worldspawn", "CrowbarTouch");
	register_touch(g_szClassNameCrowbar, "player", "Fwd_PlayerCrowbarTouch");
	//register_touch("weaponbox", "worldspawn", "Touch");
	register_touch("trigger_hurt", "player", "HurtTouch");
	
	unregister_forward(FM_PrecacheEvent, g_fwid, 1);
	register_forward(FM_Touch, "Fwd_Touch");
	register_forward(FM_Touch, "Fwd_Touch_Snowballwar");
	register_forward(FM_PlaybackEvent, "FwdPlaybackEvent");
	register_forward(FM_PlayerPreThink, "Fwd_PlayerPreThink"); 
	
	for(new i = 0; i < Cvars; i++)
		cvar_pointer[i] = register_cvar(cvar_names[i] , cvar_defaults[i]);
		
	g_pRoundTime = get_cvar_pointer("mp_roundtime");

	// Events
	register_logevent("EventRoundStart", 2, "1=Round_Start");
	register_logevent("EventRoundEnd", 2, "1&Restart_Round");
	register_logevent("EventRoundEnd", 2, "1=Game_Commencing");
	register_logevent("EventRoundEnd", 2, "1=Round_End");
	register_event("SendAudio", "Event_SendAudio", "a", "2&%!MRAD_terwin");
	register_event("NVGToggle", "Event_NVGToggle", "be");
	register_event("23", "EventSpray", "a", "1=112");
	register_event("Money", "EventMoney", "b");
	register_message(get_user_msgid("SendAudio"), "MsgSendAudio");
	register_message(get_user_msgid("StatusIcon"), "MsgStatusIcon");
	register_message(get_user_msgid("FlashBat"), "MsgFlashBat");
	register_message(get_user_msgid("Flashlight"), "MsgFlashLight");
	register_message(get_user_msgid("Money"), "MsgMoney");
	register_message(g_iMsgSayText, "MsgSayText");
	register_message(g_iMsgTextMsg, "MsgTextMsg");
	
	// Client Commands
	register_clcmd("wear_disguise", "ClCmd_CheckDisguise", _, "Wear Disguise");
	register_clcmd("glow_blue", "Clcmd_GlowBlue", _, "Glow Blue");
	register_clcmd("glow_red", "Clcmd_GlowRed", _, "Glow Red");
	register_clcmd("unglow", "Clcmd_UnglowPlayer", _, "Unglow Player");
	register_clcmd("drop", "ClCmd_drop", _, "Crowbar Drop");
	register_clcmd("say", "ClCmd_Say", _, "Check Answer");
	
	g_tSayCommands = TrieCreate();
	
	for( new i = 0; i < SayCommands; i++ )
		TrieSetCell(g_tSayCommands, g_szSayCommands[ i ], i);
	
	for(new i = 0; i < sizeof(SayClientCmds); i = i+2)
		rd_register_saycmd(SayClientCmds[i], SayClientCmds[i+1], 0);
	
	register_concmd("amx_take_points", "cmd_take_points", ADMIN_POINTS, "<target> <amount>");
	register_concmd("amx_give_points", "cmd_give_points", ADMIN_POINTS, "<target> <amount>");
	register_concmd("amx_reset_points", "cmd_reset_points", ADMIN_POINTS, "<target>");
	register_concmd("amx_set_button", "cmd_set_button", ADMIN_RCON);
	register_concmd("amx_tagplayer", "tag_player", ADMIN_RCON, "< partial player name > < tag > - Adds a tag to a player");
	register_concmd("amx_untagplayer", "untag_player", ADMIN_RCON);
	register_concmd("amx_untagall", "untag_all", ADMIN_RCON);
	
	g_iTimerEntity = create_entity("info_target");
	entity_set_string(g_iTimerEntity, EV_SZ_classname, "hud_entity");
	register_think("hud_entity", "Fwd_HudThink");
	entity_set_float(g_iTimerEntity, EV_FL_nextthink, get_gametime() + 1.0);

	#if defined SAVE_METHOD_NICK
	g_vault = nvault_open("jbpoints_nicks");
	#endif
	#if defined SAVE_METHOD_IP
	g_vault = nvault_open("jbpoints_ip");
	#endif
	#if defined SAVE_METHOD_ID
	g_vault = nvault_open("jbpoints");
	#endif
	if(g_vault == INVALID_HANDLE)
		set_fail_state( "Error opening Points nVault" );
		
	nVault = nvault_open("CustomPlayerTags");
	
	if(nVault == INVALID_HANDLE)
		set_fail_state( "Error opening Player Tags nVault" );	
}

enum Commands
{
	say,
	say_slash,
	say_dot,
	sayteam,
	sayteam_slash,
	sayteam_dot
};
	
new const say_commands[Commands][] = {
	"say /%s",
	"say %s",
	"say .%s",
	"say_team %s",
	"say_team /%s",
	"say_team .%s"
};

stock rd_register_saycmd(const saycommand[], const function[], flags) {
	static temp[64];
	for (new Commands:i = say; i < Commands; i++)
	{
		formatex(temp, 63, say_commands[i], saycommand);
		register_clcmd(temp, function, flags);
	}
}

public MsgMoney(msgid, dest, id)
{
	set_pdata_int(id, OFFSET_CSMONEY, 0);
	set_msg_arg_int(1, ARG_LONG, 0);
}

public MsgFlashLight(const MsgId, const MsgType, const id)
	set_msg_arg_int(2, ARG_BYTE, 100);

public MsgFlashBat(const MsgId, const MsgType, const id) {
	if(get_msg_arg_int(1) < 100) {
		set_msg_arg_int(1, ARG_BYTE, 100);
		
		set_pdata_int(id, m_iFlashBattery, 100, 5);
	}	
}

new g_iMessage;
public Fwd_ChargerUse( const iEntity, const iCaller ) {
	if( get_user_health( iCaller ) == 100 )
		return HAM_SUPERCEDE;
	
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE || g_bGunGame || g_bSnowballWar || g_bBoxMatch)
	{
		if(!get_bit(g_iMessage, iCaller))
		{
			fnColorPrint(iCaller, "Sorry! You cannot use this right now.");
			set_bit(g_iMessage, iCaller);
			set_task(15.0, "sendmessage", iCaller);
		}
		if( get_pdata_int( iEntity, m_iJuice, 5 ) > 0 )
			set_pdata_int( iEntity, m_iJuice, 0 );
	}
	else
	{
		if( get_pdata_int( iEntity, m_iJuice, 5 ) <= 1 )
			set_pdata_int( iEntity, m_iJuice, 500 );
	}
	
	return HAM_IGNORED;
}

public HurtTouch(iEnt, id)
{
	if( entity_get_float(iEnt, EV_FL_dmg) >= 0.0 )
		return;
	
	if( entity_get_float(id, EV_FL_takedamage) == DAMAGE_NO )
		return;
	
	if( entity_get_int(iEnt, EV_INT_spawnflags) & SF_TRIGGER_HURT_NO_CLIENTS )
		return;
	
	static Float:fTime ; fTime = get_gametime();
	if( entity_get_float(iEnt, EV_FL_dmgtime) > fTime )
	{
		if( fTime != entity_get_float(iEnt, EV_FL_pain_finished) )
		{
			if(  !( entity_get_int(iEnt, EV_INT_impulse) & (1<<(id-1)) )  )
			{
				g_GonnaBeHurt[id] = get_pdata_int(iEnt, m_bitsDamageInflict, 4);
			}
		}
	}
	else
	{
		g_GonnaBeHurt[id] = get_pdata_int(iEnt, m_bitsDamageInflict, 4);
	}
}

public Player_TakeHealth(id, Float:flHealth, bitsDamageType)
{
	if( g_GonnaBeHurt[id] == bitsDamageType )
	{
		g_GonnaBeHurt[id] = -1;
		if(g_iDay[ TOTAL_DAYS ] != DAY_NONE || g_bGunGame || g_bSnowballWar || g_bBoxMatch)
		{
			if(!get_bit(g_iMessage, id))
			{
				fnColorPrint(id, "Sorry! You cannot use this right now.");
				set_bit(g_iMessage, id);
				set_task(15.0, "sendmessage", id);
			}
			return HAM_SUPERCEDE;
		}
	}
	return HAM_HANDLED;
} 

public sendmessage(id)
{
	clear_bit(g_iMessage, id);
}

public Fwd_ButtonAttack(const button, const id, Float:damage, Float:direction[3], const tracehandle, const damagebits)
{
	new Float:fNextUse;
	pev(button, pev_fuser4, fNextUse);
	
	new Float:fGametime = get_gametime();
	new class[32], sModel[32];
	pev(button, pev_classname, class, 32);
	pev(button, pev_model, sModel, 32);
	
	if (fNextUse > fGametime)
		return HAM_IGNORED;
		
	if(is_valid_ent(button) && get_pcvar_num(cvar_pointer[cvar_shootbuttons]) == 1)
	{
		ExecuteHamB(Ham_Use, button, id, 0, 1, 1.0);
		entity_set_float(button, EV_FL_frame, 0.0);
		if( equal(sModel, szModel, 0) )
		{
			new szTargetName[32];
			get_user_name(id, szTargetName, charsmax(szTargetName));
			if(g_bAutoOpened)
				g_bAutoOpened = false;
			else {
				static iTimeLeft, iMinutes, iSeconds;
				iTimeLeft = floatround(g_fRoundTime - (get_gametime() - g_fRoundStartTime),floatround_ceil);
	
				if(iTimeLeft <= 0)
				{
					iMinutes = 0;
					iSeconds = 0;
				}
				else {
					iMinutes = (iTimeLeft / 60);
					iSeconds = (iTimeLeft % 60);
				}
				
				if(id > 0)
					fnColorPrint(0, "%L", 
					LANG_SERVER, "JB_OPENCELLS", '^3', szTargetName, '^1', '^4', '^1', 
					'^3', iMinutes, '^1', '^3', iSeconds > 9 ? "" : "0", iSeconds);
			}
					
			if (!g_bAlreadyOpened)
			{
				remove_task( TASKID );
				g_bAlreadyOpened = true;
				g_bCanBuy = false;
			}
				
			set_pev(button, pev_fuser4, fGametime + get_pdata_float(button, m_flWait, 5));
		}
	}
	return HAM_IGNORED;
}

public Fwd_DoorAttack(const door, const id, Float:damage, Float:direction[3], const tracehandle, const damagebits)
{	
	if(is_valid_ent(door))
	{
		if(g_iDay[ TOTAL_DAYS ] != DAY_NONE)
		{
			ExecuteHamB(Ham_Use, door, id, 0, 1, 1.0);
			entity_set_float(door, EV_FL_frame, 0.0);
		}
		if(get_bit(g_bHasCellKeys, id))
		{
			fnColorPrint(id, "%L", LANG_SERVER, "JB_SHOP_CELLKEY1");
			ExecuteHamB(Ham_Use, door, id, 0, 1, 1.0);
			entity_set_float(door, EV_FL_frame, 0.0);
			clear_bit(g_bHasCellKeys, id);
		}
		if(g_bGunGame)
		{
			ExecuteHamB(Ham_Use, door, id, 0, 1, 1.0);
			entity_set_float(door, EV_FL_frame, 0.0);
		}
	}
	return HAM_IGNORED;
}

public Fwd_PlayerWeaponTouch(const iEntity, const id)
{
	if(!IsPlayer(id))
		return HAM_IGNORED;

	new Model[32];
	pev(iEntity, pev_model, Model, 31);
		
	static CsTeams:team;
	team = cs_get_user_team(id);
	
	switch( g_iDay[ TOTAL_DAYS ] )
	{
		case DAY_ZOMBIE:
			switch(team)
			{
				case CS_TEAM_T: if (!equal(Model, "models/w_ak47.mdl")) return HAM_SUPERCEDE;
				case CS_TEAM_CT: return HAM_SUPERCEDE;
			}
		case DAY_SHARK:
			switch(team)
			{
				case CS_TEAM_T: if (!equal(Model, "models/w_awp.mdl")) return HAM_SUPERCEDE;
				case CS_TEAM_CT: return HAM_SUPERCEDE;
			}
		case DAY_NIGHT:
			switch(team)
			{
				case CS_TEAM_T: if (!equal(Model, "models/w_m4a1.mdl")) return HAM_SUPERCEDE;
				case CS_TEAM_CT: return HAM_SUPERCEDE;
			}
		case DAY_HIDENSEEK:
			if(team == CS_TEAM_T)
				return HAM_SUPERCEDE;
		case DAY_REZOMBIE:
			switch(team)
			{
				case CS_TEAM_T: return HAM_SUPERCEDE;
				case CS_TEAM_CT: if (!equal(Model, "models/w_ak47.mdl")) return HAM_SUPERCEDE;
			}
		case DAY_RESHARK:	
			switch(team)
			{
				case CS_TEAM_T: return HAM_SUPERCEDE;
				case CS_TEAM_CT: if (!equal(Model, "models/w_awp.mdl")) return HAM_SUPERCEDE;
			}
		case DAY_RENIGHT:
			switch(team)
			{
				case CS_TEAM_T: return HAM_SUPERCEDE;
				case CS_TEAM_CT: if (!equal(Model, "models/w_m4a1.mdl")) return HAM_SUPERCEDE;
			}
		case DAY_FREEZETAG:
			return HAM_SUPERCEDE;
		case DAY_GANG:
			if(team == CS_TEAM_T)
				if (!equal(Model, "models/w_mac10.mdl"))
					return HAM_SUPERCEDE;
		case DAY_GRENADE:
			if(team == CS_TEAM_T)
				if (!equal(Model, "models/w_hegrenade.mdl"))
					return HAM_SUPERCEDE;
		case DAY_USPNINJAS:
			if (!equal(Model, "models/w_usp.mdl"))
				return HAM_SUPERCEDE;
	}
	
	if(g_bBoxMatch)
		if(team == CS_TEAM_T)
			return HAM_SUPERCEDE;
			
	if(g_bSnowballWar)
		if(team == CS_TEAM_T)
			if (!equal(Model, "models/w_smokegrenade.mdl"))
				return HAM_SUPERCEDE;
				
	if(g_bGunGame)
		if (!equal(Model, g_szWeaponModels[ g_iGunGameLevel[id][level] ]))
			return HAM_SUPERCEDE;
	
	return HAM_IGNORED;
}
/*
public Touch(weaponbox, worldspawn)
{
	if(pev_valid(weaponbox))
	{
		float_weapon(weaponbox);
		set_task(0.1, "spin_weapon", weaponbox);
	}
}

public float_weapon(ent)
{
	if(pev_valid(ent))
	{

		static iRandom_1; iRandom_1 = random(256);
		static iRandom_2; iRandom_2 = random(256);
		static iRandom_3; iRandom_3 = random(256);
		set_rendering(ent,kRenderFxGlowShell,iRandom_1,iRandom_2,iRandom_3,kRenderNormal,16);
	
		static Float:floatvector[3];
		pev(ent,pev_origin,floatvector);
		floatvector[2] += 30.0;
		set_pev(ent,pev_origin,floatvector);
	
		pev(ent,pev_angles,floatvector);
		floatvector[0] -= 90.0;
		floatvector[1] += 45.0;
		set_pev(ent,pev_angles,floatvector);
	
		set_pev(ent,pev_movetype,MOVETYPE_NOCLIP);
	
		set_pev(ent,pev_solid,SOLID_TRIGGER);
	
		set_pev(ent,pev_velocity,Float:{0.0,0.0,0.0});
	}
}

public spin_weapon(ent)
{
	if(pev_valid(ent))
	{
		static Float:floatvector[3];
	
		floatvector[0] = 0.0;
		floatvector[1] = 25.0;
		floatvector[2] = 0.0;
	
		set_pev(ent,pev_avelocity,floatvector);
	}
}
*/
public Player_AddPlayerItem(const id, const iEntity)
{
	new iWeapID = cs_get_weapon_id( iEntity );

	if( !iWeapID )
		return HAM_IGNORED;
		
	static CsTeams:team;
	team = cs_get_user_team(id);
	switch( g_iDay[ TOTAL_DAYS ] )
	{
		case DAY_ZOMBIE:
			switch(team)
			{
				case CS_TEAM_T:
					if(iWeapID != CSW_KNIFE && iWeapID != CSW_AK47)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
				case CS_TEAM_CT:
					if(iWeapID != CSW_KNIFE)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
			}
		case DAY_SHARK:
			switch(team)
			{
				case CS_TEAM_T:
					if(iWeapID != CSW_KNIFE && iWeapID != CSW_AWP)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
				case CS_TEAM_CT:
					if(iWeapID != CSW_KNIFE)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
			}
		case DAY_NIGHT:
			switch(team)
			{
				case CS_TEAM_T:
					if(iWeapID != CSW_KNIFE && iWeapID != CSW_M4A1)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
				case CS_TEAM_CT:
					if(iWeapID != CSW_KNIFE)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
			}
		case DAY_HIDENSEEK:
			if(team == CS_TEAM_T)
				if(iWeapID != CSW_KNIFE)
				{
					SetHamReturnInteger( 1 );
					return HAM_SUPERCEDE;
				}
		case DAY_REZOMBIE:
			switch(team)
			{
				case CS_TEAM_T:
					if(iWeapID != CSW_KNIFE)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
				case CS_TEAM_CT:
					if(iWeapID != CSW_KNIFE && iWeapID != CSW_AK47)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
			}
		case DAY_RESHARK:
			switch(team)
			{
				case CS_TEAM_CT:
					if(iWeapID != CSW_KNIFE && iWeapID != CSW_AWP)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
				case CS_TEAM_T:
					if(iWeapID != CSW_KNIFE)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
			}
		case DAY_RENIGHT:
			switch(team)
			{
				case CS_TEAM_T:
					if(iWeapID != CSW_KNIFE)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
				case CS_TEAM_CT:
					if(iWeapID != CSW_KNIFE && iWeapID != CSW_M4A1)
					{
						SetHamReturnInteger( 1 );
						return HAM_SUPERCEDE;
					}
			}
		case DAY_FREEZETAG:
			if(iWeapID != CSW_KNIFE)
			{
				SetHamReturnInteger( 1 );
				return HAM_SUPERCEDE;
			}
		case DAY_GANG:
			if(team == CS_TEAM_T)
				if(iWeapID != CSW_KNIFE && iWeapID != CSW_MAC10)
				{
					SetHamReturnInteger( 1 );
					return HAM_SUPERCEDE;
				}
		case DAY_GRENADE:
			if(team == CS_TEAM_T)
				if(iWeapID != CSW_KNIFE && iWeapID != CSW_HEGRENADE)
				{
					SetHamReturnInteger( 1 );
					return HAM_SUPERCEDE;
				}
		case DAY_USPNINJAS:
			if(iWeapID != CSW_KNIFE && iWeapID != CSW_USP)
			{
				SetHamReturnInteger( 1 );
				return HAM_SUPERCEDE;
			}
	}
	
	if(g_bBoxMatch)
		if(team == CS_TEAM_T)
			if(iWeapID != CSW_KNIFE)
			{
				SetHamReturnInteger( 1 );
				return HAM_SUPERCEDE;
			}
			
			
	if(g_bSnowballWar)
		if(team == CS_TEAM_T)
			if(iWeapID != CSW_KNIFE && iWeapID != CSW_SMOKEGRENADE)
			{
				SetHamReturnInteger( 1 );
				return HAM_SUPERCEDE;
			}
			
	if(g_bGunGame)
		if (iWeapID != CSW_KNIFE && iWeapID != g_iWeaponLevel[g_iGunGameLevel[id][level]])
		{
			SetHamReturnInteger( 1 );
			return HAM_SUPERCEDE;
		}

	
	return HAM_IGNORED;
}

public plugin_precache()
{
	g_fwid = register_forward( FM_PrecacheEvent, "FwdPrecacheEvent", 1 );
	
	g_iRingSprite = precache_model("sprites/shockwave.spr");
	
	static i;
	for(i = 0; i < sizeof(CrowbarModels); i++)
		precache_model(CrowbarModels[i]);
 
	for(i = 0; i < sizeof(CrowbarSounds); i++)
		precache_sound(CrowbarSounds[i]);
		
	for(i = 0; i < sizeof(BoxingModels); i++)
		precache_model(BoxingModels[i]);
 
	for(i = 0; i < sizeof(BoxingSounds); i++)
		precache_sound(BoxingSounds[i]);
		
	for(i = 0; i < sizeof(SnowballWarModels); i++)
		precache_model(SnowballWarModels[i]);
		
	for(i = 0; i < sizeof(SnowballWarSounds); i++)
		precache_sound(SnowballWarSounds[i]);
		
	for(i = 0; i < sizeof(GunGameSounds); i++)
		precache_sound(GunGameSounds[i]);
		
	precache_model(ZombieModels[0]);
	g_iLaserSprite = precache_model( g_szLaserSprite );
	
	for(i = 0; i < sizeof(NightCrawlerModels); i++)
		precache_model(NightCrawlerModels[i]);
		
	precache_model("models/player/urban/urban.mdl");
	precache_model("models/player/leet/leet.mdl");

	g_iSpriteArrow = precache_model("sprites/arrow1.spr");
	g_iSpriteLine  = precache_model("sprites/smoke.spr");
	g_iDrop = precache_model("sprites/blood.spr");
	g_iSpray = precache_model("sprites/bloodspray.spr");
	g_iGlass = precache_model("models/glassgibs.mdl");
	
	precache_sound(g_szSound_Bell);
	for(i = 0; i < sizeof(NightCrawlerSounds); i++)
		precache_sound(NightCrawlerSounds[i]);
	
	g_buttonvault = nvault_open("cellbuttons");
	if(g_buttonvault == INVALID_HANDLE)
		set_fail_state("Error opening Cell Buttons nVault");
	RegisterHam(Ham_Spawn, "func_button", "ButtonSpawn");
	Get_Button();
}

public FwdPrecacheEvent( type, const name[] ) {
	for( new i = 0; i < sizeof g_iGunEvents; ++i ) {
		if( equal( g_iGunEvents[ i ], name ) ) {
			g_iGunEvent_IDsBitsum |= ( 1<<get_orig_retval() );
			return FMRES_HANDLED;
		}
	}
	return FMRES_IGNORED;
}
new g_iFinalT;

public FwdPlaybackEvent( flags, id, eventid ) {
	if( !( g_iGunEvent_IDsBitsum & ( 1<<eventid) ) || !(1 <= id <= g_iMaxPlayers ) && !g_bInLr && g_iGameType != 2)
		return FMRES_IGNORED;
	if(id == g_iFinalT && get_bit(g_bIsLast, g_iFinalT) && g_iGetUserWeapon == get_user_weapon(g_iFinalT))	
	{
		new wepID = find_ent_by_owner(-1, g_szWeaponNames[g_iGetUserWeapon], g_iFinalCT);
		if(wepID)
			cs_set_weapon_ammo(wepID, 1);
	}
	if(id == g_iFinalCT && get_bit(g_bIsChosen, g_iFinalCT) && g_iGetUserWeapon == get_user_weapon(g_iFinalCT))
	{
		new wepID = find_ent_by_owner(-1, g_szWeaponNames[g_iGetUserWeapon], g_iFinalT);
		if(wepID)
			cs_set_weapon_ammo(wepID, 1);
	}
	return FMRES_HANDLED;
}

public plugin_cfg()
	get_mapname(szMap, 32);

public client_putinserver(id) {
	if(bool:!is_user_hltv(id))
		set_bit(g_bIsConnected, id);
		
	fm_set_speak(id, SPEAK_NORMAL);
	
	clear_bit(g_bIsAlive, id);
	clear_bit(g_bHasVoted, id);
	clear_bit(check_bteam, id);
	clear_bit(check_rteam, id);
	clear_bit(check_gteam, id);
	clear_bit(g_bHide, id);
	reset_all(id);
	
	get_user_info(id, "name", g_iUserName[id], 31);
	new szTag[32], authid[32], data;
	get_user_authid(id, authid, charsmax(authid));
	data = nvault_get(nVault, authid, szTag, charsmax(szTag));
	if(data)
	{
		formatex(g_iUserTagName[id], 54, "[%s] %s", szTag, g_iUserName[id]);
		set_bit(g_bUserHasTag, id);
	}
	else
	{
		formatex(g_iUserTagName[id], 54, "%s", g_iUserName[id]);
		clear_bit(g_bUserHasTag, id);
	}
}

public client_authorized(id) {
	if(!is_user_bot(id) && !is_user_hltv(id))
	{
		#if defined SAVE_METHOD_NICK
		get_user_name(id, g_iAuth[id], charsmax(g_iAuth));
		#endif
		#if defined SAVE_METHOD_IP
		get_user_ip(id, g_iAuthIP[id], charsmax(g_iAuthIP));
		#endif
		#if defined SAVE_METHOD_ID
		get_user_authid(id, g_iAuthID[id], charsmax(g_iAuthID));
		#endif
		
		GetData(id);
	}
}

public plugin_end(){
	TrieDestroy(g_tSayCommands);
	nvault_close(g_vault);
	nvault_close(g_buttonvault);	
}

new g_iRandom;
public client_disconnect(id){
	if(get_bit(g_bIsSimon, id)){
		ResetSimon(id);
	}
	remove_task(id+TASK_BEAM);
	if(task_exists(id)) 
		remove_task(id);	
	// Save Points
	SaveData(id);
	clear_bit(g_bIsConnected, id);
	clear_bit(g_bIsAlive, id);
	clear_bit(g_bHasVoted, id);
	clear_bit(check_bteam, id);
	clear_bit(check_rteam, id);
	clear_bit(check_gteam, id);
	clear_bit(g_iMessage, id);
	
	switch(g_iDay[TOTAL_DAYS])
	{
		case DAY_FREEZETAG: CheckTerrorist( );
		case DAY_NIGHT: 
			if(id == g_iRandom) 
				g_iRandom = fnGetRandomPlayer();
		case DAY_RENIGHT: 
			if(id == g_iRandom)
				g_iRandom = fnGetCTRandomPlayer();
		case DAY_GANG: 
		{
			if(get_bit(check_rteam, id))
			{
				check_redteam--;
				clear_bit(check_rteam, id);
			}
			if(get_bit(check_bteam, id))
			{
				check_blueteam--;
				clear_bit(check_bteam, id);
			}
			if(get_bit(check_gteam, id))
			{
				clear_bit(check_gteam, id);
			}
			CheckTerrorist2( );
		}
	}
}

public status(id)
	if( g_iDay[ TOTAL_DAYS ] == DAY_FREEZETAG )
		fnColorPrint(id, "%L", LANG_SERVER, "JB_FREEZETAG_M1", '^3', fnGetTerrorists(), '^1', '^3', g_FrozenT );
		
public CmdRockTheDay(id) {
	
	new g_autostartvote = get_pcvar_num(cvar_pointer[cvar_autostartvote]);
	if(g_autostartvote != 0)
	{
		fnColorPrint(id, "Sorry! but auto vote day is enabled.");
		return PLUGIN_HANDLED;
	}

	if(g_bVoteLocked) {
		fnColorPrint(id, "You must wait to rock the day again!");
		return PLUGIN_HANDLED;
	}
	
	if( gVoting )
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M11");
		return PLUGIN_HANDLED;
	}
	
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE){
		fnColorPrint(id, "No rocking the day during fun day!");
		return PLUGIN_HANDLED;
	}
	
	g_iRockTheDay[id] = 1;
	new count = 0;
	new connected = 0;
	static iPlayers[32], iNum, iPlayer, i;
	get_players( iPlayers, iNum ); 
	for( i = 0; i < iNum; i++ )
	{
		iPlayer = iPlayers[i];
		connected++;
		if(g_iRockTheDay[iPlayer] != 0) {
			count ++;
		}
	}
	
	new Float:g_dPeopleNeeded = get_pcvar_num(cvar_pointer[cvar_rockthedaypercent])/100.0;
	if( floatround(float(connected) * g_dPeopleNeeded) - count < 1 )
	{
		fnColorPrint(0, "^1Enough people have^3 rock the day!");
	}
	else if(get_bit(g_bHasVoted, id))
	{
		fnColorPrint(id, "^1You have already^3 rock the day!");
	}
	else
	{
		fnColorPrint(id, "^1Need ^3%d^1 More to^3 rock the day!", floatround(float(connected) * g_dPeopleNeeded) - count);
		set_bit(g_bHasVoted, id);

		new Players[32];
		new playerCount, i, iPlayer;
		new szName[32];
		get_user_name(id, szName, 31);
		get_players(Players, playerCount);
		for (i=0; i<playerCount; i++) 
		{
			iPlayer = Players[ i ];
			if(iPlayer != id)
			{
				fnColorPrint(iPlayer, "^3%s^1 has^3 rock the day^1 out of [^4 %d^1/^4%d^1 ]", szName, count, floatround(float(connected) * g_dPeopleNeeded));
			}
		}
	}
	
	if(floatround(float(connected) * g_dPeopleNeeded) <= count) {

		VoteConfigs();
		
		new Players[32];
		new playerCount, i;
		get_players(Players, playerCount);
		for (i=0; i<playerCount; i++) 
			clear_bit(g_bHasVoted, Players[ i ]);
	}
	return PLUGIN_HANDLED;	
}
new g_iOnNewRound = false;
public VoteConfigs() {
	
	static iPlayers[32], iNum, iPlayer, i;
	get_players( iPlayers, iNum ); 
	for( i = 0; i < iNum; i++ )
	{
		iPlayer = iPlayers[i];
		g_iRockTheDay[iPlayer] = 0;
	}
	g_bVoteLocked = true;
	g_iOnNewRound = true;
	fnColorPrint(0, "Voting will begin on new day.");
}
	
public EventRoundStart() {
	g_fRoundTime = floatmul(get_pcvar_float(g_pRoundTime),60.0);
	g_fRoundStartTime = get_gametime();
	
	set_task(CELL_TIMER, "TASK_PushButton", TASKID );//61
	//if(g_iAdminDay >= 1)
		//g_iAdminDay--;
	
	if(g_iOnNewRound)
	{
		g_iOnNewRound = false;
		set_task(3.0, "CheckVoteDay");
	}
	new g_autostartvote = get_pcvar_num(cvar_pointer[cvar_autostartvote]);
	if( g_autostartvote == 0 )
	{
		g_iWaitUnlock++;
		new g_timeunlockrtd = get_pcvar_num(cvar_pointer[cvar_timeunlockrtd]);
		if( g_iWaitUnlock-1 == g_timeunlockrtd )	
		{
			g_bVoteLocked = false;
			g_iWaitUnlock = 0;
		}
	}
	else {
		g_iAutoStartVote++;
		if(g_iAutoStartVote == g_autostartvote)
		{
			fnColorPrint(0, "%L", LANG_SERVER, "JB_VOTEDAY_M1");
			set_task(5.0, "CheckVoteDay");
			g_iAutoStartVote = 0;
		}
	}
	
	// Reset LR Blocker
	g_iBlockLastRequest = 0;
	g_bDayHasStarted = false;
	g_bTeamDivided = false;
	g_bInLr = false;
	g_bAlreadyOpened = false;
	g_bAutoOpened = false;
	g_bCanBuy = true;
	g_bBoxMatch = false;
	g_bSnowballWar = false;
	g_bGunGame = false;
	g_iCrowbars = 0;
	g_iDisguise = 0;
	g_iFootstep = 0;
	g_iCellKeys = 0;
	g_iInvis = 0;
	g_iSpeed = 0;
	remove_entity_name(g_szClassNameCrowbar);
	Day_Ends( );
}

public CheckVoteDay()
{
	static iPlayers[32], iNum, iPlayer, i;
	get_players( iPlayers, iNum ); 
	for( i = 0; i < iNum; i++ )
	{
		iPlayer = iPlayers[i];
		StartVote(iPlayer, 0);
	}
}

public specialday_check(id){
	if(get_user_team(id) != 2 )
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M1");
		return PLUGIN_HANDLED;
	}
	
	if(!access(id, DAY_ACCESS) )
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M2");
		return PLUGIN_HANDLED;
	}
	
	if(!get_bit(g_bIsConnected, id))	
		return PLUGIN_HANDLED;

	if(!get_bit(g_bIsAlive, id))
	{	
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M3");
		return PLUGIN_HANDLED;
	}
	
	if(g_bDayHasStarted)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M4");
		return PLUGIN_HANDLED;
	}
	if(g_iAreWeInaVote)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M5");
		return PLUGIN_HANDLED;
	}
	/*
	static g_iAdminDayChat;
	if( g_iAdminDay == 1 )
		g_iAdminDayChat = true;
	else g_iAdminDayChat = false;

	if( g_iAdminDay >= 1 && !access(id, DAY_ACCESS) )
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M6", g_iAdminDay, g_iAdminDayChat ? "" : "s" );
		return PLUGIN_HANDLED;
	}*/
	
	if(fnGetTerrorists() <= 1)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M7");
		return PLUGIN_HANDLED;
	}
	
	specialday_menu(id);
	return PLUGIN_HANDLED;
}

public specialday_ends(id)
{
	if(get_user_team(id) != 2){
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M8");	
		return PLUGIN_HANDLED;
	}
	if(g_iDay[ TOTAL_DAYS ] == DAY_NONE){
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M9");
		return PLUGIN_HANDLED;
	}
	static szName[32]; get_user_name(id, szName, charsmax(szName));
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M10", '^3', szName, '^1');

	Day_Ends( );

	return PLUGIN_HANDLED;
}

stock StripPlayerWeapons(id)
{
	//strip_user_weapons(id); 
	//give_item(id, "weapon_knife");
	//new const DONT_STRIP = ( 1 << 2 ) | ( 1 << CSW_KNIFE );
		
	for(new i=CSW_P228; i<=CSW_P90; i++)
	{
		//if( DONT_STRIP & ( 1 << i ) )
			//continue;
		if(g_iGameType == 4)
			if(g_iGetUserWeapon == get_user_weapon(id))
				continue;
		ham_strip_user_weapon(id, i);
	}
	if(HasShield(id))
	{
		strip_user_weapons(id); 
		
	}
	give_item(id, "weapon_knife");
	//for(new i=CSW_P228; i<=CSW_P90; i++)
		//ham_strip_user_weapon(id, i);
}
//Connors Stock Thanks
stock ham_strip_user_weapon(id, iCswId, iSlot = 0, bool:bSwitchIfActive = true) 
{ 
	new iWeapon;
	if( !iSlot ) 
	{ 
		static const iWeaponsSlots[] = { 
			-1, 
			2, //CSW_P228 
			-1, 
			1, //CSW_SCOUT 
			4, //CSW_HEGRENADE 
			1, //CSW_XM1014 
			5, //CSW_C4 
			1, //CSW_MAC10 
			1, //CSW_AUG 
			4, //CSW_SMOKEGRENADE 
			2, //CSW_ELITE 
			2, //CSW_FIVESEVEN 
			1, //CSW_UMP45 
			1, //CSW_SG550 
			1, //CSW_GALIL 
			1, //CSW_FAMAS 
			2, //CSW_USP 
			2, //CSW_GLOCK18 
			1, //CSW_AWP 
			1, //CSW_MP5NAVY 
			1, //CSW_M249 
			1, //CSW_M3 
			1, //CSW_M4A1 
			1, //CSW_TMP 
			1, //CSW_G3SG1 
			4, //CSW_FLASHBANG 
			2, //CSW_DEAGLE 
			1, //CSW_SG552 
			1, //CSW_AK47 
			3, //CSW_KNIFE 
			1 //CSW_P90 
		};
		iSlot = iWeaponsSlots[iCswId];
	} 
	
	const m_rgpPlayerItems_Slot0 = 367;
	
	iWeapon = get_pdata_cbase(id, m_rgpPlayerItems_Slot0 + iSlot, XO_PLAYER); 
	
	const XTRA_OFS_WEAPON = 4; 
	const m_pNext = 42; 
	const m_iId = 43; 
	
	while( iWeapon > 0 ) 
	{ 
		if( get_pdata_int(iWeapon, m_iId, XTRA_OFS_WEAPON) == iCswId ) 
		{ 
			break; 
		} 
		iWeapon = get_pdata_cbase(iWeapon, m_pNext, XTRA_OFS_WEAPON); 
	} 
	
	if( iWeapon > 0 ) 
	{ 
		if( bSwitchIfActive && get_pdata_cbase(id, m_pActiveItem, XO_PLAYER) == iWeapon ) 
		{ 
			ExecuteHamB(Ham_Weapon_RetireWeapon, iWeapon); 
		} 
	
		if( ExecuteHamB(Ham_RemovePlayerItem, id, iWeapon) ) 
		{ 
			user_has_weapon(id, iCswId, 0); 
			ExecuteHamB(Ham_Item_Kill, iWeapon); 
			return 1; 
		} 
	} 
	
	return 0;
}

public Day_Ends( )
{
	if( g_iDay[ TOTAL_DAYS ] == DAY_NONE )
		return PLUGIN_HANDLED;
		
	server_cmd("sv_gravity 800");
	switch (g_iDay[ TOTAL_DAYS ])
	{
		case DAY_ZOMBIE, DAY_REZOMBIE, DAY_NIGHT, DAY_RENIGHT, DAY_GRENADE:
		{
			set_lights("#OFF");
			fog(false);
		}
		case DAY_GANG:
		{
			check_blueteam = 0;
			check_redteam = 0;
		}
		case DAY_USPNINJAS:server_cmd("mp_footsteps 1");
	}

	static CsTeams:team;
	static iPlayers[32], iNum, i, iPlayer;
	get_players( iPlayers, iNum, "a"); 
	for ( i=0; i<iNum; i++ ) 
	{
		iPlayer = iPlayers[i];

		team = cs_get_user_team(iPlayer);
		set_user_health(iPlayer, g_100HP);	
		set_user_noclip(iPlayer, 0);
		set_user_footsteps(iPlayer, 0);
		set_user_maxspeed(iPlayer, 250.0);
		set_user_rendering(iPlayer, _, 0, 0, 0, _, 0);
		switch(g_iDay[ TOTAL_DAYS ])
		{
			case DAY_ZOMBIE:
			{	
				g_iDeaths[iPlayer] = 0;
				if(team == CS_TEAM_CT)
				{
					if( g_ThermalOn[iPlayer] )
					{
						engclient_cmd(iPlayer, "nightvision");
						cs_set_user_nvg(iPlayer,false);
					}
					else cs_set_user_nvg(iPlayer,false);
				}
			}
			case DAY_REZOMBIE:
			{	
				g_iDeaths[iPlayer] = 0;
				if(team == CS_TEAM_T)
				{
					if( g_ThermalOn[iPlayer] )
					{
						engclient_cmd(iPlayer, "nightvision");
						cs_set_user_nvg(iPlayer,false);
					}
					else cs_set_user_nvg(iPlayer,false);
				}
			}
			case DAY_FREEZETAG: Unfreeze(iPlayer);
			case DAY_GANG:
			{
				clear_bit(check_bteam, iPlayer);
				clear_bit(check_rteam, iPlayer);
				clear_bit(check_gteam, iPlayer);
			}
			case DAY_HIDENSEEK: Unfreeze(iPlayer);
			case DAY_GRENADE: clear_bit(check_gteam, iPlayer);
		}
		if(is_user_stuck(iPlayer))
			ClientCommand_UnStuck(iPlayer);
			
		g_iDay[ TOTAL_DAYS ] = DAY_NONE;
		
		switch(team)
		{
			case CS_TEAM_T: { StripPlayerWeapons(iPlayer); }
			case CS_TEAM_CT: 
			{ 
				clear_bit2(iPlayer, checkWeapon);
				RestoreWeapons(iPlayer);
				if(!get_bit2(iPlayer, checkWeapon))
				{
					GiveItem2(iPlayer, CSW_M4A1);
					GiveItem2(iPlayer, CSW_DEAGLE);
					clear_bit2(iPlayer, checkWeapon);
					//fnColorPrint(iPlayer, "Failed to retrieve your weapons!");
				}
			}
		}
		if(!get_bit(g_bUserHasTag, iPlayer))
			remove_tag_player(iPlayer);
		else
		{
			new szTag[32], authid[32], data;
			get_user_authid(iPlayer, authid, charsmax(authid));
			data = nvault_get(nVault, authid, szTag, charsmax(szTag));
			if(data)
				formatex(g_iUserTagName[iPlayer], 54, "[%s] %s", szTag, g_iUserName[iPlayer]);
		}
		if (get_user_weapon(iPlayer) == CSW_KNIFE) 
		{
			cs_reset_user_weapon(iPlayer);
		}
		cs_reset_user_model(iPlayer);
		emit_sound(iPlayer, CHAN_VOICE, NightCrawlerSounds[0], 0.0, ATTN_NORM, SND_STOP, PITCH_NORM);
	}

	return PLUGIN_HANDLED;
}
		
public CheckStartVote(id)
{
	if( gVoting )
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M11");
		return PLUGIN_HANDLED;
	}
	if( !access(id, VOTEDAY_ACCESS) )
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_NOACCESS");
		return PLUGIN_HANDLED;
	}
	
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE || g_bDayHasStarted  || fnGetTerrorists() <= 1 || fnGetCounterTerrorists() == 0)
	{
		return PLUGIN_HANDLED;
	}
	
	StartVote(id, 0);
	return PLUGIN_HANDLED;
}

//new bool:hasvoted;
public StartVote(id, iPage){
	if(g_bDayHasStarted || g_iBlockLastRequest)
		return PLUGIN_HANDLED;
	if(g_bInLr && task_exists(TASK_DAYTIMER))
		return PLUGIN_HANDLED;
			
	if( !task_exists(TASK_DAYTIMER) )
	{
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M12");
		g_DayTimer = 30;
		set_task( 1.0, "EndVote", TASK_DAYTIMER, _, _, "b" );
	}
	
	new gMenu[256];
	formatex( gMenu, charsmax(gMenu), "%L", LANG_SERVER, "JB_VOTEMENU_TITLE", g_szPluginPrefix, g_DayTimer );
	
	gVoteMenu = menu_create( gMenu, "menu_handler" );

	new iNumber[5], szOption[48];
	//new bigger = 0;

	for( new i = 1; i < g_iStartDay; i++ )
	{
		if( SKIP_DAYS & ( 1 << i )/* || g_bVoteDayUsed[i] == true*/)
			continue;
		
		num_to_str(i, iNumber, 4);
		formatex(szOption, 47, "%L", LANG_SERVER, "JB_VOTEMENU_SUB", g_bVoteDayUsed[i] ? "\d" : "",  LANG_SERVER, g_iStartDayNames[i], gVotes[i]);
		menu_additem(gVoteMenu, szOption, iNumber);
	}

	menu_display(id, gVoteMenu, iPage);
	if( access(id, VOTEDAY_ACCESS) )
			gVoting += WEIGHT_ADMIN;
		else
			gVoting += WEIGHT_PLAYER;
			
	clear_bit(g_bHasClosedMenu, id);
	g_iAreWeInaVote = true;

	return PLUGIN_HANDLED;
}

new iPage;
public menu_handler(id, gVoteMenu, item)
{
	//If the menu was exited or if there is not a vote
	if( item == MENU_EXIT || !gVoting )
	{
		set_bit(g_bHasClosedMenu, id);
		menu_destroy(gVoteMenu);
		return PLUGIN_HANDLED;
	}
	if(get_bit(g_bHasVotedAlready, id))
	{
		player_menu_info(id, gVoteMenu, gVoteMenu, iPage); 
		StartVote(id, iPage);
		return PLUGIN_HANDLED;
	}
	
	new data[6], name[64];
	new access, callback;
	menu_item_getinfo(gVoteMenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new szKey = str_to_num(data);
	
	new szName[32]; get_user_name(id, szName, charsmax(szName));
	
	if(g_bVoteDayUsed[ szKey ])
	{
		fnColorPrint(id, "Sorry! %L has already been locked untill next vote.", LANG_SERVER, g_iStartDayNames[ szKey ]);
		player_menu_info(id, gVoteMenu, gVoteMenu, iPage); 
		StartVote(id, iPage);
		return PLUGIN_HANDLED;
	}

	if( !get_bit(g_bHasVotedAlready, id) && get_user_flags(id) & VOTEDAY_ACCESS)
	{
		gVotes[szKey] += WEIGHT_ADMIN;
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M13", '^3', szName, '^1', LANG_SERVER, g_iStartDayNames[ szKey ], '^4', '^1', '^4');
		//hasvoted = true;
	}
	else if( !get_bit(g_bHasVotedAlready, id) )
	{
		gVotes[szKey] += WEIGHT_PLAYER;
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M14", '^3', szName, '^1', LANG_SERVER, g_iStartDayNames[ szKey ], '^4', '^1', '^4');
		//hasvoted = true;
	}

	set_bit(g_bHasVotedAlready, id);
	player_menu_info(id, gVoteMenu, gVoteMenu, iPage); 
	StartVote(id, iPage);

	return PLUGIN_HANDLED;
	
}
new g_iBlock = true;
public EndVote()
{

	g_DayTimer--;
	if( g_DayTimer >= 0 )
	{
		static iPlayers[32], iNum, iPlayer, i;
		get_players( iPlayers, iNum ); 
		for( i = 0; i < iNum; i++ )
		{
			iPlayer = iPlayers[i];
			player_menu_info(iPlayer, gVoteMenu, gVoteMenu, iPage); 
			if(!get_bit(g_bHasClosedMenu, iPlayer))
				StartVote(iPlayer, iPage);
		}
	}
	
	if( !g_bInLr && g_DayTimer <= 5 && !g_iBlockLastRequest)
	{
		new sSound[16];
		num_to_word(g_DayTimer, sSound, 15);
		client_cmd(0, "spk vox/%s.wav", sSound);
	}
	
	if( g_DayTimer <= 0 ) // if for some reason it glitches and gets below zero
	{
		remove_task(TASK_DAYTIMER);
		new bigger = 0;

		for( new i=1; i<g_iStartDay; i++ )
		{
			if( gVotes[i] > gVotes[bigger] )
			{
				bigger = i;
			}
		}
		
		if( bigger == 0 )
		{
			bigger = random_num(1,13);
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M15");
		}

		EXEC_DayAction(bigger);
		gVoting = 0;
		g_DayTimer = 0;
		for( new i=1; i<g_iStartDay; i++ )
		{
			gVotes[i] = 0;
		}
	}
	if( g_bInLr )
	{
		remove_task(TASK_DAYTIMER);
		EXEC_DayAction(0);
		gVoting = 0;
		g_DayTimer = 0;
		for( new i=1; i<g_iStartDay; i++ )
		{
			gVotes[i] = 0;
		}
	}
	
	if( g_iBlockLastRequest )
	{
		if(!g_iBlock)
			fnColorPrint(0, "Vote Timer has been paused will resume on new round!");
		g_iBlock = true;
		g_DayTimer++;
	}
	else
	{
		g_iBlock = false;
	}
}

EXEC_DayAction(iValue)
{
	static iPlayers[32], iNum, i, iPlayer;
	get_players(iPlayers, iNum); 
	new newmenu;
	for(i=0;i<iNum;i++)
	{
		iPlayer = iPlayers[i];
		clear_bit(g_bHasVotedAlready, iPlayer);
		if( !get_bit(g_bHasClosedMenu, iPlayer) && player_menu_info(iPlayer, gVoteMenu, newmenu) )
		{
			menu_cancel(iPlayer);
			client_cmd(iPlayer, "slot1" );
		}
		clear_bit(g_bHasClosedMenu, iPlayer);
	}
	iPage = 0;
	if(!g_bInLr)
	{

		for( new i = 1; i < g_iStartDay; i++ )
		{
			if( SKIP_DAYS & ( 1 << i )/* || g_bVoteDayUsed[i] == true*/)
				continue;
				
			g_bVoteDayUsed[i] = false;
		}
		g_bVoteDayUsed[iValue] = true;
		//hasvoted = false;
		g_iDay[ TOTAL_DAYS ] = iValue;
		do_specialday(0);
	}
	g_iAreWeInaVote = false;
}

public specialday_menu(id)
{
	new gMenu[256];
	formatex( gMenu, charsmax(gMenu), "%L", LANG_SERVER, "JB_DAYMENU_TITLE");
	
	new specialdaymenu = menu_create( gMenu, "specialday_submenu" );
	
	new iNumber[5], szOption[64];
	for( new i = 1; i < g_iStartDay; i++ )
	{
		num_to_str(i, iNumber, 4);
		formatex(szOption, 63, "%L ", LANG_SERVER, g_iStartDayNames[i]);
		menu_additem(specialdaymenu, szOption, iNumber);
	}
		
	menu_setprop(specialdaymenu, MPROP_EXIT, MEXIT_ALL);
	menu_display(id, specialdaymenu, 0);
}

public specialday_submenu(id, specialdaymenu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(specialdaymenu);
		return PLUGIN_HANDLED;
	}
	
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
	
	if(!get_bit(g_bIsAlive, id))
	{
		menu_destroy(specialdaymenu);
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(specialdaymenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new Key = str_to_num(data);
	for( new i = 1; i < g_iStartDay; i++ )
		g_iDay[ i ] = Key;

	//g_iAdminDay = get_pcvar_num(cvar_pointer[cvar_admindaywait]) + 1;
	do_specialday(id);
	menu_destroy(specialdaymenu);
	return PLUGIN_HANDLED;
}

public do_specialday(id)
{
	if(g_bDayHasStarted)
	{
		return PLUGIN_HANDLED;
	}
	if(g_iDay[ TOTAL_DAYS ] == DAY_DEATHMATCH)
	{
		iRandom = random( sizeof(szWeapons) );
	}
	static iPlayers[32], iNum, i, iPlayer;
	get_players( iPlayers, iNum, "a" ); 
	
	if(g_bBoxMatch || g_bSnowballWar || g_bGunGame)
	{
		g_bBoxMatch = false;
		g_bSnowballWar = false;
		g_bGunGame = false;
		for( new i; i<iNum; i++ ) { 
			
			iPlayer = iPlayers[i]; 
			cs_reset_user_weapon(iPlayer);
		}
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M16");
	}
	switch(g_iDay[ TOTAL_DAYS ])
	{
		case DAY_GRAVITY: server_cmd("sv_gravity %d", GRAVITY_DAY);
		case DAY_LAVA: server_cmd("decalfrequency 5");
		case DAY_HIDENSEEK:
		{
			g_Timer = HIDE_N_SEEK_TIMER;
			//g_bFrozenTime = true;
			set_task( 1.0, "countdown", TASK_HNS);
		}
		case DAY_FREEZETAG:
		{
			server_cmd("sv_gravity %d", FREEZETAG_GRAVITY);
			g_FrozenT = 0;
		}
		case DAY_ZOMBIE:
		{
			set_lights(g_iZombieDayLights);
			if(get_pcvar_num(cvar_pointer[cvar_fogeffect]) == 1)
				fog(true);
		}
		case DAY_REZOMBIE:
		{
			set_lights(g_iZombieDayLights);
			if(get_pcvar_num(cvar_pointer[cvar_fogeffect]) == 1)
				fog(true);
		}
		case DAY_GRENADE:
		{
			set_lights(g_iGrenadeDayLights);
			server_cmd("sv_gravity 500");
		}
		case DAY_NIGHT:
		{
			set_lights(g_iNightCrawlerDayLights);
			g_iRandom = fnGetRandomPlayer();
		}
		case DAY_RENIGHT:
		{
			set_lights(g_iNightCrawlerDayLights);
			g_iRandom = fnGetCTRandomPlayer();
		}
		case DAY_USPNINJAS:server_cmd("mp_footsteps 0");
	}
	g_bCanBuy = false;
	
	if(pev_valid(iEnt))
	{
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M21");
		ExecuteHamB(Ham_Use, iEnt, 0, 0, 1, 1.0);
	}
	else {
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M22");
		OpenDoors("func_door");
		OpenDoors("func_door_rotating");
	}
		
	if(!g_bAlreadyOpened) {
		remove_task( TASKID );
		g_bCanBuy = false;
		g_bAutoOpened = true;
		g_bAlreadyOpened = true;
		
	}
	g_bDayHasStarted = true;
	if(!g_iAreWeInaVote)
	{
		new szName[ 32 ]; get_user_name(id, szName, charsmax(szName));
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M23", '^3', szName, '^1', '^3', LANG_SERVER, g_iStartDayNames[ g_iDay[ TOTAL_DAYS ] ] );
	}
	else {
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M24", '^3', LANG_SERVER, g_iStartDayNames[ g_iDay[ TOTAL_DAYS ] ] );
	}
	
	for ( i=0; i<iNum; i++ ) 
	{
		iPlayer = iPlayers[i];
		set_player_day(iPlayer);
	}
		
	return PLUGIN_HANDLED;
}

//#define is_num_odd(%1) (%1&1)

set_player_day(const iPlayer)
{
	static CsTeams:team;
	team = cs_get_user_team(iPlayer);
	new g_AliveCT = fnGetCounterTerrorists();
	new g_AliveT = fnGetTerrorists();
		
	if(get_bit(g_bIsSimon, iPlayer))
	{
		fnColorPrint(iPlayer, "%L", LANG_SERVER, "JB_DAY_M17");
		ResetSimon(iPlayer);
	}
	if(get_bit(g_bHasNadepack, iPlayer)) {
		ham_strip_weapon(iPlayer, "weapon_flashbang");
		ham_strip_weapon(iPlayer, "weapon_hegrenade");
		ham_strip_weapon(iPlayer, "weapon_smokegrenade");
		g_iPoints[iPlayer] += get_pcvar_num(cvar_pointer[cvar_nadepackprice]);
		cs_set_user_money(iPlayer, g_iPoints[iPlayer], 1);
		fnColorPrint(iPlayer, "%L", LANG_SERVER, "JB_DAY_M18");
		clear_bit(g_bHasNadepack, iPlayer);
	}
	switch(g_iDay[ TOTAL_DAYS ])
	{
		case DAY_FREEDAY:
			if(team == CS_TEAM_T)
			{
				set_user_rendering(iPlayer, kRenderFxGlowShell, 255, 140, 0, kRenderNormal, 20); 
				set_tag_player(iPlayer, "Freeday");
			}
		
		case DAY_ZOMBIE:
		{
			switch(team)
			{
				case CS_TEAM_T: 
				{
					GiveItem(iPlayer, "weapon_ak47", 900);
					if(get_bit(g_bHasCrowbar, iPlayer)) {
						fnColorPrint(iPlayer, "No crowbar doing reverse zombie day" );
						fnColorPrint(iPlayer, "You have been refunded your shop points." );
						g_iPoints[iPlayer] += get_pcvar_num(cvar_pointer[cvar_crowbarprice]);
						cs_set_user_money(iPlayer, g_iPoints[iPlayer], 1);
						clear_bit(g_bHasCrowbar, iPlayer);
					}
					set_tag_player(iPlayer, "Survivor");
				}
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					cs_set_user_nvg(iPlayer,true);
					//engclient_cmd(iPlayer, "nightvision");
					
					set_user_health(iPlayer, g_AliveT * g_400HP + g_100HP);
					set_user_maxspeed(iPlayer, ZOMBIE_SPEED);
					set_tag_player(iPlayer, "Zombie");
				}
			}
			if (get_user_weapon(iPlayer) == CSW_KNIFE) 
			{
				cs_reset_user_weapon(iPlayer);
			}
		}
		
		case DAY_SHARK:
		{
			switch(team)
			{
				case CS_TEAM_T: 
				{
					SaveWeapons(iPlayer);
					GiveItem(iPlayer, "weapon_awp", 30);
					set_tag_player(iPlayer, "Fisher Man");
				}
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					set_user_noclip(iPlayer, 1);
					set_user_health(iPlayer, g_AliveT * g_25HP + g_100HP);
					set_tag_player(iPlayer, "Shark");
				}
			}
		}
		
		case DAY_DEATHMATCH:
		{
			SaveWeapons(iPlayer);
			GiveItem(iPlayer, szWeapons[iRandom], iBpAmmo[iRandom]);
		}
		
		case DAY_NIGHT:
		{
			//emit_sound(iPlayer, CHAN_VOICE, NightCrawlerSounds[0], 0.0, ATTN_NORM, SND_STOP, PITCH_NORM);
			
			switch(team)
			{
				case CS_TEAM_T:
				{
					set_tag_player(iPlayer, "Survivor");
					SaveWeapons(iPlayer);
					GiveItem(iPlayer, "weapon_m4a1", 200);
					GiveItem(iPlayer, "weapon_deagle", 125);
					cs_reset_user_model(iPlayer);
					emit_sound(iPlayer, CHAN_VOICE, NightCrawlerSounds[0], 1.0, ATTN_NORM, 0, PITCH_NORM);
				}
				case CS_TEAM_CT:
				{
					//set_tag_player(iPlayer, "NightCrawler"); // Had to add a delay
					clear_bit(g_HasBeenHit, iPlayer);
					clear_bit(g_bTeleport, iPlayer);
					g_bTeleportUsed[iPlayer] = 0;
					cs_set_user_model(iPlayer, "nightcrawler");
					set_task(0.2, "tagtask", iPlayer);
					SaveWeapons(iPlayer);
					set_user_footsteps(iPlayer, 1);
					set_user_maxspeed(iPlayer, NIGHTCRAWLER_SPEED);
					if(g_iRandom == iPlayer)
						g_iRandom = fnGetRandomPlayer();
				}
			}
			emit_sound(iPlayer, CHAN_VOICE, NightCrawlerSounds[0], 1.0, ATTN_NORM, 0, PITCH_NORM);
		}
		
		case DAY_SPARTAN:
		{
			switch(team)
			{
				case CS_TEAM_T:
				{
					SaveWeapons(iPlayer);
					GiveItem(iPlayer, "weapon_deagle", 150);
					give_item(iPlayer, "weapon_shield");
				}
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					GiveItem(iPlayer, "weapon_m4a1", 150);
				}
			}
		}

		case DAY_REZOMBIE:
		{
			switch(team)
			{
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					GiveItem(iPlayer, "weapon_ak47", 900);
					set_tag_player(iPlayer, "Survivor");
				}
				case CS_TEAM_T:
				{
					SaveWeapons(iPlayer);
					cs_set_user_nvg(iPlayer,true);
					//engclient_cmd(iPlayer, "nightvision");
					set_user_health(iPlayer, g_AliveCT * g_200HP + g_100HP );
					set_user_maxspeed(iPlayer, REZOMBIE_SPEED);
					if(get_bit(g_bHasCrowbar, iPlayer)) {
						fnColorPrint(iPlayer, "No crowbar doing reverse zombie day" );
						fnColorPrint(iPlayer, "You have been refunded your shop points." );
						g_iPoints[iPlayer] += get_pcvar_num(cvar_pointer[cvar_crowbarprice]);
						cs_set_user_money(iPlayer, g_iPoints[iPlayer], 1);
						clear_bit(g_bHasCrowbar, iPlayer);
					}
					set_tag_player(iPlayer, "Zombie");
					if (get_user_weapon(iPlayer) == CSW_KNIFE) 
					{
						cs_reset_user_weapon(iPlayer);
					}
				}
			}
		}
		case DAY_RESHARK:
		{
			switch(team)
			{
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					set_user_health(iPlayer, g_AliveT * g_10HP + g_100HP);	
					GiveItem(iPlayer, "weapon_awp", 30);
					set_tag_player(iPlayer, "Fisher Man");
				}
				case CS_TEAM_T:
				{
					set_tag_player(iPlayer, "Shark");
					SaveWeapons(iPlayer);
					set_user_noclip(iPlayer, 1);
					set_user_health(iPlayer, g_AliveCT * g_10HP + g_50HP);
				}
			}
		}

		case DAY_RENIGHT:
		{
			//emit_sound(iPlayer, CHAN_VOICE, NightCrawlerSounds[0], 0.0, ATTN_NORM, SND_STOP, PITCH_NORM);
			emit_sound(iPlayer, CHAN_VOICE, NightCrawlerSounds[0], 1.0, ATTN_NORM, 0, PITCH_NORM);
			switch(team)
			{
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					set_user_health(iPlayer, g_AliveT * g_10HP + g_100HP);
					cs_set_user_armor(iPlayer, 225, CS_ARMOR_VESTHELM);
					GiveItem(iPlayer, "weapon_m4a1", 250);
					GiveItem(iPlayer, "weapon_deagle", 200);
					cs_reset_user_model(iPlayer);
					set_tag_player(iPlayer, "Survivor");
				}
				case CS_TEAM_T:
				{
					//set_tag_player(iPlayer, "NightCrawler");
					set_task(0.2, "tagtask", iPlayer);
					clear_bit(g_HasBeenHit, iPlayer);
					clear_bit(g_bTeleport, iPlayer);
					g_bTeleportUsed[iPlayer] = 0;
					cs_set_user_model(iPlayer, "nightcrawler");
					SaveWeapons(iPlayer);
					set_user_footsteps(iPlayer, 1);
					set_user_maxspeed(iPlayer, RENIGHTCRAWLER_SPEED);
					if(g_iRandom == iPlayer)
						g_iRandom = fnGetCTRandomPlayer();
				}
			}
		}

		case DAY_FREEZETAG:
		{
			g_iTagCount[iPlayer] = 0;
			SaveWeapons(iPlayer);
			if(get_bit(g_bHasSpeed, iPlayer)) {
				fnColorPrint(iPlayer, "%L", LANG_SERVER, "JB_DAY_M19");
				fnColorPrint(iPlayer, "%L", LANG_SERVER, "JB_DAY_M20");
				g_iPoints[iPlayer] += get_pcvar_num(cvar_pointer[cvar_speedprice]);
				cs_set_user_money(iPlayer, g_iPoints[iPlayer], 1);
				clear_bit(g_bHasSpeed, iPlayer);
				ExecuteHamB(Ham_Player_ResetMaxSpeed, iPlayer);
			}
		}
		case DAY_GANG:
		{
			switch(team)
			{
				case CS_TEAM_T:
				{
					SaveWeapons(iPlayer);
					GiveItem2(iPlayer, CSW_MAC10, 30, 2000);
					set_user_health(iPlayer, 250);
					cs_set_user_armor(iPlayer, 100, CS_ARMOR_VESTHELM);
					if(check_blueteam <= check_redteam)
					{
						set_user_rendering(iPlayer,kRenderFxGlowShell,0,0,255,kRenderNormal,16);
						UTIL_ScreenFade2(iPlayer, 2.0, 4.0);
						check_blueteam++;
						clear_bit(check_rteam, iPlayer);
						clear_bit(check_gteam, iPlayer);
						set_bit(check_bteam, iPlayer);
						fnColorPrint(iPlayer, "You are on the blue team!");
						set_tag_player(iPlayer, "Blue Gang");
					}
					else
					{
						set_user_rendering(iPlayer,kRenderFxGlowShell,255,0,0,kRenderNormal,16);
						UTIL_ScreenFade1(iPlayer, 2.0, 4.0);
						check_redteam++;
						clear_bit(check_bteam, iPlayer);
						clear_bit(check_gteam, iPlayer);
						set_bit(check_rteam, iPlayer);
						fnColorPrint(iPlayer, "You are on the red team!");
						set_tag_player(iPlayer, "Red Gang");
					}
				}
				case CS_TEAM_CT: 
				{
					SaveWeapons(iPlayer);
					if(get_bit(check_rteam, iPlayer))
					{
						check_redteam--;
						clear_bit(check_rteam, iPlayer);
					}
					if(get_bit(check_bteam, iPlayer))
					{
						check_blueteam--;
						clear_bit(check_bteam, iPlayer);
					}
					set_tag_player(iPlayer, "Police");
					GiveItem(iPlayer, "weapon_m4a1", 90);
					GiveItem(iPlayer, "weapon_deagle", 35);
					set_bit(check_gteam, iPlayer);
					set_user_rendering(iPlayer, _, 0, 0, 0, _, 0);
				}
			}
		}

		case DAY_GRENADE:
		{
			switch(team)
			{
				case CS_TEAM_T:
				{
					SaveWeapons(iPlayer);
					GiveItem2(iPlayer, CSW_HEGRENADE, -1, 2000);
					set_user_health(iPlayer, 250);
					cs_set_user_armor(iPlayer, 100, CS_ARMOR_VESTHELM);
					clear_bit(check_gteam, iPlayer);
					clear_bit(check_bteam, iPlayer);
				}
				case CS_TEAM_CT: 
				{
					SaveWeapons(iPlayer);
					set_bit(check_gteam, iPlayer);
					GiveItem(iPlayer, "weapon_m4a1", 90);
					GiveItem(iPlayer, "weapon_deagle", 35);
				}
			}
		}
		case DAY_USPNINJAS:
		{
			switch(team)
			{
				case CS_TEAM_T:
				{
					SaveWeapons(iPlayer);
					GiveItem2(iPlayer, CSW_USP, -1, 200);
					new UspEntity = find_ent_by_owner(-1, "weapon_usp", iPlayer);
					cs_set_weapon_silen(UspEntity);
					show_rules(iPlayer);
					set_tag_player(iPlayer, "Hider");
				}
				case CS_TEAM_CT:
				{
					SaveWeapons(iPlayer);
					GiveItem2(iPlayer, CSW_USP, -1, 200);
					new UspEntity = find_ent_by_owner(-1, "weapon_usp", iPlayer);
					cs_set_weapon_silen(UspEntity);
					show_rules(iPlayer);
					set_tag_player(iPlayer, "Seeker");
				}
			}
		}
	}
	if(get_bit(g_bHasFreeday, iPlayer))
	{
		set_tag_player(iPlayer, "Freeday");
	}
}

public tagtask(iPlayer)
{
	set_tag_player(iPlayer, "NightCrawler");
}

show_rules(id)
{
	new hudmsg[512];
	set_hudmessage(255, 255, 255, 0.02, 0.25, 2, 0.1, 10.0, 0.05, 1.0, 1);
	format(hudmsg, 511, "");
	add(hudmsg,511,"What is this USP Ninjas you speak of!?!?!?^n^n");
	add(hudmsg,511,"The objective of this game is for the seekers(Guard's) to find and kill the hiders(Prisoner's).^n^n");
	add(hudmsg,511,"Rule #1: The seekers(Guard's) will enter the building after 25 seconds of the start of the day^n");
	add(hudmsg,511,"Rule #2: The hiders(Prisoner's) are not allowed to leave the building at any point in the round.^n");
	add(hudmsg,511,"Rule #3: Your USP must ALWAYS be silenced, no matter what team you are on.^n");
	add(hudmsg,511,"Rule #4: If the seekers kill all but one hider the day ends.^n");
	show_hudmessage(id, hudmsg);
}

public countdown()
{	
	static iPlayers[32], iNum, i, iPlayer;
	get_players( iPlayers, iNum, "ae", "CT" ); 
	
	set_hudmessage(255, 255, 255, -1.0, -1.0, 0, 0.75, 0.75, 0.75, 0.75, 1);
	//if( g_Timer > 60 )
		//show_hudmessage(0, "%L", LANG_SERVER, "JB_DAY_M25", g_Timer-60);
		// Was lame that cts where frozen so its removed!
	if( g_Timer == 60 )
		for ( i=0; i<iNum; i++ ) 
		{
			iPlayer = iPlayers[i];
			set_pev(iPlayer, pev_flags, pev(iPlayer, pev_flags) | FL_FROZEN);
		}
			
	if( g_Timer <= HIDE_N_SEEK_TIMER && g_Timer > 0 )
	{
		show_hudmessage(0, "%L", LANG_SERVER, "JB_DAY_M26", g_Timer);
		if( g_Timer <= 10 )
		{
			new sSound[16];
			num_to_word(g_Timer, sSound, 15);
			client_cmd(0, "spk vox/%s.wav", sSound);
		}
		for ( i=0; i<iNum; i++ )
		{
			iPlayer = iPlayers[i];
			UTIL_ScreenFade(iPlayer, 1.0, 1.0);
		}
	}
	g_Timer--;
	set_task( 1.0, "countdown", TASK_HNS );
	if( g_iDay[ TOTAL_DAYS ] == DAY_NONE )
		g_Timer = 0;
		
	if( g_Timer <= 0 )
	{
		for ( i=0; i<iNum; i++ ) 
		{
			iPlayer = iPlayers[i];
			RestoreWeapons(iPlayer);
			Unfreeze(iPlayer);
		}
		//g_bFrozenTime = false;
		show_hudmessage(0, "%L", LANG_SERVER, "JB_DAY_M27");
		client_cmd(0, "spk ^"sound/radio/com_go.wav^"");
		remove_task( TASK_HNS );
	}
}

#define CLAMP_SHORT(%1) clamp( %1, 0, 0xFFFF )
#define CLAMP_BYTE(%1) clamp( %1, 0, 0xFF )

UTIL_ScreenFade(const id, Float:fDuration, Float:fHoldTime) {
	message_begin( MSG_ONE_UNRELIABLE, g_iMsgId_ScreenFade, _, id);
	write_short(CLAMP_SHORT(floatround(4096 * fDuration))); // 1 << 12 = 4096
	write_short(CLAMP_SHORT(floatround(4096 * fHoldTime)));
	write_short(0x0000); // FFADE_IN = 0x0000
	write_byte(0);
	write_byte(0);
	write_byte(0);
	write_byte(200);
	message_end();
}

/*================================================================================
 [Forwards / Events]
=================================================================================*/
public Fwd_PlayerSpawn_Post(const id)
{
	if (!is_user_alive(id))
		return HAM_HANDLED;
		
	set_bit(g_bIsAlive, id);
	
	static CsTeams:team;
	team = cs_get_user_team(id);

	switch(team)
	{
		case CS_TEAM_T:
		{
			clear_bit(g_bHasCrowbar, id);
			new get_Cvar = get_pcvar_num(cvar_pointer[cvar_blockvoice]);
			switch (get_Cvar)
			{
				case 0: fm_set_speak(id, SPEAK_ALL);
				case 1: if(get_user_flags(id) & ADMIN_MIC)
						fm_set_speak(id, SPEAK_ALL);
					else fm_set_speak(id, SPEAK_TEAM);
				case 2: if(get_user_flags(id) & ADMIN_MIC)
						fm_set_speak(id, SPEAK_ALL);
					else fm_set_speak(id, SPEAK_LISTENALL);
			}
		}
		case CS_TEAM_CT: fm_set_speak(id, SPEAK_ALL);
	}
	
	if(!get_bit(g_bUserHasTag, id))
		remove_tag_player(id);
	else
	{
		new szTag[32], authid[32], data;
		get_user_authid(id, authid, charsmax(authid));
		data = nvault_get(nVault, authid, szTag, charsmax(szTag));
		if(data)
			formatex(g_iUserTagName[id], 54, "[%s] %s", szTag, g_iUserName[id]);
	}
	
	if(g_iDay[ TOTAL_DAYS ] == DAY_NONE)
	{
		StripPlayerWeapons(id);
		reset_all(id);
		/*switch(team)
		{
			case CS_TEAM_T: set_task(0.3, "show_shopmenu", id);
			case CS_TEAM_CT: set_task(0.3, "ClassMenu", id);
		}*/
		if(!g_bGunGame || !g_bSnowballWar || !g_bBoxMatch)
		{
			if(team == CS_TEAM_CT)
				set_task(0.3, "ClassMenu", id);
		}

		cs_reset_user_weapon(id);
		
		if(g_bGunGame)
		{
			cs_set_user_armor(id, 100, CS_ARMOR_VESTHELM);
			GiveItem2(id, g_iWeaponLevel[g_iGunGameLevel[id][level]]);
		}
	}
	else set_player_day(id);
	
	return HAM_HANDLED;
}

public Fwd_TraceAttack_Player_Post(const victim, const attacker, Float:flDamage, Float:flDirection[3], const ptr, const iDamagebits)
{
	// Not a valid attacker / no victim
	if (!IsPlayer(attacker))
		return HAM_IGNORED;

	g_bHeadShot[attacker][victim] = bool:( get_tr2(ptr, TR_iHitgroup) == HITGROUP_HEAD );
	
	return HAM_IGNORED;
}

public Fwd_TraceAttack_Player_Pre(const victim, const attacker, Float:flDamage, Float:flDirection[3], const ptr, const iDamagebits)
{
	// Not a valid attacker / no victim
	if (!IsPlayer(attacker))
		return HAM_IGNORED;
	//new g_bHeadshotEnabled = get_pcvar_num(cvar_pointer[cvar_headshot_only]);
	if(g_bHeadshotEnabled && g_bInLr && g_iGameType == 9)// 9 = scout dual
	{
		if(get_tr2(ptr, TR_iHitgroup) != HIT_HEAD)
		{
			return HAM_SUPERCEDE;
		}
	}
	
	return HAM_IGNORED;
}
//static CsTeams:set_user_team;
public Fwd_PlayerDamage(const victim, const inflictor, const attacker, Float:damage, const iDamageType)
{
	//set_user_team = cs_get_user_team(victim);
	if(get_bit(g_bIsAlive, victim) && iDamageType == DMG_FALL)
	{
		switch( g_iDay[ TOTAL_DAYS ] )
		{
			case DAY_NIGHT: 
			{
				if(cs_get_user_team(victim) == CS_TEAM_CT)
				{
					SetHamReturnInteger(0);
					return HAM_SUPERCEDE;
				}
			}
			case DAY_RENIGHT:
			if(cs_get_user_team(victim) == CS_TEAM_T)
			{
				SetHamReturnInteger(0);
				return HAM_SUPERCEDE;
			}
			case DAY_USPNINJAS:
			if(cs_get_user_team(victim) == CS_TEAM_CT)
			{
				SetHamReturnInteger(0);
				return HAM_SUPERCEDE;
			}
		}
	}
	if(!IsPlayer( attacker ) || victim == attacker)
		return HAM_IGNORED;
		
	if(g_bBoxMatch)
	{
		if(get_user_weapon(attacker) == CSW_KNIFE)
			SetHamParamFloat(4, damage * 0.2);
			
		if(cs_get_user_team(attacker) == CS_TEAM_T && get_user_weapon(attacker) != CSW_KNIFE)
		{
			SetHamReturnInteger(0);
			return HAM_SUPERCEDE;
		}
		g_iVictimTeam = cs_get_user_team_index(victim);
		if( g_iVictimTeam == cs_get_user_team_index(attacker) )
		{
			cs_set_user_team_index(victim, g_iVictimTeam == TEAM_T ? TEAM_CT : TEAM_T);
			EnableHamForward(g_iHhTakeDamagePost);
			return HAM_HANDLED;
		}
	}
	if(g_bSnowballWar)
	{	
		if(get_user_weapon(attacker) == CSW_KNIFE)
			SetHamParamFloat(4, damage * 0.2);
		g_iVictimTeam = cs_get_user_team_index(victim);
		if( g_iVictimTeam == cs_get_user_team_index(attacker) )
		{
			cs_set_user_team_index(victim, g_iVictimTeam == TEAM_T ? TEAM_CT : TEAM_T);
			EnableHamForward(g_iHhTakeDamagePost);
			return HAM_HANDLED;
		}
	}
	if(g_bGunGame)
	{	
		if(get_bit(g_bSetFakeGodmode, victim))
		{
			SetHamReturnInteger(0);
			return HAM_SUPERCEDE;
		}
		g_iVictimTeam = cs_get_user_team_index(victim);
		if( g_iVictimTeam == cs_get_user_team_index(attacker) )
		{
			cs_set_user_team_index(victim, g_iVictimTeam == TEAM_T ? TEAM_CT : TEAM_T);
			EnableHamForward(g_iHhTakeDamagePost);
			return HAM_HANDLED;
		}
	}

	switch( g_iDay[ TOTAL_DAYS ] )
	{
		case DAY_DEATHMATCH:
		{	
			g_iVictimTeam = cs_get_user_team_index(victim);
			if( g_iVictimTeam == cs_get_user_team_index(attacker) )
			{
				cs_set_user_team_index(victim, g_iVictimTeam == TEAM_T ? TEAM_CT : TEAM_T);
				EnableHamForward(g_iHhTakeDamagePost);
				return HAM_HANDLED;
			}
		}
		case DAY_HIDENSEEK:
			//if( g_bFrozenTime )
			if(cs_get_user_team(attacker) == CS_TEAM_T)
				return HAM_SUPERCEDE;
		case DAY_FREEZETAG: return HAM_SUPERCEDE;
		case DAY_ZOMBIE:
			if(cs_get_user_team(attacker) == CS_TEAM_CT)
				SetHamParamFloat(4, (damage+35)-damage);
		case DAY_REZOMBIE:
			if(cs_get_user_team(attacker) == CS_TEAM_T)
				SetHamParamFloat(4, (damage+10)-damage);
		case DAY_GANG:
		{
			if(get_bit(check_bteam, attacker) && get_bit(check_bteam, victim)
			|| get_bit(check_rteam, attacker) && get_bit(check_rteam, victim)
			|| get_bit(check_gteam, attacker) && get_bit(check_gteam, victim)
			|| get_bit(check_rteam, attacker) && get_bit(check_gteam, victim)
			|| get_bit(check_bteam, attacker) && get_bit(check_gteam, victim))
			{
				SetHamReturnInteger(0);
				return HAM_SUPERCEDE;
			}
				
			g_iVictimTeam = cs_get_user_team_index(victim);
			if( g_iVictimTeam == cs_get_user_team_index(attacker) )
			{
				cs_set_user_team_index(victim, g_iVictimTeam == TEAM_T ? TEAM_CT : TEAM_T);
				EnableHamForward(g_iHhTakeDamagePost);
				return HAM_HANDLED;
			}	
		}
		case DAY_GRENADE:
		{
			if(!get_bit(check_gteam, attacker) && get_bit(check_gteam, victim)
			|| get_bit(check_gteam, attacker) && get_bit(check_gteam, victim))
			{
				SetHamReturnInteger(0);
				return HAM_SUPERCEDE;
			}
				
			g_iVictimTeam = cs_get_user_team_index(victim);
			if( g_iVictimTeam == cs_get_user_team_index(attacker) )
			{
				cs_set_user_team_index(victim, g_iVictimTeam == TEAM_T ? TEAM_CT : TEAM_T);
				EnableHamForward(g_iHhTakeDamagePost);
				return HAM_HANDLED;
			}
		}
		case DAY_NIGHT:
		{
			if(cs_get_user_team(victim) == CS_TEAM_CT)
			{
				if(!task_exists(victim))
				{
					set_bit(g_HasBeenHit, victim);
					set_task(1.5, "resetmodel", victim);
				}
			}
		}
		case DAY_RENIGHT:
		{
			if(cs_get_user_team(victim) == CS_TEAM_T)
			{
				if(!task_exists(victim))
				{
					set_bit(g_HasBeenHit, victim);
					set_task(1.5, "resetmodel", victim);
				}
			}
		}
	}
	
	if(get_bit(g_bInDisguise, victim))
	{
		cs_reset_user_model(victim);
		fnColorPrint(victim, "%L", LANG_SERVER, "JB_DAY_M28");
		fnColorPrint(victim, "%L", LANG_SERVER, "JB_DAY_M29");
		clear_bit(g_bInDisguise, victim);
	}

	if(attacker == inflictor && get_user_weapon(attacker) == CSW_KNIFE && get_bit(g_bHasCrowbar, attacker))
	{
		SetHamParamFloat(4, damage + 35);
		return HAM_HANDLED;
	}

	return HAM_IGNORED;
}

public resetmodel(id)
{
	clear_bit(g_HasBeenHit, id);
	remove_task(id);
}

public Player_TakeDamage_Post(victim)
{
	/*if( g_iDay[ TOTAL_DAYS ] == DAY_DEATHMATCH 
	|| g_iDay[ TOTAL_DAYS ] == DAY_GANG 
	|| g_iDay[ TOTAL_DAYS ] == DAY_GRENADE 
	|| g_bBoxMatch 
	|| g_bSnowballWar 
	|| g_bGunGame)
	{
		cs_set_user_team_index(victim, g_iVictimTeam);
		DisableHamForward( g_iHhTakeDamagePost );
		
		cs_set_user_team(victim, set_user_team);
		//new sName[32]; get_user_name(victim, sName, charsmax(sName));	
		//fnColorPrint(0, "%s Your team is %d", sName,g_iVictimTeam);
	}*/
	cs_set_user_team_index(victim, g_iVictimTeam);
	DisableHamForward( g_iHhTakeDamagePost );
	
	//cs_set_user_team(victim, set_user_team);
}

public RespawnPlayer(id)
{
	if(g_iDay[ TOTAL_DAYS ] == DAY_ZOMBIE || g_iDay[ TOTAL_DAYS ] == DAY_REZOMBIE && get_bit(g_bIsConnected, id))
	{
		ExecuteHamB(Ham_CS_RoundRespawn, id);
		set_user_health(id, get_user_health(id) + (g_50HP * g_iDeaths[id]));
		cs_set_user_armor(id, (g_100HP * g_iDeaths[id]), CS_ARMOR_VESTHELM);
	}
}

public gungamerespawn(id)
{
	if(g_bGunGame && get_bit(g_bIsConnected, id))
	{
		ExecuteHamB(Ham_CS_RoundRespawn, id);
		set_bit(g_bSetFakeGodmode, id);
		set_task(3.0, "removefakegodmode", id);
	}
}

public removefakegodmode(id)
{
	if(g_bGunGame && get_bit(g_bIsConnected, id))
	{
		clear_bit(g_bSetFakeGodmode, id);
	}
}

public Fwd_PlayerKilled_Pre(victim, attacker, shouldgib)
{
	if (!IsPlayer(victim))
		return HAM_IGNORED;
		
	if(g_bGunGame)
	{
		new aName[32]; get_user_name(attacker, aName, charsmax(aName));
		new sName[32]; get_user_name(victim, sName, charsmax(sName));	
		if(get_bit(g_bIsAlive, attacker))
		{
			if(get_user_weapon(attacker) != CSW_KNIFE)
			{
				emit_sound(attacker, CHAN_AUTO, GunGameSounds[3], 1.0, ATTN_NORM, 0, PITCH_NORM);
				g_iGunGameLevelNext[attacker]++;
	
				if(g_iGunGameLevelNext[attacker] == 3)
				{
					g_iGunGameLevelNext[attacker] = 0;
					g_iGunGameLevel[attacker][level]++;
					StripPlayerWeapons(attacker);
					if(g_iGunGameLevel[attacker][level] <= 15)
						GiveItem2(attacker, g_iWeaponLevel[g_iGunGameLevel[attacker][level]]);
					
					if(g_iGunGameLevel[attacker][level] <= 16)
						fnColorPrint(0, "Gun-Game^3 %s^1 is on level^3 %s", aName, g_szGunGameNames[g_iGunGameLevel[attacker][level]]);
					if(g_iGunGameLevel[attacker][level] == 16)	
						emit_sound(0, CHAN_AUTO, GunGameSounds[2], 1.0, ATTN_NORM, 0, PITCH_NORM);
				}
				if(g_iGunGameLevelNext[attacker] < 3)
				{
					fnColorPrint(attacker, "Gun-Game You need^3 %d^1 kills ot advance.^3 %d / 3", 3-g_iGunGameLevelNext[attacker], g_iGunGameLevelNext[attacker]);
					new wepID = find_ent_by_owner(-1, g_szWeaponNames[g_iWeaponLevel[g_iGunGameLevel[attacker][level]]], attacker);
					if(wepID)
						cs_set_weapon_ammo(wepID, g_iWeaponLevelRefillammo[g_iGunGameLevel[attacker][level]]);	
				}
			}
			if(g_iGunGameLevel[attacker][level] < 16 && get_user_weapon(attacker) == CSW_KNIFE)
			{
				emit_sound(attacker, CHAN_AUTO, GunGameSounds[3], 1.0, ATTN_NORM, 0, PITCH_NORM);
				g_iGunGameLevelNext[attacker]++;
	
				if(g_iGunGameLevelNext[attacker] == 3)
				{
					g_iGunGameLevelNext[attacker] = 0;
					g_iGunGameLevel[attacker][level]++;
					StripPlayerWeapons(attacker);
					if(g_iGunGameLevel[attacker][level] <= 15)
						GiveItem2(attacker, g_iWeaponLevel[g_iGunGameLevel[attacker][level]]);
					
					if(g_iGunGameLevel[attacker][level] <= 16)
						fnColorPrint(0, "Gun-Game^3 %s^1 is on level^3 %s", aName, g_szGunGameNames[g_iGunGameLevel[attacker][level]]);
					if(g_iGunGameLevel[attacker][level] == 16)	
						emit_sound(0, CHAN_AUTO, GunGameSounds[2], 1.0, ATTN_NORM, 0, PITCH_NORM);
				}
				if(g_iGunGameLevelNext[attacker] < 3)
				{
					fnColorPrint(attacker, "Gun-Game You need^3 %d^1 kills ot advance.^3 %d / 3", 3-g_iGunGameLevelNext[attacker], g_iGunGameLevelNext[attacker]);
					new wepID = find_ent_by_owner(-1, g_szWeaponNames[g_iWeaponLevel[g_iGunGameLevel[attacker][level]]], attacker);
					if(wepID)
						cs_set_weapon_ammo(wepID, g_iWeaponLevelRefillammo[g_iGunGameLevel[attacker][level]]);	
				}
			}
			if(g_iGunGameLevel[victim][level] > 0 && g_iGunGameLevel[attacker][level] < 16 && get_user_weapon(attacker) == CSW_KNIFE)
			{
				g_iGunGameLevel[victim][level]--;
				g_iGunGameLevel[attacker][level]++;
				g_iGunGameLevelNext[attacker] = 0;
				StripPlayerWeapons(attacker);
				GiveItem2(attacker, g_iWeaponLevel[g_iGunGameLevel[victim][level]]);
				GiveItem2(attacker, g_iWeaponLevel[g_iGunGameLevel[attacker][level]]);
				emit_sound(victim, CHAN_AUTO, GunGameSounds[0], 1.0, ATTN_NORM, 0, PITCH_NORM);
				emit_sound(attacker, CHAN_AUTO, GunGameSounds[1], 1.0, ATTN_NORM, 0, PITCH_NORM);
				fnColorPrint(0, "Gun-Game^4 %s^1 has stoled a^3 level^1 from^4 %s", aName, sName);
			}
			if(g_iGunGameLevel[attacker][level] == 16 && get_user_weapon(attacker) == CSW_KNIFE && cs_get_user_team(attacker) == CS_TEAM_T)
			{
				g_bGunGame = false;
				fnColorPrint(0, "Gun-Game^3 %s^1 has won the game!", aName);
				static iPlayers[32], iNum, i, iPlayer;
				get_players( iPlayers, iNum, "ae", "TERRORIST"  ); 
				for( i=0; i<iNum; i++ )
				{
					iPlayer = iPlayers[i];
					if(attacker == iPlayer)
						continue;
					if(g_iGunGameLevel[attacker][level] >= g_iGunGameLevel[iPlayer][level])
					{
						user_silentkill(iPlayer);
					}
				}
				emit_sound(0, CHAN_AUTO, g_szSound_Bell, 1.0, ATTN_NORM, 0, PITCH_NORM);
			}
			if(g_iGunGameLevel[attacker][level] == 16 && get_user_weapon(attacker) == CSW_KNIFE && cs_get_user_team(attacker) == CS_TEAM_CT)
			{
				fnColorPrint(attacker, "Gun-Game^3 You^1 have made it to the final^4 level!");
				g_bGunGame = false;
				emit_sound(0, CHAN_AUTO, g_szSound_Bell, 1.0, ATTN_NORM, 0, PITCH_NORM);
			}
		}
		StripPlayerWeapons(victim);
		set_task(3.0, "gungamerespawn", victim);
	}
		
	clear_bit(g_bIsAlive, victim);
		
	if(get_bit(g_bHasCrowbar, victim))
		g_iCrowbars--;
	
	if(get_bit(g_bHasSpeed, victim))
		g_iSpeed--;
		
	if(get_bit(g_bHasInvis, victim))
		g_iInvis--;

	if(get_bit(g_bHasFootstep, victim))
		g_iFootstep--;	
		
	if(get_bit(g_bHasDisguise, victim))
	{
		g_iDisguise--;
		cs_reset_user_model(victim);
		clear_bit(g_bHasDisguise, victim);
		clear_bit(g_bInDisguise, victim);
	}
	
	if(get_bit(g_bHasCellKeys, victim))
		g_iCellKeys--;
	
	if(get_bit(g_bInMathProblem, victim)) {
		set_user_rendering(victim, _, 0, 0, 0, _, 0);
		// Unfreeze player if it's frozen
		//static Flags; Flags = entity_get_int( victim, EV_INT_flags );
		//entity_set_int( victim, EV_INT_flags, Flags &~ FL_FROZEN );
		clear_bit(g_bInMathProblem, victim);
	}
	
	if(get_bit(g_bIsSimon, victim)){
		ResetSimon(victim);
	}

	// Get info
	new vName[32]; get_user_name(victim, vName, charsmax(vName));		
	// Check if they are something special to annoy them lol
	if( get_bit(g_bIsChosen, victim) || get_bit(g_bIsLast, victim) && g_bInLr )
	{
		// Advertise
		if (g_iGameType == 10)
		{
			fnColorPrint(0, "OMG!^3 %s^1 sucks! He died as^3 Rambo^1", vName);
			if(get_user_team(victim) == 1) 
			{
				remove_task(victim+TASK_BEAM);
				clear_bit(g_bIsLast, victim);
				g_bInLr = false;
				g_iGameType = 0;
			}
		}
		else {
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M30", '^3', vName, '^1', '^4', LANG_SERVER, fnGetGameType());

			for (new i = 1; i <= g_iMaxPlayers; i++)
			{
				remove_task(i+TASK_BEAM);
				clear_bit(g_bIsLast, i);
				clear_bit(g_bIsChosen, i);
				g_bInLr = false;
				g_iGameType = 0;
			}
		}
	}

	
	if( !g_bInLr && fnGetTerrorists() == 1 && fnGetCounterTerrorists() >= 1)
	{
		static iPlayers[32], iNum, i, iPlayer;
		get_players( iPlayers, iNum, "ae", "TERRORIST"  ); 
		for( i=0; i<iNum; i++ )
		{
			iPlayer = iPlayers[i];
			Show_LastRequestMenu(iPlayer);
		}
	}
	
	switch( g_iDay[ TOTAL_DAYS ] ) {
		case DAY_ZOMBIE:
			if(cs_get_user_team(victim) == CS_TEAM_CT)
			{
				g_iDeaths[victim]++;
				set_task(10.0*g_iDeaths[victim], "RespawnPlayer", victim);
				fnColorPrint(victim, "%L", LANG_SERVER, "JB_DAY_M31", (10*g_iDeaths[victim]));
			}
		case DAY_REZOMBIE:
			if(cs_get_user_team(victim) == CS_TEAM_T)
			{
				g_iDeaths[victim]++;
				set_task(10.0*g_iDeaths[victim], "RespawnPlayer", victim);
				fnColorPrint(victim, "%L", LANG_SERVER, "JB_DAY_M31", (10*g_iDeaths[victim]));
			}
		case DAY_NIGHT:
		{
			cs_reset_user_model(victim);
			emit_sound(victim, CHAN_VOICE, NightCrawlerSounds[0], 0.0, ATTN_NORM, SND_STOP, PITCH_NORM);
			if(g_iRandom == victim)
				g_iRandom = fnGetRandomPlayer();
		}
		case DAY_RENIGHT:
		{
			cs_reset_user_model(victim);
			emit_sound(victim, CHAN_VOICE, NightCrawlerSounds[0], 0.0, ATTN_NORM, SND_STOP, PITCH_NORM);
			if(g_iRandom == victim)
				g_iRandom = fnGetCTRandomPlayer();
		}
		case DAY_FREEZETAG: CheckTerrorist( );
		case DAY_GANG:
		{
			if(get_bit(check_rteam, victim))
			{
				check_redteam--;
				clear_bit(check_rteam, victim);
			}
			if(get_bit(check_bteam, victim))
			{
				check_blueteam--;
				clear_bit(check_bteam, victim);
			}
			if(get_bit(check_gteam, victim))
			{
				clear_bit(check_gteam, victim);
			}
			
			CheckTerrorist2( );
		}
	}
	
	if(!get_bit(g_bUserHasTag, victim))
		remove_tag_player(victim);
	else
	{
		new szTag[32], authid[32], data;
		get_user_authid(victim, authid, charsmax(authid));
		data = nvault_get(nVault, authid, szTag, charsmax(szTag));
		if(data)
			formatex(g_iUserTagName[victim], 54, "[%s] %s", szTag, g_iUserName[victim]);
	}
	
	// Hide Terrorist's name/give points for kill by Kruegs (soccdooccs)
	if (get_bit(g_bIsConnected, attacker) && get_bit(g_bIsAlive, attacker) && get_user_team(attacker) == 1)
	{
		if(g_bHeadShot[attacker][victim])
		{
			g_bHeadShot[attacker][victim] = false;
			cs_set_user_money(attacker, g_iPoints[attacker] += get_pcvar_num(cvar_pointer[cvar_headshotpoints]), 1);
		}
		else
		{
			cs_set_user_money(attacker, g_iPoints[attacker] += get_pcvar_num(cvar_pointer[cvar_killpoints]), 1);
		}
		SaveData(attacker);
		
		ExecuteHamB(Ham_Killed, victim, 0, shouldgib);
		set_pev(attacker, pev_frags, pev(attacker, pev_frags) + 1.0);
		
		return HAM_SUPERCEDE;
	}
		
	return HAM_IGNORED;
}

public Fwd_PlayerTouch(const Touched, const Toucher)
{
	if(!IsPlayer(Toucher))
		return HAM_IGNORED;
		
	if(g_iDay[ TOTAL_DAYS ] == DAY_FREEZETAG)
	{
		static Flags; Flags = entity_get_int(Touched, EV_INT_flags);
			
		// Freeze an enemy
		if(cs_get_user_team(Toucher) == CS_TEAM_CT && cs_get_user_team(Touched) == CS_TEAM_T)
		{
			// Already frozen ?
			if(Flags & FL_FROZEN)
				return HAM_IGNORED;
	
			entity_set_int(Touched, EV_INT_flags, Flags | FL_FROZEN);
			g_iTagCount[Touched]++;
			g_FrozenT++;
			set_bit(g_bIsTag, Touched);
			
			// msg		
			static dName[32]; get_user_name(Touched, dName, charsmax(dName));
			static rName[32]; get_user_name(Toucher, rName, charsmax(rName));
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M32", '^3', '^4', dName, '^1', '^4', rName, '^1'); 

			if(g_iTagCount[Touched] < 2)
				if(is_user_admin(Touched))
					set_user_rendering(Touched, kRenderFxGlowShell, 0, 255, 0, kRenderNormal, 40);
				else set_user_rendering(Touched, kRenderFxGlowShell, 255, 0, 0, kRenderNormal, 40);
			else set_user_rendering(Touched, kRenderFxGlowShell, 255, 255, 0, kRenderNormal, 40);
			
			//Gaurds should be the ones killing in this game.
			if(g_iTagCount[Touched] > 2)
			{
				g_iPoints[Toucher] += get_pcvar_num(cvar_pointer[cvar_killpoints]);
				cs_set_user_money(Toucher, g_iPoints[Toucher], 1);
				fnColorPrint(Touched, "%L", LANG_SERVER, "JB_DAY_M34", '^3', '^1'); 
				Unfreeze(Touched);
				set_user_rendering(Touched);
				user_silentkill(Touched);
			}
			
			// Check if all the terrorist are frozen
			CheckTerrorist( );
		}
		
		// Unfreeze a teammate
		if(cs_get_user_team(Toucher) == CS_TEAM_T && cs_get_user_team(Touched) == CS_TEAM_T)
		{
			if(Flags & FL_FROZEN && g_iTagCount[Touched] <= 2)
			{
				// msg		
				static dName[32]; get_user_name(Touched, dName, charsmax(dName));
				static rName[32]; get_user_name(Toucher, rName, charsmax(rName));
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M33", '^3', '^4', dName, '^1', '^4', rName, '^1'); 
				
				Unfreeze(Touched);
				
				set_user_rendering(Touched);
			}
			/*
			if(Flags & FL_FROZEN && g_iTagCount[Touched] >= 2)
			{
				g_iPoints[Toucher] += get_pcvar_num(cvar_pointer[cvar_killpoints]);
				fnColorPrint(Touched, "%L", LANG_SERVER, "JB_DAY_M34", '^3', '^1'); 
				Unfreeze(Touched);
				set_user_rendering(Touched);
				user_silentkill(Touched);
			}*/
		}
	}
	return HAM_IGNORED;
}

public Unfreeze(const id){
	// Unfreeze player if it's frozen
	static Flags; Flags = entity_get_int( id, EV_INT_flags );
	entity_set_int( id, EV_INT_flags, Flags &~ FL_FROZEN );
	
	if( get_bit(g_bIsTag, id) )
	{
		g_FrozenT--;
		clear_bit(g_bIsTag, id);
	}
}

// Check if all the terrorist are frozen
CheckTerrorist( )
{
	new g_prisonors = fnGetTerrorists();
	new g_LastPrisoner = g_prisonors - 1;
	if( g_LastPrisoner == g_FrozenT )
	{
		static iPlayers[32], iNum, i, iPlayer;
		get_players( iPlayers, iNum, "ae", "TERRORIST"  ); 
		for( i=0; i<iNum; i++ )
		{
			iPlayer = iPlayers[i];
			g_iTagCount[iPlayer] = 0;
			if( get_bit(g_bIsTag, iPlayer) )
			{
				Unfreeze(iPlayer);
				user_silentkill(iPlayer);
			}
		}
		g_FrozenT = 0;	
	}
}
		
CheckTerrorist2( )
{
	if( fnGetTerrorists() == 1 )
	{
		Day_Ends( );
		fnColorPrint(0, "The %s gang-team has won!", check_blueteam == 0 ? "blue" : "red"); 
	}
	if( g_iDay[ TOTAL_DAYS ] == DAY_GANG && (check_blueteam == 0 || check_redteam == 0) )
	{
		fnColorPrint(0, "The Teams have been divided up again! Due to %s gang-team dying.", check_blueteam == 0 ? "blue" : "red"); 
		check_redteam = 0;
		check_blueteam = 0;
		static iPlayers[32], iNum, i, iPlayer;
		get_players( iPlayers, iNum, "ae", "TERRORIST"  ); 
		for( i=0; i<iNum; i++ )
		{	
			iPlayer = iPlayers[i];
			set_player_day(iPlayer);
		}
	}
}

new const oldknife_sounds[][] =
{
	"weapons/knife_deploy1.wav",   
	"weapons/knife_hit1.wav",   
	"weapons/knife_hit2.wav",    
	"weapons/knife_hit3.wav",    
	"weapons/knife_hit4.wav",    
	"weapons/knife_hitwall1.wav",  
	"weapons/knife_slash1.wav",    
	"weapons/knife_slash2.wav",    
	"weapons/knife_stab.wav"    
};

new const newknife_sounds[][] =
{
	"weapons/knife_deploy1.wav",   
	"sword_strike1.wav",   
	"sword_strike2.wav",    
	"sword_strike3.wav",    
	"sword_strike4.wav",    
	"weapons/knife_hitwall1.wav",  
	"weapons/knife_slash1.wav",    
	"weapons/knife_slash2.wav",    
	"weapons/knife_stab.wav"    
};
public sound_emit(const id, const channel, const sample[])
{
	if(get_bit(g_bIsConnected, id) && is_user_alive(id))
	{
		static CsTeams:team;
		team = cs_get_user_team(id);
		if(equal(sample, "weapons/knife_", 14) && get_bit(g_bHasCrowbar, id))
		{
			switch(sample[17])
			{
				case('b'): emit_sound(id, CHAN_WEAPON, "weapons/cbar_hitbod2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
				case('w'): emit_sound(id, CHAN_WEAPON, "weapons/cbar_hit1.wav", 1.0, ATTN_NORM, 0, PITCH_LOW);
				case('1', '2'): emit_sound(id, CHAN_WEAPON, "weapons/bullet_hit2.wav", random_float(0.5, 1.0), ATTN_NORM, 0, PITCH_NORM);
				case('s'): emit_sound(id, CHAN_WEAPON, "weapons/cbar_miss1.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
			}
			return FMRES_SUPERCEDE;
		}
		if(g_bBoxMatch)
		{
			for(new i = 0; i < sizeof BoxingSounds; i++)
			{
				if(equal(sample, oldknife_sounds[i]))
				{
					emit_sound(id, channel, BoxingSounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM);
					return FMRES_SUPERCEDE;
				}
			}
		}
		switch (g_iDay[ TOTAL_DAYS ])
		{
			case DAY_NIGHT:
			{
				if(team == CS_TEAM_CT)
				{
					for(new i = 2; i < sizeof newknife_sounds; i++)
					{
						if(equal(sample, oldknife_sounds[i]))
						{
							emit_sound(id, channel, newknife_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM);
							return FMRES_SUPERCEDE;
						}
					}
				}
			}
			case DAY_RENIGHT:
			{
				if(team == CS_TEAM_T)
				{
					for(new i = 2; i < sizeof newknife_sounds; i++)
					{
						if(equal(sample, oldknife_sounds[i]))
						{
							emit_sound(id, channel, newknife_sounds[i], 1.0, ATTN_NORM, 0, PITCH_NORM);
							return FMRES_SUPERCEDE;
						}
					}
				}
			}
		}
	}
	
	return FMRES_IGNORED;
}
new Float: throworigin[3];
public ClCmd_drop(id)
{
	entity_get_vector(id, EV_VEC_origin, throworigin);
	if (get_bit(g_bHasCrowbar,id) && (get_user_weapon(id) == CSW_KNIFE)) 
	{
		clear_bit(g_bHasCrowbar, id);
		cs_reset_user_weapon(id);
		spawn_crowbar(id);
		return PLUGIN_HANDLED;
	}
	
	return PLUGIN_CONTINUE;	
}

public spawn_crowbar(const id)
{
	new iEntity;
	new Float:where[3];
	
	iEntity = create_entity("info_target");
	set_pev(iEntity, pev_classname, g_szClassNameCrowbar);
	set_pev(iEntity, pev_solid, SOLID_TRIGGER);
	set_pev(iEntity, pev_movetype, MOVETYPE_BOUNCE);
	entity_set_model(iEntity, CrowbarModels[2]);
	pev(id, pev_origin, where);
	where[2] += 50.0;
	where[0] += random_float(-20.0, 20.0);
	where[1] += random_float(-20.0, 20.0);
	entity_set_origin(iEntity, where);
	where[0] = 0.0;
	where[2] = 0.0;
	where[1] = random_float(0.0, 180.0);
	entity_set_vector(iEntity, EV_VEC_angles, where);
	velocity_by_aim(id, 200, where);
	entity_set_vector(iEntity, EV_VEC_velocity, where);
	
	
	return PLUGIN_HANDLED;
}

public CrowbarTouch(const id, const world)	
{
	new Float:velocity[3];
	new Float:volume;
	entity_get_vector(id, EV_VEC_velocity, velocity);
	
	velocity[0] = (velocity[0] * 0.45);
	velocity[1] = (velocity[1] * 0.45);
	velocity[2] = (velocity[2] * 0.45);
	entity_set_vector(id, EV_VEC_velocity, velocity);
	volume = get_speed(id) * 0.005; 
	if (volume > 1.0) volume = 1.0;
	if (volume > 0.1) emit_sound(id, CHAN_AUTO, "debris/metal2.wav", volume, ATTN_NORM, 0, PITCH_NORM);
	return PLUGIN_CONTINUE;	
}

public Fwd_PlayerCrowbarTouch(const iEntity, const id)
{
	if(!IsPlayer(id))
		return HAM_IGNORED;
		
	if( get_bit(g_bIsAlive, id) && cs_get_user_team(id) == CS_TEAM_T && !get_bit(g_bHasCrowbar, id))
	{
		set_bit(g_bHasCrowbar, id);
		remove_entity(iEntity);
		if (get_user_weapon(id) == CSW_KNIFE) 
		{
			cs_reset_user_weapon(id);
		}
		emit_sound(id, CHAN_AUTO, "items/gunpickup2.wav", 1.0, ATTN_NORM, 0, PITCH_NORM);
	}
	return HAM_IGNORED;
}

public Player_ResetMaxSpeed(const id)
{
	if(get_bit(g_bIsAlive, id))
	{
		if(get_bit(g_bHasSpeed, id))
		{
			new Float:maxSpeed = get_pcvar_float(cvar_pointer[cvar_shopspeed]);
			set_pev(id, pev_maxspeed, maxSpeed);
		}
		static CsTeams:team;
		team = cs_get_user_team(id);
			
		switch( g_iDay[ TOTAL_DAYS ] )
		{
			case DAY_ZOMBIE:
				if(team == CS_TEAM_CT)
					set_user_maxspeed(id, ZOMBIE_SPEED);
			case DAY_NIGHT:
				if(team == CS_TEAM_CT)
					set_user_maxspeed(id, NIGHTCRAWLER_SPEED);
			case DAY_REZOMBIE:
				if(team == CS_TEAM_T)
					set_user_maxspeed(id, REZOMBIE_SPEED);
			case DAY_RENIGHT:
				if(team == CS_TEAM_T)
					set_user_maxspeed(id, RENIGHTCRAWLER_SPEED);
		}
	}
}

public Fwd_Usp_Deploy(const weapon)
{
	if(g_iDay[ TOTAL_DAYS ] == DAY_USPNINJAS)
	{
		set_usp_silent(weapon);
		SendWeaponAnim(get_weapon_owner(weapon), 6);
	}
}

public Fwd_Usp_SecondaryAttack(const weapon)
{
	if(g_iDay[ TOTAL_DAYS ] == DAY_USPNINJAS)
	{
		set_usp_silent(weapon);
		SendWeaponAnim(get_weapon_owner(weapon), 0);
		set_pdata_float(weapon, m_flNextSecondaryAttack, 9999.9, OFFSET_LINUX); 
	}
}

SendWeaponAnim(id, iAnim)
{
	entity_set_int(id, EV_INT_weaponanim, iAnim);

	message_begin(MSG_ONE, SVC_WEAPONANIM, _, id);
	write_byte(iAnim);
	write_byte(entity_get_int(id, EV_INT_body));
	message_end();
}

public Fwd_ItemDeploy2_Post(const weapon)
{
	// Get the owner of the weapon
	new id = get_pdata_cbase(weapon, m_pPlayer, OFFSET_LINUX);
	if(get_bit(g_bIsAlive, id))
	{
		static CsTeams:team;
		team = cs_get_user_team(id);
		switch(g_iDay[ TOTAL_DAYS ])
		{
			case DAY_ZOMBIE:
			{
				if(team == CS_TEAM_CT)
					set_pev(id, pev_viewmodel2, ZombieModels[0]);
			}
			case DAY_REZOMBIE:
			{
				if(team == CS_TEAM_T)
					set_pev(id, pev_viewmodel2, ZombieModels[0]);
			}
			case DAY_NIGHT:
			{
				if(team == CS_TEAM_CT)
					set_pev(id, pev_viewmodel2, NightCrawlerModels[0]);
			}
			case DAY_RENIGHT:
			{
				if(team == CS_TEAM_T)
					set_pev(id, pev_viewmodel2, NightCrawlerModels[0]);
			}
			case DAY_NONE:
			{
				if( get_bit(g_bHasCrowbar, id))
				{
					set_pev(id, pev_viewmodel2, CrowbarModels[1]);
					set_pev(id, pev_weaponmodel2, CrowbarModels[0]);
				}
				else if(g_bBoxMatch)
				{
					switch(team)
					{
						case 1: set_pev(id, pev_viewmodel2, BoxingModels[1]);
						case 2: set_pev(id, pev_viewmodel2, BoxingModels[0]);
					}
				}
				else if(g_bSnowballWar)
				{
					set_pev(id, pev_viewmodel2, SnowballWarModels[4]);
					set_pev(id, pev_weaponmodel2, SnowballWarModels[3]);
				}
				else 
				{
					set_pev(id, pev_viewmodel2, "models/v_knife.mdl");
					set_pev(id, pev_weaponmodel2, "models/p_knife.mdl");
				}
			}
		}
	}
}

public Fwd_ItemDeploy_Post(const weapon)
{
	// Get the owner of the weapon
	new id = get_pdata_cbase(weapon, m_pPlayer, OFFSET_LINUX);
	if(get_bit(g_bIsAlive, id))
	{
		if(g_bSnowballWar)
		{
			set_pev(id, pev_viewmodel2, SnowballWarModels[1]);
			set_pev(id, pev_weaponmodel2, SnowballWarModels[0]);
		}
		else 
		{
			set_pev(id, pev_viewmodel2, "models/v_smokegrenade.mdl");
			set_pev(id, pev_weaponmodel2, "models/p_smokegrenade.mdl");
		}
	}
}
/*
public Fwd_ItemDeploy_Post(const weapon)
{
	// Get the owner of the weapon
	new id = get_pdata_cbase(weapon, m_pPlayer, OFFSET_LINUX);
	// The game isn't Shot4Shot
	if (g_iGameType != 2)
		return HAM_IGNORED;
	//if (get_bit(g_bIsLast, id) || get_bit(g_bIsChosen, id))
		//if( weapon != CSW_KNIFE )
			//set_pdata_int(weapon, OFFSET_CLIPAMMO, 1, 4);
	return HAM_IGNORED;
}*/

public Fwd_Use_Pre(const this, const caller, const activator, const use_type, Float:value)
{
	if (caller != activator)
		return HAM_IGNORED;
	
	new Float:fNextUse;
	pev(this, pev_fuser4, fNextUse);
	
	new Float:fGametime = get_gametime();
	
	if (fNextUse > fGametime)
		return HAM_IGNORED;
	
	new class[32], sModel[32];
	pev(this, pev_classname, class, 32);
	pev(this, pev_model, sModel, 32);
	
	if( equal(sModel, szModel, 0) )
	{
		new szTargetName[32];
		get_user_name(caller, szTargetName, charsmax(szTargetName));
		if(g_bAutoOpened)
			g_bAutoOpened = false;
		else {
			static iTimeLeft, iMinutes, iSeconds;
			iTimeLeft = floatround(g_fRoundTime - (get_gametime() - g_fRoundStartTime),floatround_ceil);

			if(iTimeLeft <= 0)
			{
				iMinutes = 0;
				iSeconds = 0;
			}
			else {
				iMinutes = (iTimeLeft / 60);
				iSeconds = (iTimeLeft % 60);
			}
			
			if(caller > 0)
				fnColorPrint(0, "%L", LANG_SERVER, "JB_OPENCELLS", 
				'^3', szTargetName, '^1', '^4', '^1', 
				'^3', iMinutes, '^1', '^3', iSeconds > 9 ? "" : "0", iSeconds);
		}
				
		if (!g_bAlreadyOpened)
		{
			remove_task( TASKID );
			g_bAlreadyOpened = true;
			g_bCanBuy = false;
		}
			
		set_pev(this, pev_fuser4, fGametime + get_pdata_float(this, m_flWait, 5));
	}
	return HAM_IGNORED;
}

public Event_SendAudio()
	g_iBlockLastRequest = 1;
	
public EventRoundEnd()
{
	remove_task( TASKID );
	server_cmd("sv_gravity 800");
	g_bInLr = false;
	g_bAlreadyOpened = false;
	g_bAutoOpened = false;
	g_bCanBuy = true;
	g_bBoxMatch = false;
	g_bSnowballWar = false;
	g_bGunGame = false;
	g_iCrowbars = 0;
	g_iGameType = 0;
	g_iDisguise = 0;
	g_iFootstep = 0;
	g_iCellKeys = 0;
	g_iInvis = 0;
	g_iSpeed = 0;
	Day_Ends( );
}

/*================================================================================
 [Save/Load Points]
=================================================================================*/
public SaveData(id)
{	
	new vKey[32], vData[32];
	//Save their points  
	#if defined SAVE_METHOD_NICK
	formatex(vKey, 31, "%s-points", g_iAuth[id]);  
	#endif 
	#if defined SAVE_METHOD_IP
	formatex(vKey, 31, "%s-points", g_iAuthIP[id]); 
	#endif 
	#if defined SAVE_METHOD_ID
	formatex(vKey, 31, "%s-points", g_iAuthID[id]);  
	#endif 
	
	formatex(vData, 31, "%i", g_iPoints[id]);
	nvault_set(g_vault, vKey , vData);
}

public GetData(id)
{	
	new szKey[32];
	#if defined SAVE_METHOD_NICK
	formatex(szKey, 31, "%s-points", g_iAuth[id]);  
	#endif 
	#if defined SAVE_METHOD_IP
	formatex(szKey, 31, "%s-points", g_iAuthIP[id]);  
	#endif 
	#if defined SAVE_METHOD_ID
	formatex(szKey, 31, "%s-points", g_iAuthID[id]); 
	#endif 
	g_iPoints[id] = nvault_get( g_vault , szKey );
}

/*================================================================================
 [The Shop]
=================================================================================*/
public ClCmd_shop(id)
{
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;

	if(!get_pcvar_num(cvar_pointer[cvar_shop]))
	{
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M35");
		return PLUGIN_HANDLED;
	}
	if(cs_get_user_team(id) != CS_TEAM_T)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M36");
		return PLUGIN_HANDLED;
	}
	
	if(!g_bCanBuy)
	{
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M37");
		return PLUGIN_HANDLED;
	}
	
	if(!get_bit(g_bIsAlive, id))
	{
		fnColorPrint( id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}

	show_shopmenu(id);
	return PLUGIN_HANDLED;
}

public show_shopmenu(id)
{
	if(get_bit(g_bIsAlive, id) && cs_get_user_team(id) == CS_TEAM_T)
	{
		new szText[256];
		new points = g_iPoints[id];
		//g_bHasMenuOpen[id] = true
		set_bit(g_bHasMenuOpen, id);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_TITLE", points);
		new shopmenu = menu_create(szText, "sub_shopmenu");
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M1", get_pcvar_num(cvar_pointer[cvar_crowbarprice]), g_iCrowbars, get_pcvar_num(cvar_pointer[cvar_crowbarlimit]));
		menu_additem(shopmenu, szText, "1", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M2", get_pcvar_num(cvar_pointer[cvar_armorprice]));
		menu_additem(shopmenu, szText, "2", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M3", get_pcvar_num(cvar_pointer[cvar_nadepackprice]));
		menu_additem(shopmenu, szText, "3", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M4", get_pcvar_num(cvar_pointer[cvar_invisprice]), g_iInvis, get_pcvar_num(cvar_pointer[cvar_invislimit]));
		menu_additem(shopmenu, szText, "4", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M5", get_pcvar_num(cvar_pointer[cvar_speedprice]), g_iSpeed, get_pcvar_num(cvar_pointer[cvar_speedlimit]));
		menu_additem(shopmenu, szText, "5", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M6", get_pcvar_num(cvar_pointer[cvar_footstepprice]), g_iFootstep, get_pcvar_num(cvar_pointer[cvar_footsteplimit]));
		menu_additem(shopmenu, szText, "6", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M7", get_pcvar_num(cvar_pointer[cvar_disguiseprice]), g_iDisguise, get_pcvar_num(cvar_pointer[cvar_disguiselimit]));
		menu_additem(shopmenu, szText, "7", 0);
		
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SHOP_M8", get_pcvar_num(cvar_pointer[cvar_cellkeysprice]), g_iCellKeys, get_pcvar_num(cvar_pointer[cvar_cellkeyslimit]));
		menu_additem(shopmenu, szText, "8", 0);
		
		menu_setprop(shopmenu, MPROP_EXIT , MEXIT_ALL);
		menu_display(id, shopmenu, 0);
	}

	return PLUGIN_HANDLED;
}

public sub_shopmenu(id, shopmenu, item)  
{
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
			
	if (item == MENU_EXIT || cs_get_user_team(id) == CS_TEAM_CT || !get_bit(g_bIsAlive, id) || !g_bCanBuy)
	{
		clear_bit(g_bHasMenuOpen, id);
		menu_destroy(shopmenu);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	clear_bit(g_bHasMenuOpen, id);
	menu_item_getinfo(shopmenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new Key = str_to_num(data);
	
	switch (Key)
	{
		case 1:
		{
			if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_crowbarprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else {
				if(get_bit(g_bHasCrowbar, id))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				
				else if(g_iCrowbars >= get_pcvar_num(cvar_pointer[cvar_crowbarlimit]))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M40");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				else give_crowbar(id);
			}
			show_shopmenu(id);
		}
		
		case 2:
		{
			if(get_bit(g_bHasArmor, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_armorprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else give_armor(id);
			show_shopmenu(id);
		}
		
		case 3:
		{
			if(get_bit(g_bHasNadepack, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_nadepackprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else give_nadepack(id);
			show_shopmenu(id);
		}
		
		case 4:
		{
			if(get_bit(g_bHasInvis, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_invisprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(get_bit(g_bHasFreeday, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M41");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else {
				if(g_iInvis >= get_pcvar_num(cvar_pointer[cvar_invislimit]))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M42");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				else give_invis(id);
			}
			show_shopmenu(id);
		}
		
		case 5:
		{
			if(get_bit(g_bHasSpeed, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_speedprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(g_iDay[ TOTAL_DAYS ] == DAY_FREEZETAG)
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M43");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else
			{
				if(g_iSpeed >= get_pcvar_num(cvar_pointer[cvar_speedlimit]))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M44");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				else give_speed(id);
			}
			show_shopmenu(id);
		}
		
		case 6:
		{
			if(get_bit(g_bHasFootstep, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_footstepprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else
			{
				if(g_iFootstep >= get_pcvar_num(cvar_pointer[cvar_footsteplimit]))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M45");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				else give_footstep(id);
			}
			show_shopmenu(id);
		}
		
		case 7:
		{
			if(get_bit(g_bHasDisguise, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_disguiseprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else
			{
				if(g_iDisguise >= get_pcvar_num(cvar_pointer[cvar_disguiselimit]))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M46");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				else give_disguise(id);
			}
			show_shopmenu(id);
		}
		case 8:
		{
			if(get_bit(g_bHasCellKeys, id))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M39");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else if(g_iPoints[id] < get_pcvar_num(cvar_pointer[cvar_cellkeysprice]))
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M38");
				show_shopmenu(id);
				return PLUGIN_HANDLED;
			}
			else
			{
				if(g_iCellKeys >= get_pcvar_num(cvar_pointer[cvar_cellkeyslimit]))
				{
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M47");
					show_shopmenu(id);
					return PLUGIN_HANDLED;
				}
				else give_cellkeys(id);
			}
			show_shopmenu(id);
		}

	}
	menu_destroy(shopmenu);
	return PLUGIN_HANDLED;
}

public give_crowbar(id)
{
	set_bit(g_bHasCrowbar, id);
	ham_strip_weapon(id, "weapon_knife");
	give_item(id, "weapon_knife");
	g_iCrowbars++;
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_crowbarprice]);
	cs_set_user_money(id, g_iPoints[id], 1);

	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M48");
	return PLUGIN_HANDLED;
}

public give_armor(id)
{
	set_bit(g_bHasArmor, id);
	set_user_armor(id, 100);
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M49");
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_armorprice]);
	cs_set_user_money(id, g_iPoints[id], 1);

	return PLUGIN_HANDLED;
}

public give_nadepack(id)
{
	set_bit(g_bHasNadepack, id);
	give_item(id, "weapon_flashbang");
	give_item(id, "weapon_hegrenade");
	give_item(id, "weapon_smokegrenade");
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_nadepackprice]);
	cs_set_user_money(id, g_iPoints[id], 1);
	
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M50");
	
	return PLUGIN_HANDLED;
}

public give_invis(id)
{
	new AlphaVal = get_pcvar_num(cvar_pointer[cvar_alphavalue]);
	set_bit(g_bHasInvis, id);
	set_user_rendering(id,kRenderFxGlowShell,0,0,0,kRenderTransAlpha,AlphaVal);
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_invisprice]);
	cs_set_user_money(id, g_iPoints[id], 1);
	
	g_iInvis++;
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M51");
	return PLUGIN_HANDLED;
}

public give_speed(id)
{
	new Float:maxSpeed = get_pcvar_float(cvar_pointer[cvar_shopspeed]);
	set_bit(g_bHasSpeed, id);
	set_user_maxspeed(id,maxSpeed);
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_speedprice]);
	cs_set_user_money(id, g_iPoints[id], 1);
	
	g_iSpeed++;
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M52");
	return PLUGIN_HANDLED;
}

public give_footstep(id)
{
	set_user_footsteps(id, 1);
	set_bit(g_bHasFootstep, id);
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_footstepprice]);
	cs_set_user_money(id, g_iPoints[id], 1);
	
	g_iFootstep++;
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M53");
	return PLUGIN_HANDLED;
}

public give_disguise(id)
{
	set_bit(g_bHasDisguise, id);
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_crowbarprice]);
	cs_set_user_money(id, g_iPoints[id], 1);

	g_iDisguise++;
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M54");
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M55");
	return PLUGIN_HANDLED;
}

public give_cellkeys(id)
{
	set_bit(g_bHasCellKeys, id);
	g_iPoints[id] -= get_pcvar_num(cvar_pointer[cvar_cellkeysprice]);
	cs_set_user_money(id, g_iPoints[id], 1);

	g_iCellKeys++;
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M56");
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M57");
	return PLUGIN_HANDLED;
}

public EventMoney(id)
	cs_set_user_money(id, g_iPoints[id], 1);

/*================================================================================
 [Give/Take Points]
=================================================================================*/
public cmd_give_points(id,level,cid)
{
	if(!cmd_access(id,level,cid,3))
		return PLUGIN_HANDLED;

	new target[32], amount[21];
 
	read_argv(1, target, 31 );
	read_argv(2, amount, 20 );
 
	new player = cmd_target( id, target, 8 );
 
	if(!player) 
		return PLUGIN_HANDLED;
 
	new admin_name[32]; get_user_name(id, admin_name, charsmax(admin_name));
	new player_name[32]; get_user_name(player, player_name, charsmax(player_name));
	new pointnum = str_to_num(amount);
	
	g_iPoints[player] += pointnum;
	cs_set_user_money(player, g_iPoints[player], 1);
 
	switch(get_cvar_num ("amx_show_activity"))
	{
		case 1: fnColorPrint( 0, "%L", LANG_SERVER, "JB_DAY_M58", pointnum, player_name);
		case 2: fnColorPrint( 0, "%L", LANG_SERVER, "JB_DAY_M59", admin_name, pointnum, player_name);
	}
	
	fnColorPrint(player, "%L", LANG_SERVER, "JB_DAY_M60", pointnum, g_iPoints[player]);
 
	SaveData(id);

	return PLUGIN_HANDLED;
}

public cmd_take_points(id,level,cid)
{
	if(!cmd_access (id, level, cid, 2))
		return PLUGIN_HANDLED;
 
	new target[32], amount[21];
 
	read_argv( 1, target, 31 );
	read_argv( 2, amount, 20 );
 
	new player = cmd_target( id, target, 8 );

	if(!player) 
		return PLUGIN_HANDLED;
 
	new admin_name[32]; get_user_name(id, admin_name, charsmax(admin_name));
	new player_name[32]; get_user_name(player, player_name, charsmax(player_name));
	
	new pointnum = str_to_num( amount );
	
	if(g_iPoints[player] < pointnum)
	{
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M61");
		return PLUGIN_HANDLED;
	}
	
	g_iPoints[player] -= pointnum;
	cs_set_user_money(player, g_iPoints[player], 1);
	
	switch(get_cvar_num("amx_show_activity"))
	{
		case 1: fnColorPrint( 0, "%L", LANG_SERVER, "JB_DAY_M62", pointnum, player_name);
		case 2: fnColorPrint( 0, "%L", LANG_SERVER, "JB_DAY_M63", admin_name, pointnum, player_name);
	}
	
	fnColorPrint( player, "%L", LANG_SERVER, "JB_DAY_M64", pointnum, g_iPoints[player]);
 
	SaveData(id);
 
	return PLUGIN_HANDLED;
}

public cmd_reset_points(id,level,cid)
{
	if(!cmd_access(id,level,cid,2))
		return PLUGIN_HANDLED;
		
	new target[32];
 
	read_argv(1, target, 31);
 
	new player = cmd_target(id, target, 8);
 
	if(!player) 
		return PLUGIN_HANDLED;
 
	new admin_name[32]; get_user_name(id, admin_name, charsmax(admin_name));
	new player_name[32]; get_user_name(player, player_name, charsmax(player_name));
	g_iPoints[player] = 0;
	cs_set_user_money(player, g_iPoints[player], 1);
 
	switch(get_cvar_num ("amx_show_activity"))
	{
		case 1: fnColorPrint( 0, "%L", LANG_SERVER, "JB_DAY_M65", player_name);
		case 2: fnColorPrint( 0, "%L", LANG_SERVER, "JB_DAY_M66", admin_name, player_name);
	}
	
	fnColorPrint(player, "%L", LANG_SERVER, "JB_DAY_M67");
 
	SaveData(id);

	return PLUGIN_HANDLED;
}

/*================================================================================
 [Open By 8:00/cell button stuff]
=================================================================================*/

public cmd_set_button(id,level,cid)
{
	if(!cmd_access(id,level,cid,1))
		return PLUGIN_HANDLED;
		
	new szTempModel[64];
	new szTempClass[64];
	new szTemp[64];
	new szTempEnt;
	new Map[32];
	new szKey[32];
	
	szTempEnt = GetAimingEnt(id);
	
	if( pev_valid(szTempEnt) )
	{
		entity_get_string( szTempEnt, EV_SZ_classname, szTempClass, charsmax( szTempClass ) );
		if( equal( szTempClass, "func_button" ) || equal( szTempClass, "func_rot_button" ) || equal( szTempClass, "button_target" ) )
		{
			pev(szTempEnt, pev_model, szTempModel, 63);
			iEnt = szTempEnt;
			log_amx("%s", iEnt);
			
			get_mapname(Map, 31);
			strtolower(Map);
			
			formatex(szKey , 31 , "%s" , Map);
			formatex(szTemp , 64, "%s#%s#", szTempModel, szTempClass);
			
			nvault_set(g_buttonvault , szKey , szTemp);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M68", szTempModel, szTempClass, Map);
		
		}
		else{
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M69");
		}
	}
	else{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M70");
	}

	return PLUGIN_HANDLED;
}

GetAimingEnt(id)
{
	static Float:start[3], Float:view_ofs[3], Float:dest[3], i;
	
	pev(id, pev_origin, start);
	pev(id, pev_view_ofs, view_ofs);
	
	for( i = 0; i < 3; i++ )
	{
		start[i] += view_ofs[i];
	}
	
	pev(id, pev_v_angle, dest);
	engfunc(EngFunc_MakeVectors, dest);
	global_get(glb_v_forward, dest);
	
	for( i = 0; i < 3; i++ )
	{
		dest[i] *= 9999.0;
		dest[i] += start[i];
	}

	engfunc(EngFunc_TraceLine, start, dest, DONT_IGNORE_MONSTERS, id, 0);
	
	return get_tr2(0, TR_pHit);
}

public TASK_PushButton()
{
	if(g_iAreWeInaVote)
		remove_task( TASKID );
	else
	{
		static iTimeLeft, iMinutes, iSeconds;
		iTimeLeft = floatround(g_fRoundTime - (get_gametime() - g_fRoundStartTime),floatround_ceil);
	
		iMinutes = (iTimeLeft / 60);
		iSeconds = (iTimeLeft % 60);
		if(!g_bInLr)
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M71", '^3', iMinutes, '^1', '^3', iSeconds > 9 ? "" : "0", iSeconds, '^1' );
		g_bCanBuy = false;
		if(pev_valid(iEnt))
		{
			g_bAutoOpened = true;
			ExecuteHamB(Ham_Use, iEnt, 0, 0, 1, 1.0);
		}
	}
}

public Get_Button()
{
	new szTemp[64];
	new Map[32];
	new szKey[32];
	new ButtonModel, ButtonClass;
	
	get_mapname(Map, 31);
	strtolower(Map);
	
	formatex(szKey , 31 , "%s" , Map);
	formatex(szTemp , 63, "%s#%s#", ButtonModel, ButtonClass); 
	nvault_get(g_buttonvault, szKey, szTemp, 255); 
	replace_all(szTemp , 255, "#", " ");
	
	parse(szTemp,szModel, 31, szClass, 31);  
	log_amx("%L", LANG_SERVER, "JB_DAY_M72", szModel[0], szClass[0]);

	ButtonClass = szClass[0];
	ButtonModel = szModel[0];
	
	return PLUGIN_HANDLED;
} 

public ButtonSpawn( Ent )
{
	new Mnumber[32];
	pev( Ent, pev_model, Mnumber, 31 );
	
	if( equali( Mnumber, szModel ) )
		iEnt = Ent;
}
/*================================================================================
 [Commands]
=================================================================================*/
new simonmenu;
public ClCmd_simon(id) {
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
		
	// Not a terrorist
	if (get_user_team(id) != 2)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M73");
		return PLUGIN_HANDLED;
	}
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M74");
		return PLUGIN_HANDLED;
	}
	
	// More than 1 terrorist
	if (fnGetTerrorists() < 1)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M75");
		return PLUGIN_HANDLED;
	}
	
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M76");
		return PLUGIN_HANDLED;
	}
	
	if(get_bit(g_bIsSimon, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M78");
		clear_bit(g_bIsSimon, id);
		if(!get_bit(g_bUserHasTag, id))
			remove_tag_player(id);
		else
		{
			new szTag[32], authid[32], data;
			get_user_authid(id, authid, charsmax(authid));
			data = nvault_get(nVault, authid, szTag, charsmax(szTag));
			if(data)
				formatex(g_iUserTagName[id], 54, "[%s] %s", szTag, g_iUserName[id]);
		}
		if (!task_exists(id+TASK_SIMONBEAM))
			remove_task(id+TASK_SIMONBEAM);
			
		if( player_menu_info(id, simonmenu, simonmenu) )
		{
			menu_cancel(id);
			client_cmd(id, "slot1" );
		}
		return PLUGIN_HANDLED;
	}
	
	if (fnGetSimons() >= MAX_SIMONS)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M77");
		return PLUGIN_HANDLED;
	}
	new szName[32]; get_user_name(id, szName, charsmax(szName));
	fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M79", '^3', szName, '^1', '^4', '^1', '^4', '^1', '^3', '^1');
	set_bit(g_bIsSimon, id);
	set_tag_player(id, "Simon");
	if (!task_exists(id+TASK_SIMONBEAM))
		set_task(3.0, "Task_SimonStartRing", id+TASK_SIMONBEAM, _, _, "b");
	show_SimonMenu(id);
	return PLUGIN_HANDLED;
}

new const g_iSimonNames[][] = {
	"JB_SIMON_M1", 
	"JB_SIMON_M2",
	"JB_SIMON_M3", 
	"JB_SIMON_M4",
	"JB_SIMON_M5", 
	"JB_SIMON_M6",
	"JB_SIMON_M7"
};

#define SIMON_ITEMS sizeof(g_iSimonNames)
new const g_iAccessSimon[SIMON_ITEMS] = {
	0, 
	0,
	0, 
	0,
	ADMIN_SIMON, 
	0,
	ADMIN_SIMON
};

public show_SimonMenu(id)
{
	if(get_bit(g_bIsSimon, id))
	{
		new szText[256];
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_SIMON_TITLE", g_szPluginPrefix);
		simonmenu = menu_create(szText, "sub_simonmenu");
		
		new iNumber[5], szOption[40];
		for( new i = 0; i < SIMON_ITEMS; i++ ) {
			num_to_str(i+1, iNumber, 4);
			formatex(szOption, 39, "%L", LANG_SERVER, g_iSimonNames[i]);
			menu_additem(simonmenu, szOption, iNumber, g_iAccessSimon[i]);
		}
		
		menu_setprop(simonmenu, MPROP_EXIT , MEXIT_NORMAL);
		menu_display(id, simonmenu, 0);
	}
	return PLUGIN_HANDLED;
}

public sub_simonmenu(id, simonmenu, item)  
{
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
		
	if (item == MENU_EXIT || cs_get_user_team(id) == CS_TEAM_T)
	{
		if(get_bit(g_bIsSimon, id))
		{
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M78");
			clear_bit(g_bIsSimon, id);
			if (!task_exists(id+TASK_SIMONBEAM))
				remove_task(id+TASK_SIMONBEAM);
		}
		menu_destroy(simonmenu);
		return PLUGIN_HANDLED;
	}
	
	if (!get_bit(g_bIsAlive, id) || g_iDay[ TOTAL_DAYS ] != DAY_NONE || !get_bit(g_bIsSimon, id) || g_bInLr)
	{
		menu_destroy(simonmenu);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(simonmenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new Key = str_to_num(data);
	new szName[32]; get_user_name(id, szName, charsmax(szName));
	
	switch (Key)
	{
		case 1:
		{
			if(pev_valid(iEnt))
				ExecuteHamB(Ham_Use, iEnt, 0, 0, 1, 1.0);
				
			if(!g_bAlreadyOpened)
			{
				remove_task( TASKID );
				
				g_bCanBuy = false;
				
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M80", '^3', '^4', szName, '^1');
				g_bAutoOpened = true;
				g_bAlreadyOpened = true;
			}
			show_SimonMenu(id);
		}
		case 2: {ClCmd_opendoors(id);show_SimonMenu(id);}
		case 3: {ClCmd_closedoors(id);show_SimonMenu(id);}
		case 4:
		{
			static iNum, iPlayers[32], iPlayer, i, Count;
			Count = 0;
			get_players(iPlayers, iNum, "ae", "TERRORIST");  
			
			for ( i=0; i<iNum; i++ ) 
			{
				iPlayer = iPlayers[i]; 
				if(get_bit(g_bHasFreeday, iPlayer))
					continue;
				Count++;
			}
			new iExtraPlayers = Count % 2; 
			if (iExtraPlayers)  
			{ 
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M81", '^4', '^1', '^3'); 
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M82"); 
			} 
			else if(g_bTeamDivided) 
			{ 
				for ( i=0; i<iNum; i++ ) 
				{
					iPlayer = iPlayers[i]; 
					if(get_bit(g_bHasFreeday, iPlayer))
						continue;
						
					set_user_rendering(iPlayer, _, 0, 0, 0, _, 0);
				}
				g_bTeamDivided = false; 
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M83"); 
			} 
			else 
			{ 
				for(new maxPerTeam = (iNum / 2), g_iTeams[2], g_iTeam, iPlayer, i = 0; i < iNum; i++) 
				{ 
					iPlayer = iPlayers[i]; 
					if(get_bit(g_bHasFreeday, iPlayer))
						continue;
					
					g_iTeam = random_num(0, 1); 
					
					if(g_iTeams[g_iTeam] >= maxPerTeam) 
						g_iTeam = !g_iTeam; 
					else 
						g_iTeams[g_iTeam]++; 
					
					if( g_iTeam == 1 )
					{
						set_user_rendering(iPlayer,kRenderFxGlowShell,255,0,0,kRenderNormal,16);
						UTIL_ScreenFade1(iPlayer, 2.0, 4.0);
						fnColorPrint(iPlayer, "You are on the blue team!");
					}
					if( g_iTeam == 0 )
					{
						set_user_rendering(iPlayer,kRenderFxGlowShell,0,0,255,kRenderNormal,16);
						UTIL_ScreenFade2(iPlayer, 2.0, 4.0);
						fnColorPrint(iPlayer, "You are on the red team!");
					}
				}
				
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M84", '^3', '^4', szName, '^1', '^3', '^1'); 
				g_bTeamDivided = true; 
			} 
			show_SimonMenu(id);
		}
		case 5: {emit_sound(0, CHAN_AUTO, g_szSound_Bell, 1.0, ATTN_NORM, 0, PITCH_NORM);show_SimonMenu(id);}
		case 6:
		{
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M85", '^3', '^4', szName, '^1'); 
			MathMenu(id);
		}
		case 7:
		{
			static g_iPlayer; 
			g_iPlayer = fnGetRandomPlayer();
			new szName1[32]; get_user_name(g_iPlayer, szName1, charsmax(szName1));
			if(g_iPlayer > 0 && !get_bit(g_bHasFreeday, g_iPlayer))
			{
				user_silentkill(g_iPlayer);
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M86", '^3', '^4', szName, '^1', '^3', szName1); 
			}
			show_SimonMenu(id);
		}

	}
	menu_destroy(simonmenu);
	return PLUGIN_HANDLED;
}

UTIL_ScreenFade1(const id, Float:fDuration, Float:fHoldTime) {
	message_begin( MSG_ONE_UNRELIABLE, g_iMsgId_ScreenFade, _, id);
	write_short(CLAMP_SHORT(floatround(4096 * fDuration))); // 1 << 12 = 4096
	write_short(CLAMP_SHORT(floatround(4096 * fHoldTime)));
	write_short(0x0000); // FFADE_IN = 0x0000
	write_byte(255);
	write_byte(0);
	write_byte(0);
	write_byte(150);
	message_end();
}

UTIL_ScreenFade2(const id, Float:fDuration, Float:fHoldTime) {
	message_begin( MSG_ONE_UNRELIABLE, g_iMsgId_ScreenFade, _, id);
	write_short(CLAMP_SHORT(floatround(4096 * fDuration))); // 1 << 12 = 4096
	write_short(CLAMP_SHORT(floatround(4096 * fHoldTime)));
	write_short(0x0000); // FFADE_IN = 0x0000
	write_byte(0);
	write_byte(0);
	write_byte(255);
	write_byte(150);
	message_end();
}

public ResetSimon(id) {
	clear_bit(g_bIsSimon, id);
	if(!get_bit(g_bUserHasTag, id))
		remove_tag_player(id);
	else
	{
		new szTag[32], authid[32], data;
		get_user_authid(id, authid, charsmax(authid));
		data = nvault_get(nVault, authid, szTag, charsmax(szTag));
		if(data)
			formatex(g_iUserTagName[id], 54, "[%s] %s", szTag, g_iUserName[id]);
	}
	static iPlayers[32], iNum, i, iPlayer;
	get_players(iPlayers, iNum, "ae", "TERRORIST");  
	for ( i=0; i<iNum; i++ ) 
	{
		iPlayer = iPlayers[i];
		if(get_bit(g_bInMathProblem, iPlayer))
		{
			fnColorPrint(iPlayer, "%L", LANG_SERVER, "JB_DAY_M87");
			//static Flags; Flags = entity_get_int( iPlayer, EV_INT_flags );
			//entity_set_int( iPlayer, EV_INT_flags, Flags &~ FL_FROZEN );
			clear_bit(g_bInMathProblem, iPlayer);
			set_user_rendering(iPlayer, _, 0, 0, 0, _, 0);
		}
	}
}
//Thanks to gangien
public ClCmd_math(id) {
	new count = random_num(3, 6);
	new values[10];
	new operations[10];
	for(new i = 0; i < count; i++) {
		if(i < count - 1)
			operations[i] = random_num(0, 3);
		do {
			values[i] = random_num(1, 20);
		} while ((i > 0) && (values[i] == 0) && (operations[i - 1] == 3));
	}
	new solved = values[random_num(0, count - 1)];
	new str[256];
	new fl[16];
	for(new i = 0; i < count - 1; i++) 
		add(str, sizeof(str), "(");
	
	for(new i = 0; i < count; i++) {
		if(values[i] == solved)
			add(str, sizeof(str), "x");
		else {
			num_to_str(values[i], fl, sizeof(fl));
			add(str, sizeof(str), fl);
		}
		if(i > 0)
			add(str, sizeof(str), ")");
		
		if(i < count - 1)
			add(str, sizeof(str), g_iOperators[operations[i]]);
		
	}
	
	new Float:fValue = float(values[0]);
	for(new i = 1; i < count; i++)
	{
		switch(operations[i - 1]) 
		{
			case 0: fValue = floatadd(fValue, float(values[i]));
			case 1: fValue = floatsub(fValue, float(values[i]));
			case 2: fValue = floatmul(fValue, float(values[i]));
			case 3: fValue = floatdiv(fValue, float(values[i]));
		}
	}

	format(mathEquations[id], 127, "%L", LANG_SERVER, "JB_DAY_M89", str, fValue);
	mathAnswer[id] = solved;
	set_hudmessage(200, 155, 0, -1.0, 0.50, 0, 6.0, 1.0, 0.3, 0.5, 3);
	show_hudmessage(id, mathEquations[id]);
	set_task(1.0, "Task_StartMath", id+TASK_MATH, _, _, "b");
	return PLUGIN_HANDLED;
}

public Task_StartMath(id)
{
	// id = id - TASK_BEAM = id
	id -= TASK_MATH;
	
	// Avoid the task call if the user died
	if (!get_bit(g_bIsConnected, id) || !get_bit(g_bIsAlive, id) || !get_bit(g_bInMathProblem, id) || g_bInLr)
	{
		remove_task(id+TASK_MATH);
		return;
	}
	// Set the beam
	fnSetMath(id);
}

fnSetMath(id) {
	set_hudmessage(200, 155, 0, -1.0, 0.50, 0, 6.0, 1.1, 0.3, 0.5, 3);
	show_hudmessage(id, mathEquations[id]);
	set_user_rendering(id,kRenderFxGlowShell,255,255,255,kRenderNormal,16);
}

public ClCmd_nextproblem(id) {
	if( get_bit(g_bInMathProblem, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M88");
		ClCmd_math(id);
	}
}

public ClCmd_HideTag(id)
{
	if(is_user_admin(id))
	{
		if(get_bit(g_bHide, id))
		{
			clear_bit(g_bHide, id);
			fnColorPrint(id, "Your tag is not hidden anymore!");
		}
		else 
		{
			fnColorPrint(id, "Your tag is hidden!");
			set_bit(g_bHide, id);
		}
	}
}

public client_infochanged(id)
{
	if( !is_user_connected(id) )
		return PLUGIN_CONTINUE;
	
	get_user_info(id, "name", g_iUserName[id], 31);
	
	new szTag[32], authid[32], data;
	get_user_authid(id, authid, charsmax(authid));
	data = nvault_get(nVault, authid, szTag, charsmax(szTag));
	if(data)
	{
		formatex(g_iUserTagName[id], 54, "[%s] %s", szTag, g_iUserName[id]);
		set_bit(g_bUserHasTag, id);
	}
	else
	{
		formatex(g_iUserTagName[id], 54, "%s", g_iUserName[id]);
		clear_bit(g_bUserHasTag, id);
	}

	if( is_user_hltv(id) || is_user_bot(id) )
		return PLUGIN_CONTINUE;
	
	return PLUGIN_CONTINUE;
}

public MsgTextMsg(iMesgId, iMsgType, id)
{
	if( get_msg_args()!=5 || get_msg_arg_int(1)!=print_chat_colored )
		return PLUGIN_CONTINUE;
	
	static s_iSenderId;

	static s_iMessage[192];
	get_msg_arg_string(3, s_iMessage, 191);
	if( equal(s_iMessage, "#Game_radio") )
	{
		get_msg_arg_string(5, s_iMessage, 191);
		if( equal(s_iMessage, "#Fire_in_the_hole") )
		{
			static s_iSender[4];
			get_msg_arg_string(2, s_iSender, 3);
			copy(s_iMessage, 191, "%s1 (RADIO) :  %s2");
			set_msg_arg_string(3, s_iMessage);
		}
		else
		{
			set_msg_arg_string(3, "%s1 (RADIO) :  %s2");
		}

		if( !get_bit(g_bHide, s_iSenderId) && (get_bit(g_bUserHasTag, s_iSenderId) || get_bit(g_bUserHasTagDay, s_iSenderId)))
			set_msg_arg_string(4, g_iUserTagName[s_iSenderId]);

	}
	
	return PLUGIN_CONTINUE;
}

public MsgSayText(iMsgId, iMsgType, id)
{
	if( get_msg_args()!=4 )
		return PLUGIN_CONTINUE;
	
	static s_iMessage[192], s_iText[192], s_iSenderId;
	get_msg_arg_string(2, s_iMessage, 191);
	get_msg_arg_string(4, s_iText, 191);
	s_iSenderId = get_msg_arg_int(1);
	
	if( g_iOldMessage[0] && equal(s_iMessage, g_iLastMsg) && equal(s_iText, g_iLastText) )
	{
		if( g_iOldMessage[0]==-1 )
			return PLUGIN_HANDLED;

		if( !get_bit(g_bHide, id) && (get_bit(g_bUserHasTag, id) || get_bit(g_bUserHasTagDay, id)) )
			set_msg_arg_string(3, g_iUserTagName[s_iSenderId]);
		else
			set_msg_arg_string(3, g_iUserName[s_iSenderId]);

		set_msg_arg_string(2, g_iOldMessage);
		set_msg_arg_string(4, "");

		return PLUGIN_CONTINUE;
		
	}
	else
	{
		g_iLastMsg = s_iMessage;
		g_iLastText = s_iText; 
	}

	new iReturned;
	iReturned = format_message(s_iMessage, 191, s_iText);
	switch( replace_arguments(iReturned, s_iMessage) )
	{
		case PLUGIN_CONTINUE: return PLUGIN_CONTINUE;
		case PLUGIN_HANDLED:  return PLUGIN_HANDLED;
	}

	if( !get_bit(g_bHide, id) && (get_bit(g_bUserHasTag, id) || get_bit(g_bUserHasTagDay, id)) )
		set_msg_arg_string(3, g_iUserTagName[s_iSenderId]);
	else
		set_msg_arg_string(3, g_iUserName[s_iSenderId]);	
		
	return PLUGIN_CONTINUE;
}

replace_arguments(iReturnedValue, iMessage[192])
{
	g_iOldMessage[0] = 0;
	
	switch( iReturnedValue )
	{
		case -2:
		{
			set_msg_arg_string(2, iMessage);
			return PLUGIN_CONTINUE;
		}
		case PLUGIN_CONTINUE: return PLUGIN_CONTINUE;
		case PLUGIN_HANDLED:
		{
			g_iOldMessage[0] = -1;
			return PLUGIN_HANDLED;
		}
		default:
		{
			g_iOldMessage = iMessage;
			set_msg_arg_string(2, iMessage);
			set_msg_arg_string(4, "");
		}
	}
	
	return -1;
}

format_message(iMessage[], const iMsgLen, const iText[])
{
	if( equal(iMessage, g_szSayCommands[Say_NameChange]) )
	{
		copy(iMessage, iMsgLen, "* %s1 changed name to %s2");
		return -2;
	}
	new iCommand;
	new iLen;
	if( TrieGetCell( g_tSayCommands, iMessage, iCommand ) )
	{
		switch(iCommand)
		{	
			case Say_ChatCT:	iLen = copy(iMessage, iMsgLen, "(Gaurds) %s1 :  ");
			case Say_ChatT:		iLen = copy(iMessage, iMsgLen, "(Prisoners) %s1 :  ");
			case Say_ChatCT_Dead:	iLen = copy(iMessage, iMsgLen, "*DEAD*(Gaurds) %s1 :  ");
			case Say_ChatT_Dead:	iLen = copy(iMessage, iMsgLen, "*DEAD*(Prisoners) %s1 :  ");
			case Say_ChatSpec: 	iLen = copy(iMessage, iMsgLen, "(Spectator) %s1 :  ");
			case Say_ChatAll:	
			{
				iLen = copy(iMessage, iMsgLen, "%s1 :  ");
			}
			case Say_ChatAll_Dead:	
			{
				iLen = copy(iMessage, iMsgLen, "*DEAD* %s1 :  ");
			}
			
			case Say_ChatAll_Spec:	
			{
				iLen = copy(iMessage, iMsgLen, "*SPEC* %s1 :  ");
			}
			default:		return PLUGIN_CONTINUE;
		}
	}
	
	new iLen2 = (copy(iMessage[iLen], iMsgLen-iLen, iText)-1);
	if( iLen2<=0 )
		return PLUGIN_HANDLED;
	
	iLen2+=iLen;
	new bool:bWordExists;
	for( iLen+=0; iLen<iLen2; iLen++ )
	{
		if( iMessage[iLen]=='' || iMessage[iLen]=='' || iMessage[iLen]=='' || iMessage[iLen]=='' || iMessage[iLen]=='%' )
			iMessage[iLen] = ' ';
		else if( iMessage[iLen]!=' ' )
			bWordExists = true;
	}
	
	if( !bWordExists )
		return PLUGIN_HANDLED;
		
	return -1;
}

public tag_player(id, level, cid) {
	if(!cmd_access(id, level, cid, 2)) 
		return PLUGIN_HANDLED;
	
	new name[32]; read_argv(1, name, charsmax(name));
	new player = cmd_target(id, name, CMDTARGET_ALLOW_SELF);
	
	if(!player)	return PLUGIN_HANDLED;
	
	new tag[32]; read_argv(2, tag, charsmax(tag));
	new authid[32]; get_user_authid(player, authid, charsmax(authid));
	static data[32];
	new len;
	
	formatex( data[ len ], sizeof( data ) - len - 1, "%s", tag );
	
	nvault_set(nVault, authid, data);
	console_print(id, "Player tagged successfully.");

	formatex(g_iUserTagName[player], 54, "[%s] %s", tag, g_iUserName[player]);
	set_bit(g_bUserHasTag, player);
	
	return PLUGIN_HANDLED;
}
public set_tag_player(id, szTag[]) {
	formatex(g_iUserTagName[id], 54, "[%s] %s", szTag, g_iUserName[id]);
	set_bit(g_bUserHasTagDay, id);
}
public remove_tag_player(id) {
	clear_bit(g_bUserHasTagDay, id);
}
public untag_player(id, level, cid) {
	if(!cmd_access(id, level, cid, 2)) 
		return PLUGIN_HANDLED;
	
	new name[32]; read_argv(1, name, charsmax(name));
	new player = cmd_target(id, name, CMDTARGET_ALLOW_SELF);
	
	if(!player)	
		return PLUGIN_HANDLED;
	
	new authid[32]; get_user_authid(player, authid, charsmax(authid));
	static data[256], timestamp;
	new success = nvault_lookup(nVault, authid, data, sizeof( data ) - 1, timestamp );
	
	if(success) {
		console_print(id, "Tag removed from the specified player.");
		nvault_remove(nVault, authid);
	}
	else
		console_print(id, "That player has no flag attached.");
		
	formatex(g_iUserTagName[player], 54, "%s", g_iUserName[player]);
	clear_bit(g_bUserHasTag, player);
	
	return PLUGIN_HANDLED;
}

public untag_all(id, level, cid) {
	if(!cmd_access(id, level, cid, 1)) 
		return PLUGIN_HANDLED;
	
	client_print(id, print_console, "All tags have been removed.");
	nvault_prune(nVault , 0 , get_systime());
	
	new players[32], pnum, iPlayer; 
	get_players(players, pnum);
	for( new i; i<pnum; i++ ) { 
		iPlayer = players[i]; 
		clear_bit(g_bUserHasTag, iPlayer);
	}
	
	return PLUGIN_HANDLED;
}

public ClCmd_Say(id)
{
	new Message[128];

	read_argv(1, Message, 127);
	remove_quotes(Message);
	new myAns[128];
	num_to_str(mathAnswer[id], myAns, 127);

	if( get_bit(g_bInMathProblem, id) && is_str_num(Message))
	{
		new szName[32]; get_user_name(id, szName, charsmax(szName));
		if (equali(Message, myAns))
		{
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M90");
			set_user_rendering(id, _, 0, 0, 0, _, 0);
			// Unfreeze player if it's frozen
			//static Flags; Flags = entity_get_int( id, EV_INT_flags );
			//entity_set_int( id, EV_INT_flags, Flags &~ FL_FROZEN );

			if (task_exists(id + TASK_MATH))
				remove_task(id + TASK_MATH);
				
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M91", szName);
			clear_bit(g_bInMathProblem, id);
		}
		else {
			new Health = get_user_health(id);
			new hp;

			if (Health <= DMG_MATHQ)
			{
				if (Health == 1) {
					fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M92");
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M93", '^3', szName, '^1', '^4', '^1');
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M94");
					//static Flags; Flags = entity_get_int( id, EV_INT_flags );
					//entity_set_int( id, EV_INT_flags, Flags &~ FL_FROZEN );
					clear_bit(g_bInMathProblem, id);
					set_user_rendering(id,kRenderFxGlowShell,255,255,0,kRenderNormal,16);
					return PLUGIN_HANDLED;
				} 
				else hp = 1;
			} 
			else hp = Health - DMG_MATHQ;

			set_user_health(id, hp);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M95", Health - hp);
		}
		return PLUGIN_HANDLED;
	}
	return PLUGIN_CONTINUE;
}

public MathMenu(id) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
		
	if(!get_bit(g_bIsSimon, id)) 
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M96");
		return PLUGIN_HANDLED;
	}
	
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M97");
		return PLUGIN_HANDLED;
	}

	new szText[256];
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_MATH_TITLE");
	new menu = menu_create(szText, "sub_mathmenu");
	
	new players[32], pnum, tempid; 
	new szName[32], szTempid[10]; 
	
	get_players(players, pnum, "ae", "TERRORIST"); 
	
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_MATH_M1");
	menu_additem(menu, szText, "1", 0);
	
	for( new i; i<pnum; i++ ) { 
		tempid = players[i]; 
		
		if(get_bit(g_bInMathProblem, tempid) || get_bit(g_bHasFreeday, tempid)) 
			continue;
		get_user_name(tempid, szName, charsmax(szName)); 
		num_to_str(tempid, szTempid, 9); 
		menu_additem(menu, szName, szTempid, 0); 
	} 
	
	menu_display(id, menu); 
	return PLUGIN_HANDLED; 
}

public sub_mathmenu(id, menu, item) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if( item == MENU_EXIT || !get_bit(g_bIsSimon, id) || g_bInLr ) { 
		menu_destroy(menu); 
		return PLUGIN_HANDLED; 
	}
	
	new data[6], name[64]; 
	new access, callback; 
	menu_item_getinfo(menu, item, access, data, charsmax(data), name, charsmax(name), callback); 
	
	new tempid = str_to_num(data); 
	
	new szName[32], szName2[32]; 
	get_user_name(id, szName, charsmax(szName)); 
	get_user_name(tempid, szName2, charsmax(szName2));
	if(tempid == 1) {
		new players[32], pnum, iPlayer; 
		get_players(players, pnum, "ae", "TERRORIST");
		for( new i; i<pnum; i++ ) { 
			iPlayer = players[i]; 
			
			if(get_bit(g_bInMathProblem, iPlayer) || get_bit(g_bHasFreeday, iPlayer)) 
				continue;
	
			set_bit(g_bInMathProblem, iPlayer);
			ClCmd_math(iPlayer);
			fnColorPrint(iPlayer, "%L", LANG_SERVER, "JB_DAY_M98");
			//static Flags; Flags = entity_get_int(iPlayer, EV_INT_flags);
			//entity_set_int(iPlayer, EV_INT_flags, Flags | FL_FROZEN );
		} 
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M99", '^3', '^4', szName, '^1', '^4', '^1');
	}else{
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M100", '^3', '^4', szName, '^1', '^4', szName2, '^1');
		fnColorPrint(tempid, "%L", LANG_SERVER, "JB_DAY_M101");
		set_bit(g_bInMathProblem, tempid);
		ClCmd_math(tempid);
		//static Flags; Flags = entity_get_int(tempid, EV_INT_flags);
		//entity_set_int(tempid, EV_INT_flags, Flags | FL_FROZEN );
	}
	menu_destroy(menu); 
	show_SimonMenu(id);
	return PLUGIN_HANDLED; 
}  

public ClCmd_points(id)
{
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M102", '^4', g_iPoints[id], '^1');
	//g_iPoints[id] += 500;
}
	
public ClCmd_boxmatch(id)
{
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M103");
		return PLUGIN_HANDLED;
	}
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M104");
		return PLUGIN_HANDLED;
	}
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	/*
	// Not a terrorist
	if (get_user_team(id) == 1)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}*/
	// Not a counter-terrorist
	if (!access(id, ADMIN_BOXDAY))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}
	new szName[32]; get_user_name(id, szName, charsmax(szName));
	new players[32], pnum, iPlayer; 
	get_players(players, pnum, "a");
	
	if(g_bBoxMatch)
	{
		g_bBoxMatch = false;
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M106", '^3', szName, '^1', '^4', '^1');
		for( new i; i<pnum; i++ ) { 
			
			iPlayer = players[i]; 
			cs_reset_user_weapon(iPlayer);
		}
	}
	else
	{
		g_bBoxMatch = true;
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M107", '^3', szName, '^1', '^4', '^1');
		for( new i; i<pnum; i++ ) { 
			
			iPlayer = players[i]; 
			cs_reset_user_weapon(iPlayer);
		}

	}
	return PLUGIN_HANDLED;
}

public CmdFreeForAll(id)
{
	if(g_iDay[ TOTAL_DAYS ] != DAY_NONE)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M103");
		return PLUGIN_HANDLED;
	}
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M104");
		return PLUGIN_HANDLED;
	}
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	if (!access(id, ADMIN_FREEFORALL))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}
	show_ffamenu(id);
	return PLUGIN_HANDLED;
}

public show_ffamenu(id)
{
	new szText[256];
	formatex(szText, charsmax(szText), "%s^n Free For All", g_szPluginPrefix);
	new ffamenu = menu_create(szText, "sub_ffamenu");
	
	menu_additem(ffamenu, "Box-Match", "1");
	menu_additem(ffamenu, "Snowball War", "2");
	menu_additem(ffamenu, "Gun-Game", "3");
	
	menu_setprop(ffamenu, MPROP_EXIT , MEXIT_NORMAL);
	menu_display(id, ffamenu, 0);
}

public sub_ffamenu(id, ffamenu, item)  
{
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
		
	if (item == MENU_EXIT || cs_get_user_team(id) == CS_TEAM_T)
	{
		menu_destroy(simonmenu);
		return PLUGIN_HANDLED;
	}
	
	if (!get_bit(g_bIsAlive, id) || g_iDay[ TOTAL_DAYS ] != DAY_NONE || g_bInLr)
	{
		menu_destroy(ffamenu);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(ffamenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new Key = str_to_num(data);
	new szName[32]; get_user_name(id, szName, charsmax(szName));
	new players[32], pnum, iPlayer; 
	get_players(players, pnum, "a");
	switch (Key)
	{
		case 1:
		{
			if(g_bSnowballWar || g_bGunGame)
			{
				fnColorPrint(0, "Sorry! %s is enabled", g_bGunGame ? "Gun-Game" : "Snowball War");
				return PLUGIN_HANDLED;
			}
			if(g_bBoxMatch)
			{
				g_bBoxMatch = false;
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M106", '^3', szName, '^1', '^4', '^1');
				for( new i; i<pnum; i++ ) { 
					
					iPlayer = players[i]; 
					cs_reset_user_weapon(iPlayer);
				}
			}
			else
			{
				g_bBoxMatch = true;
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M107", '^3', szName, '^1', '^4', '^1');
				for( new i; i<pnum; i++ ) { 
					
					iPlayer = players[i]; 
					cs_reset_user_weapon(iPlayer);
				}
		
			}
			//show_ffamenu(id);
		}
		case 2: 
		{
			if(g_bBoxMatch || g_bGunGame)
			{
				fnColorPrint(0, "Sorry! %s is enabled", g_bBoxMatch ? "Box-Match" : "Snowball War");
				return PLUGIN_HANDLED;
			}
			if(g_bSnowballWar)
			{
				g_bSnowballWar = false;
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M106", '^3', szName, '^1', '^4', '^1');
				for( new i; i<pnum; i++ ) { 
					
					iPlayer = players[i]; 
					if (get_user_weapon(iPlayer) == CSW_KNIFE) 
					{
						cs_reset_user_weapon(iPlayer);
					}
				}
			}
			else
			{
				g_bSnowballWar = true;
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M107", '^3', szName, '^1', '^4', '^1');
				for( new i; i<pnum; i++ ) { 
					iPlayer = players[i]; 
					if (get_user_weapon(iPlayer) == CSW_KNIFE) 
					{
						cs_reset_user_weapon(iPlayer);
					}
					GiveItem2(iPlayer, CSW_SMOKEGRENADE, -1, 1);
				}
		
			}
			//show_ffamenu(id);
		}
		case 3: 
		{
			if(g_bBoxMatch || g_bSnowballWar)
			{
				fnColorPrint(0, "Sorry! %s is enabled", g_bBoxMatch ? "Box-Match" : "Gun-Game");
				return PLUGIN_HANDLED;
			}
			if(g_bGunGame)
			{
				g_bGunGame = false;
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M106", '^3', szName, '^1', '^4', '^1');
				for( new i; i<pnum; i++ ) { 
					
					iPlayer = players[i]; 
					if (get_user_weapon(iPlayer) == CSW_KNIFE) 
					{
						cs_reset_user_weapon(iPlayer);
					}
					g_iGunGameLevel[iPlayer][level] = 0;
					g_iGunGameLevelNext[iPlayer] = 0;
				}
			}
			else
			{
				g_bGunGame = true;
				fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M107", '^3', szName, '^1', '^4', '^1');
				for( new i; i<pnum; i++ ) { 
					iPlayer = players[i]; 
					if (get_user_weapon(iPlayer) == CSW_KNIFE) 
					{
						cs_reset_user_weapon(iPlayer);
					}
					clear_bit(g_bSetFakeGodmode, iPlayer);
					g_iGunGameLevel[iPlayer][level] = 0;
					g_iGunGameLevelNext[iPlayer] = 0;
					StripPlayerWeapons(iPlayer);
					cs_set_user_armor(id, 100, CS_ARMOR_VESTHELM);
					GiveItem2(iPlayer, g_iWeaponLevel[g_iGunGameLevel[iPlayer][level]]);
				}
		
			}
			//show_ffamenu(id);
		}
	}
	menu_destroy(ffamenu);
	return PLUGIN_HANDLED;
}

cs_reset_user_weapon(iPlayer)
{
	new iWeapon = get_pdata_cbase(iPlayer, m_pActiveItem, XO_PLAYER);
	if(pev_valid(iWeapon))
		ExecuteHamB(Ham_Item_Deploy, iWeapon);
}
	
public ClCmd_closedoors(id) {
	if(g_bBufferDoors)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M108");
		return PLUGIN_HANDLED;
	}
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M104");
		return PLUGIN_HANDLED;
	}
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	// Not a counter-terrorist
	if (!access(id, ADMIN_DOORS))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}
	g_bBufferDoors = true;
	set_task(2.0, "BufferDoors");
	CloseDoors("func_door");
	CloseDoors("func_door_rotating");
	new szName[32]; get_user_name(id, szName, charsmax(szName)); 
	fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M109", '^3', szName, '^1', '^4', '^1');
	return PLUGIN_HANDLED;
}

public ClCmd_randomct(id) {
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M104");
		return PLUGIN_HANDLED;
	}
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	// Not a counter-terrorist
	if (!access(id, ADMIN_RANDOM_CT_SWITCH))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_NOACCESS");
		return PLUGIN_HANDLED;
	}
	
	static g_iPlayer; 
	g_iPlayer = fnGetRandomPlayer();
	new szName[32]; get_user_name(id, szName, charsmax(szName));
	new szName1[32]; get_user_name(g_iPlayer, szName1, charsmax(szName1));
	
	if(g_iPlayer > 0 && !get_bit(g_bHasFreeday, g_iPlayer) && get_user_team(g_iPlayer) == 1)
	{
		cs_set_user_team(g_iPlayer, CS_TEAM_CT);
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M110", '^3', szName, '^1', '^3', szName1, '^1', '^4', '^1'); 
	}

	return PLUGIN_HANDLED;
}

public ClCmd_opendoors(id) {
	if(g_bBufferDoors)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M108");
		return PLUGIN_HANDLED;
	}
	if(g_bInLr)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M104");
		return PLUGIN_HANDLED;
	}
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	// Not a counter-terrorist
	if (!access(id, ADMIN_DOORS))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}
	g_bBufferDoors = true;
	set_task(2.0, "BufferDoors");
	OpenDoors("func_door");
	OpenDoors("func_door_rotating");
	new szName[32]; get_user_name(id, szName, charsmax(szName)); 
	fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M111", '^3', szName, '^1', '^4', '^1');
	return PLUGIN_HANDLED;
}

public BufferDoors()
	g_bBufferDoors = false;

CloseDoors( const szClassName[] ) {
	new iEntity = find_ent_by_class(ENG_NULLENT, szClassName);
	while( is_valid_ent( iEntity ) )
	{
		dllfunc(DLLFunc_Think, iEntity);
		iEntity = find_ent_by_class(iEntity, szClassName);
		//DispatchKeyValue(iEnt,"wait",2);
	}
}
//Thanks to connor
OpenDoors( const szClassName[] ) {
	new iEntity = find_ent_by_class(ENG_NULLENT, szClassName);
	while( is_valid_ent( iEntity ) )
	{
		dllfunc( DLLFunc_Use, iEntity, 0 );
		iEntity = find_ent_by_class(iEntity, szClassName);
		//DispatchKeyValue(iEnt,"wait",0);
	}
}

public ClCmd_channel(id)
{
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
		
	fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M112", '^3',  g_iSpeakNames[ fm_get_speak(id) ] );
	/*
	if (get_user_team(id) != 2 && !access(id, ADMIN_MIC))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}
	if(!access(id, ADMIN_MIC))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_NOACCESS");
		return PLUGIN_HANDLED;
	}*/
	Show_MicMenu(id, iPage);
	return PLUGIN_HANDLED;
}

public Show_MicMenu(id, iPage) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	
	new szText[256];
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_MIC_TITLE");
	new menu = menu_create(szText, "sub_channelmenu");
	
	new players[32], pnum, tempid; 
	new szName[32], szTempid[10];
	new szOption[128];
	get_players(players, pnum); 
	
	for( new i; i<pnum; i++ ) { 
		tempid = players[i]; 
		fm_get_speak(tempid);
		get_user_name(tempid, szName, charsmax(szName)); 
		num_to_str(tempid, szTempid, 9);
		formatex(szOption, 127, "%L", LANG_SERVER, "JB_MIC_M1", szName, g_iSpeakNames[ fm_get_speak(tempid) ] );
		menu_additem(menu, szOption, szTempid);
	} 
	
	menu_display(id, menu, iPage); 
	return PLUGIN_HANDLED; 
}

public sub_channelmenu(id, menu, item) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if( item == MENU_EXIT ) { 
		menu_destroy(menu); 
		return PLUGIN_HANDLED; 
	}
	
	if (get_user_team(id) != 2 && !access(id, ADMIN_MIC))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M105");
		return PLUGIN_HANDLED;
	}
	if(!access(id, ADMIN_MIC))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_NOACCESS");
		return PLUGIN_HANDLED;
	}
	
	new data[6], name[64]; 
	new access, callback; 
	menu_item_getinfo(menu, item, access, data, charsmax(data), name, charsmax(name), callback); 
	
	new tempid = str_to_num(data); 
	
	new szName[32], szName2[32]; 
	get_user_name(id, szName, charsmax(szName)); 
	get_user_name(tempid, szName2, charsmax(szName2));
	
	switch( fm_get_speak(tempid) )
	{
		case 1: fm_set_speak(tempid, 2);
		case 2: fm_set_speak(tempid, 3);
		case 3: fm_set_speak(tempid, 4);
		case 4: fm_set_speak(tempid, 1);
	}

	if( id != tempid )
		fnColorPrint(tempid, "%L", LANG_SERVER, "JB_DAY_M113", '^3', szName, '^1', '^4', g_iSpeakNames[ fm_get_speak(tempid) ], '^1');

	player_menu_info(id, menu, menu, iPage); 
	Show_MicMenu(id, iPage);
	return PLUGIN_HANDLED; 
}  

public ClCmd_LastRequest(id)
{
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
	// Not a terrorist
	if (get_user_team(id) != 1)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M114");
		return PLUGIN_HANDLED;
	}
	
	// Not alive
	if (!get_bit(g_bIsAlive, id))
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
		
	// More than 1 terrorist
	if (fnGetTerrorists() > 1)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M115");
		return PLUGIN_HANDLED;
	}
	
	// Less than 1 Counter-terrorist
	if (fnGetCounterTerrorists() < 1)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M116");
		return PLUGIN_HANDLED;
	}
	
	// Is he the last one?	
	if (get_bit(g_bIsLast, id))
	{
		// Check if there's a game
		if (g_iGameType)
		{
			// There's a battle in progress
			if (fnGetChosen())
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M117");
				return PLUGIN_HANDLED;
			}
			else if (g_iGameType == 10)
			{
				fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M117");
				return PLUGIN_HANDLED;
			}
		}
	}
	
	// He's the last terrorist, open menu!
	Show_LastRequestMenu(id);
	
	return PLUGIN_HANDLED;
}		

public Task_StartRing(id)
{
	// id = id - TASK_BEAM = id
	id -= TASK_BEAM;
	
	// Avoid the task call if the user died
	if (!get_bit(g_bIsConnected, id) || !get_bit(g_bIsAlive, id))
	{
		remove_task(id+TASK_BEAM);
		return;
	}
	
	// Set the beam
	fnSetRing(id);
}

public Task_SimonStartRing(id)
{
	// id = id - TASK_BEAM = id
	id -= TASK_SIMONBEAM;
	
	// Avoid the task call if the user died
	if (!get_bit(g_bIsConnected, id) || !get_bit(g_bIsAlive, id) || !get_bit(g_bIsSimon, id) || g_bInLr)
	{
		remove_task(id+TASK_SIMONBEAM);
		return;
	}

	// Set the beam
	fnSetSimonRing(id);
}
#define LastRequest 9
new const g_iLastRequestNames[LastRequest][] = {
	"JB_LASTREQUEST_M1", 
	"JB_LASTREQUEST_M2",
	"JB_LASTREQUEST_M3", 
	"JB_LASTREQUEST_M4",
	"JB_LASTREQUEST_M5", 
	"JB_LASTREQUEST_M6",
	"JB_LASTREQUEST_M7", 
	"JB_LASTREQUEST_M8",
	"JB_LASTREQUEST_M9"
};

/*================================================================================
 [Lr Menu]
=================================================================================*/
Show_LastRequestMenu(id)
{
	new alivenumm = fnGetCounterTerrorists();
	// Avoid Round End Last Request
	if (g_iBlockLastRequest)
	{
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M118");
		return PLUGIN_HANDLED;
	}
	
	if(g_bBoxMatch || g_bSnowballWar || g_bGunGame)
	{
		new players[32], pnum, iPlayer; 
		get_players(players, pnum, "a");
		g_bBoxMatch = false;
		g_bSnowballWar = false;
		g_bGunGame = false;
		fnColorPrint(0, "Free for all has been disable do to last request.");
		for( new i; i<pnum; i++ ) { 
			
			iPlayer = players[i]; 
			cs_reset_user_weapon(iPlayer);
		}
	}
	
	g_bInLr = true;
	set_bit(g_bHasMenuOpen, id);
	set_bit(g_bIsLast, id);
	fm_set_speak(id, SPEAK_ALL);

	new szText[256];
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_LASTREQUEST_TITLE");
	new rMenu = menu_create(szText, "LastRequestHandler");
	new iNumber[5], szOption[40];
	
	for( new i = 0; i < LastRequest; i++ ) {
		num_to_str(i+1, iNumber, 4);
		formatex(szOption, 39, "%L", LANG_SERVER, g_iLastRequestNames[i]);
		menu_additem(rMenu, szOption, iNumber);
	}

	if (alivenumm >= NUMBER_OF_GUARDS)
	{
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_LASTREQUEST_M10");
		menu_additem(rMenu, szText, "10", 0);
	}
	else {
		formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_LASTREQUEST_M10");
		menu_additem(rMenu, szText, "10", ADMIN_IMMUNITY);
	}

	menu_setprop(rMenu, MPROP_EXIT, MEXIT_ALL);
	menu_display(id, rMenu, 0);
	
	return PLUGIN_CONTINUE;
}

Show_PlayersMenu(id)
{
	new Pos[3], szName[32], Title[96];
	formatex(Title, charsmax(Title), "%L", LANG_SERVER, "JB_LASTREQUEST_SUB", LANG_SERVER, fnGetGameType());
	
	new pMenu = menu_create(Title, "PlayersHandler");
	if (g_iGameType == 10 )
	{
		formatex(Title, charsmax(Title), "%L", LANG_SERVER, "JB_LASTREQUEST_SUB_M1");
		menu_additem(pMenu, Title, "1", 0);
	}
	else if ( g_iGameType == 7 )
	{
		formatex(Title, charsmax(Title), "Sonic-Boom");
		menu_additem(pMenu, Title, "1", 0);
	}
	else
	{
		static iPlayers[32], iNum, i, iPlayer;
		get_players( iPlayers, iNum, "ae", "CT" ); 
		for ( i=0; i<iNum; i++ ) 
		{
			iPlayer = iPlayers[i];
			// Add them to the menu
			num_to_str(iPlayer, Pos, charsmax(Pos));
			get_user_name(iPlayer, szName, charsmax(szName));
		
			menu_additem(pMenu, szName, Pos);
			
		}
	}
	menu_setprop(pMenu, MPROP_EXIT, MEXIT_NEVER);
	menu_display(id, pMenu, 0);
}
	
public LastRequestHandler(id, rMenu, item)
{
	if (item == MENU_EXIT || !get_bit(g_bHasMenuOpen, id)) {
		menu_destroy(rMenu);
		return PLUGIN_HANDLED;
	}
	
	new name[64], data[6];
	new access, callback;
	menu_item_getinfo(rMenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new szKey = str_to_num(data);
	
	// Show CT's Menu + Set the gametype to the key chosen
	g_iGameType = szKey;
	Show_PlayersMenu(id);
	
	return PLUGIN_HANDLED;
}

#define Rebel 4
new const g_iRebelNames[Rebel][] = {
	"JB_REBEL_M1", 
	"JB_REBEL_M2",
	"JB_REBEL_M3", 
	"JB_REBEL_M4"
};

#define S4S 9
new const g_iS4SNames[S4S][] = {
	"JB_S4S_M1", //JB_S4S_M1 == random weapon
	"JB_S4S_M2",
	"JB_S4S_M3", 
	"JB_S4S_M4",
	"JB_S4S_M5", 
	"JB_S4S_M6",
	"JB_S4S_M7", 
	"JB_S4S_M8",
	"JB_S4S_M9"
};

#define WEAPON_TOSS 4
new const g_iWeaponTossNames[WEAPON_TOSS][] = {
	"JB_S4S_M1", //JB_S4S_M1 == random weapon
	"JB_WEAPONTOSS_M2", // Grenage
	"JB_S4S_M3", //JB_S4S_M3 == Deagle
	"JB_S4S_M5" //JB_S4S_M5 == M4A1
};

public PlayersHandler(id, pMenu, item) {
	if(!get_bit(g_bIsConnected, id))
		return PLUGIN_HANDLED;
	if (item == MENU_EXIT || !get_bit(g_bHasMenuOpen, id)) {
		menu_destroy(pMenu);
		return PLUGIN_HANDLED;
	}
	
	// Avoid Round End Last Request
	if (g_iBlockLastRequest)
	{
		menu_destroy(pMenu);
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M118");
		return PLUGIN_HANDLED;
	}
	
	// Not a terrorist
	if (get_user_team(id) != 1)
		return PLUGIN_HANDLED;
	
	// Not alive
	if (!get_bit(g_bIsAlive, id))
		return PLUGIN_HANDLED;
		
	// More than 1 terrorist
	if (fnGetTerrorists() > 1)
		return PLUGIN_HANDLED;
	
	if(get_bit(g_bIsAlive, id)) {
		if(g_iGameType == 10) {
	
			clear_bit(g_bHasMenuOpen, id);
			
			new szText[256];
			formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_REBEL_TITLE");
			new rebelingmenu = menu_create(szText, "sub_rebelmenu");
			new iNumber[5], szOption[40];
			for( new i = 0; i < Rebel; i++ ) {
				num_to_str(i+1, iNumber, 4);
				formatex(szOption, 39, "%L", LANG_SERVER, g_iRebelNames[i]);
				menu_additem(rebelingmenu, szOption, iNumber);
			}
			menu_setprop(rebelingmenu, MPROP_EXIT, MEXIT_NEVER);
			menu_display(id, rebelingmenu, 0);
		}
		else {
			
			new cName[32], Name[64], Data[6];
			new Access, Callback;
			menu_item_getinfo(pMenu, item, Access, Data, charsmax(Data), Name, charsmax(Name), Callback);
			get_user_name(id, cName, charsmax(cName));
		
			clear_bit(g_bHasMenuOpen, id);
			
			g_iFinalCT = str_to_num(Data);

			// Start the battle
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M119", cName, '^4', LANG_SERVER, fnGetGameType(), '^1', '^4', Name);
			set_user_footsteps(id, 0);
			set_pev(id, pev_maxspeed, 250.0);
			// Make the rings
			set_task(3.0, "Task_StartRing", g_iFinalCT+TASK_BEAM, _, _, "b");
		
			// Avoid the task twice for the last terrorist
			if (!task_exists(id+TASK_BEAM))
				set_task(3.0, "Task_StartRing", id+TASK_BEAM, _, _, "b");
		
			// Reset health
			set_user_health(g_iFinalCT, 100);
			set_user_health(id, 100);	
			clear_bit(g_bHasCrowbar, id);	
			// Strip Weapons
			g_iGetUserWeapon = CSW_KNIFE;
			StripPlayerWeapons(id);
			StripPlayerWeapons(g_iFinalCT);
			
			cs_reset_user_weapon(id);
			g_iFinalT = id;
			// GameType = Key = Game
			switch (g_iGameType) 
			{
				case 1: {
					// No ideas here..
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M120");
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M121");
					server_cmd("sv_gravity 800");
				}
				case 2: {
					new szText[256];
					formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_S4S_TITLE");
					new Shot4Shot = menu_create(szText, "Shot4Shot_submenu");
					
					// Give random weapon for Shot4Shot
					new iNumber[5], szOption[40];
					for( new i = 0; i < S4S; i++ ) {
						num_to_str(i+1, iNumber, 4);
						formatex(szOption, 39, "%L", LANG_SERVER, g_iS4SNames[i]);
						menu_additem(Shot4Shot, szOption, iNumber);
					}

					menu_setprop(Shot4Shot,MPROP_EXIT, MEXIT_NEVER);
					menu_display(id, Shot4Shot, 0);
					
					server_cmd("sv_gravity 800");
				}
			
				case 3: {	
					new szText[128];
					formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_RACE_TITLE");
					new race = menu_create(szText, "race_submenu");
					formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_RACE_M1", RACE_TIMER);
					menu_additem(race, szText, "1", 0);
					menu_setprop(race,MPROP_EXIT, MEXIT_NEVER);
					menu_display(id, race, 0);
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M122");
					server_cmd("sv_gravity 800");
				}
			
				case 4: {
					// Give a random weapon for the gun toss
					new szText[256];
					formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_WEAPONTOSS_TITLE");
					new Weapon_Toss = menu_create(szText, "Weapon_Toss_submenu");
					
					// Give random weapon for Shot4Shot
					new iNumber[5], szOption[40];
					for( new i = 0; i < WEAPON_TOSS; i++ ) {
						num_to_str(i+1, iNumber, 4);
						formatex(szOption, 39, "%L", LANG_SERVER, g_iWeaponTossNames[i]);
						menu_additem(Weapon_Toss, szOption, iNumber);
					}
					/*
					new iNumber[5], szOption[40];
					for( new i = 0; i < S4S; i++ ) {
						num_to_str(i+1, iNumber, 4);
						formatex(szOption, 39, "%L", LANG_SERVER, g_iS4SNames[i]);
						menu_additem(Weapon_Toss, szOption, iNumber);
					}*/
		
					menu_setprop(Weapon_Toss,MPROP_EXIT, MEXIT_NEVER);
					menu_display(id, Weapon_Toss, 0);
			
					// Empty clip ammo
					//set_pdata_int(Ent, OFFSET_CLIPAMMO, 0, OFFSET_LINUX)
					//set_pdata_int(Ent2, OFFSET_CLIPAMMO, 0, OFFSET_LINUX)
					server_cmd("sv_gravity 800");
				}
			
				case 5: {
					// No ideas here..
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M123");
					server_cmd("sv_gravity 800");
				}
			
				case 6: {
					set_user_armor(id ,100);
					set_user_armor(g_iFinalCT ,100);
					GiveItem(id, "weapon_hegrenade", 1);
					GiveItem(g_iFinalCT, "weapon_hegrenade", 1);
					fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M124");
					server_cmd("sv_gravity 800");
				}
				
				case 7: {
					explode_me(id);
					server_cmd("sv_gravity 800");
				}
				case 8: {
					GiveItem(id, "weapon_m3", 100);
					GiveItem(g_iFinalCT, "weapon_m3", 100);
					set_user_health(g_iFinalCT, 500);
					set_user_health(id, 500);
					set_user_armor(id ,100);
					set_user_armor(g_iFinalCT ,100);
					server_cmd("sv_gravity 800");
				}
				case 9: {
					g_bHeadshotEnabled = false;
					
					new szText[128];
					formatex(szText, charsmax(szText), "\yHead Shot only?");
					new scoutdual = menu_create(szText, "scoutdaul_submenu");
					menu_additem(scoutdual, "Yes", "1", 0);
					menu_additem(scoutdual, "No", "2", 0);
					menu_setprop(scoutdual,MPROP_EXIT, MEXIT_NEVER);
					menu_display(id, scoutdual, 0);
					/*
					GiveItem(id, "weapon_scout", 100);
					GiveItem(g_iFinalCT, "weapon_scout", 100);
					set_user_armor(id ,100);
					set_user_armor(g_iFinalCT ,100);
					server_cmd("sv_gravity %d", SCOUTDUAL_GRAVITY);	*/
				}
			}
			set_bit(g_bIsChosen, g_iFinalCT);
		}
		//g_bInLr = true; TEST
		clear_bit(g_bHasCrowbar, id);
	}
	return PLUGIN_HANDLED;
}

public sub_rebelmenu(id, rebelingmenu, item)
{
	if (item == MENU_EXIT)
	{
		menu_destroy(rebelingmenu);
		return PLUGIN_HANDLED;
	}
	if(!g_bInLr)
	{
		menu_destroy(rebelingmenu);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(rebelingmenu, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new Key = str_to_num(data);
	
	StripPlayerWeapons(id);
	new g_AliveCT = fnGetCounterTerrorists();
	switch (Key)
	{
		case 1:
		{
			// Start the battle
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M125");
			StripPlayerWeapons(id);
			
			iRandom = random( sizeof(g_szWeaponList1) );
			GiveItem(id, g_szWeaponList1[iRandom], 600);
			
			set_user_health(id, g_AliveCT * g_100HP + g_100HP );
			set_user_armor(id, 100);
			set_user_footsteps(id, 0);
			set_pev(id, pev_maxspeed, 250.0);
		}
		
		case 2: 
		{
			StripPlayerWeapons(id);
			set_user_health(id, g_AliveCT * g_100HP + g_100HP );
			GiveItem(id, "weapon_deagle", 35);
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M126");
		}
		
		case 3: 
		{	
			StripPlayerWeapons(id);
			set_user_health(id, 1);
			GiveItem(id, "weapon_ak47", 200);
			set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderTransAlpha, 15);
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M127");
		}
		
		case 4: 
		{
			StripPlayerWeapons(id);
			set_user_health(id, g_AliveCT * g_100HP + g_100HP );
			GiveItem(id, "weapon_glock18", 200);
			set_user_rendering(id, kRenderFxGlowShell, 255, 0, 0, kRenderTransAlpha, 255);
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M128");
		}
	}
	menu_destroy(rebelingmenu);
	return PLUGIN_HANDLED;
}

public Shot4Shot_submenu(id, Shot4Shot, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(Shot4Shot);
		return PLUGIN_HANDLED;
	}
	if(!g_bInLr)
	{
		menu_destroy(Shot4Shot);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(Shot4Shot, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new key = str_to_num(data);
	switch(key)
	{
		case 1: GiveRandomWeapon(id);
		case 2: 
		{
			GiveItem2(g_iFinalCT, CSW_USP, 1, 0);
			GiveItem2(id, CSW_USP, 1, 0);
		}
		case 3: 
		{
			GiveItem2(g_iFinalCT, CSW_DEAGLE, 1, 0);
			GiveItem2(id, CSW_DEAGLE, 1, 0);
		}
		case 4:
		{
			GiveItem2(g_iFinalCT, CSW_FIVESEVEN, 1, 0);
			GiveItem2(id, CSW_FIVESEVEN, 1, 0);
		}
		case 5: 
		{
			GiveItem2(g_iFinalCT, CSW_M4A1, 1, 0);
			GiveItem2(id, CSW_M4A1, 1, 0);
		}
		case 6: 
		{
			GiveItem2(g_iFinalCT, CSW_TMP, 1, 0);
			GiveItem2(id, CSW_TMP, 1, 0);
		}
		case 7: 
		{
			GiveItem2(g_iFinalCT, CSW_M249, 1, 0);
			GiveItem2(id, CSW_M249, 1, 0);
		}
		case 8: 
		{
			GiveItem2(g_iFinalCT, CSW_AWP, 1, 0);
			GiveItem2(id, CSW_AWP, 1, 0);
		}
		case 9: 
		{
			GiveItem2(g_iFinalCT, CSW_SCOUT, 1, 0);
			GiveItem2(id, CSW_SCOUT, 1, 0);
		}
	}
	
	menu_destroy( Shot4Shot );
	return PLUGIN_CONTINUE;
}

new g_iTime;
public race_submenu(id, race, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(race);
		return PLUGIN_HANDLED;
	}
	if(!g_bInLr)
	{
		menu_destroy(race);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(race, item, access, data, charsmax(data), name, charsmax(name), callback);
	new count = RACE_TIMER;
	g_iTime = RACE_TIMER+1;
	new key = str_to_num(data);
	switch(key)
	{
		case 1: set_task(1.0, "TaskStartTimer", TASK_TIMER, _, _, "a", count+2);
	}
	menu_destroy( race );
	return PLUGIN_CONTINUE;
}

public scoutdaul_submenu(id, scoutdaul, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(scoutdaul);
		return PLUGIN_HANDLED;
	}
	if(!g_bInLr)
	{
		menu_destroy(scoutdaul);
		return PLUGIN_HANDLED;
	}
	//g_bHeadshotEnabled = false;
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(scoutdaul, item, access, data, charsmax(data), name, charsmax(name), callback);
	new key = str_to_num(data);
	switch(key)
	{
		case 1:
		{
			g_bHeadshotEnabled = true;
			fnColorPrint(id, "Headshot only enabled!");
			fnColorPrint(g_iFinalCT, "Headshot only enabled!");
		}
		case 2:
		{
			g_bHeadshotEnabled = false;
			fnColorPrint(id, "Headshot only disabled!");
			fnColorPrint(g_iFinalCT, "Headshot only disabled!");
		}
	}
	
	GiveItem(id, "weapon_scout", 100);
	GiveItem(g_iFinalCT, "weapon_scout", 100);
	set_user_armor(id ,100);
	set_user_armor(g_iFinalCT ,100);
	server_cmd("sv_gravity %d", SCOUTDUAL_GRAVITY);
	
	menu_destroy( scoutdaul );
	return PLUGIN_CONTINUE;
}

public TaskStartTimer(count) {
	switch(g_iTime--)
	{
		case 0:
		{
			client_cmd(0, "spk ^"sound/radio/com_go.wav^"");
			set_hudmessage(0, 255, 0, -1.0, -1.0, 1);
			show_hudmessage(0, "%L", LANG_SERVER, "JB_DAY_M27");
		}
		case 1..21:
		{
			new szTime[20];
			num_to_word(g_iTime, szTime, charsmax(szTime));
			client_cmd(0, "spk ^"fvox/%s.wav^"", szTime);
			set_hudmessage(255, 0, 0, -1.0, -1.0, 1);
			show_hudmessage(0, "%L", LANG_SERVER, "JB_DAY_M173", g_iTime);
		}
	}
}
new bool:distance_checkway;
public Weapon_Toss_submenu(id, Weapon_Toss, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(Weapon_Toss);
		return PLUGIN_HANDLED;
	}
	if(!g_bInLr)
	{
		menu_destroy(Weapon_Toss);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(Weapon_Toss, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new key = str_to_num(data);
	
	switch(key)
	{
		case 1: GiveRandomWeapon(id);
		case 2:
		{
			give_item(g_iFinalCT, "weapon_hegrenade");
			give_item(id, "weapon_hegrenade");
		}
		case 3:
		{
			GiveItem2(g_iFinalCT, CSW_DEAGLE, 0, 0);
			GiveItem2(id, CSW_DEAGLE, 0, 0);
		}
		case 4:
		{
			GiveItem2(g_iFinalCT, CSW_M4A1, 0, 0);
			GiveItem2(id, CSW_M4A1, 0, 0);
		}
	}
	
	new szText[128];
	formatex(szText, charsmax(szText), "\rWeapon Toss:\y Options");
	new weapontossO = menu_create(szText, "weapontossO_submenu");
	menu_additem(weapontossO, "Check distance old way (by Sight)", "1", 0);
	menu_additem(weapontossO, "Check distance new way (by Measurement)", "2", 0);
	menu_setprop(weapontossO,MPROP_EXIT, MEXIT_NEVER);
	menu_display(id, weapontossO, 0);
	
	menu_destroy( Weapon_Toss );
	distance_checkway = false;
	return PLUGIN_CONTINUE;
}

public weapontossO_submenu(id, Weapon_Toss, item)
{
	if(item == MENU_EXIT)
	{
		menu_destroy(Weapon_Toss);
		return PLUGIN_HANDLED;
	}
	if(!g_bInLr)
	{
		menu_destroy(Weapon_Toss);
		return PLUGIN_HANDLED;
	}
	
	new data[7], name[64];
	new access, callback;
	menu_item_getinfo(Weapon_Toss, item, access, data, charsmax(data), name, charsmax(name), callback);
	
	new key = str_to_num(data);
	switch(key)
	{
		case 1: distance_checkway = false;
		case 2:	distance_checkway = true;
	}
	return PLUGIN_CONTINUE;
}

public GiveRandomWeapon(id)
{
	iRandom = random( sizeof(szWeapons2) );
	
	if(g_iGameType == 4)
	{
		GiveItem2(g_iFinalCT, get_weaponid(szWeapons2[iRandom]), 0, 0);
		GiveItem2(id, get_weaponid(szWeapons2[iRandom]), 0, 0);  
	}else{
		GiveItem2(g_iFinalCT, get_weaponid(szWeapons2[iRandom]), 1, 0);
		GiveItem2(id, get_weaponid(szWeapons2[iRandom]), 1, 0);  
	}
}

new Float: droporigin[3];

#define MSG_TYPE_ALONE MSG_ONE // default: (uncommented)
//#define MSG_TYPE_ALONE MSG_ONE_UNRELIABLE // default: (commented)
#define MSG_TYPE_ALL MSG_ALL // default: (uncommented)
//#define MSG_TYPE_ALL MSG_BROADCAST // default: (commented)

public grenade_throw(id, iGrenId, iWeaponType)
{
	if(get_bit(g_bIsLast, id) || get_bit(g_bIsChosen, id) && g_iGameType == 4 && distance_checkway)
	{
		entity_get_vector(id, EV_VEC_origin, throworigin);
	}
	if(g_bSnowballWar)
	{
		message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
		write_byte(TE_BEAMFOLLOW);
		write_short(iGrenId);
		write_short(g_iSpriteLine);
		write_byte(10);
		write_byte(5);
		write_byte(0);
		write_byte(25);
		write_byte(25);
		write_byte(200);
		message_end();
	}
}

public ShowballWar_effect(Float:fOrigin[3]){
	new origin[3];
	FVecIVec(fOrigin,origin);
	
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY);
	write_byte(TE_BLOODSPRITE);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]);
	write_short(g_iSpray);
	write_short(g_iDrop);
	write_byte(255);
	write_byte(15);
	message_end();
}

public ShowballWar_chillplayer(id)
{
	set_user_rendering(id,kRenderFxGlowShell,0,206,209,kRenderNormal,25);
	g_IsChilled[id] = true;
	pev(id, pev_maxspeed, g_iMaxSpeed[id]);
	g_ChillySpeed[id] = g_iMaxSpeed[id] * 50.0 / 100.0;
	set_pev(id,pev_maxspeed,g_ChillySpeed[id]);

	message_begin(MSG_ONE,g_iMsgId_ScreenFade,_,id);
	write_short(floatround(4096.0 * 1.0));
	write_short(floatround(3072.0 * 1.0));
	write_short(0x0000);
	write_byte(0);
	write_byte(206);
	write_byte(209);
	write_byte(100);
	message_end();
	emit_sound(id, CHAN_AUTO, SnowballWarSounds[1], 1.0, ATTN_NORM, 0, PITCH_NORM);
}

public ShowballWar_unchill(id,Float:fOrigin[3])
{	
	new origin[3];
	FVecIVec(fOrigin, origin);
	set_user_rendering(id, kRenderFxGlowShell, 0, 0, 0, kRenderNormal, 25);
	set_pev(id, pev_maxspeed, g_iMaxSpeed[id]);
	g_IsChilled[id] = false;
	
	message_begin(MSG_ONE,g_iMsgId_ScreenFade,_,id);
	write_short(0);
	write_short(0);
	write_short(0x0000);
	write_byte(0);
	write_byte(0);
	write_byte(0);
	write_byte(255);
	message_end();
	
	message_begin(MSG_BROADCAST,SVC_TEMPENTITY);
	write_byte(TE_BREAKMODEL);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2] + 24);
	write_coord(16);
	write_coord(16);
	write_coord(16);
	write_coord(random_num(-50,50));
	write_coord(random_num(-50,50));
	write_coord(25);
	write_byte(10);
	write_short(g_iGlass);
	write_byte(10);
	write_byte(25);
	write_byte(0x01);
	message_end();
	
	//Emit sound
	emit_sound(id, CHAN_AUTO, SnowballWarSounds[0], 1.0, ATTN_NORM, 0, PITCH_NORM);
}

public Fwd_Entity_Think( ent )
{
	if( !g_bInLr && !pev_valid( ent ) )
		return FMRES_IGNORED;
	
	if( g_iGameType == 4 )
	{
		static owner;
		owner = pev( ent, pev_owner );
		if(get_bit(g_bIsLast, owner) || get_bit(g_bIsChosen, owner))
		{
			new hit = -1, Float:origin[3];
			// Get the origin
			pev(ent, pev_origin, origin);
			
			while ((hit = find_ent_in_sphere(hit, origin, 18.2)))
			{
				if (hit > g_iMaxPlayers)
					break;
				
				if (!get_bit(g_bIsConnected, hit) && !get_bit(g_bIsAlive, hit))
					continue;
				
				return touch_em(ent, hit);
			}
			set_pev(ent, pev_nextthink, get_gametime() + 0.1);		
			return FMRES_SUPERCEDE;
		}
	}

	return FMRES_IGNORED;
}

touch_em(ent, id)
{
	new szClassname[32];
	pev(ent, pev_model, szClassname, charsmax(szClassname));
	
	if (contain(szClassname, "w_hegrenade.mdl") != -1)
	{
		// User can have the grenade, give it to him and remove it
		if (cs_get_user_bpammo(id, CSW_HEGRENADE) < 1)
		{
			if (cs_get_user_bpammo(id, CSW_HEGRENADE) == 0)
			{
				give_item(id, "weapon_hegrenade");
			}
			else cs_set_user_bpammo(id, CSW_HEGRENADE, cs_get_user_bpammo(id, CSW_HEGRENADE) + 1);
			
			// Remove and block engine call
			remove_entity(ent);
			return PLUGIN_HANDLED;
		}		
	}
	
	// If not then we set the next think and block again the engine call
	set_pev(ent, pev_nextthink, get_gametime() + 0.1);
	return HAM_SUPERCEDE;
}

public Fwd_Model_Think(ent, const model[])
{
	if( !g_bInLr && !pev_valid(ent) )
		return FMRES_IGNORED;
		
	static id;
	id = pev( ent, pev_owner );
	
	if(!IsPlayer(id))
		return FMRES_IGNORED;
			
	//if(g_iDay[ TOTAL_DAYS ] == DAY_GRENADE)
		//set_rendering(ent,kRenderFxGlowShell,0,255,0,kRenderNormal,16);
	
	if(g_iDay[ TOTAL_DAYS ] == DAY_GRENADE 
	|| (get_bit(g_bIsLast, id) && g_iGameType == 4 || g_iGameType ==  6) 
	|| (get_bit(g_bIsChosen, id) && g_iGameType == 4 || g_iGameType ==  6))
	{
		switch(cs_get_user_team(id))
		{
			case 1:set_rendering(ent,kRenderFxGlowShell,255,0,0,kRenderNormal,16);
			case 2:set_rendering(ent,kRenderFxGlowShell,0,0,255,kRenderNormal,16);
		}
		static iRandom_1; iRandom_1 = random(256);
		static iRandom_2; iRandom_2 = random(256);
		static iRandom_3; iRandom_3 = random(256);	
		set_rendering(ent,kRenderFxGlowShell,iRandom_1,iRandom_2,iRandom_3,kRenderNormal,16);
		message_begin(MSG_TYPE_ALL, SVC_TEMPENTITY);
		write_byte(TE_BEAMFOLLOW);
		write_short(ent);
		write_short(g_iSpriteArrow);
		write_byte(15);
		write_byte(7);
		write_byte(iRandom_1);
		write_byte(iRandom_2);
		write_byte(iRandom_3);
		write_byte(191);
		message_end();
				
		message_begin(MSG_TYPE_ALL, SVC_TEMPENTITY);
		write_byte(TE_BEAMFOLLOW);
		write_short(ent);
		write_short(g_iSpriteLine);
		write_byte(15);
		write_byte(1);
		write_byte(iRandom_1);
		write_byte(iRandom_2);
		write_byte(iRandom_3);
		write_byte(191);
		message_end();
		if((get_bit(g_bIsLast, id) || get_bit(g_bIsChosen, id) && g_iGameType == 4) && distance_checkway)
		{
			if(pev_valid(ent))
				set_task( 0.1, "CheckWeapon", ent, _, _, "b" );
		}
	}
	if(g_bSnowballWar && equali(model,"models/w_smokegrenade.mdl")){
		static Float:velocity[3];
		static owner;
		owner = pev(ent,pev_owner);
		entity_set_model(ent, SnowballWarModels[2]);
		
		if(get_bit(g_bIsAlive, owner))
			cs_set_user_bpammo(owner, CSW_SMOKEGRENADE, 2);
		
		set_pev(ent, pev_dmgtime, get_gametime() + 9999.0);
		set_pev(ent, pev_gravity, 0.3);
		pev(ent, pev_velocity, velocity);
		
		velocity[0] *= 1.5;
		velocity[1] *= 1.5;
		velocity[2] *= 1.5;
		
		set_pev(ent, pev_velocity,velocity);
		return FMRES_SUPERCEDE;
	}
	if(g_iGameType == 6 && equali(model,"models/w_hegrenade.mdl")){
		static owner;
		owner = pev(ent,pev_owner);
		if(get_bit(g_bIsAlive, owner))
			cs_set_user_bpammo(owner, CSW_HEGRENADE, 2);
	}
	return FMRES_IGNORED;
}

public CheckWeapon(ent)
{
	if ( !pev_valid(ent) && !g_bInLr)
	{
		remove_task(ent);
		return FMRES_IGNORED;
	}
	if(pev_valid(ent))
	{
		static Float:Velocity[3];
		pev(ent, pev_velocity, Velocity);
		if (Velocity[0] == 0.0 && Velocity[1] == 0.0 && Velocity[2] == 0.0) 
		{
			static id;
			id = pev( ent, pev_owner );
			entity_get_vector(ent, EV_VEC_origin, droporigin);
			new Float: distance = get_distance_f(throworigin, droporigin);
			static szName[32]; get_user_name(id, szName, 31);
			if(get_bit(g_bIsAlive, id))
			{
				fnColorPrint(g_iFinalCT, "Weapon Toss:^4 %s^1 has throwed^4 %.1f units^1 from throwing position.", szName, distance);
				fnColorPrint(g_iFinalT, "Weapon Toss:^4 %s^1 has throwed^4 %.1f units^1 from throwing position.", szName, distance);
			}
			remove_task(ent);
		}
	}
	else
	{
		remove_task(ent);
	}
	
	return FMRES_IGNORED;
}

/*================================================================================
 [Suicide Bomber]
=================================================================================*/

public explode_me(id) {
	// get my origin
	new Float:explosion[3];
	pev(id, pev_origin, explosion);

	user_kill(id);   

	// create explosion
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
	write_byte(TE_EXPLOSION);
	write_coord(floatround(explosion[0]));
	write_coord(floatround(explosion[1]));
	write_coord(floatround(explosion[2]));
	write_short(explosion_sprite);
	write_byte(30);
	write_byte(30);
	write_byte(0);
	message_end();

	fm_radius_damage(id, explosion, EXPLODE_DAMAGE, EXPLODE_RADIUS, "grenade");
}

stock fm_radius_damage(id, Float:orig[3], Float:dmg , Float:rad, wpnName[]="") {
	new szClassname[33], Float:Health;
	static Ent;
	Ent = -1;
	while((Ent = engfunc(EngFunc_FindEntityInSphere, Ent, orig, rad))) {
		pev(Ent,pev_classname,szClassname,32);
		if(equali(szClassname, "player") 
		&& get_bit(g_bIsConnected, Ent) 
		&& get_bit(g_bIsAlive, Ent) )
		{
			pev(Ent, pev_health, Health);
			Health -= dmg;
			
			new szName[32], szName1[32];
			get_user_name(Ent, szName, charsmax(szName));
			get_user_name(id, szName1, charsmax(szName1));
			
			if(Health <= 0.0) 
				createKill(Ent, id, wpnName);
			else set_pev(Ent, pev_health, Health);
		}
	}             
}

// stock for create kill
stock createKill(id, attacker, weaponDescription[]) {
	new szFrags, szFrags2;
	
	if(id != attacker) {
		szFrags = get_user_frags(attacker);
		set_user_frags(attacker, szFrags + 1);
		logKill(attacker, id, weaponDescription);
		   
		//Kill the victim and block the messages
		set_msg_block(g_iMsgDeath,BLOCK_ONCE);
		set_msg_block(g_iMsgScoreInfo,BLOCK_ONCE);
		user_kill(id);
		  
		//user_kill removes a frag, this gives it back
		szFrags2 = get_user_frags(id);
		set_user_frags(id, szFrags2 + 1);
		  
		//Replaced HUD death message
		message_begin(MSG_ALL, g_iMsgDeath,{0,0,0},0);
		write_byte(attacker);
		write_byte(id);
		write_byte(0);
		write_string(weaponDescription);
		message_end();
		  
		//Update killers scorboard with new info
		message_begin(MSG_ALL, g_iMsgScoreInfo);
		write_byte(attacker);
		write_short(szFrags);
		write_short(get_user_deaths(attacker));
		write_short(0);
		write_short(get_user_team(attacker));
		message_end();
		  
		//Update victims scoreboard with correct info
		message_begin(MSG_ALL, g_iMsgScoreInfo);
		write_byte(id);
		write_short(szFrags2);
		write_short(get_user_deaths(id));
		write_short(0);
		write_short(get_user_team(id));
		message_end();
		
		new szName[32], szName1[32];
		get_user_name(id, szName, charsmax(szName));
		get_user_name(attacker, szName1, charsmax(szName1));
	}
}

// stock for log kill
stock logKill(id, victim, weaponDescription[] ) {
	new namea[32],namev[32],authida[35],authidv[35],teama[16],teamv[16];
   
	//Info On Attacker
	get_user_name(id,namea,charsmax(namea));
	get_user_team(id,teama,15);
	get_user_authid(id,authida,34);
   
	//Info On Victim
	get_user_name(victim,namev,charsmax(namev));
	get_user_team(victim,teamv,15);
	get_user_authid(victim,authidv,34);
   
	//Log This Kill
	if(id != victim)
		log_message("^"%s<%d><%s><%s>^" killed ^"%s<%d><%s><%s>^" with ^"%s^"",
		namea,get_user_userid(id),authida,teama,namev,get_user_userid(victim),authidv,teamv, weaponDescription );
	else
		log_message("^"%s<%d><%s><%s>^" committed suicide with ^"%s^"",
		namea,get_user_userid(id),authida,teama, weaponDescription );
}

/*================================================================================
 [Glow/UnGlow Menu]
=================================================================================*/
public JBGlowMenu(id) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT ) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M129");
			return PLUGIN_HANDLED;
		}
		
		if(!get_bit(g_bIsAlive, id)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
			return PLUGIN_HANDLED;
		}
	}	
	new szText[128];
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_GLOW_TITLE");
	new menu = menu_create(szText, "sub_menu");
	
	new players[32], pnum, tempid; 
	new szName[32], szTempid[10]; 
	
	set_bit(g_bHasMenuOpen, id);
	get_players(players, pnum, "ae", "TERRORIST"); 
	
	for( new i; i<pnum; i++ ) { 
		tempid = players[i]; 
		
		if(!get_bit(g_bHasFreeday, tempid)) {
			get_user_name(tempid, szName, charsmax(szName)); 
			num_to_str(tempid, szTempid, 9); 
			menu_additem(menu, szName, szTempid, 0); 
		}
	} 
	
	menu_display(id, menu); 
	return PLUGIN_HANDLED; 
}

public sub_menu(id, menu, item) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if( item == MENU_EXIT ) { 
		clear_bit(g_bHasMenuOpen, id);
		menu_destroy(menu); 
		return PLUGIN_HANDLED; 
	} 
	
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT )
			return PLUGIN_HANDLED;
		
		if(!get_bit(g_bIsAlive, id)) 
			return PLUGIN_HANDLED;
	}
	
	new data[6], name[64]; 
	new access, callback; 
	menu_item_getinfo(menu, item, access, data, charsmax(data), name, charsmax(name), callback); 
	
	new tempid = str_to_num(data); 
	new szName[32], szName2[32], szauth[32], szauth2[32]; 
	get_user_name(id, szName, charsmax(szName)); 
	get_user_name(tempid, szName2, charsmax(szName2));
	get_user_authid(id, szauth, 31);
	get_user_authid(tempid, szauth2, 31);
	
	set_user_rendering(tempid, kRenderFxGlowShell, 255, 140, 0, kRenderNormal, 20); 
	set_bit(g_bHasFreeday, tempid);
	
	set_tag_player(tempid, "Freeday");
	clear_bit(g_bHasMenuOpen, id);
	fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M130", szName, szName2);
	log_amx("%L", LANG_SERVER, "JB_DAY_M132", szName, szauth, szName2, szauth2);
	
	if(get_bit(g_bHasInvis, tempid)) {
		fnColorPrint(tempid, "%L", LANG_SERVER, "JB_DAY_M131");
		fnColorPrint(tempid, "%L", LANG_SERVER, "JB_DAY_M133");
		g_iPoints[tempid] += get_pcvar_num(cvar_pointer[cvar_invisprice]);
		cs_set_user_money(tempid, g_iPoints[tempid], 1);
		clear_bit(g_bHasInvis, tempid);
		
		return PLUGIN_HANDLED;
	}
	
	menu_destroy(menu); 
	return PLUGIN_HANDLED; 
}  

public JBUnglowMenu(id) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT ) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M134");
			return PLUGIN_HANDLED;
		}
		
		if(!get_bit(g_bIsAlive, id)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
			return PLUGIN_HANDLED;
		}
	}
	
	new szText[256];
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_UNGLOW_TITLE");
	new menu = menu_create(szText, "Unglow_sub_menu");
	
	new players[32], pnum, tempid; 
	new szName[32], szTempid[10]; 
	
	set_bit(g_bHasMenuOpen, id);
	get_players(players, pnum, "a"); 
	
	for( new i; i<pnum; i++ ) {
		tempid = players[i]; 
		
		if (get_bit(g_bHasFreeday, tempid)) { 
			get_user_name(tempid, szName, charsmax(szName)); 
			num_to_str(tempid, szTempid, 9); 
			menu_additem(menu, szName, szTempid, 0);	
		}  
	} 
	
	menu_display(id, menu); 
	return PLUGIN_HANDLED; 
}

public Unglow_sub_menu(id, menu, item) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if( item == MENU_EXIT ) { 
		clear_bit(g_bHasMenuOpen, id);
		menu_destroy(menu); 
		return PLUGIN_HANDLED; 
	} 
	
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT ) {
			return PLUGIN_HANDLED;
		}
		
		if(!get_bit(g_bIsAlive, id)) {
			return PLUGIN_HANDLED;
		}
	}
	
	new data[6], name[64]; 
	new access, callback; 
	menu_item_getinfo(menu, item, access, data, charsmax(data), name, charsmax(name), callback); 
	
	clear_bit(g_bHasMenuOpen, id);
	new tempid = str_to_num(data); 
	new szName[32], szName2[32], szauth[32], szauth2[32]; 
	get_user_name(id, szName, charsmax(szName)); 
	get_user_name(tempid, szName2, charsmax(szName2));
	get_user_authid(id, szauth, 31);
	get_user_authid(tempid, szauth2, 31);
	
	set_user_rendering(tempid);
	clear_bit(g_bHasFreeday, tempid);
	
	if(!get_bit(g_bUserHasTag, tempid))
		remove_tag_player(tempid);
	else
	{
		new szTag[32], authid[32], data;
		get_user_authid(tempid, authid, charsmax(authid));
		data = nvault_get(nVault, authid, szTag, charsmax(szTag));
		if(data)
			formatex(g_iUserTagName[tempid], 54, "[%s] %s", szTag, g_iUserName[tempid]);
	}
	
	fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M135", szName, szName2);
	log_amx("%L", LANG_SERVER, "JB_DAY_M136", szName, szauth, szName2, szauth2);
	
	menu_destroy(menu); 
	return PLUGIN_HANDLED; 
} 

public Clcmd_GlowRed(id) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT ) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M129");
			return PLUGIN_HANDLED;
		}
		
		if(!get_bit(g_bIsAlive, id)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
			return PLUGIN_HANDLED;
		}
	}
	
	new szTempClass[64];
	new player;
	
	player = GetAimingEnt(id);
	
	if(!pev_valid(player))
		return PLUGIN_HANDLED;
	
	pev(player, pev_classname, szTempClass, 63);
	
	if(equali(szTempClass, "player", 0)) {
		if(cs_get_user_team(player) == CS_TEAM_CT) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M137");
			return PLUGIN_HANDLED;
		}
		
		if(get_bit(g_bHasFreeday, player)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M138");
			return PLUGIN_HANDLED;
		}
		set_user_rendering(player,kRenderFxGlowShell,255,0,0,kRenderNormal,16);
		set_bit(g_bIsGlowing, player);
		fnColorPrint(player, "%L", LANG_SERVER, "JB_DAY_M139");
	}
	else {
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M140");
		return PLUGIN_HANDLED;
	}
	return PLUGIN_HANDLED; 
} 

public Clcmd_GlowBlue(id) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT ) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M129");
			return PLUGIN_HANDLED;
		}
		
		if(!get_bit(g_bIsAlive, id)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
			return PLUGIN_HANDLED;
		}
	}
	
	new szTempClass[64];
	new player;
	
	player = GetAimingEnt(id);
	
	if(!pev_valid(player))
		return PLUGIN_HANDLED;
	
	pev(player, pev_classname, szTempClass, 63);
	
	if(equali(szTempClass, "player", 0)) {
		if(cs_get_user_team(player) == CS_TEAM_CT) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M137");
			return PLUGIN_HANDLED;
		}
		if(get_bit(g_bHasFreeday, player)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M138");
			return PLUGIN_HANDLED;
		}
		set_user_rendering(player,kRenderFxGlowShell,0,0,255,kRenderNormal,16);
		set_bit(g_bIsGlowing, player);
		fnColorPrint(player, "%L", LANG_SERVER, "JB_DAY_M141");
	}
	else {
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M140");
		return PLUGIN_HANDLED;
	}
	return PLUGIN_HANDLED; 
} 

public Clcmd_UnglowPlayer(id) { 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if(!is_user_admin(id)) {
		if( cs_get_user_team( id ) != CS_TEAM_CT ) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M142");
			return PLUGIN_HANDLED;
		}
		if(!get_bit(g_bIsAlive, id)) {
			fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
			return PLUGIN_HANDLED;
		}
	}
	new szTempClass[64];
	new player;
	new szName[32], szName2[32], szauth[32], szauth2[32]; 
	get_user_name(id, szName, charsmax(szName)); 
	get_user_name(player, szName2, charsmax(szName2));
	get_user_authid(id, szauth, 31);
	get_user_authid(player, szauth2, 31);
	
	player = GetAimingEnt(id);
	
	if(!pev_valid(player))
		return PLUGIN_HANDLED;
	
	pev(player, pev_classname, szTempClass, 63);
	
	if(equali(szTempClass, "player", 0)) {
		if(get_bit(g_bHasFreeday, player)) {
			set_user_rendering(player, _, 0, 0, 0, _, 0);
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M143", szName, szName2);
			clear_bit(g_bHasFreeday, player);
			if(!get_bit(g_bUserHasTag, player))
				remove_tag_player(player);
			else
			{
				new szTag[32], authid[32], data;
				get_user_authid(player, authid, charsmax(authid));
				data = nvault_get(nVault, authid, szTag, charsmax(szTag));
				if(data)
					formatex(g_iUserTagName[player], 54, "[%s] %s", szTag, g_iUserName[player]);
			}
			return PLUGIN_HANDLED;
		}
		else if(get_bit(g_bIsGlowing, player)) {	
			set_user_rendering(player, _, 0, 0, 0, _, 0);
			clear_bit(g_bIsGlowing, player);
			fnColorPrint(player, "%L", LANG_SERVER, "JB_DAY_M144", szName);
		}
		
		else
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M145");
	}
	else
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M140");
	
	return PLUGIN_HANDLED; 
}

/*================================================================================
 [Class Menu]
=================================================================================*/
new const g_iClassNames[][] = {
	"JB_CLASS_M1", 
	"JB_CLASS_M2",
	"JB_CLASS_M3", 
	"JB_CLASS_M4",
	"JB_CLASS_M5", 
	"JB_CLASS_M6",
	"JB_CLASS_M7",
	"JB_CLASS_M8",
	"JB_CLASS_M9",
	"JB_CLASS_M10"
};

#define CLASS sizeof(g_iClassNames)
new const g_iAccessClass[CLASS] = {
	0, 
	0,
	0, 
	0,
	0, 
	0,
	0,
	ADMIN_CLASS,
	ADMIN_CLASS,
	ADMIN_CLASS
};

public ClassMenu(id)
{ 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	
	if( cs_get_user_team( id ) != CS_TEAM_CT ) {
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M146");
		return PLUGIN_HANDLED;
	}
	
	if(!get_bit(g_bIsAlive, id)) {
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	
	if(!g_bCanBuy) {
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M147");
		return PLUGIN_HANDLED;
	}
	set_bit(g_bHasMenuOpen, id);
	new szText[256];
	formatex(szText, charsmax(szText), "%L", LANG_SERVER, "JB_CLASS_TITLE");
	new menu = menu_create(szText, "Class_sub_menu");
	
	// Give random weapon for Shot4Shot
	new iNumber[5], szOption[40];
	for( new i = 0; i < CLASS; i++ ) {
		num_to_str(i+1, iNumber, 4);
		formatex(szOption, 39, "%L", LANG_SERVER, g_iClassNames[i]);
		menu_additem(menu, szOption, iNumber, g_iAccessClass[i]);
	}
	
	menu_display(id, menu); 
	return PLUGIN_HANDLED; 
}

public Class_sub_menu(id, menu, item) 
{ 
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if( item == MENU_EXIT || cs_get_user_team( id ) != CS_TEAM_CT) { 
		clear_bit(g_bHasMenuOpen, id);
		menu_destroy(menu);
		return PLUGIN_HANDLED; 
	}
	
	if( cs_get_user_team( id ) != CS_TEAM_CT )
		return PLUGIN_HANDLED;
	
	if(!get_bit(g_bIsAlive, id)) 
		return PLUGIN_HANDLED;
	
	if(!g_bCanBuy) 
		return PLUGIN_HANDLED;
	
	new data[6], name[64]; 
	new access, callback; 
	StripPlayerWeapons(id);
	clear_bit(g_bHasMenuOpen, id);
	menu_item_getinfo(menu, item, access, data, charsmax(data), name, charsmax(name), callback); 
	
	switch(str_to_num(data)) {
		case(1): {
			GiveItem2(id, CSW_M4A1);
			GiveItem(id, "weapon_usp", 100);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M148");
		}
		case(2): {
			GiveItem(id, "weapon_ak47", 90);
			GiveItem(id, "weapon_glock18", 120);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M149");
		}
		case(3): {
			GiveItem(id, "weapon_awp", 30);
			GiveItem(id, "weapon_deagle", 35);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M150");
		}
		case(4): {
			GiveItem(id, "weapon_ump45", 100);
			GiveItem(id, "weapon_usp", 100);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M151");
		}
		case(5): {
			GiveItem(id, "weapon_m3", 32);
			GiveItem(id, "weapon_p228", 52);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M152");
		}
		case(6): {
			GiveItem(id, "weapon_mac10", 100);
			GiveItem(id, "weapon_deagle", 1000);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M153");
		}
		case(7): {
			GiveItem(id, "weapon_aug", 90);
			GiveItem(id, "weapon_p228", 52);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M154");
		}
		case(8): {
			//cs_set_user_model(id, "vip");
			give_item(id, "weapon_shield");
			GiveItem(id, "weapon_usp", 200);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M155");
		}
		case(9): {
			//cs_set_user_model(id, "vip");
			GiveItem(id, "weapon_m249", 400);
			GiveItem(id, "weapon_elite", 100);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M156");
		}
		case(10): {
			//cs_set_user_model(id, "vip");
			GiveItem(id, "weapon_galil", 200);
			GiveItem(id, "weapon_deagle", 100);
			fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M157");
		}
	}
	set_user_armor(id, 100);
	menu_destroy(menu); 
	return PLUGIN_HANDLED; 
}  

public MsgStatusIcon(const iMsgId, const iMsgDest, const iPlayer)
{
	if(get_bit(g_bIsConnected, iPlayer) && get_bit(g_bIsAlive, iPlayer))
	{
		static szMsg[8];
		get_msg_arg_string(2, szMsg, 7);
    
		if(equal(szMsg, "buyzone"))
		{
			set_pdata_int(iPlayer, OFFSET_BUYZONE, get_pdata_int(iPlayer, OFFSET_BUYZONE) & ~(1<<0));
			return PLUGIN_HANDLED;
		}
	}
	return PLUGIN_CONTINUE;
}

/*================================================================================
 [Hud message]
=================================================================================*/
public Fwd_HudThink(const iEntity)
{
	if ( iEntity != g_iTimerEntity )
		return;
		
	static g_prisoners;
	g_prisoners = fnGetTerrorists();
	static g_guards;
	g_guards = fnGetCounterTerrorists();
	
	if( g_prisoners == 1 && g_iDay[ TOTAL_DAYS ] != DAY_NONE )
	{
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M158");
		Day_Ends( );
	}
	if( g_guards < 1 && g_iDay[ TOTAL_DAYS ] != DAY_NONE )
	{
		fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M159");
		Day_Ends( );
	}
	
	if( g_iDay[ TOTAL_DAYS ] == DAY_GANG )
	{
		set_hudmessage(255, 0, 0, 0.0, 0.50, 0, 0.75, 0.75, 0.75, 0.75, 3);
		show_hudmessage(0, "Red Gang Members %d", check_redteam);
		set_hudmessage(0, 0, 255, 0.0, 0.60, 0, 0.75, 0.75, 0.75, 0.75, 1);
		show_hudmessage(0, "Blue Gang Members %d", check_blueteam);
	}	
	
	if(g_iDay[ TOTAL_DAYS ] == DAY_USPNINJAS)
	{
		static iPlayers[32], iNum, i, iPlayer;
		get_players( iPlayers, iNum, "ae", "TERRORIST"  ); 
		for( i=0; i<iNum; i++ )
		{
			iPlayer = iPlayers[i];
			if(!is_user_outside(iPlayer))
				continue;
			
			user_slap(iPlayer, 5);
			new origin[3];
			get_user_origin(iPlayer, origin);
			blood_effects(origin);
			UTIL_ScreenFade1(iPlayer, 2.0, 4.0);
		}
	}

	
	set_hudmessage(0, 255, 0, -1.0, 0.01, 0, 0.75, 0.75, 0.75, 0.75, 2);
	
	if( g_iDay[ TOTAL_DAYS ] != DAY_NONE && !g_iAreWeInaVote )
		show_hudmessage(0,"%L", LANG_SERVER, "JB_HUD_M1", g_prisoners, g_guards, LANG_SERVER, g_iStartDayNames[ g_iDay[ TOTAL_DAYS ] ]);
	else show_hudmessage(0,"%L", LANG_SERVER, "JB_HUD_M2", g_prisoners, g_guards);
	
	entity_set_float( g_iTimerEntity, EV_FL_nextthink, get_gametime() + 1.0 );
} 

stock blood_effects(origin[3])
{
	message_begin(MSG_PVS, SVC_TEMPENTITY, origin);
	write_byte(TE_BLOODSPRITE);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]+20);
	write_short(g_iSpray);
	write_short(g_iDrop);
	write_byte(248);
	write_byte(30);
	message_end();
	
	message_begin(MSG_PVS, SVC_TEMPENTITY, origin);
	write_byte(TE_BLOODSTREAM);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]+30);
	write_coord(random_num(-20, 20));
	write_coord(random_num(-20, 20));
	write_coord(random_num(50, 300));
	write_byte(70);
	write_byte(random_num(100, 200));
	message_end();
	
	message_begin(MSG_PVS, SVC_TEMPENTITY, origin);
	write_byte(TE_PARTICLEBURST);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]);
	write_short(50);
	write_byte(70);
	write_byte(3);
	message_end();
	
	message_begin(MSG_PVS, SVC_TEMPENTITY, origin);
	write_byte(TE_BLOODSTREAM);
	write_coord(origin[0]);
	write_coord(origin[1]);
	write_coord(origin[2]+10);
	write_coord(random_num(-360, 360));
	write_coord(random_num(-360, 360));
	write_coord(-10);
	write_byte(70);
	write_byte(random_num(50, 100));
	message_end();
}

stock Float:is_user_outside(id)
{
	new Float:vOrigin[3], Float:fDist;
	pev(id, pev_origin, vOrigin);
	
	fDist = vOrigin[2];
	
	while(engfunc(EngFunc_PointContents, vOrigin) == CONTENTS_EMPTY)
		vOrigin[2] += 5.0;
	
	if(engfunc(EngFunc_PointContents, vOrigin) == CONTENTS_SKY)
		return (vOrigin[2] - fDist);
	
	return 0.0;
}

/*================================================================================
 [Functions]
=================================================================================*/
fnGetSimons() {
	static iPlayers[32], iNum, i, iPlayer, Simons;
	Simons = 0;
	get_players(iPlayers, iNum, "ae", "CT"); 
	for( i=0; i<iNum; i++ ) {
		iPlayer = iPlayers[i];
		if(get_bit(g_bIsSimon, iPlayer))
			Simons++;
	}

	return Simons;
}

fnGetRandomPlayer() {
	static iPlayers[32], iNum;
	get_players(iPlayers, iNum, "ae", "TERRORIST"); 
	return iNum ? iPlayers[random(iNum)] : 0;
}

fnGetCTRandomPlayer() {
	static iPlayers[32], iNum;
	get_players(iPlayers, iNum, "ae", "CT"); 
	return iNum ? iPlayers[random(iNum)] : 0;
}

fnGetTerrorists() {
	/* Get's the number of terrorists */
	static iPlayers[32], iNum;
	get_players(iPlayers, iNum, "ae", "TERRORIST"); 
	return iNum;
}

fnGetCounterTerrorists() {
	/* Get's the number of counter-terrorists */
	static iPlayers[32], iNum;
	get_players(iPlayers, iNum, "ae", "CT");
	return iNum;
}

fnGetChosen() {
	/* Get's if there's a chosen one between players */
	new temp;
	static iPlayers[32], iNum, i, iPlayer;
	get_players(iPlayers, iNum, "ae", "CT"); 
	for( i=0; i<iNum; i++ )
	{
		iPlayer = iPlayers[i];
		if(get_bit(g_bIsChosen, iPlayer))
			temp = set_bit(g_bIsChosen, iPlayer);
	}

	return temp;
}

stock in_array(needle, data[], size) { 
	for(new i = 0; i < size; i++) { 
		if(data[i] == needle) 
			return i;
	} 
	return -1; 
}  


fnGetGameType() {
	/* Get's the game type of the last request games */
	new Game[32];
	
	switch (g_iGameType) {
		case 0: Game = "JB_LASTREQUEST_M0";
		case 1: Game = "JB_LASTREQUEST_M1";
		case 2: Game = "JB_LASTREQUEST_M2";
		case 3: Game = "JB_LASTREQUEST_M3";
		case 4: Game = "JB_LASTREQUEST_M4";
		case 5: Game = "JB_LASTREQUEST_M5";
		case 6: Game = "JB_LASTREQUEST_M6";
		case 7: Game = "JB_LASTREQUEST_M7";
		case 8: Game = "JB_LASTREQUEST_M8";
		case 9: Game = "JB_LASTREQUEST_M9";
		case 10: Game = "JB_LASTREQUEST_M10";	
	}
	return Game;
}

fnSetRing(id) {	
	/* Teh beam cylinder !!! */
	new Float:flOrigin[3], iOrigin[3];
	pev(id, pev_origin, flOrigin);
	FVecIVec(flOrigin, iOrigin);

	// Beam Color
	new Colors = get_user_team(id);
	new Beam = GetPlayerHullSize(id);
	new Admin = is_user_admin(id);
	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iOrigin); 
	write_byte(TE_BEAMCYLINDER);
	write_coord(iOrigin[0]);
	write_coord(iOrigin[1]);
	if(Beam == HULL_HEAD)
		write_coord(iOrigin[2]-16);
	else write_coord(iOrigin[2]-33);
	write_coord(iOrigin[0]);
	write_coord(iOrigin[1]);
	write_coord(iOrigin[2] + 200);
	write_short(g_iRingSprite);		// Sprite Index
	write_byte(0);				// Start Frame
	write_byte(0);				// Frame Rate
	write_byte(5);				// Life
	write_byte(5);				// Width 
	write_byte(0);				// Noise
	if(Admin) {
		write_byte(Colors == 2 ? 255 : 0);//r
		write_byte(Colors == 1 ? 255 : 255);//g
		write_byte(0);//b
	}
	else {
		write_byte(Colors == 1 ? 255 : 0);
		write_byte(0);
		write_byte(Colors == 2 ? 255 : 0);
	}
	write_byte(200);			// Brightness
	write_byte(0);				// Speed
	message_end();
}

fnSetSimonRing(id) {
	/* Teh beam cylinder !!! */
	new Float:flOrigin[3], iOrigin[3];
	pev(id, pev_origin, flOrigin);
	FVecIVec(flOrigin, iOrigin);

	// Beam Color
	new Beam = GetPlayerHullSize(id);

	message_begin(MSG_BROADCAST, SVC_TEMPENTITY, iOrigin); 
	write_byte(TE_BEAMCYLINDER);
	write_coord(iOrigin[0]);
	write_coord(iOrigin[1]);
	if(Beam == HULL_HEAD)
		write_coord(iOrigin[2]-16);
	else write_coord(iOrigin[2]-33);
	write_coord(iOrigin[0]);
	write_coord(iOrigin[1]);
	write_coord(iOrigin[2] + 200);
	write_short(g_iRingSprite);		// Sprite Index
	write_byte(0);				// Start Frame
	write_byte(0);				// Frame Rate
	write_byte(5);				// Life
	write_byte(25);				// Width 
	write_byte(0);				// Noise
	write_byte(255);//r
	write_byte(255);//g
	write_byte(255);//b
	write_byte(200);			// Brightness
	write_byte(0);				// Speed
	message_end();
}

fnColorPrint(index, const Msg[], any:...) {
	new Buffer[190], Buffer2[192];
	formatex(Buffer2, charsmax(Buffer2), "^x04[%s] ^x01%s", g_szPluginPrefix, Msg);
	vformat(Buffer, charsmax(Buffer), Buffer2, 3);

	if (!index) {
		for (new i = 1; i <= g_iMaxPlayers; i++) {
			if (!is_user_connected(i))
				continue;

			message_begin(MSG_ONE_UNRELIABLE, g_iMsgSayText,_, i);
			write_byte(i);
			write_string(Buffer);
			message_end();
		}
	}
	else {
		if (!is_user_connected(index))
			return;

		message_begin(MSG_ONE, g_iMsgSayText,_, index);
		write_byte(index);
		write_string(Buffer);
		message_end();
	}
}

public MsgSendAudio(const iMsgId, const iMsgDest, const id)
{
	if(id && g_iGameType == 4 || g_iDay[ TOTAL_DAYS ] == DAY_GRENADE || g_bSnowballWar || g_iGameType == 6)
	{
		new szRadioKey[19];
		static const MRAD_FIREINHOLE[] = "%!MRAD_FIREINHOLE";
		get_msg_arg_string(2, szRadioKey, charsmax(szRadioKey));
		if( equal(szRadioKey, MRAD_FIREINHOLE) )
		{
			if( get_msg_block(g_iMsgTextMsg) != BLOCK_SET )
			{
				set_msg_block(g_iMsgTextMsg, BLOCK_ONCE);
			}
			return PLUGIN_HANDLED;
		}
	}

	return PLUGIN_CONTINUE;
} 

public reset_all(id)
{ 	
	clear_bit(g_bIsLast, id);
	clear_bit(g_bIsChosen, id);
	clear_bit(g_bHasCrowbar, id);
	clear_bit(g_bHasArmor, id);
	clear_bit(g_bHasSpeed, id);
	clear_bit(g_bHasInvis, id);
	clear_bit(g_bInDisguise, id);
	clear_bit(g_bHasNadepack, id);
	clear_bit(g_bHasFootstep, id);
	clear_bit(g_bHasDisguise, id);
	clear_bit(g_bHasCellKeys, id);
	clear_bit(g_bHasFreeday, id);
	clear_bit(g_bInDisguise, id);
	clear_bit(g_bIsGlowing, id);
	clear_bit(g_bIsSimon, id);
	clear_bit(g_bInMathProblem, id);
	
	if(task_exists(id+TASK_BEAM))
		remove_task(id+TASK_BEAM);
	
	set_user_footsteps(id, 0);
	set_user_maxspeed(id, 250.0);
	set_user_rendering(id);
}

// takes a weapon from a player efficiently
// Thanks to XxAvalanchexX
public ham_strip_weapon(const id, const weapon[])
{
	if(!equal(weapon,"weapon_",7)) return 0;
	
	new wId = get_weaponid(weapon);
	if(!wId) return 0;

	new wEnt;
	while((wEnt = engfunc(EngFunc_FindEntityByString,wEnt,"classname",weapon)) && pev(wEnt,pev_owner) != id) {}
	if(!wEnt) return 0;
	
	if(get_user_weapon(id) == wId) ExecuteHamB(Ham_Weapon_RetireWeapon,wEnt);
	
	if(!ExecuteHamB(Ham_RemovePlayerItem,id,wEnt)) return 0;
	ExecuteHamB(Ham_Item_Kill,wEnt);
	
	set_pev(id,pev_weapons,pev(id,pev_weapons) & ~(1<<wId));
	
	return 1;
}
public ClCmd_CheckDisguise(id) {
	if(!get_bit(g_bIsConnected, id)) 
		return PLUGIN_HANDLED;
	if( cs_get_user_team( id ) != CS_TEAM_T ) {
		fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M160");
		return PLUGIN_HANDLED;
	}
		
	if(!get_bit(g_bIsAlive, id)) {
		fnColorPrint(id, "%L", LANG_SERVER, "JB_USER_DEAD");
		return PLUGIN_HANDLED;
	}
	
	if(!get_bit(g_bHasDisguise, id)) {
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M161");
		return PLUGIN_HANDLED;
	}
	
	if(get_bit(g_bInDisguise, id)) {
		if(IsBeingWatched(id)) {
			fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M162");
			return PLUGIN_HANDLED;
		}
		else {
			cs_set_user_model(id, "leet");
			clear_bit(g_bInDisguise, id);
			fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M163");
			return PLUGIN_HANDLED;
		}
	}
	else {
		if(IsBeingWatched(id)) {
			fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M164");
			return PLUGIN_HANDLED;
		}
		else {
			cs_set_user_model(id, "urban");
			set_bit(g_bInDisguise, id);
			fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M165");
			return PLUGIN_HANDLED;
		}
	}
	return PLUGIN_HANDLED;
}
// checks if they are in a ct's view
// Thanks to joaquimandrade
IsBeingWatched(id) {
	new CsTeams:team = cs_get_user_team(id);
	new Float:origin[3];
	entity_get_vector(id,EV_VEC_origin,origin);
		
	for(new i=1,CsTeams:teamViewer;i<=g_iMaxPlayers;i++) {
		if(get_bit(g_bIsAlive, i)) {
			teamViewer = cs_get_user_team(i);
				
			if(team != teamViewer)
				if(fm_is_ent_visible_maxdistance(i,id,.maxdistance = DetectionMaxDistance) && is_in_viewcone(i,origin))
					return true;
		}
	}
	return false;
}

bool:fm_is_ent_visible_maxdistance(const index, const entity, ignoremonsters = 0, Float:maxdistance) {	
	new Float:start[3], Float:dest[3];
	pev(index, pev_origin, start);
	pev(index, pev_view_ofs, dest);
	xs_vec_add(start, dest, start);
	pev(entity, pev_origin, dest);
	
	if(vector_distance(start,dest) <= maxdistance) {
		engfunc(EngFunc_TraceLine, start, dest, ignoremonsters, index, 0);
		new Float:fraction;
		get_tr2(0, TR_flFraction, fraction);
		
		if (fraction == 1.0 || get_tr2(0, TR_pHit) == entity)
			return true;
	}
	return false;
}

//Taken From exolent//
public Fwd_SetVoice(const receiver, const sender, bool:bListen)
{
	if(!get_bit(g_bIsConnected, receiver) 
	|| !get_bit(g_bIsConnected, sender) 
	|| g_iSpeakFlags[sender] == SPEAK_NORMAL 
	&& g_iSpeakFlags[receiver] != SPEAK_LISTENALL)
	{
		return FMRES_IGNORED;
	}
	
	static iSpeakType;
	iSpeakType = 0;
	if(g_iSpeakFlags[sender] == SPEAK_ALL
	|| g_iSpeakFlags[receiver] == SPEAK_LISTENALL
	|| g_iSpeakFlags[sender] == SPEAK_TEAM && get_pdata_int(sender, 114) == get_pdata_int(receiver, 114))
	{
		iSpeakType = 1;
	}
	
	engfunc(EngFunc_SetClientListening, receiver, sender, iSpeakType);
	return FMRES_SUPERCEDE;
}

public SaveWeapons(iPlayer)
{
	if( !get_bit(g_bIsConnected, iPlayer) && !get_bit(g_bIsAlive, iPlayer) )
		return PLUGIN_HANDLED;
		
	new iWeaponBits = g_iWeaponBits[iPlayer] = entity_get_int(iPlayer, EV_INT_weapons) & VALID_WEAPONS;
	
	for(new i;i<=CSW_P90;i++)
	{
		if(IsWeaponInBits(i, iWeaponBits))
		{
			g_iWeaponClip[iPlayer][i] = cs_get_weapon_ammo(find_ent_by_owner(-1, g_szWeaponNames[i], iPlayer));
			g_iWeaponAmmo[iPlayer][i] = cs_get_user_bpammo(iPlayer, i);
		}
	}
	StripPlayerWeapons(iPlayer);
	
	return PLUGIN_HANDLED;
}

public RestoreWeapons(iPlayer)
{
	if( !get_bit(g_bIsConnected, iPlayer) && !get_bit(g_bIsAlive, iPlayer) )
	{
		return PLUGIN_HANDLED;
	}
	
	StripPlayerWeapons(iPlayer);
	new iWeaponBits = g_iWeaponBits[iPlayer];
	new iEntity;
	//clear_bit(iPlayer, checkWeapon);
	for(new i;i<=CSW_P90;i++)
	{
		if(IsWeaponInBits(i, iWeaponBits))
		{
			iEntity = give_item(iPlayer, g_szWeaponNames[i]);
			
			cs_set_weapon_ammo(iEntity, g_iWeaponClip[iPlayer][i]);
			cs_set_user_bpammo(iPlayer, i, g_iWeaponAmmo[iPlayer][i]);
			set_bit2(iPlayer, checkWeapon);
			//fnColorPrint(iPlayer, "You got your weapons back");
		}	
	}
	//set_bit(iPlayer, checkWeapon);
	/*
	if(!get_bit(iPlayer, checkWeapon))
	{
		GiveItem2(iPlayer, CSW_M4A1);
		GiveItem2(iPlayer, CSW_DEAGLE);
		clear_bit(iPlayer, checkWeapon);
		fnColorPrint(iPlayer, "Failed to retrieve your weapons!");
	}*/
	//fnColorPrint(0, "Failed to GET HERE");

	return PLUGIN_HANDLED;
}
// Thanks to Arkshine
public ClientCommand_UnStuck(const id)
{
	new i_Value;

	if ((i_Value = UTIL_UnstuckPlayer(id, START_DISTANCE, MAX_ATTEMPTS)) != 1)
		switch (i_Value)
		{
			case 0: fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M166");
			case -1: fnColorPrint(id, "%L", LANG_SERVER, "JB_DAY_M167");
		}

	return PLUGIN_CONTINUE;
}

UTIL_UnstuckPlayer(const id, const i_StartDistance, const i_MaxAttempts)
{
	// Is Not alive, ignore.
	if (!get_bit(g_bIsAlive, id))  return -1;
	
	static Float:vf_OriginalOrigin[Coord_e], Float:vf_NewOrigin[Coord_e];
	static i_Attempts, i_Distance;
	
	// Get the current player's origin.
	pev (id, pev_origin, vf_OriginalOrigin);
	
	i_Distance = i_StartDistance;

	while (i_Distance < 1000)
	{
		i_Attempts = i_MaxAttempts;
	
		while (i_Attempts--)
		{
			vf_NewOrigin[x] = random_float(vf_OriginalOrigin[ x ] - i_Distance, vf_OriginalOrigin[ x ] + i_Distance);
			vf_NewOrigin[y] = random_float(vf_OriginalOrigin[ y ] - i_Distance, vf_OriginalOrigin[ y ] + i_Distance);
			vf_NewOrigin[z] = random_float(vf_OriginalOrigin[ z ] - i_Distance, vf_OriginalOrigin[ z ] + i_Distance);
		
			engfunc (EngFunc_TraceHull, vf_NewOrigin, vf_NewOrigin, DONT_IGNORE_MONSTERS, GetPlayerHullSize (id), id, 0);
		
			// Free space found.
			if (get_tr2 (0, TR_InOpen) && !get_tr2 (0, TR_AllSolid) && !get_tr2 (0, TR_StartSolid))
			{
				// Set the new origin .
				engfunc (EngFunc_SetOrigin, id, vf_NewOrigin);
				return 1;
			}
		}
	
		i_Distance += i_StartDistance;
	}

	// Could not be found.
	return 0;
} 

stock bool:is_user_stuck(id) { 
	new Float:g_origin[3]; 
	pev(id, pev_origin, g_origin); 
	if ( trace_hull(g_origin, HULL_HUMAN,id) != 0 ) 
	{ 
		return true; 
	} 
	return false; 
} 

public CmdSprayMessage(id)
{
	if(get_pcvar_num(cvar_pointer[cvar_sprayenable]) != 1)
		return PLUGIN_HANDLED;
	if(get_user_team(id) == 1 && !access(id, SPRAY_ACCESS))
	{
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M168" );
		return PLUGIN_HANDLED;
	}
	
	if(!g_bSprayMessages)
	{
		g_bSprayMessages = true;
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M169", '^4', '^3' );
	} 
	else {
		g_bSprayMessages = false;
		fnColorPrint( id, "%L", LANG_SERVER, "JB_DAY_M170", '^4', '^3' );
	}
	return PLUGIN_HANDLED;
}

public EventSpray()
{
	if(get_pcvar_num(cvar_pointer[cvar_sprayenable]) != 1)
		return;
	static iPlayer;
	iPlayer = read_data(2);
	if(!get_bit(g_bIsConnected, iPlayer) && !get_bit(g_bIsAlive, iPlayer))
		return;
		
	static iOrigin[3];
	iOrigin[0] = read_data(3);
	iOrigin[1] = read_data(4);
	iOrigin[2] = read_data(5);
	
	static Float:vecOrigin[3];
	IVecFVec(iOrigin, vecOrigin);
	
	static Float:vecDirection[3];
	velocity_by_aim(iPlayer, 5, vecDirection);
	
	static Float:vecStop[3];
	xs_vec_add(vecOrigin, vecDirection, vecStop);
	xs_vec_mul_scalar(vecDirection, -1.0, vecDirection);
	
	static Float:vecStart[3];
	xs_vec_add(vecOrigin, vecDirection, vecStart);
	engfunc(EngFunc_TraceLine, vecStart, vecStop, IGNORE_MONSTERS, -1, 0);
	get_tr2(0, TR_vecPlaneNormal, vecDirection);
	vecDirection[2] = 0.0;
	xs_vec_normalize(vecDirection, vecDirection);
	xs_vec_mul_scalar(vecDirection, 5.0, vecDirection);
	xs_vec_add(vecOrigin, vecDirection, vecStart);
	xs_vec_copy(vecStart, vecStop);
	vecStop[2] -= 9999.0;
	engfunc(EngFunc_TraceLine, vecStart, vecStop, IGNORE_MONSTERS, -1, 0);
	get_tr2(0, TR_vecEndPos, vecStop);
	
	static szName[32]; get_user_name(iPlayer, szName, charsmax(szName));
	
	if(iPlayer > 0)
		if(g_bSprayMessages)
			fnColorPrint(0, "%L", LANG_SERVER, "JB_DAY_M171", szName, '^4', (vecStart[2] - vecStop[2]), '^1', '^3');
		else fnColorPrint( iPlayer, "%L", LANG_SERVER, "JB_DAY_M172", '^4', (vecStart[2] - vecStop[2]), '^1', '^3');
}
/*

RadiuzDamage( iEntity, Float:flDamage, Float:flRadius ) {
	new Float:vExplodeAt[ 3 ];
	pev( iEntity, pev_origin, vExplodeAt );
	
	new id = FM_NULLENT, Float:flTakeDamage, Float:vOrigin[ 3 ], Float:flAdjustedDamage;
	
	while( ( id = engfunc( EngFunc_FindEntityInSphere, id, vExplodeAt, flRadius ) ) != 0 ) {
		if( id == iEntity )
			continue;
	
		pev( id, pev_takedamage, flTakeDamage );
		if( flTakeDamage == DAMAGE_NO )
			continue;
	
		if( is_user_alive( id ) ) {
			pev( id, pev_origin, vOrigin );
	
			flAdjustedDamage = flDamage - get_distance_f( vExplodeAt, vOrigin ) * flDamage / flRadius;
	
			ExecuteHamB( Ham_TakeDamage, id, iEntity, iEntity, flAdjustedDamage, DMG_GENERIC );
		}
	}
}*/

public Fwd_AddToFullPack(es_handle, e, ent, host, hostflags, player, pSet)
{
	
	if( player && get_bit(g_bIsAlive, host))
	{
		switch (g_iDay[ TOTAL_DAYS ])
		{
			case DAY_HIDENSEEK:
			{
				static CsTeams:team; team = cs_get_user_team(ent);
				static CsTeams:teamhost; teamhost = cs_get_user_team(host);
				static alpha;
				switch (team)
				{
					case CS_TEAM_CT: alpha = 255;
					case CS_TEAM_T:
					{
						static Float:flDistance;
						flDistance = entity_range(host, ent); 
						if( flDistance < 1000.0 ) 
						{ 
							alpha = floatround((1.0 - (flDistance / 1000.0)) * 255.0);
						}
						else alpha = 1;
					}
				}
				
				if(team != teamhost)
				{
					set_es(es_handle, ES_RenderMode, kRenderTransAlpha);
					set_es(es_handle, ES_RenderAmt, alpha);
					//set_es(es_handle, ES_Origin, Float:{99999.9,99999.9,99999.9});
				}
				
			}
			case DAY_NIGHT:
			{	
				static CsTeams:team; team = cs_get_user_team(ent);
				static CsTeams:teamhost; teamhost = cs_get_user_team(host);
				
				if(team == CS_TEAM_CT && team != teamhost)
				{
					if(get_bit(g_HasBeenHit, ent))
					{
						set_es(es_handle, ES_RenderFx, kRenderFxDistort);
						set_es(es_handle, ES_RenderColor, {0, 0, 0});
						set_es(es_handle, ES_RenderMode, kRenderTransAdd);
						set_es(es_handle, ES_RenderAmt, 127);
					}
					else {
						set_es(es_handle, ES_RenderMode, kRenderTransAlpha);
						set_es(es_handle, ES_RenderAmt, 0);
					}
				}
				if(team == CS_TEAM_CT && team == teamhost)
				{
					set_es(es_handle, ES_RenderFx, kRenderFxDistort);
					set_es(es_handle, ES_RenderColor, {0, 0, 0});
					set_es(es_handle, ES_RenderMode, kRenderTransAdd);
					set_es(es_handle, ES_RenderAmt, 127);
				}
			}
			case DAY_RENIGHT:
			{	
				static CsTeams:team; team = cs_get_user_team(ent);
				static CsTeams:teamhost; teamhost = cs_get_user_team(host);
				
				if(team == CS_TEAM_T && team != teamhost)
				{
					if(get_bit(g_HasBeenHit, ent))
					{
						set_es(es_handle, ES_RenderFx, kRenderFxDistort);
						set_es(es_handle, ES_RenderColor, {0, 0, 0});
						set_es(es_handle, ES_RenderMode, kRenderTransAdd);
						set_es(es_handle, ES_RenderAmt, 127);
					}
					else {
						set_es(es_handle, ES_RenderMode, kRenderTransAlpha);
						set_es(es_handle, ES_RenderAmt, 0);
					}
				}
				if(team == CS_TEAM_T && team == teamhost)
				{
					set_es(es_handle, ES_RenderFx, kRenderFxDistort);
					set_es(es_handle, ES_RenderColor, {0, 0, 0});
					set_es(es_handle, ES_RenderMode, kRenderTransAdd);
					set_es(es_handle, ES_RenderAmt, 127);
				}
			}
		}
		if(g_ThermalOn[host])
		{
			static CsTeams:team; team = cs_get_user_team(ent);
			static CsTeams:teamhost; teamhost = cs_get_user_team(host);
			static color[3];
			
			switch (team)
			{
				case CS_TEAM_CT:
				{
					color[0] = 255;
					color[1] = 0;
					color[2] = 0;
				}
				case CS_TEAM_T:
				{
					color[0] = 0;
					color[1] = 0;
					color[2] = 255;
				}
			}
			
			if(team != teamhost)
			{
				set_es(es_handle, ES_RenderFx, 19);
				set_es(es_handle, ES_RenderColor, color);
				set_es(es_handle, ES_RenderMode, 0);
				set_es(es_handle, ES_RenderAmt, 25);
			}
		}
	}
	
	return FMRES_IGNORED;
}

public fm_get_speak(id)
{
	if(!get_bit(g_bIsConnected, id))
	{
		log_error(AMX_ERR_NATIVE, "[FmSetSpeak] Invalid player %d", id);
		return 0;
	}
	
	return g_iSpeakFlags[id];
}

public fm_set_speak(id, nums)
{
	if(!get_bit(g_bIsConnected, id))
	{
		log_error(AMX_ERR_NATIVE, "[FmSetSpeak] Invalid player %d", id);
		return;
	}
	g_iSpeakFlags[id] = nums;
}

GiveItem(const id, const szItem[], const bpAmmo) {
	give_item(id, szItem);
	cs_set_user_bpammo(id, get_weaponid(szItem), bpAmmo);
}

new static bpAmmo_default[CSW_P90+1] = {
	0,
	52,
	0,
	90,
	1,
	32,
	1,
	100,
	90,
	1,
	120,
	100,
	100,
	90,
	90,
	90,
	100,
	120,
	30,
	120,
	200,
	32,
	90,
	120,
	90,
	2,
	35,
	90,
	90,
	0,
	100
};
stock GiveItem2(const id, const szItem, iAmmo = -1, bpAmmo = -1) {
	give_item(id, g_szWeaponNames[szItem]);
	
	if(iAmmo >= 0) {
		new wepID = find_ent_by_owner(-1, g_szWeaponNames[szItem], id);
		if(wepID)
		{
			cs_set_weapon_ammo(wepID, iAmmo);
		}
	}
	
	if(bpAmmo >= 0) 
		cs_set_user_bpammo(id, szItem, bpAmmo);
	else cs_set_user_bpammo(id, szItem, bpAmmo_default[szItem]);
	if(g_bInLr && (g_iGameType == 2 || g_iGameType == 4))
	{
		g_iGetUserWeapon = szItem;
	}
}

public fog(bool:FogOn) {
	if(FogOn) {
		message_begin(MSG_ALL,g_iMsgFog,{0,0,0},0);
		write_byte(180);	// red
		write_byte(1);		// green
		write_byte(1);		// blue
		write_byte(10);		// Start distance
		write_byte(41);		// Start distance
		write_byte(95);		// End distance
		write_byte(59);		// End distance
		message_end();	
	}
	else {
		message_begin(MSG_ALL,g_iMsgFog,{0,0,0},0);
		write_byte(0);		// red
		write_byte(0);		// green
		write_byte(0);		// blue
		write_byte(0);		// Start distance
		write_byte(0);		// Start distance
		write_byte(0);		// End distance
		write_byte(0);		// End distance
		message_end();
	}
}
public Fwd_Touch_Snowballwar(ent, id)
{
	if(!pev_valid(ent))
		return FMRES_IGNORED;
	
	if(g_bSnowballWar)
	{
		static classname[20], classname2[20], Float:origin[3], owner;
		owner = pev(ent,pev_owner);
		pev(ent, pev_origin, origin);
		pev(id, pev_classname, classname2, charsmax(classname2));
		pev(ent, pev_classname, classname, charsmax(classname));
		
		if(equali(classname,"grenade") && equali(classname2,"player"))
		{
			if(get_user_health(id) > 20 /*&& !g_IsChilled[id]*/)
			{
				set_user_health(id, get_user_health(id) - 20);	
				ShowballWar_chillplayer(id);
				if(task_exists(id)) 
					remove_task(id);
				set_task(3.0, "task_user_unchill", id);
			}
			else if(get_user_health(id) <= 20)
				createKill(id,owner,"snowball");
		}
		
		if(equali(classname,"grenade")){
			ShowballWar_effect(origin);
			set_pev(ent, pev_flags, pev(ent, pev_flags) | FL_KILLME);
		}
	}
	return FMRES_IGNORED;
}
#define STR_T 32
new Float:g_wallorigin[32][3];

public Fwd_Touch(id, world)
{
	if(!is_user_connected(id) && !is_user_alive(id))
		return FMRES_IGNORED;
		
	static classname[STR_T];
	pev(world, pev_classname, classname, (STR_T-1));
	
	static CsTeams:team;
	team = cs_get_user_team(id);
	switch (g_iDay[ TOTAL_DAYS ])
	{
		case DAY_NIGHT:
			if(team == CS_TEAM_CT)
				if(equal(classname, "worldspawn") || equal(classname, "func_wall") || equal(classname, "func_breakable"))
					pev(id, pev_origin, g_wallorigin[id]);
		case DAY_RENIGHT:
			if(team == CS_TEAM_T)
				if(equal(classname, "worldspawn") || equal(classname, "func_wall") || equal(classname, "func_breakable"))
					pev(id, pev_origin, g_wallorigin[id]);
	}
	return FMRES_IGNORED;
}

public task_user_unchill(id){
	new Float:origin[3];
	pev(id,pev_origin,origin);
	
	ShowballWar_unchill(id,origin);
}

public wallclimb(id, button) 
{ 
	static Float:origin[3]; 
	pev(id, pev_origin, origin);
	
	if(button & IN_RELOAD && !get_bit(g_bTeleport, id) && g_bTeleportUsed[id] < 3) 
	{ 
		g_bTeleportUsed[id]++;
		fnColorPrint(id, "You have been teleported! You have^4 %d teleports^1 left.", (3-g_bTeleportUsed[id]));
		emit_sound(id, CHAN_AUTO, NightCrawlerSounds[1], 1.0, ATTN_NORM, 0, PITCH_NORM);
		set_bit(g_bTeleport, id);
		set_task(5.0, "resetteleport", id);
		static Float:start[3], Float:dest[3];
		pev(id, pev_origin, start);
		pev(id, pev_view_ofs, dest);
		xs_vec_add(start, dest, start);
		
		pev(id, pev_v_angle, dest);
		engfunc(EngFunc_MakeVectors, dest);
		global_get(glb_v_forward, dest);
		xs_vec_mul_scalar(dest, 9999.0, dest);
		xs_vec_add(start, dest, dest);
		
		engfunc(EngFunc_TraceLine, start, dest, IGNORE_MONSTERS, id, 0);
		get_tr2(0, TR_vecEndPos, start);
		get_tr2(0, TR_vecPlaneNormal, dest);
		
		static const player_hull[] = { HULL_HUMAN, HULL_HEAD };
		engfunc(EngFunc_TraceHull, start, start, DONT_IGNORE_MONSTERS, player_hull[_:!!(pev(id, pev_flags) & FL_DUCKING)], id, 0);
		if (!get_tr2(0, TR_StartSolid) && !get_tr2(0, TR_AllSolid) && get_tr2(0, TR_InOpen)) {
			engfunc(EngFunc_SetOrigin, id, start);
			return FMRES_HANDLED;
		}
		
		static Float:size[3];
		pev(id, pev_size, size);
		xs_vec_mul_scalar(dest, (size[0] + size[1]) / 2.0, dest);
		xs_vec_add(start, dest, dest);
		
		engfunc(EngFunc_SetOrigin, id, dest);
		if(is_user_stuck(id))
			ClientCommand_UnStuck(id);
		return FMRES_HANDLED;
	} 
	
	if(get_distance_f(origin, g_wallorigin[id]) > 10.0)	
		return FMRES_IGNORED;
	
	if(get_entity_flags(id) & FL_ONGROUND) 
		return FMRES_IGNORED; 

	if(button & IN_FORWARD) 
	{ 
		static Float:velocity[3]; 
		velocity_by_aim(id, 275, velocity); 
		set_user_velocity(id, velocity); 
	} 
	else if(button & IN_BACK) 
	{ 
		static Float:velocity[3]; 
		velocity_by_aim(id, -120, velocity); 
		set_user_velocity(id, velocity); 
	} 
	return FMRES_IGNORED; 
}    

public resetteleport(id)
{
	clear_bit(g_bTeleport, id);
}

public Fwd_PlayerPreThink(id)  
{ 
	if(get_bit(g_bIsAlive, id))
	{
		static CsTeams:team;
		team = cs_get_user_team(id);
		switch(g_iDay[ TOTAL_DAYS ])
		{
			case DAY_NIGHT:
			{
				switch(team)
				{
					case CS_TEAM_CT:
					{
						new button = get_user_button(id); 
					     
						if(button & IN_USE || button & IN_RELOAD ) //Use button = climb 
							wallclimb(id, button);	
					}
					case CS_TEAM_T: set_laser(id);
				}
			}
			case DAY_RENIGHT:
			{
				switch(team)
				{
					case CS_TEAM_T:
					{
						new button = get_user_button(id); 
					     
						if(button & IN_USE || button & IN_RELOAD ) //Use button = climb 
							wallclimb(id, button);	
					}
					case CS_TEAM_CT: set_laser(id);
				}
			}
		}
	}
}  

public set_laser(id)
{
	if(g_iRandom == id && g_iRandom != 0)
	{
		static iTarget, iBody, iRed, iGreen, iBlue, iWeapon;
		get_user_aiming(id, iTarget, iBody);
		iWeapon = get_user_weapon(id);
		if(IsPrimaryWeapon(iWeapon) || IsSecondaryWeapon(iWeapon))
		{
			if( is_user_alive(iTarget) && cs_get_user_team(iTarget) != cs_get_user_team(id))
			{
				iRed = 255;
				iGreen = 0;
				iBlue = 0;
			}
			else {
				iRed = 0;
				iGreen = 255;
				iBlue = 0;
			}
			
			static iOrigin[ 3 ];
			get_user_origin(id, iOrigin, 3);
			
			message_begin(MSG_BROADCAST, SVC_TEMPENTITY);
			write_byte(TE_BEAMENTPOINT);
			write_short(id | 0x1000);
			write_coord(iOrigin[0]);
			write_coord(iOrigin[1]);
			write_coord(iOrigin[2]);
			write_short(g_iLaserSprite);
			write_byte(1);
			write_byte(10);
			write_byte(1);
			write_byte(5);
			write_byte(0);
			write_byte(iRed);
			write_byte(iGreen);
			write_byte(iBlue);
			write_byte(150);
			write_byte(25);
			message_end();
		}
	}
}

public Event_NVGToggle(id)
	g_ThermalOn[id] = read_data(1);
