-- Jukebox SQL upgrade script
-- From version 0.5.3.1 to 0.5.4.0

-- Fix "queue" column of jb_streams so that it defaults to 0
ALTER TABLE `jb_streams` CHANGE `queue`  `queue` MEDIUMINT( 8 ) UNSIGNED NOT NULL DEFAULT  '0';

-- Renames indexes to match field names (no appreciable effect, just for clarity)
ALTER TABLE  `jb_log_history` DROP INDEX  `id_username`, ADD INDEX 
`username_id` (  `username_id` ); ALTER TABLE  `jb_log_history` DROP INDEX 
`id_track` , ADD INDEX  `track_id` (  `track_id` );

-- Adjust table indicies
ALTER TABLE  `jb_options` ADD UNIQUE (`steamid`);
ALTER TABLE  `jb_options` DROP PRIMARY KEY;

-- Add ID field to Options table for use by the Log
ALTER TABLE  `jb_options` ADD `id` MEDIUMINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY FIRST;

-- Make sure that there is a Steam ID entry in the Options table for all of the Log Users entries
INSERT INTO `jb_options` (`steamid`) SELECT `steam_id` AS 'steamid' FROM `jb_log_users` ON DUPLICATE KEY UPDATE `jb_options`.`id` = `jb_options`.`id`;

-- Add "user_id" field to log history table
ALTER TABLE `jb_log_history` ADD `user_id` MEDIUMINT UNSIGNED NOT NULL AFTER `id` , ADD INDEX ( `user_id` );

-- Find the Options entry ID to associate with each Log entry using the Steam ID
UPDATE `jb_log_history` AS hi SET hi.`user_id` = (SELECT op.`id` FROM `jb_options` AS op LEFT JOIN `jb_log_users` AS us ON op.`steamid` = us.`steam_id` LEFT JOIN `jb_log_usernames` AS na ON us.`id` = na.`user_id` WHERE na.`id` = hi.`username_id`);

-- Remove the Log Users table - it is no longer needed
DROP TABLE `jb_log_users`;

-- Remove the user_id field from the Log Usernames table - it is no longer needed
ALTER TABLE  `jb_log_usernames` DROP  `user_id`;