<?php

$track_folder = "tracks/";

require_once "include/database.php";
require_once "include/settings.php";

$script_folder = dirname($_SERVER['SCRIPT_FILENAME']);

function isEmptyDir($dir) {
	return (($files = @scandir($dir)) && count($files) <= 2);
}

ignore_user_abort(TRUE);

Print("Beginning Jukebox remote transfer script.<BR />\n");

dbconn();

// Search database for non-uploaded files
$query = sprintf(
	"SELECT id, md5 FROM %s WHERE uploaded = FALSE",
		$audio_tables['tracks']
	);
$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);

if(mysql_num_rows($result)) {
	// Set up and test FTP connection
	$conn = ftp_connect($ftp_host, $ftp_port) or die("FTP connection to $ftp_host on port $ftp_port failed.");
	if($conn && @ftp_login($conn, $ftp_user, $ftp_pass)) {
		print("FTP connection to $ftp_host successful for user $ftp_user.<BR />\n");
	} else {
		ftp_close($conn);
 		die("FTP connection failed.<BR />\n");
	}

	// Move to Jukebox folder
	if(isset($ftp_subfolder) && $ftp_subfolder != "") {
		if(!ftp_chdir($conn, $ftp_subfolder)) {
			die("Error: Failed to change FTP directory to Jukebox folder (" . $ftp_subfolder . ")!  Current directory name = " . ftp_pwd($conn));
		}
	}
	//$file_count = 0;
	while($row = mysql_fetch_array($result)) {
		/*
		// A check to prevent timeout
		if($file_count++ >= 5) {
			print("Stopping after 5 uploads.  Run again to transfer more tracks.");
			break;
		}
		*/

		set_time_limit(120);
		// Build target path
		$id = $row['id'];
		$md5 = $row['md5'];
		$target_subfolder = $track_folder;
		for($i = 0; $i < $folder_depth; $i++) {
			$target_subfolder .= $md5[$i]."/";
		}
		$target_file = $target_subfolder.$md5.".mp3";
		// Check for file
		if(!file_exists($target_file)) {
			print("Error: File $target_file of id #$id is missing!<BR />\n");
			continue;
		}

		// Prepare FTP folder structure
		for($i = 0; $i < $folder_depth; $i++) {
			if(@ftp_chdir($conn, $md5[$i]) === FALSE) {
				if(ftp_mkdir($conn, $md5[$i]) === FALSE || @ftp_chdir($conn, $md5[$i]) === FALSE) {
					die("Error: Failed to create remote directory {$md5[$i]} at ".ftp_pwd($conn));
					break 2;
				} else {
					$temp_handle = tmpfile();
					fwrite($temp_handle, "STOP SNOOPING AROUND!");
					rewind($temp_handle);
					if(!ftp_fput($conn, "index.html", $temp_handle, FTP_ASCII)) {
						print("WARNING: Failed to create dummy index file in remote folder '" . ftp_pwd($conn) . "'.<BR />\n");
					}
					fclose($temp_handle);
				}
			}
		}
		echo "Write folder for id #$id: ".ftp_pwd($conn)."<BR />\n"; // DEBUG

		// Transfer file
		print("Beginning transfer of {$md5}.mp3 of id #$id...");
		$attempt_count = 0;
		$attempt_test = false;
		do {
			$attempt_count++;
			$attempt_test = ftp_put($conn, $md5.".mp3", $target_file, FTP_BINARY);
		} while(!$attempt_test && $attempt_count < 3);
		if(!$attempt_test) {
			print("Error: File {$md5}.mp3 of id #$id failed to transfer!<BR />\n");
			break;
		} else {
			print(" complete!<BR />\n");
		}
		for($i = 0; $i < $folder_depth; $i++) {
			if(!ftp_cdup($conn)) {
				die("Error: Failed to move up directory structure to Jukebox root folder.");
			}
		}

		// Mark change in MySQL directory
		$query = sprintf("UPDATE %s SET uploaded = TRUE WHERE id = %d",
				$audio_tables['tracks'],
				$id
			);
		if(!mysql_query($query)) {
			die("Error: MySQL remote server table update failed for track ID #$id.");
		}

		// Delete source
		if(!unlink($target_file)) {
			print("Error: Failed to delete local source file {$md5}.mp3 of ID #$id after transfer!<BR />\n");
		}
	}


	/*
	// Recursively delete empty folders
	for($i = 0; $i < $folder_depth; $i++) {
		$drop_chars = -2*$i;
		if($drop_chars == 0) {
			$drop_chars = NULL;
		}
		$target_folder = substr($target_subfolder, 0, $drop_chars);
		print("DEBUG: Attempting to remove folder $target_folder..."); // DEBUG
		if(IsEmptyDir($target_folder)) {
			if(!rmdir($target_folder)) {
				print("Warning: Failed to remove local directory $target_folder!<BR />\n"); // DEBUG
			} else {
				print(" successful.<BR />\n"); // DEBUG
			}
		} else {
			print(" folder is not empty.<BR />\n"); // DEBUG
			break;
		}
	}
	*/

} else {
	print("There are no new files to transfer.<BR />\n");
}

print("<BR />\nRemote server upload process complete!<BR />\n");

?>
