<?php

$THIS_PATH=dirname(__FILE__);

require_once "class.rc4crypt.php";
require_once "settings.php";

// Common "get" activity used throughout code
function get_or_null($data_title, $do_null = TRUE, $char_esc = TRUE) {
	if (isset($_GET[$data_title])) {
		$data = $_GET[$data_title];
		if(get_magic_quotes_gpc()) {
			$data = stripslashes($data);
		}
		/*
		if ($char_esc) {
			$data = htmlspecialchars($data);
			// $data = htmlspecialchars(mysql_real_escape_string($data));
		}
		*/
	} else {
		$data = NULL;
	}
	return $data;
}

// Common "post" activity used throughout code
function post_or_null($data_title, $do_null = TRUE, $char_esc = TRUE, $array_key = NULL) {
	if(($array_key && isset($_POST[$data_title][$array_key])) || (!$array_key && isset($_POST[$data_title]))) {
		if ($array_key) {
			$data = $_POST[$data_title][$array_key];
		} else {
			$data = $_POST[$data_title];
		}

		if(get_magic_quotes_gpc()) {
			if(is_array($data)) {
				foreach($data as $i => $row) {
					$data[$i] = stripslashes($row);
				}
			} else {
				$data = stripslashes($data);
			}
		}

		/*
		if ($char_esc) {
			$data = htmlspecialchars($data);
			// $data = htmlspecialchars(mysql_real_escape_string($data));
		}
		*/
	// } elseif ($do_null) {
	} else {
		$data = NULL;
		//echo "Debug: POST '{$data_title}' = NULL<BR />\n"; // DEBUG
	}

	return $data;
}


// A mechanism to pull data from either a primary or secondary source, depending on availability.
function choose_data_source($primary_source, $second_source = NULL) {
	if(isset($primary_source) && $primary_source !== "" && $primary_source != NULL) {
		return $primary_source;
	} elseif (isset($second_source) && $second_source !== NULL) {
		return $second_source;
	} else {
		return "";
	}
}


// Provides the full 128-bit MD5 digest in binary (for smaller database storage than 32-character string type)
function md5bin( $target ) {
    $md5 = md5( $target );
    $ret = '';

    for ( $i = 0; $i < 32; $i += 2 ) {
        $ret .= chr( hexdec( $md5{ $i + 1 } ) + hexdec( $md5{ $i } ) * 16 );
    }

    return $ret;
}


// Return the web directory of the script in which the function is called
function my_dir(){
	return end(explode('/', dirname(!empty($_SERVER['REQUEST_URI']) ? $_SERVER['REQUEST_URI'] : !empty($_SERVER['PHP_SELF']) ? $_SERVER['PHP_SELF'] : str_replace('\\','/',__FILE__))));
}

function html_head($title = "") {
	global $site_name;
	$num_args = func_num_args();
	print ("<HTML>\n<HEAD>\n\t<TITLE>".$site_name." - ".$title."</TITLE>\n");
	if($num_args > 1) {
		for($i = 1; $i < $num_args; $i++) {
			$row = func_get_arg($i);
			if(is_string($row)) {
				print("\t<SCRIPT TYPE=\"text/JavaScript\" SRC=\"include/javascript/".$row.".js\"></SCRIPT>\n");
			}
		}
	}
	print("</HEAD>\n\n<BODY>\n");

	return NULL;
}

function html_foot() {
	print <<<END
</BODY>
</HTML>
END;

	return NULL;
}



function base64url_encode($input) {
	return strtr(base64_encode($input), '+/=', '-_.');
}

function base64url_decode($input) {
	return base64_decode(strtr($input, '-_.', '+/='));
}

// To use, must run "html_head()" before any HTML and with "OpenBrWindow" as one of the parameters.
function music_popup($id, $display = "Play") {

	global $leech_pass;

	static $key = "";

	if($key == "") {
		$key = bin2hex(rc4crypt::encrypt($leech_pass, pack("l1", time())));
	}

	$playback_script = "query.php";
	$sample_width = 300;
	$sample_height = 60;
	//return "<A HREF=\"javascript:;\" onClick=\"OpenBrWindow('".$playback_script."?id=".$id."&level=2&instruction=play', 'sample_play', 'scrollbars=no,width=".$sample_width.",height=".$sample_height."')\" >".$display."</A>";
	return "<A HREF=\"javascript:;\" onClick=\"OpenBrWindow('".$playback_script."?id=".$id."&key=".$key."', 'sample_play', 'scrollbars=no,width=".$sample_width.",height=".$sample_height."')\" >".$display."</A>";
}

?>