<?php

// The scripts used in this script
require_once "include/security.php";
require_once "include/database.php";
require_once "include/settings.php";
require_once "include/common.php";


$track_folder = "tracks/"; // The subfolder where tracks are perminately stored after being processed.
$columns = array("title", "artist", "album", "genre", "track", "added"); // The data to display in the main Browse table.  Displayed in order.


/*** form_uploads_meta()

Retreives and pre-processes the meta uploaded via HTTP POST method.
 - Note: This function is paired with meta_to_post(), which are designed to work with each other.

Inputs: None

Returns: An array of associative arrays of the following structure:
  - One associative array for each set of POSTed data.
  - Retreives the data identified in the $meta_types array at the top of the function.

***/
function form_uploads_meta() {
	// The data names to look for in HTTP POST when getting track form data
	$meta_types = array("id", "title", "artist", "album", "genre", "track");

	$upload = array();

	// Is this server inserting magic quotes into the POST results?
	$magic_quotes = get_magic_quotes_gpc();

	// Loop through each track
	for($i = 0; $i < count($_POST[$meta_types[0]]); $i++) {
		$upload[$i] = array();

		// Loop through each data type
		foreach($meta_types as $target) {
			if($magic_quotes) { // Purge magic quotes
				$upload[$i][$target] = choose_data_source(stripslashes($_POST[$target][$i]));
			} else { // Straight copy POST results
				$upload[$i][$target] = choose_data_source($_POST[$target][$i]);
			}
		}

	}

	return $upload;
}


// Connect to the database
dbconn();

$THIS_FILE = $_SERVER["PHP_SELF"];

// The flag for figuring out which feature to run
$do = strtolower(choose_data_source(post_or_null('do'), get_or_null('do')));

// Check to see if this user has admin rights
$is_admin = $session->isAdmin();

// The delete tracks operation - admin reserved
if($do == "details") {
	if(!html_head_secure("Jukebox - Details", "OpenBrWindow")) {
		html_foot();
		exit();
	}
	$id = choose_data_source(post_or_null('id_array'), get_or_null('id'));
	if($id === NULL) {
		die("Error: No tracks indentified.");
	}
	if(!is_array($id)) {
		$id = array($id);
	}
	$id_list = mysql_clean_input(implode(",", $id));
	
	$query = sprintf("SELECT COUNT(*) FROM %s", $audio_tables['tracks']);
	$result = mysql_query($query) or sqlerrorhandler("(" . mysql_errno() . ") " . mysql_error(), $query, $THIS_FILE, __LINE__);
	$row = mysql_fetch_row($result);
	$track_count = $row[0];
	
	// $query = sprintf("SELECT tr.title, tr.artist, tr.album, tr.genre, tr.track, tr.bitrate, tr.playtime, DATE_FORMAT(tr.added,'%%Y-%%m-%%d %%H:%%i') AS added, tr.playcount, us.username, FIND_IN_SET(tr.popularity, rank_list) AS rank FROM %s AS tr LEFT JOIN %s AS us ON us.id = tr.uploader CROSS JOIN (SELECT GROUP_CONCAT(popularity ORDER BY popularity DESC) AS rank_list FROM %s) rank_list WHERE tr.id IN (%s) ORDER BY FIELD(tr.id,%s)", $audio_tables['tracks'], $audio_tables['users'], $audio_tables['tracks'], $id_list, $id_list);
	
	$query = sprintf("SELECT tr.id, tr.title, tr.artist, tr.album, tr.genre, tr.track, tr.bitrate, tr.playtime, DATE_FORMAT(tr.added,'%%Y-%%m-%%d %%H:%%i') AS added, tr.playcount, us.username, rl.rank FROM %s AS tr LEFT JOIN %s AS us ON us.id = tr.uploader LEFT JOIN (SELECT id, @count := @count + 1, @prev := @curr, @curr := popularity, @rank := IF(@prev = @curr, @rank, @count) AS rank FROM %s, (SELECT @curr := null, @prev := null, @rank := 0, @count := 0) sel1 ORDER BY popularity DESC) AS rl ON tr.id = rl.id WHERE tr.id IN (%s) ORDER BY FIELD(tr.id,%s)", $audio_tables['tracks'], $audio_tables['users'], $audio_tables['tracks'], $id_list, $id_list);
	
	$result = mysql_query($query) or sqlerrorhandler("(" . mysql_errno() . ") " . mysql_error(), $query, $THIS_FILE, __LINE__);
	
	if(mysql_num_rows($result) <= 0) {
		die("Error: Query returned no results.");
	}
	
	print("<TABLE ALIGN=\"center\" BORDER=\"1\">\n");
	while($row = mysql_fetch_array($result)) {
		$music_popup = music_popup($row['id'], htmlspecialchars($row['title']));
		$playtime = sprintf("%d:%d", floor($row['playtime']/60), $row['playtime']%60);
		if($row['playcount'] > 0) {
			$rank = sprintf("%d of %d", $row['rank'], $track_count);
		} else {
			$rank = "N/A";
		}
		print <<<END
	<TR><TD>
		<TABLE WIDTH=\"100%\">
			<TR>
				<TD>Title:</TD><TD COLSPAN=3>{$music_popup}</TD>
			</TR>
			<TR>
				<TD>Artist:</TD><TD COLSPAN=3>{$row['artist']}</TD>
			</TR>
			<TR>
				<TD>Album:</TD><TD COLSPAN=3>{$row['album']}</TD>
			</TR>
			<TR>
				<TD>Genre:</TD><TD>{$row['genre']}</TD>
				<TD>Track:</TD><TD>{$row['track']}</TD>
			</TR>
			<TR>
				<TD>Added:</TD><TD>{$row['added']}</TD>
				<TD>Bitrate:</TD><TD>{$row['bitrate']}</TD>
			</TR>
			<TR>
				<TD>Uploader:</TD><TD>{$row['username']}</TD>
				<TD>Duration:</TD><TD>{$playtime}</TD>
			</TR>
			<TR>
				<TD>Rank:</TD><TD>{$rank}</TD>
				<TD>Play count:</TD><TD>{$row['playcount']}</TD>
			</TR>
		</TABLE>
	</TD></TR>

END;
	}
	print("\n\t<TR><TD ALIGN=\"center\"><A HREF=\"" . $THIS_FILE . "\">Back</A></TD></TR>\n");
	print("</TABLE>\n");
} elseif($do == "delete" && $session->userlevel >= UPLOAD_LEVEL) {
	
	// Check user credentials
	if(!html_head_secure("Jukebox - Delete")) {
		html_foot();
		exit();
	}
	
	// Can accept either a single ID or an array of IDs
	$id = choose_data_source(post_or_null('id_array'), get_or_null('id'));
	
	if(!isset($id)) {
		exit();
	}
  
  // If the user has reviewed and confirm deletion
  // if($conf_del == "1") {
	
	// Connect to remote FTP server if it's being used
	if($remote_server_on) {
	
		// Set up and test FTP connection
		$conn =	ftp_connect($ftp_host, $ftp_port) or die("FTP connection to $ftp_host on port $ftp_port failed.");
		if($conn && @ftp_login($conn, $ftp_user, $ftp_pass)) {
			print("FTP connection to $ftp_host successful for user $ftp_user.<BR />\n");
		} else {
			ftp_close($conn);
			print("FTP connection failed.<BR />\n");
			return;
		}

		// Move to Jukebox folder
		if(isset($ftp_subfolder) && $ftp_subfolder != "") {
			if(!ftp_chdir($conn, $ftp_subfolder)) {
				die("Error: Failed to change FTP directory to Jukebox folder (" . $ftp_subfolder . ")!  Current directory name = ".ftp_pwd($conn));
			}
		}
		
	}

	// Put id into an array object if it's not already
	if(!is_array($id)) {
		$id = array($id);
	}

	// Failsafe check to make sure there are entries
	if(count($id) <= 0) {
		print("No targets provided!");
		return;
	}

	// Convert the ID array to a comma delimited string
	$query_id_list = implode(",", $id);

	// Build the query
	$query = sprintf("SELECT id, title, md5, uploader, uploaded FROM %s WHERE ID IN (%s) ORDER BY FIELD(id,%s)", $audio_tables['tracks'], $query_id_list, $query_id_list);
	/*
	$query = "SELECT id, title, HEX(md5) AS md5";
	if($remote_server_on) {
		$query .= ", uploader, uploaded";
	}
	$query .= " FROM " . $audio_tables['tracks'];
	if($remote_server_on) {
		$query .= " LEFT JOIN ".$audio_tables['remote_server']." ON id = track_id";
	}
	$query .= " WHERE id IN (" . $query_id_list . ") ORDER BY FIELD(id," . $query_id_list . ")";
	*/
	
	// Execute the query
	$result = mysql_query($query) or sqlerrorhandler("(" . mysql_errno() . ") " . mysql_error(), $query, $THIS_FILE, __LINE__);
	
	// Abort if nothing was found
	if(mysql_num_rows($result) <= 0) {
		print("No search results returned!<BR />\n");
		return;
	}

	// Files that are successfully deleted are tracked in this array
	$delete_list = array();
	
	// Loop through and delete the actual files - not the database entries quite yet
	while($row = mysql_fetch_array($result)) {
		if(!$session >= ADMIN_LEVEL && ($session < UPLOAD_LEVEL || $row['uploader'] != $session->id)) {
			print("Warning: You don't have permission to delete '" . $row['title'] . "' (entry ID" . $row['id'] . ")<BR />\n");
			continue;
		}
		$md5 = $row['md5']; // enforce lowercase (for Unix systems)
		
		// If the track is on the remote server, then delete it from there
		if($remote_server_on && $row['uploaded']) {
			
			// Move to the target folder (from the md5 hash)
			for($i = 0; $i < $folder_depth; $i++) {
				if(!ftp_chdir($conn, $md5[$i])) {
					ftp_close($conn);
					print("Error: Browing to folder '".$md5[$i]."' for track '".$row['title']."', md5 '".$md5." failed!<BR />\n");
					continue 2;
				}
			}
			
			// Attempt to delete, pass on if failed
			if(!ftp_delete($conn, $md5.".mp3")) {
				ftp_close($conn);
				print("Error: Failed to delete file ".$md5.".mp3!<BR />\n");
				continue;
			}
			
			// Move back to the top folder
			for($i = 0; $i < $folder_depth; $i++) {
				if(!ftp_cdup($conn)) {
					ftp_close($conn);
					print("Error: Failed to return to file server root directory!<BR />\n");
					continue 2;
				}
			}

		// If the track is hosted locally...
		} else {
			$target_folder = $track_folder;
			for($i = 0; $i < $folder_depth; $i++) {
				$target_folder .= $md5[$i]."/";
			}
			
			// Attempt to delete
			if(!unlink($target_folder.$md5.".mp3")) {
				print("File deletion failed!<BR />\n");
				continue;
			}
			
		}
		
		// Report successful deletion
		print($row['title']." deletion complete.<BR />\n");
		
		// Add file deletion to list
		$delete_list[] = $row['id'];
	}
	
	// Remove deleted tracks from the database
	if(count($delete_list) > 0) {
		$query_id_list = implode (",", $delete_list);
		
		// Build query
		$query = sprintf("DELETE FROM %s WHERE id IN (%s)", $audio_tables['tracks'], $query_id_list);
		
		// Execute query
		mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);
		
		print("Deleted files have been removed from the database.<BR />\n");
	}
	
	print("<BR />\n<A HREF=\"".$THIS_FILE."\">Continue</A><BR />\n");
	
	/*
	// Confirm the deletions
	} elseif($id) {
		
		// Put id in array if it's not already
		if (!is_array($id)) {
			$id = array($id);
		}
		
		// The list of target tracks
		$query_id_list = implode(",", $id);
		
		// The data to show when confirming the deletion
		$select_list = implode(", ", $columns);
		
		// Build the query
		$query = "SELECT id, ".$select_list." FROM ".$audio_tables['tracks']." WHERE id IN(".$query_id_list.") ORDER BY FIELD(id,".$query_id_list.")";
		
		// Execute query
		$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);

		// Begin displaying targeted tracks
		print("Confirm deletions...<BR />\n");

		print("<FORM NAME=\"library_list\" ID=\"library_list\" ACTION=\"".$THIS_FILE."\" METHOD=\"post\">\n");
		print("<INPUT TYPE=\"hidden\" NAME=\"do\" VALUE=\"delete\">\n");
		print("<INPUT TYPE=\"hidden\" NAME=\"conf_del\" VALUE=\"1\">\n");
		print("<TABLE BORDER=\"1\" WIDTH=\"100%\">\n\t<TR WIDTH=\"100%\">\n");
		
		// Draw the table titles
		foreach($columns as $target) {
			print("\t\t<TH>".ucfirst($target)."</TH>\n");
		}
		print("\t</TR>\n");

		// Loop through the track results
		while($row = mysql_fetch_array($result)) {
			print("\t<TR WIDTH=\"100%\">\n");
			print("\t\t<INPUT TYPE=\"hidden\" NAME=\"id_array[]\" VALUE=\"".$row['id']."\" /></TD>\n");
			foreach($columns as $target) {
				print("\t\t<TD ALIGN=\"center\">".$row[$target]."</TD>\n");
			}
			print("\t</TR>\n\n");
		}
		print("</TABLE>\n\n");

		print("<FORM ACTION=\"".$THIS_FILE."\" METHOD=\"post\">\n");
		print("<BUTTON TYPE=\"submit\">Confirm</BUTTON><BR />\n");
		print("</FORM>\n");
		
	}
	*/
	
// Edit track metadata
} elseif($do == "edit" && $session->userlevel >= UPLOAD_LEVEL) {
	
	// The maximum data lengths for each type
	$type_lengths = array("title"=>80, "artist"=>80, "album"=>80, "genre"=>80, "track"=>3);
	$meta_types = array("id", "title", "artist", "album", "genre", "track");
	
	// Check user credentials and show top menu
	if(!html_head_secure("Jukebox - Edit")) {
		html_foot();
		exit;
	}
	
	$id = choose_data_source(post_or_null('id_array'), get_or_null('id'));
	$conf_edit = post_or_null('conf_edit');
	
	// If user has submitted changes
	if($conf_edit == 1) {
		
		// Retreive metadata from HTTP POST
		$track_meta = form_uploads_meta();
		$all_targets = post_or_null('all_targets');
		
		foreach($all_targets as $target) {
			$for_all = post_or_null("all_" . $target);
			foreach($track_meta as $key => $track) {
				$track_meta[$key][$target] = $for_all;
			}
		}
		
		// Loop through tracks
		foreach ($track_meta as $item) {
			
			// If not admin, confirm this was submitted by the original uploader
			if($session->userlevel < ADMIN_LEVEL) {
				$query = "SELECT uploader FROM " . $audio_tables['tracks'] . " WHERE id = " . mysql_clean_input($item['id']);
				$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);
				$row = mysql_fetch_array($result);
				if($row['uploader'] != $session->id) {
					print("Warning: You do not have permission to edit Entry #" . $item['id'] . ".  It is being skipped.<BR />\n");
					continue;
				}
			}
			
			// Build update query
			$query = "UPDATE " . $audio_tables['tracks'] . " SET";
			$multiple = FALSE;
			foreach($meta_types as $type) {
				if($type !== "id") {
					if ($multiple) {
						$query .= ",";
					} else {
						$multiple = TRUE;
					}
					$query .= " " . $type . " = '" . mysql_clean_input($item[$type]) . "'";
				}
			}
			$query .= " WHERE id = " . mysql_clean_input($item['id']);

			// Execute query
			mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);

			print("Updated track \"" . $item['title'] . "\".<BR />\n");
		}

		// Close up message
		print("<BR />Editing complete!<BR />\n");
		print("<BR />\n<A HREF=\"".$THIS_FILE."\">Continue</A><BR />\n");

	// Generate metadata editing form
	} elseif($id) {
		$all_types = array("album", "artist", "genre");
		
		// Put id in array if it's not
		if(!is_array($id)) {
			$id = array($id);
		}
		
		$all_entries = array();
		foreach($all_types as $target) {
			$all_entries[$target] = NULL;
		}

		// Put target array into comma-delimited list
		$query_id_list = implode(",", $id);

		// Build query
		$query = "SELECT id, uploader, " . implode(", ", $columns) . " FROM " . $audio_tables['tracks'] . " WHERE id IN (" . $query_id_list . ") ORDER BY FIELD(id," . $query_id_list . ")";
		
		// Execute query
		$results = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);
		
		// Begin form generation
		print("<FORM NAME=\"library_list\" ID=\"library_list\" ACTION=\"".$THIS_FILE."\" METHOD=\"post\">\n");
		print("<INPUT TYPE=\"hidden\" NAME=\"conf_edit\" VALUE=\"1\">\n");
		print("<INPUT TYPE=\"hidden\" NAME=\"do\" VALUE=\"edit\">\n");
		print("<TABLE ALIGN=\"center\" BORDER=\"1\">\n");
		
		$edit_count = 0;

		// Loop through track entries
		while($row = mysql_fetch_array($results)) {
			
			// If user does not have permission to edit this track, then skip it
			if(!$session >= ADMIN_LEVEL && ($session < UPLOAD_LEVEL || $row['uploader'] != $session->id)) {
				continue;
			}
			
			foreach($all_entries as $key => $entry) {
				if($entry === NULL) { // If this is the first track to be considered then populate the fields
					$all_entries[$key] = $row[$key];
				} elseif($entry !== "" && $entry != $row[$key]) { // If this track doesn't match the "change all of type" field, then clear it
					$all_entries[$key] = "";
				}
			}
			
			print("\t<TR><TD><TABLE WIDTH=\"100%\">\n");
			print("\t<INPUT TYPE=\"hidden\" NAME=\"id[]\" VALUE=\"" . $row['id'] . "\">\n");
			
			// Loop through each data type's field for the track entry
			foreach($columns as $target) {
				print("\t<TR>\n");
				print("\t\t<TD>\n\t\t\t" . ucfirst($target) . ":\n\t\t</TD>\n");
				print("\t\t<TD>\n\t\t\t<INPUT TYPE=\"text\" SIZE=\"" . $type_lengths[$target] . "\" MAXLENGTH=\"" . $type_lengths[$target] . "\" NAME=\"". $target . "[]\" VALUE=\"" . $row[$target] . "\" />\n\t\t</TD>\n");
				print("\t</TR>\n");
			}

			print("\t</TABLE>\n");
			print("\t</TD></TR>\n");
			
			$edit_count++;
		}
		
		// "Settings for all" block
		if($edit_count > 1) { // Only display if there are multiple tracks
			print("<TR><TD COLSPAN=\"2\"><TABLE>\n");
			print("\t<TR>\n\t\t<TH COLSPAN=\"2\">");
			print("\t\t\tChange settings for all uploads...");
			print("</TH>\n\t</TR>\n");
	
			foreach($all_types as $type) {
				print("\t<TR>\n\t\t<TD ALIGN=\"center\">\n");
				print("\t\t\t\t<INPUT TYPE=\"checkbox\" NAME=\"all_targets[]\" VALUE=\"" . $type . "\" />\n");
				print("\t\t\t\t " . ucfirst($type) . ":\n\t\t\t</TD>\n");
				print("\t\t\t<TD>\n\t\t\t\t<INPUT TYPE=\"text\" SIZE=\"" . $type_lengths[$type] . "\" MAXLENGTH=\"" . $type_lengths[$type] . "\" NAME=\"all_" . $type ."\" VALUE=\"".$all_entries[$type]."\">\n");
				print("\t\t</TD>\n\t</TR>\n");
			}
			print("</TABLE></TD></TR>\n");
		}
		
		// Close up form
		print("\t<TR><TD ALIGN=\"center\" width=\"100%\">\n");
		print("\t\t<INPUT TYPE=\"reset\" VALUE=\"Reset\" />\n");
		print("\t\t<INPUT TYPE=\"submit\" VALUE=\"Continue\" />\n");
		print("\t</TD></TR>\n");

		print("</TABLE>\n");
		print("</FORM>\n");

	}

// The main database browser and the default page of the Browse script
} else {

	// Define data types in table
	// $columns = array("title", "artist", "album", "genre", "track"); // Data to display for each entry
	
	// An array of arrays - operation, user level flag, owner_allowed flag
	$functions = array(
			array("details", USER_LEVEL, "information.png"),
			array("edit", ADMIN_LEVEL, "table_edit.png"),
			array("delete", ADMIN_LEVEL, "delete.png", "Delete selected tracks from library?")
		); // Available functions

	// Sorting, filtering and searching data, which is passed on via HTTP POST
	$result_count = choose_data_source(get_or_null('page_count'), 50);
	$result_count_start = choose_data_source(post_or_null('page_count_start'), 0);
	$order = choose_data_source(get_or_null('order'), post_or_null('order'));
	$order_dir = choose_data_source(get_or_null('order_dir'), post_or_null('order_dir'));
	$search_string = choose_data_source(post_or_null('search'), get_or_null('search'));
	$last_search_string = choose_data_source(post_or_null('last_search'), "");
	$search_target = post_or_null('search_target');
	
	// Replaces the +'s in the query with spaces
	if($search_string) {
		$search_string = str_replace(" ", "+", $search_string);
	}
	
	// If the user provides a new search term, reset the sorting and pagination
	if($search_string != $last_search_string) {
		$result_count_start = 0;
	}
	
	// Build where string
	if($search_string) {
		
		// Build the "where" items into an array, then implode them
		$where_list = array();
		
		// If the search targets are not defined, just search all the display columns
		if(is_array($search_target)) {
			$where_types = $search_target;
		} else {
			$where_types = $columns;
		}
		
		// Build array
		foreach($where_types as $target) {
			$where_list[] = $target." LIKE '%".str_replace("+", "%", mysql_clean_input($search_string))."%'";
		}
		
		// Build where string
		$where = " WHERE " . implode(" OR ", $where_list);
		
	} else {
		
		$where = "";
		
	}
	
	
	// CLEAN THIS UP - too easy to inject code here
	// Build query string
	$query = sprintf("SELECT id, uploader, %s FROM %s%s ORDER BY %s%s LIMIT %s,%s",
			implode(", ", $columns),
			$audio_tables['tracks'],
			$where,
			($order) ? (mysql_clean_input($order)) : ($columns[0]),
			($order_dir) ? (" " . mysql_clean_input($order_dir)) : (""),
			mysql_clean_input($result_count_start),
			mysql_clean_input($result_count)
		);

	// Execute string
	$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);


	// Check user credentials
	if(!html_head_secure("Jukebox - Browse Library", "OpenBrWindow", "MarkAllRows", "FillCheckbox", "AddAndGo")) {
		html_foot();
		exit();
	}

	// The search field
	print("<FORM NAME=\"library_search\" ID=\"library_search\" ACTION=\"".$THIS_FILE."\" METHOD=\"post\">\n");
	print("<INPUT TYPE=\"hidden\" NAME=\"last_search\" VALUE=\"" . $search_string . "\">\n");
	if($order) {
		print("<INPUT TYPE=\"hidden\" NAME=\"order\" VALUE=\"" . $order . "\">\n");
	}
	if($order_dir) {
		print("<INPUT TYPE=\"hidden\" NAME=\"order_dir\" VALUE=\"" . $order_dir . "\">\n");
	}
	print("<TABLE ALIGN=\"center\">\n");
	print("\t<TR>\n\t\t<TD COLSPAN=\"" . (count($columns)+3) . "\">Search: <INPUT TYPE=\"text\" NAME=\"search\" SIZE=\"100\" MAXLENGTH=\"200\"");
	if($search_string) {
		print(" VALUE=\"" . str_replace("+", " ", $search_string) . "\"");
	}
	print("></TD>\n\t</TR>\n");
	print("\t<TR>\n");


	// Build page list
	
	// Page list query
	$query = sprintf("SELECT COUNT(*) FROM %s%s", $audio_tables['tracks'], $where);
	
	// Execture query
	$count_result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $THIS_FILE, __LINE__);
	
	// Figure out page count and current page from the number of results
	$total_count = mysql_fetch_array($count_result);
	$total_count = $total_count[0];
	$page_count = (int) ceil($total_count / $result_count);
	$this_page = (int) ceil(($result_count_start+1) / $result_count);
	
	// Generate the drop-down form item
	print("\t\t<TD>Page: <SELECT NAME=\"page_count_start\" OnChange=\"document.library_search.submit();\">\n");
	for($i = 1; $i <= $page_count; $i++) {
		printf("\t\t\t<OPTION VALUE=\"%s\"%s>%s</OPTION>\n", ($i-1)*$result_count, ($i == $this_page) ? (" SELECTED=\"selected\"") : (""), $i);
	}
	print("\t\t</SELECT></TD>\n");

	// Build the search target toggles
	$search_target_count = 0;
	foreach($columns as $target) {
		print("\t\t<TD><INPUT TYPE=\"checkbox\" NAME=\"search_target[]\" VALUE=\"".$target."\"");
		if(!isset($search_target) || $search_target == NULL || (isset($search_target[$search_target_count]) && $search_target[$search_target_count] == $target)) {
			print(" CHECKED=\"checked\"");
			$search_target_count++;
		}
		print(">".ucfirst($target)."</TD>\n");
	}
	
	// Check/Uhcheck all toggles
	print("\t\t<TD><A HREF=\"javascript:;\" onClick=\"markAllRows('library_search','td');\">Check All</A>\n \t\t/ \t\t\n<A HREF=\"javascript:;\" onClick=\"unMarkAllRows('library_search','td');\">Uncheck All</A></TD>\n");
	
	// Search submit and form close
	print("\t\t<TD><BUTTON TYPE=\"submit\">Search</BUTTON></TD>\n");
	print("\t</TR>\n</TABLE>\n</FORM>\n\n");

	// Check for results
	if(mysql_num_rows($result) <= 0) {
		$last_url = post_or_null('last_url');
		print("No results!<BR />\n");
		if($last_url) {
			print("<A HREF=\"".$last_url."\">Go Back</A><BR />\n");
		} else {
			print("<A HREF=\"javascript:;\" onClick=\"history.go(-1);return true;\">Go Back</A><BR />\n");
		}
		html_foot();
		return;
	}
	
	// Determine if this user uploaded any of the tracks appearing on this page
	if($session->userlevel >= UPLOAD_LEVEL && $session->userlevel < ADMIN_LEVEL) {
		if(isset($where) && strlen($where) > 0) {
			$where .= " AND";
		} else {
			$where = " WHERE";
		}
		$where .= " uploader = " . $session->id;
		$query_buttons = sprintf("SELECT COUNT(*) AS uploader_count FROM %s%s LIMIT %s,%s",
				$audio_tables['tracks'],
				$where,
				mysql_clean_input($result_count_start),
				mysql_clean_input($result_count)
			);
		$result_buttons = mysql_query($query_buttons) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query_buttons, $THIS_FILE, __LINE__);
		$row_buttons = mysql_fetch_array($result_buttons);
		$uploader_test = ($row_buttons['uploader_count'] > 0);
	} else {
		$uploader_test = FALSE;
	}

	// Results table
	print("<FORM NAME=\"library_list\" ID=\"library_list\" ACTION=\"".$THIS_FILE."\" METHOD=\"post\">\n");
	print("<DIV ID=\"dynamic_input\">\n</DIV>\n");

	// Fill Checkboxes code borrowed from PHPMyAdmin
	$control_buffer = "<A HREF=\"javascript:;\" onClick=\"markAllRows('library_list','tr');\">Check All</A>\n / \n<A HREF=\"javascript:;\" onClick=\"unMarkAllRows('library_list','tr');\">Uncheck All</A>\n";
	$control_buffer .= "<I>With selected:</I>\n";
	
	// Add the buttons for each operation
	foreach($functions as $target) {
		if($uploader_test || $session->userlevel >= $target[1]) {
			// $control_buffer .= "<BUTTON TYPE=\"submit\" name=\"do\" value=\"" . $target[0] . "\" />" . ucfirst($target[0]) . "</BUTTON>\n";
			$control_buffer .= sprintf("<INPUT TYPE=\"image\" SRC=\"graphics/icons/%s\" ALT=\"%s\"%s NAME=\"do\" VALUE=\"%s\" />\n",
					$target[2],
					ucfirst($target[0]),
					(isset($target[3])) ? (" onClick=\"" . $target[3] . "\"") : (""),
					$target[0]
				);
		}
	}
	print($control_buffer);
	
	// Start of displayed data table
	print("<TABLE BORDER=\"1\" WIDTH=\"100%\">\n\t<TR WIDTH=\"100%\">\n\t\t<TH></TH>\n");

	// The base URL that goes into the form sorting URLs
	$header_url = $THIS_FILE."?";
	if($search_string) {
		$header_url .= "search=" . $search_string . "&";
	}
	
	// Build the form column headings, with sort URLs
	foreach($columns as $target) {
		// If this column is the current sorted one, toggle the sort direction
		if($order == $target && $order_dir != "DESC") {
			$target_order_dir = "DESC";
		} else {
			$target_order_dir = "ASC";
		}
		
		// Display
		print("\t\t<TH><A HREF=\"".$header_url."order=".$target."&order_dir=".$target_order_dir);
		print("\">".ucfirst($target)."</A></TH>\n");
	}
	
	// The functions column heading
	print("\t\t<TH COLSPAN=\"".count($functions)."\">Functions</TH>\n");
	print("\t</TR>\n");
	
	$item_count = 0;

	// Loop through each track's data set
	while($row = mysql_fetch_array($result)) {
		print("\t<TR>\n");
		print("\t\t<TD><INPUT TYPE=\"checkbox\" NAME=\"id_array[]\" ID=\"frm_box_" . $item_count . "\" VALUE=\"".$row['id']."\" /></TD>\n");
		$first_column = TRUE; // The first column will include a playback URL
		
		// Loop through each column for the track
		foreach($columns as $target) {
			print("\t\t<TD ALIGN=\"center\">");
			if($first_column) {
				print(music_popup($row['id'], htmlspecialchars($row[$target])));
				$first_column = FALSE;
			} else {
				print($row[$target]);
			}
			print("</TD>\n");
		}
		
		// Display the function links
		print("\t\t<TD ALIGN=\"center\" NOWRAP=\"nowrap\">\n");
		foreach($functions as $target) {
			if($session->userlevel >= $target[1] || ($session->userlevel >= UPLOAD_LEVEL && $row['uploader'] == $session->id)) {
				// print("\t\t\t<A HREF=\"".$THIS_FILE."?do=" . $target[0] . "&id=".$row['id']."\">".ucfirst($target[0])."</A>&nbsp;\n");
				// print("\t\t\t<A HREF=\"".$THIS_FILE."?do=" . $target[0] . "&id=".$row['id']."\"><IMG SRC=\"graphics/icons/" . $target[2] . "\" BORDER=\"0\" ALT=\"" . ucfirst($target[0])."\"></A>&nbsp;\n");
				printf("\t\t\t<A HREF=\"javascript:;\" onClick=\"unMarkAllRows('library_list','tr');FillCheckbox('frm_box_%d');AddAndGo('library_list','dynamic_input','do','%s'%s);\"><IMG SRC=\"graphics/icons/%s\" ALT=\"%s\" /></A>\n",
					$item_count,
					$target[0],
					(isset($target[3])) ? (",'" . $target[3] . "'") : (""),
					$target[2],
					ucfirst($target[0])
				);
			}
		}
		print("\t</TR>\n\n");
	}
	print("</TABLE>\n\n");

	// Repeat the Fill Checkboxes feature
	print($control_buffer);

	print("</FORM><BR />\n\n");
	
	$item_count++;
}

html_foot();
?>
