<?php

// Jukebox SQL database upgrade script
// Run this script until it reports it is complete.
// This script will take a long time to run on a large database.  If you have MP3s on the Remote File Server, it will take even longer.  Your browser will keep trying to load the page, like it has stalled, until the script is complete.  Be patient, and do not interrupt your web browser while the script is running.

require_once("include/settings.php");
require_once("include/database.php");
require_once("include/getid3/getid3.php"); // The 3rd-party script that looks up track meta data

define("TRACKS_DIR", "tracks/");

dbconn();

$query = sprintf("SHOW COLUMNS FROM %s", $audio_tables['tracks']);
$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);

$start_time = time();

$playtime_int_test = false;
$playtime_float_test = false;
$playtime_temp_test = false;
$uploaded_test = false;
$latest_time_test = false;
$md5_binary_test = false;
$md5_string_test = false;
$md5_temp_test = false;
while($row = mysql_fetch_array($result)) {
	if($row['Field'] == "playtime") {
		if($row['Type'] == "smallint(5) unsigned") {
			$playtime_int_test = true;
		} elseif($row['Type'] == "float unsigned") {
			$playtime_float_test = true;
		}
	} elseif($row['Field'] == "playtime_temp") {
		$playtime_temp_test = true;
	} elseif($row['Field'] == "uploaded") {
		$uploaded_test = true;
	} elseif($row['Field']  == "md5") {
		if($row['Type'] == "varchar(16)") {
			$md5_binary_test = true;
		} elseif($row['Type'] = "varchar(32)") {
			$md5_string_test = true;
		}
	} elseif($row['Field'] == "md5_temp") {
		$md5_temp_test = true;
	}
}

$query = sprintf("SHOW COLUMNS FROM %s", $audio_tables['streams']);
$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
while($row = mysql_fetch_array($result)) {
	if($row['Field'] == "latest_time") {
		$latest_time_test = true;
	}
}

if(!$uploaded_test) {
	print("Merging remote_transfer records with main tracks table.<BR />\n");
	$query = sprintf("ALTER TABLE %s ADD `uploaded` BOOL NOT NULL DEFAULT '0' AFTER `popularity`", $audio_tables['tracks']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	
	$query = sprintf("SELECT `track_id`, `uploaded` FROM %s", $audio_tables['remote_server']);
	$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	
	while($row = mysql_fetch_array($result)) {
		$query = sprintf("UPDATE %s SET `uploaded` = %d WHERE `id` = %d", $audio_tables['tracks'], $row['uploaded'], $row['track_id']);
		mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	}
	
	$query = sprintf("DROP TABLE %s", $audio_tables['remote_server']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
}

if($latest_time_test) {
	$query = sprintf("ALTER TABLE %s DROP latest_time", $audio_tables['streams']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
}


if(!$playtime_float_test && !$playtime_temp_test) {
	print("Preparing temporary playtime column for re-calculation.<BR />\n");
	$query = sprintf("ALTER TABLE %s ADD `playtime_temp` FLOAT UNSIGNED NOT NULL DEFAULT '0' AFTER `playtime`", $audio_tables['tracks']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	$playtime_temp_test = true;
}

if(!$md5_string_test && !$md5_temp_test) {
	printf("Preparing temporary md5 column for type casting.<BR />\n");
	$query = sprintf("ALTER TABLE %s ADD `md5_temp` VARCHAR(32) NOT NULL AFTER `md5`", $audio_tables['tracks']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	$md5_temp_test = true;
}

if($md5_binary_test && $md5_temp_test) {
	print("Execute md5 type casting from binary to hexadecimal string.<BR />\n");
	$query = sprintf("SELECT `id`, LOWER(HEX(`md5`)) AS `md5` FROM %s", $audio_tables['tracks']);
	$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	while($row = mysql_fetch_array($result)) {
		$query = sprintf("UPDATE %s SET `md5_temp` = '%s' WHERE `id` = %d", $audio_tables['tracks'], $row['md5'], $row['id']);
		mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	}
	
	$query = sprintf("ALTER TABLE %s DROP COLUMN `md5`", $audio_tables['tracks']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	
	$query = sprintf("ALTER TABLE %s CHANGE `md5_temp` `md5` VARCHAR(32) NOT NULL", $audio_tables['tracks']);
	mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
}

if($playtime_float_test && !$playtime_temp_test) {
	die("This SQL upgrade script has already been applied!  Aborting...");
}

$query = sprintf(
	"SELECT `id`, `title`, `md5`, `uploaded` FROM %s WHERE `playtime_temp` < 0.1 ORDER BY `id`",
		$audio_tables['tracks']
	);
$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);

if(mysql_num_rows($result) > 0) {
	print("Performning playtime re-calculation.  This will take awhile...<BR />\n");
	print("<B></U>IMPORTANT:</U></B> If this script ends abrubtly without reporting that the upgrade script completed, please refresh your browser in order to continue the upgrade process.<BR />\n");
	$getID3 = new getID3;
	
	while($row = mysql_fetch_array($result)) {
		set_time_limit(120);
		$track_subfolders = "";
		for($i = 0; $i < $folder_depth; $i++) {
			$track_subfolders .= $row['md5'][$i] . "/";
		}
		if($row['uploaded']) {
			$remote_file = "ftp://" . $ftp_user . ":" . $ftp_pass . "@" . $ftp_host . "/" . $ftp_subfolder . $track_subfolders . $row['md5'] . ".mp3";
			$target_file = "temp/test_" . $row['id'] . ".mp3";
			$copy_attempts = 0;
			do {
				$copy_attempts++;
				copy($remote_file, $target_file);
			} while(!is_file($target_file) && $copy_attempts <= 2);
			if(!is_file($target_file)) {
				die(sprintf("Failed to copy file %s to to %s", $remote_file, $target_file));
			}
		} else {
			$target_file = TRACKS_DIR . $track_subfolders . $row['md5'] . ".mp3";
		}
		
		printf("Updating '%s' of ID #%d...", $row['title'], $row['id']);
		if(!is_file($target_file)) {
			die(sprintf("File %s does not exist!", $target_file));
		}

		$track_info = $getID3->analyze($target_file);
		if($row['uploaded']) {
			unlink($target_file);
		}
		getid3_lib::CopyTagsToComments($track_info);
		$track_info['playtime_seconds'];
		
		$query = sprintf("UPDATE %s SET `playtime_temp` = %f WHERE `id` = %d", $audio_tables['tracks'], $track_info['playtime_seconds'], $row['id']);
		mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
		print("complete!<BR />\n");
	}
}

if(!$playtime_float_test && $playtime_temp_test) {
	print("<BR />Re-check complete, copying over new playtime data.<BR />\n");
	$query = sprintf(
		"SELECT `id` FROM %s WHERE `playtime_temp` < 0.1 ORDER BY `id` LIMIT 1",
			$audio_tables['tracks']
		);
	$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	
	if(1 || mysql_num_rows($result) == 0) {
		$query = sprintf("ALTER TABLE %s DROP COLUMN `playtime`", $audio_tables['tracks']);
		mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
		
		$query = sprintf("ALTER TABLE %s CHANGE `playtime_temp` `playtime` FLOAT UNSIGNED NOT NULL", $audio_tables['tracks']);
		mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	}
}

$end_time = time();

printf("<BR />Upgrade script complete!  Operation took %d seconds.<BR />\n", $end_time - $start_time);

?>
