<?php

// query.php - Jukebox's main playback script

// Last updated 2011-08-14 for release 0.5.5.0

define("PLAYLIST_MAX", 100);
define("VOLUME_DEF", 80);

define("TRACK_DIR", "/tracks");  // The subfolder where tracks are perminately stored after being processed.

require_once "include/database.php";
require_once "include/settings.php";
require_once "include/common.php";
require_once "include/class.rc4crypt.php";

dbconn();


function check_key($password, $crypt_b64) {
	$time_margin = 3600;
	if(!$crypt_b64) {
		print("DEBUG: Time = " . time() . ", key not provided.<BR />\n");
		return false;
	}
	$decrypt = unpack("l1", rc4crypt::decrypt($password, pack("H*", $crypt_b64)));
	$decrypt = $decrypt[1];
	if (!is_numeric($decrypt)) {
		print("DEBUG: Time = " . time() . ", decrypted string = " . $decrypt . " - non-numeric<BR />\n");
		return false;
	}
	if(abs(time() - $decrypt) <= $time_margin) {
		return true;
	} else {
		print("DEBUG: Time = " . time() . ", decrypted string = " . $decrypt . " - bad match, difference = " . (time() - $decrypt) . "<BR />\n");
		return false;
	}
}


function hexbin($str_hex) {
  $str_bin = FALSE;
  for ($i=0; $i < strlen($str_hex); $i++) {
    $str_bin .= sprintf("%04s", decbin(hexdec($str_hex[$i])));
  }
  return $str_bin;
}


// Generate MySQL audio query
function audio_query() {
	global $audio_tables, $remote_server_on, $leech_pass;
	
	if(!check_key($leech_pass, get_or_null("key"))) {
		die("Leech protection: Credentials rejected.</BR>\n");
	}
	
	$id_list = get_or_null("id_list");
	$id_base64 = get_or_null("id_b64");
	$stream_id = get_or_null("sid");
	$id = get_or_null("id");
	
	if($stream_id) {
		$query = sprintf("SELECT pl.track_id FROM %s AS pl INNER JOIN %s AS st USING (stream_id) WHERE st.stream_id = %d AND pl.sequence >= st.now_playing ORDER BY pl.sequence", $audio_tables['playlists'], $audio_tables['streams'], mysql_clean_input($stream_id));
		$result = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
		$id_array = array();
		while($row = mysql_fetch_row($result)) {
			$id_array[] = $row[0];
		}
		$id_list = implode(",", $id_array);
	} elseif($id_list) {
		$id_list = mysql_clean_input($id_list);
	}	elseif ($id_base64) {
		$id_temp = base64url_decode($id_base64);
		$id_array = unpack("n*", $id_temp);
		$id_list = implode(",", $id_array);
		// print("Base64 hash = " . $id_base64 . ", id temp = " . $id_temp . ", id list = " . $id_list . "<BR />\n");// DEBUG
	} elseif ($id) {
		$id_list = mysql_clean_input($id);
	}
	
	if(!$id_list) {
		die("Error: No track ID numbers were provided.<BR />\n");
	}
	
	$query = sprintf("SELECT id, md5, uploaded, title, album, artist FROM %s WHERE id IN (%s) ORDER BY FIELD(id,%s) LIMIT %s",
			$audio_tables['tracks'],
			$id_list,
			$id_list,
			PLAYLIST_MAX
		);
	
	// Generate query results
	$result = array();
	$temp = mysql_query($query) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query, $_SERVER['PHP_SELF'], __LINE__);
	while($row = mysql_fetch_array($temp)) {
		$result[] = $row;
	}
	
	return $result;
}


function music_time($query, $volume = 80, $position = 0.0) {
	global $folder_depth, $remote_server_on, $file_server_url, $audio_tables;
	
	$local_tracks = "http://" . $_SERVER['SERVER_NAME'] . dirname($_SERVER['SCRIPT_NAME']) . TRACK_DIR . "/";
	if($remote_server_on && substr($file_server_url, -1) != "/") {
		$file_server_url .= "/";
	}
	
	if($volume > 100) {
		$volume = 100;
	} elseif ($volume < 0) {
		$volume = 0;
	}
	
	print <<<PR_END
<html>
<head>
	<link type="text/css" href="include/jplayer/jplayer.blue.monday.css" rel="stylesheet" />
	<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.4/jquery.min.js"></script>
	<script type="text/javascript" src="include/jplayer/jquery.jplayer.jb.js"></script>
	
  <script>
	$(document).ready(function() {
		var Playlist = function(instance, playlist, options) {
			var self = this;

			this.instance = instance; // String: To associate specific HTML with this playlist
			this.playlist = playlist; // Array of Objects: The playlist
			this.options = options; // Object: The jPlayer constructor options for this playlist

			this.current = 0;

			this.cssId = {
				jPlayer: "jquery_jplayer_",
				interface: "jp_interface_",
				playlist: "jp_playlist_"
			};
			this.cssSelector = {};

			$.each(this.cssId, function(entity, id) {
				self.cssSelector[entity] = "#" + id + self.instance;
			});

			if(!this.options.cssSelectorAncestor) {
				this.options.cssSelectorAncestor = this.cssSelector.interface;
			}

			$(this.cssSelector.jPlayer).jPlayer(this.options);

			$(this.cssSelector.interface + " .jp-previous").click(function() {
				self.playlistPrev();
				$(this).blur();
				return false;
			});

			$(this.cssSelector.interface + " .jp-next").click(function() {
				self.playlistNext();
				$(this).blur();
				return false;
			});
		};

		Playlist.prototype = {
			displayPlaylist: function() {
				var self = this;
				$(this.cssSelector.playlist + " ul").empty();
				for (i=0; i < this.playlist.length; i++) {
					var listItem = (i === this.playlist.length-1) ? "<li class='jp-playlist-last'>" : "<li>";
					listItem += "<a href='#' id='" + this.cssId.playlist + this.instance + "_item_" + i +"' tabindex='1'>"+ this.playlist[i].name +"</a>";

					// Create links to free media
					if(this.playlist[i].free) {
						var first = true;
						listItem += "<div class='jp-free-media'>(";
						$.each(this.playlist[i], function(property,value) {
							if($.jPlayer.prototype.format[property]) { // Check property is a media format.
								if(first) {
									first = false;
								} else {
									listItem += " | ";
								}
								listItem += "<a id='" + self.cssId.playlist + self.instance + "_item_" + i + "_" + property + "' href='" + value + "' tabindex='1'>" + property + "</a>";
							}
						});
						listItem += ")</span>";
					}

					listItem += "</li>";

					// Associate playlist items with their media
					$(this.cssSelector.playlist + " ul").append(listItem);
					$(this.cssSelector.playlist + "_item_" + i).data("index", i).click(function() {
						var index = $(this).data("index");
						if(self.current !== index) {
							self.playlistChange(index);
						} else {
							$(self.cssSelector.jPlayer).jPlayer("play");
						}
						$(this).blur();
						return false;
					});

					// Disable free media links to force access via right click
					if(this.playlist[i].free) {
						$.each(this.playlist[i], function(property,value) {
							if($.jPlayer.prototype.format[property]) { // Check property is a media format.
								$(self.cssSelector.playlist + "_item_" + i + "_" + property).data("index", i).click(function() {
									var index = $(this).data("index");
									$(self.cssSelector.playlist + "_item_" + index).click();
									$(this).blur();
									return false;
								});
							}
						});
					}
				}
			},
			playlistInit: function(autoplay, position) {
				if(autoplay) {
					this.playlistChange(this.current, position);
				} else {
					this.playlistConfig(this.current);
				}
			},
			playlistConfig: function(index) {
				$(this.cssSelector.playlist + "_item_" + this.current).removeClass("jp-playlist-current").parent().removeClass("jp-playlist-current");
				$(this.cssSelector.playlist + "_item_" + index).addClass("jp-playlist-current").parent().addClass("jp-playlist-current");
				this.current = index;
				$(this.cssSelector.jPlayer).jPlayer("setMedia", this.playlist[this.current]);
			},
			playlistChange: function(index, position) {
				position = typeof(position) != 'undefined' ? position : 0.0;
				this.playlistConfig(index);
				$(this.cssSelector.jPlayer).jPlayer("play", position);
			},
			playlistNext: function() {
				var index = (this.current + 1 < this.playlist.length) ? this.current + 1 : 0;
				this.playlistChange(index);
			},
			playlistPrev: function() {
				var index = (this.current - 1 >= 0) ? this.current - 1 : this.playlist.length - 1;
				this.playlistChange(index);
			},
			playlistCurrent: function() {
				return this.current;
			},
			playlistLength: function() {
				return this.playlist.length;
			}
		};

	var audioPlaylist = new Playlist("1", [

PR_END;
	
	foreach($query as $target) {
		if($remote_server_on && $target['uploaded']) {
			$track_address = $file_server_url;
		} else {
			$track_address = $local_tracks;
		}
		$md5_hash = strtolower($target['md5']);
		for($i = 0; $i < $folder_depth; $i++) {
			$track_address .= $md5_hash[$i] . "/";
		}
		$track_address .= $md5_hash . ".mp3";
		
		print("\t\t\t{\n");
		printf("\t\t\t\tname:\"%s\",\n", $target['title']);
		printf("\t\t\t\tmp3:\"%s\"\n", $track_address);
		print("\t\t\t},\n");
	}
			
	print <<<PR_END
		], {
			ready: function() {
				audioPlaylist.displayPlaylist();

PR_END;

				printf("\t\t\t\taudioPlaylist.playlistInit(true, %.1f);\n", $position); // Parameter is a boolean for autoplay.

	print <<<PR_END
			},
			ended: function() {
				if(audioPlaylist.playlistCurrent() + 1 < audioPlaylist.playlistLength()) {
					audioPlaylist.playlistNext();
				}
			},
			play: function() {
				$(this).jPlayer("pauseOthers");
			},
			swfPath: "include/jplayer",
			solution: "html, flash",
			supplied: "mp3",
			
PR_END;
			printf("\t\t\tvolume: %.2f,\n", $volume/100);

	print <<<PR_END
		});

	});
  </script>
</head>
<body>
	<div id="jquery_jplayer_1" class="jp-jplayer"></div>
	<div class="jp-audio">
		<div class="jp-type-playlist">
			<div id="jp_interface_1" class="jp-interface">
				<ul class="jp-controls">
					<li><a href="#" class="jp-play" tabindex="1">play</a></li>
					<li><a href="#" class="jp-pause" tabindex="1">pause</a></li>
					<li><a href="#" class="jp-stop" tabindex="1">stop</a></li>
					<li><a href="#" class="jp-mute" tabindex="1">mute</a></li>
					<li><a href="#" class="jp-unmute" tabindex="1">unmute</a></li>
					<li><a href="#" class="jp-previous" tabindex="1">previous</a></li>
					<li><a href="#" class="jp-next" tabindex="1">next</a></li>
				</ul>
				<div class="jp-progress">
					<div class="jp-seek-bar">
						<div class="jp-play-bar"></div>
					</div>
				</div>
				<div class="jp-volume-bar">
					<div class="jp-volume-bar-value"></div>
				</div>
				<div class="jp-current-time"></div>
				<div class="jp-duration"></div>
			</div>
			<div id="jp_playlist_1" class="jp-playlist">
				<ul>
					<!-- The method Playlist.displayPlaylist() uses this unordered list -->
					<li></li>
				</ul>
			</div>
		</div>
	</div>
</body>
</html>
PR_END;

	return TRUE;
}



// The main control sequence

$query = audio_query();

// $playlist = build_playlist($query);

$stream_id = get_or_null("sid");
$volume = choose_data_source(get_or_null("vol"), VOLUME_DEF);
if($stream_id !== NULL) {
	$query2 = sprintf("SELECT st.volume_shift, UNIX_TIMESTAMP() - UNIX_TIMESTAMP(st.start_time) - COALESCE(SUM(tr.playtime), 0) AS track_position FROM %s AS st LEFT JOIN %s AS pl USING (stream_id) LEFT JOIN %s AS tr ON (pl.track_id = tr.id AND pl.sequence < st.now_playing) WHERE st.stream_id = %d GROUP BY st.stream_id", $audio_tables['streams'], $audio_tables['playlists'], $audio_tables['tracks'], $stream_id);
	$result = mysql_query($query2) or sqlerrorhandler("(".mysql_errno().") ".mysql_error(), $query2, $_SERVER['PHP_SELF'], __LINE__);
	$row = mysql_fetch_row($result);
	$volume += $row[0];
	$position = floatval($row[1]);
	if($position < 1.0) {
		$position = 0.0;
	}
} else {
	$position = choose_data_source(get_or_null("pos"), 0.0);
	$position = floatval($position);
}

music_time($query, $volume, $position);
?>
