import * as __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__ from "@minecraft/server-editor";

import * as __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__ from "@minecraft/server";

var __webpack_require__ = {};

(() => {
    __webpack_require__.d = (exports, definition) => {
        for (var key in definition) {
            if (__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
                Object.defineProperty(exports, key, {
                    enumerable: true,
                    get: definition[key]
                });
            }
        }
    };
})();

(() => {
    __webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop);
})();

var __webpack_exports__ = {};

var x = y => {
    var x = {};
    __webpack_require__.d(x, y);
    return x;
};

var y = x => () => x;

const server_editor_namespaceObject = x({
    ["ActionTypes"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ActionTypes,
    ["ClipboardMirrorAxis"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ClipboardMirrorAxis,
    ["ClipboardRotation"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.ClipboardRotation,
    ["CursorControlMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CursorControlMode,
    ["CursorTargetMode"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.CursorTargetMode,
    ["EditorInputContext"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.EditorInputContext,
    ["EditorStatusBarAlignment"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.EditorStatusBarAlignment,
    ["InputModifier"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.InputModifier,
    ["KeyboardKey"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.KeyboardKey,
    ["MouseActionType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.MouseActionType,
    ["MouseInputType"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.MouseInputType,
    ["bindDataSource"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.bindDataSource,
    ["executeLargeOperation"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.executeLargeOperation,
    ["getLocalizationId"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.getLocalizationId,
    ["registerEditorExtension"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_editor_81aed4a5__.registerEditorExtension
});

var server_x = y => {
    var x = {};
    __webpack_require__.d(x, y);
    return x;
};

var server_y = x => () => x;

const server_namespaceObject = server_x({
    ["BlockVolumeUtils"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BlockVolumeUtils,
    ["BoundingBoxUtils"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.BoundingBoxUtils,
    ["CompoundBlockVolumeAction"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.CompoundBlockVolumeAction,
    ["CompoundBlockVolumePositionRelativity"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.CompoundBlockVolumePositionRelativity,
    ["Vector"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.Vector,
    ["system"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.system,
    ["world"]: () => __WEBPACK_EXTERNAL_MODULE__minecraft_server_fb7572af__.world
});

function stringFromException(e) {
    if (typeof e === "string") {
        return e;
    } else if (typeof e === "object" && e !== null && "message" in e) {
        return e.message;
    }
    return "Unknown exception";
}

class vector_utils_Vector3Utils {
    static equals(v1, v2) {
        return v1.x === v2.x && v1.y === v2.y && v1.z === v2.z;
    }
    static add(v1, v2) {
        return {
            x: v1.x + v2.x,
            y: v1.y + v2.y,
            z: v1.z + v2.z
        };
    }
    static subtract(v1, v2) {
        return {
            x: v1.x - v2.x,
            y: v1.y - v2.y,
            z: v1.z - v2.z
        };
    }
    static dot(a, b) {
        return a.x * b.x + a.y * b.y + a.z * b.z;
    }
    static scale(a, s) {
        const v = a;
        v.x *= s;
        v.y *= s;
        v.z *= s;
        return v;
    }
    static make(x, y, z) {
        return {
            x,
            y,
            z
        };
    }
    static floor(v) {
        return {
            x: Math.floor(v.x),
            y: Math.floor(v.y),
            z: Math.floor(v.z)
        };
    }
    static toString(v, options) {
        const decimals = options?.decimals ?? 2;
        const str = [ v.x.toFixed(decimals), v.y.toFixed(decimals), v.z.toFixed(decimals) ];
        return str.join(options?.delimiter ?? ", ");
    }
}

vector_utils_Vector3Utils.up = {
    x: 0,
    y: 1,
    z: 0
};

vector_utils_Vector3Utils.down = {
    x: 0,
    y: -1,
    z: 0
};

vector_utils_Vector3Utils.left = {
    x: -1,
    y: 0,
    z: 0
};

vector_utils_Vector3Utils.right = {
    x: 1,
    y: 0,
    z: 0
};

vector_utils_Vector3Utils.forward = {
    x: 0,
    y: 0,
    z: 1
};

vector_utils_Vector3Utils.back = {
    x: 0,
    y: 0,
    z: -1
};

vector_utils_Vector3Utils.one = {
    x: 1,
    y: 1,
    z: 1
};

vector_utils_Vector3Utils.zero = {
    x: 0,
    y: 0,
    z: 0
};

vector_utils_Vector3Utils.west = {
    x: -1,
    y: 0,
    z: 0
};

vector_utils_Vector3Utils.east = {
    x: 1,
    y: 0,
    z: 0
};

vector_utils_Vector3Utils.north = {
    x: 0,
    y: 0,
    z: 1
};

vector_utils_Vector3Utils.south = {
    x: 0,
    y: 0,
    z: -1
};

var Direction;

(function(Direction) {
    Direction[Direction["Forward"] = 0] = "Forward";
    Direction[Direction["Right"] = 1] = "Right";
    Direction[Direction["Back"] = 2] = "Back";
    Direction[Direction["Left"] = 3] = "Left";
    Direction[Direction["Up"] = 4] = "Up";
    Direction[Direction["Down"] = 5] = "Down";
})(Direction || (Direction = {}));

const directionLookup = {
    [Direction.Forward]: vector_utils_Vector3Utils.forward,
    [Direction.Right]: vector_utils_Vector3Utils.left,
    [Direction.Back]: vector_utils_Vector3Utils.back,
    [Direction.Left]: vector_utils_Vector3Utils.right,
    [Direction.Up]: vector_utils_Vector3Utils.up,
    [Direction.Down]: vector_utils_Vector3Utils.down
};

function getRotationCorrectedDirection(rotationY, realDirection) {
    if (realDirection === Direction.Up || realDirection === Direction.Down) {
        return realDirection;
    }
    const directionQuadrant = Math.floor((rotationY + 405 + realDirection * 90) % 360 / 90);
    return directionQuadrant;
}

function getRotationCorrectedDirectionVector(rotationY, realDirection) {
    const relativeDirection = getRotationCorrectedDirection(rotationY, realDirection);
    return directionLookup[relativeDirection];
}

function getDirectionVector(direction) {
    return directionLookup[direction];
}

function getScaledDirectionVector(direction, scale) {
    const vec = Vector3Utils.scale(getDirectionVector(direction), scale);
    return vec;
}

function shrinkVolumeAlongAbsoluteAxis(volume, direction, amount) {
    const bounds = server_namespaceObject.BlockVolumeUtils.getBoundingBox(volume);
    const boundSize = server_namespaceObject.BoundingBoxUtils.getSpan(bounds);
    const min = bounds.min;
    const max = bounds.max;
    const spanX = boundSize.x;
    const spanY = boundSize.y;
    const spanZ = boundSize.z;
    switch (direction) {
      case Direction.Up:
        if (spanY > amount) {
            max.y -= amount;
        }
        break;

      case Direction.Down:
        if (spanY > amount) {
            min.y += amount;
        }
        break;

      case Direction.Forward:
        if (spanZ > amount) {
            max.z -= amount;
        }
        break;

      case Direction.Back:
        if (spanZ > amount) {
            min.z += amount;
        }
        break;

      case Direction.Left:
        if (spanX > amount) {
            max.x -= amount;
        }
        break;

      case Direction.Right:
        if (spanX > amount) {
            min.x += amount;
        }
        break;
    }
    return {
        from: min,
        to: max
    };
}

function shrinkVolumeAlongViewAxis(volume, rotationY, direction, amount) {
    const relativeDirection = getRotationCorrectedDirection(rotationY, direction);
    return shrinkVolumeAlongAbsoluteAxis(volume, relativeDirection, amount);
}

function growVolumeAlongAbsoluteAxis(volume, direction, amount) {
    const maxAxialLength = 100;
    if (amount > maxAxialLength) {
        amount = maxAxialLength;
    }
    const bounds = server_namespaceObject.BlockVolumeUtils.getBoundingBox(volume);
    const boundSize = server_namespaceObject.BoundingBoxUtils.getSpan(bounds);
    const min = bounds.min;
    const max = bounds.max;
    const spanX = boundSize.x;
    const spanY = boundSize.y;
    const spanZ = boundSize.z;
    switch (direction) {
      case Direction.Up:
        if (spanY + amount > maxAxialLength) {
            amount = maxAxialLength - spanY;
        }
        max.y += amount;
        break;

      case Direction.Down:
        if (spanY + amount > maxAxialLength) {
            amount = maxAxialLength - spanY;
        }
        min.y -= amount;
        break;

      case Direction.Forward:
        if (spanZ + amount > maxAxialLength) {
            amount = maxAxialLength - spanZ;
        }
        max.z += amount;
        break;

      case Direction.Back:
        if (spanZ + amount > maxAxialLength) {
            amount = maxAxialLength - spanZ;
        }
        min.z -= amount;
        break;

      case Direction.Left:
        if (spanX + amount > maxAxialLength) {
            amount = maxAxialLength - spanX;
        }
        max.x += amount;
        break;

      case Direction.Right:
        if (spanX + amount > maxAxialLength) {
            amount = maxAxialLength - spanX;
        }
        min.x -= amount;
        break;
    }
    return {
        from: min,
        to: max
    };
}

function growVolumeAlongViewAxis(volume, rotationY, direction, amount) {
    const relativeDirection = getRotationCorrectedDirection(rotationY, direction);
    return growVolumeAlongAbsoluteAxis(volume, relativeDirection, amount);
}

var AxisPlanes;

(function(AxisPlanes) {
    AxisPlanes[AxisPlanes["XZ"] = 0] = "XZ";
    AxisPlanes[AxisPlanes["XY"] = 1] = "XY";
    AxisPlanes[AxisPlanes["YZ"] = 2] = "YZ";
})(AxisPlanes || (AxisPlanes = {}));

const axisNormalLookup = {
    [AxisPlanes.XZ]: vector_utils_Vector3Utils.up,
    [AxisPlanes.XY]: vector_utils_Vector3Utils.forward,
    [AxisPlanes.YZ]: vector_utils_Vector3Utils.left
};

function getAxisNormal(axis) {
    return axisNormalLookup[axis];
}

function getRelativeXYAxisAsNormal(rotation) {
    const direction = getRotationCorrectedDirection(rotation, Direction.Forward);
    switch (direction) {
      case Direction.Forward:
      case Direction.Back:
        return axisNormalLookup[AxisPlanes.XY];

      case Direction.Right:
      case Direction.Left:
        return axisNormalLookup[AxisPlanes.YZ];

      default:
        throw "Invalid quadrant";
    }
}

function intersectRayPlane(rayLocation, rayDirection, planeNormal, planeDistance) {
    const denominator = vector_utils_Vector3Utils.dot(rayDirection, planeNormal);
    if (denominator !== 0) {
        const t = -(vector_utils_Vector3Utils.dot(rayLocation, planeNormal) + planeDistance) / denominator;
        if (t < 0) {
            return undefined;
        }
        const scaledDirection = vector_utils_Vector3Utils.scale(rayDirection, t);
        const result = vector_utils_Vector3Utils.add(rayLocation, scaledDirection);
        return result;
    } else if (vector_utils_Vector3Utils.dot(planeNormal, rayLocation) + planeDistance === 0) {
        return rayLocation;
    }
    return undefined;
}

var MinecraftBlockTypes;

(function(MinecraftBlockTypes) {
    MinecraftBlockTypes["AcaciaButton"] = "minecraft:acacia_button";
    MinecraftBlockTypes["AcaciaDoor"] = "minecraft:acacia_door";
    MinecraftBlockTypes["AcaciaFence"] = "minecraft:acacia_fence";
    MinecraftBlockTypes["AcaciaFenceGate"] = "minecraft:acacia_fence_gate";
    MinecraftBlockTypes["AcaciaHangingSign"] = "minecraft:acacia_hanging_sign";
    MinecraftBlockTypes["AcaciaLog"] = "minecraft:acacia_log";
    MinecraftBlockTypes["AcaciaPressurePlate"] = "minecraft:acacia_pressure_plate";
    MinecraftBlockTypes["AcaciaStairs"] = "minecraft:acacia_stairs";
    MinecraftBlockTypes["AcaciaStandingSign"] = "minecraft:acacia_standing_sign";
    MinecraftBlockTypes["AcaciaTrapdoor"] = "minecraft:acacia_trapdoor";
    MinecraftBlockTypes["AcaciaWallSign"] = "minecraft:acacia_wall_sign";
    MinecraftBlockTypes["ActivatorRail"] = "minecraft:activator_rail";
    MinecraftBlockTypes["Air"] = "minecraft:air";
    MinecraftBlockTypes["Allow"] = "minecraft:allow";
    MinecraftBlockTypes["AmethystBlock"] = "minecraft:amethyst_block";
    MinecraftBlockTypes["AmethystCluster"] = "minecraft:amethyst_cluster";
    MinecraftBlockTypes["AncientDebris"] = "minecraft:ancient_debris";
    MinecraftBlockTypes["AndesiteStairs"] = "minecraft:andesite_stairs";
    MinecraftBlockTypes["Anvil"] = "minecraft:anvil";
    MinecraftBlockTypes["Azalea"] = "minecraft:azalea";
    MinecraftBlockTypes["AzaleaLeaves"] = "minecraft:azalea_leaves";
    MinecraftBlockTypes["AzaleaLeavesFlowered"] = "minecraft:azalea_leaves_flowered";
    MinecraftBlockTypes["Bamboo"] = "minecraft:bamboo";
    MinecraftBlockTypes["BambooBlock"] = "minecraft:bamboo_block";
    MinecraftBlockTypes["BambooButton"] = "minecraft:bamboo_button";
    MinecraftBlockTypes["BambooDoor"] = "minecraft:bamboo_door";
    MinecraftBlockTypes["BambooDoubleSlab"] = "minecraft:bamboo_double_slab";
    MinecraftBlockTypes["BambooFence"] = "minecraft:bamboo_fence";
    MinecraftBlockTypes["BambooFenceGate"] = "minecraft:bamboo_fence_gate";
    MinecraftBlockTypes["BambooHangingSign"] = "minecraft:bamboo_hanging_sign";
    MinecraftBlockTypes["BambooMosaic"] = "minecraft:bamboo_mosaic";
    MinecraftBlockTypes["BambooMosaicDoubleSlab"] = "minecraft:bamboo_mosaic_double_slab";
    MinecraftBlockTypes["BambooMosaicSlab"] = "minecraft:bamboo_mosaic_slab";
    MinecraftBlockTypes["BambooMosaicStairs"] = "minecraft:bamboo_mosaic_stairs";
    MinecraftBlockTypes["BambooPlanks"] = "minecraft:bamboo_planks";
    MinecraftBlockTypes["BambooPressurePlate"] = "minecraft:bamboo_pressure_plate";
    MinecraftBlockTypes["BambooSapling"] = "minecraft:bamboo_sapling";
    MinecraftBlockTypes["BambooSlab"] = "minecraft:bamboo_slab";
    MinecraftBlockTypes["BambooStairs"] = "minecraft:bamboo_stairs";
    MinecraftBlockTypes["BambooStandingSign"] = "minecraft:bamboo_standing_sign";
    MinecraftBlockTypes["BambooTrapdoor"] = "minecraft:bamboo_trapdoor";
    MinecraftBlockTypes["BambooWallSign"] = "minecraft:bamboo_wall_sign";
    MinecraftBlockTypes["Barrel"] = "minecraft:barrel";
    MinecraftBlockTypes["Barrier"] = "minecraft:barrier";
    MinecraftBlockTypes["Basalt"] = "minecraft:basalt";
    MinecraftBlockTypes["Beacon"] = "minecraft:beacon";
    MinecraftBlockTypes["Bed"] = "minecraft:bed";
    MinecraftBlockTypes["Bedrock"] = "minecraft:bedrock";
    MinecraftBlockTypes["BeeNest"] = "minecraft:bee_nest";
    MinecraftBlockTypes["Beehive"] = "minecraft:beehive";
    MinecraftBlockTypes["Beetroot"] = "minecraft:beetroot";
    MinecraftBlockTypes["Bell"] = "minecraft:bell";
    MinecraftBlockTypes["BigDripleaf"] = "minecraft:big_dripleaf";
    MinecraftBlockTypes["BirchButton"] = "minecraft:birch_button";
    MinecraftBlockTypes["BirchDoor"] = "minecraft:birch_door";
    MinecraftBlockTypes["BirchFence"] = "minecraft:birch_fence";
    MinecraftBlockTypes["BirchFenceGate"] = "minecraft:birch_fence_gate";
    MinecraftBlockTypes["BirchHangingSign"] = "minecraft:birch_hanging_sign";
    MinecraftBlockTypes["BirchLog"] = "minecraft:birch_log";
    MinecraftBlockTypes["BirchPressurePlate"] = "minecraft:birch_pressure_plate";
    MinecraftBlockTypes["BirchStairs"] = "minecraft:birch_stairs";
    MinecraftBlockTypes["BirchStandingSign"] = "minecraft:birch_standing_sign";
    MinecraftBlockTypes["BirchTrapdoor"] = "minecraft:birch_trapdoor";
    MinecraftBlockTypes["BirchWallSign"] = "minecraft:birch_wall_sign";
    MinecraftBlockTypes["BlackCandle"] = "minecraft:black_candle";
    MinecraftBlockTypes["BlackCandleCake"] = "minecraft:black_candle_cake";
    MinecraftBlockTypes["BlackCarpet"] = "minecraft:black_carpet";
    MinecraftBlockTypes["BlackGlazedTerracotta"] = "minecraft:black_glazed_terracotta";
    MinecraftBlockTypes["BlackWool"] = "minecraft:black_wool";
    MinecraftBlockTypes["Blackstone"] = "minecraft:blackstone";
    MinecraftBlockTypes["BlackstoneDoubleSlab"] = "minecraft:blackstone_double_slab";
    MinecraftBlockTypes["BlackstoneSlab"] = "minecraft:blackstone_slab";
    MinecraftBlockTypes["BlackstoneStairs"] = "minecraft:blackstone_stairs";
    MinecraftBlockTypes["BlackstoneWall"] = "minecraft:blackstone_wall";
    MinecraftBlockTypes["BlastFurnace"] = "minecraft:blast_furnace";
    MinecraftBlockTypes["BlueCandle"] = "minecraft:blue_candle";
    MinecraftBlockTypes["BlueCandleCake"] = "minecraft:blue_candle_cake";
    MinecraftBlockTypes["BlueCarpet"] = "minecraft:blue_carpet";
    MinecraftBlockTypes["BlueGlazedTerracotta"] = "minecraft:blue_glazed_terracotta";
    MinecraftBlockTypes["BlueIce"] = "minecraft:blue_ice";
    MinecraftBlockTypes["BlueWool"] = "minecraft:blue_wool";
    MinecraftBlockTypes["BoneBlock"] = "minecraft:bone_block";
    MinecraftBlockTypes["Bookshelf"] = "minecraft:bookshelf";
    MinecraftBlockTypes["BorderBlock"] = "minecraft:border_block";
    MinecraftBlockTypes["BrainCoral"] = "minecraft:brain_coral";
    MinecraftBlockTypes["BrewingStand"] = "minecraft:brewing_stand";
    MinecraftBlockTypes["BrickBlock"] = "minecraft:brick_block";
    MinecraftBlockTypes["BrickStairs"] = "minecraft:brick_stairs";
    MinecraftBlockTypes["BrownCandle"] = "minecraft:brown_candle";
    MinecraftBlockTypes["BrownCandleCake"] = "minecraft:brown_candle_cake";
    MinecraftBlockTypes["BrownCarpet"] = "minecraft:brown_carpet";
    MinecraftBlockTypes["BrownGlazedTerracotta"] = "minecraft:brown_glazed_terracotta";
    MinecraftBlockTypes["BrownMushroom"] = "minecraft:brown_mushroom";
    MinecraftBlockTypes["BrownMushroomBlock"] = "minecraft:brown_mushroom_block";
    MinecraftBlockTypes["BrownWool"] = "minecraft:brown_wool";
    MinecraftBlockTypes["BubbleColumn"] = "minecraft:bubble_column";
    MinecraftBlockTypes["BubbleCoral"] = "minecraft:bubble_coral";
    MinecraftBlockTypes["BuddingAmethyst"] = "minecraft:budding_amethyst";
    MinecraftBlockTypes["Cactus"] = "minecraft:cactus";
    MinecraftBlockTypes["Cake"] = "minecraft:cake";
    MinecraftBlockTypes["Calcite"] = "minecraft:calcite";
    MinecraftBlockTypes["CalibratedSculkSensor"] = "minecraft:calibrated_sculk_sensor";
    MinecraftBlockTypes["Camera"] = "minecraft:camera";
    MinecraftBlockTypes["Campfire"] = "minecraft:campfire";
    MinecraftBlockTypes["Candle"] = "minecraft:candle";
    MinecraftBlockTypes["CandleCake"] = "minecraft:candle_cake";
    MinecraftBlockTypes["Carrots"] = "minecraft:carrots";
    MinecraftBlockTypes["CartographyTable"] = "minecraft:cartography_table";
    MinecraftBlockTypes["CarvedPumpkin"] = "minecraft:carved_pumpkin";
    MinecraftBlockTypes["Cauldron"] = "minecraft:cauldron";
    MinecraftBlockTypes["CaveVines"] = "minecraft:cave_vines";
    MinecraftBlockTypes["CaveVinesBodyWithBerries"] = "minecraft:cave_vines_body_with_berries";
    MinecraftBlockTypes["CaveVinesHeadWithBerries"] = "minecraft:cave_vines_head_with_berries";
    MinecraftBlockTypes["Chain"] = "minecraft:chain";
    MinecraftBlockTypes["ChainCommandBlock"] = "minecraft:chain_command_block";
    MinecraftBlockTypes["ChemicalHeat"] = "minecraft:chemical_heat";
    MinecraftBlockTypes["ChemistryTable"] = "minecraft:chemistry_table";
    MinecraftBlockTypes["CherryButton"] = "minecraft:cherry_button";
    MinecraftBlockTypes["CherryDoor"] = "minecraft:cherry_door";
    MinecraftBlockTypes["CherryDoubleSlab"] = "minecraft:cherry_double_slab";
    MinecraftBlockTypes["CherryFence"] = "minecraft:cherry_fence";
    MinecraftBlockTypes["CherryFenceGate"] = "minecraft:cherry_fence_gate";
    MinecraftBlockTypes["CherryHangingSign"] = "minecraft:cherry_hanging_sign";
    MinecraftBlockTypes["CherryLeaves"] = "minecraft:cherry_leaves";
    MinecraftBlockTypes["CherryLog"] = "minecraft:cherry_log";
    MinecraftBlockTypes["CherryPlanks"] = "minecraft:cherry_planks";
    MinecraftBlockTypes["CherryPressurePlate"] = "minecraft:cherry_pressure_plate";
    MinecraftBlockTypes["CherrySapling"] = "minecraft:cherry_sapling";
    MinecraftBlockTypes["CherrySlab"] = "minecraft:cherry_slab";
    MinecraftBlockTypes["CherryStairs"] = "minecraft:cherry_stairs";
    MinecraftBlockTypes["CherryStandingSign"] = "minecraft:cherry_standing_sign";
    MinecraftBlockTypes["CherryTrapdoor"] = "minecraft:cherry_trapdoor";
    MinecraftBlockTypes["CherryWallSign"] = "minecraft:cherry_wall_sign";
    MinecraftBlockTypes["CherryWood"] = "minecraft:cherry_wood";
    MinecraftBlockTypes["Chest"] = "minecraft:chest";
    MinecraftBlockTypes["ChiseledBookshelf"] = "minecraft:chiseled_bookshelf";
    MinecraftBlockTypes["ChiseledDeepslate"] = "minecraft:chiseled_deepslate";
    MinecraftBlockTypes["ChiseledNetherBricks"] = "minecraft:chiseled_nether_bricks";
    MinecraftBlockTypes["ChiseledPolishedBlackstone"] = "minecraft:chiseled_polished_blackstone";
    MinecraftBlockTypes["ChorusFlower"] = "minecraft:chorus_flower";
    MinecraftBlockTypes["ChorusPlant"] = "minecraft:chorus_plant";
    MinecraftBlockTypes["Clay"] = "minecraft:clay";
    MinecraftBlockTypes["ClientRequestPlaceholderBlock"] = "minecraft:client_request_placeholder_block";
    MinecraftBlockTypes["CoalBlock"] = "minecraft:coal_block";
    MinecraftBlockTypes["CoalOre"] = "minecraft:coal_ore";
    MinecraftBlockTypes["CobbledDeepslate"] = "minecraft:cobbled_deepslate";
    MinecraftBlockTypes["CobbledDeepslateDoubleSlab"] = "minecraft:cobbled_deepslate_double_slab";
    MinecraftBlockTypes["CobbledDeepslateSlab"] = "minecraft:cobbled_deepslate_slab";
    MinecraftBlockTypes["CobbledDeepslateStairs"] = "minecraft:cobbled_deepslate_stairs";
    MinecraftBlockTypes["CobbledDeepslateWall"] = "minecraft:cobbled_deepslate_wall";
    MinecraftBlockTypes["Cobblestone"] = "minecraft:cobblestone";
    MinecraftBlockTypes["CobblestoneWall"] = "minecraft:cobblestone_wall";
    MinecraftBlockTypes["Cocoa"] = "minecraft:cocoa";
    MinecraftBlockTypes["ColoredTorchBp"] = "minecraft:colored_torch_bp";
    MinecraftBlockTypes["ColoredTorchRg"] = "minecraft:colored_torch_rg";
    MinecraftBlockTypes["CommandBlock"] = "minecraft:command_block";
    MinecraftBlockTypes["Composter"] = "minecraft:composter";
    MinecraftBlockTypes["Concrete"] = "minecraft:concrete";
    MinecraftBlockTypes["ConcretePowder"] = "minecraft:concrete_powder";
    MinecraftBlockTypes["Conduit"] = "minecraft:conduit";
    MinecraftBlockTypes["CopperBlock"] = "minecraft:copper_block";
    MinecraftBlockTypes["CopperOre"] = "minecraft:copper_ore";
    MinecraftBlockTypes["CoralBlock"] = "minecraft:coral_block";
    MinecraftBlockTypes["CoralFan"] = "minecraft:coral_fan";
    MinecraftBlockTypes["CoralFanDead"] = "minecraft:coral_fan_dead";
    MinecraftBlockTypes["CoralFanHang"] = "minecraft:coral_fan_hang";
    MinecraftBlockTypes["CoralFanHang2"] = "minecraft:coral_fan_hang2";
    MinecraftBlockTypes["CoralFanHang3"] = "minecraft:coral_fan_hang3";
    MinecraftBlockTypes["CrackedDeepslateBricks"] = "minecraft:cracked_deepslate_bricks";
    MinecraftBlockTypes["CrackedDeepslateTiles"] = "minecraft:cracked_deepslate_tiles";
    MinecraftBlockTypes["CrackedNetherBricks"] = "minecraft:cracked_nether_bricks";
    MinecraftBlockTypes["CrackedPolishedBlackstoneBricks"] = "minecraft:cracked_polished_blackstone_bricks";
    MinecraftBlockTypes["CraftingTable"] = "minecraft:crafting_table";
    MinecraftBlockTypes["CrimsonButton"] = "minecraft:crimson_button";
    MinecraftBlockTypes["CrimsonDoor"] = "minecraft:crimson_door";
    MinecraftBlockTypes["CrimsonDoubleSlab"] = "minecraft:crimson_double_slab";
    MinecraftBlockTypes["CrimsonFence"] = "minecraft:crimson_fence";
    MinecraftBlockTypes["CrimsonFenceGate"] = "minecraft:crimson_fence_gate";
    MinecraftBlockTypes["CrimsonFungus"] = "minecraft:crimson_fungus";
    MinecraftBlockTypes["CrimsonHangingSign"] = "minecraft:crimson_hanging_sign";
    MinecraftBlockTypes["CrimsonHyphae"] = "minecraft:crimson_hyphae";
    MinecraftBlockTypes["CrimsonNylium"] = "minecraft:crimson_nylium";
    MinecraftBlockTypes["CrimsonPlanks"] = "minecraft:crimson_planks";
    MinecraftBlockTypes["CrimsonPressurePlate"] = "minecraft:crimson_pressure_plate";
    MinecraftBlockTypes["CrimsonRoots"] = "minecraft:crimson_roots";
    MinecraftBlockTypes["CrimsonSlab"] = "minecraft:crimson_slab";
    MinecraftBlockTypes["CrimsonStairs"] = "minecraft:crimson_stairs";
    MinecraftBlockTypes["CrimsonStandingSign"] = "minecraft:crimson_standing_sign";
    MinecraftBlockTypes["CrimsonStem"] = "minecraft:crimson_stem";
    MinecraftBlockTypes["CrimsonTrapdoor"] = "minecraft:crimson_trapdoor";
    MinecraftBlockTypes["CrimsonWallSign"] = "minecraft:crimson_wall_sign";
    MinecraftBlockTypes["CryingObsidian"] = "minecraft:crying_obsidian";
    MinecraftBlockTypes["CutCopper"] = "minecraft:cut_copper";
    MinecraftBlockTypes["CutCopperSlab"] = "minecraft:cut_copper_slab";
    MinecraftBlockTypes["CutCopperStairs"] = "minecraft:cut_copper_stairs";
    MinecraftBlockTypes["CyanCandle"] = "minecraft:cyan_candle";
    MinecraftBlockTypes["CyanCandleCake"] = "minecraft:cyan_candle_cake";
    MinecraftBlockTypes["CyanCarpet"] = "minecraft:cyan_carpet";
    MinecraftBlockTypes["CyanGlazedTerracotta"] = "minecraft:cyan_glazed_terracotta";
    MinecraftBlockTypes["CyanWool"] = "minecraft:cyan_wool";
    MinecraftBlockTypes["DarkOakButton"] = "minecraft:dark_oak_button";
    MinecraftBlockTypes["DarkOakDoor"] = "minecraft:dark_oak_door";
    MinecraftBlockTypes["DarkOakFence"] = "minecraft:dark_oak_fence";
    MinecraftBlockTypes["DarkOakFenceGate"] = "minecraft:dark_oak_fence_gate";
    MinecraftBlockTypes["DarkOakHangingSign"] = "minecraft:dark_oak_hanging_sign";
    MinecraftBlockTypes["DarkOakLog"] = "minecraft:dark_oak_log";
    MinecraftBlockTypes["DarkOakPressurePlate"] = "minecraft:dark_oak_pressure_plate";
    MinecraftBlockTypes["DarkOakStairs"] = "minecraft:dark_oak_stairs";
    MinecraftBlockTypes["DarkOakTrapdoor"] = "minecraft:dark_oak_trapdoor";
    MinecraftBlockTypes["DarkPrismarineStairs"] = "minecraft:dark_prismarine_stairs";
    MinecraftBlockTypes["DarkoakStandingSign"] = "minecraft:darkoak_standing_sign";
    MinecraftBlockTypes["DarkoakWallSign"] = "minecraft:darkoak_wall_sign";
    MinecraftBlockTypes["DaylightDetector"] = "minecraft:daylight_detector";
    MinecraftBlockTypes["DaylightDetectorInverted"] = "minecraft:daylight_detector_inverted";
    MinecraftBlockTypes["DeadBrainCoral"] = "minecraft:dead_brain_coral";
    MinecraftBlockTypes["DeadBubbleCoral"] = "minecraft:dead_bubble_coral";
    MinecraftBlockTypes["DeadFireCoral"] = "minecraft:dead_fire_coral";
    MinecraftBlockTypes["DeadHornCoral"] = "minecraft:dead_horn_coral";
    MinecraftBlockTypes["DeadTubeCoral"] = "minecraft:dead_tube_coral";
    MinecraftBlockTypes["Deadbush"] = "minecraft:deadbush";
    MinecraftBlockTypes["DecoratedPot"] = "minecraft:decorated_pot";
    MinecraftBlockTypes["Deepslate"] = "minecraft:deepslate";
    MinecraftBlockTypes["DeepslateBrickDoubleSlab"] = "minecraft:deepslate_brick_double_slab";
    MinecraftBlockTypes["DeepslateBrickSlab"] = "minecraft:deepslate_brick_slab";
    MinecraftBlockTypes["DeepslateBrickStairs"] = "minecraft:deepslate_brick_stairs";
    MinecraftBlockTypes["DeepslateBrickWall"] = "minecraft:deepslate_brick_wall";
    MinecraftBlockTypes["DeepslateBricks"] = "minecraft:deepslate_bricks";
    MinecraftBlockTypes["DeepslateCoalOre"] = "minecraft:deepslate_coal_ore";
    MinecraftBlockTypes["DeepslateCopperOre"] = "minecraft:deepslate_copper_ore";
    MinecraftBlockTypes["DeepslateDiamondOre"] = "minecraft:deepslate_diamond_ore";
    MinecraftBlockTypes["DeepslateEmeraldOre"] = "minecraft:deepslate_emerald_ore";
    MinecraftBlockTypes["DeepslateGoldOre"] = "minecraft:deepslate_gold_ore";
    MinecraftBlockTypes["DeepslateIronOre"] = "minecraft:deepslate_iron_ore";
    MinecraftBlockTypes["DeepslateLapisOre"] = "minecraft:deepslate_lapis_ore";
    MinecraftBlockTypes["DeepslateRedstoneOre"] = "minecraft:deepslate_redstone_ore";
    MinecraftBlockTypes["DeepslateTileDoubleSlab"] = "minecraft:deepslate_tile_double_slab";
    MinecraftBlockTypes["DeepslateTileSlab"] = "minecraft:deepslate_tile_slab";
    MinecraftBlockTypes["DeepslateTileStairs"] = "minecraft:deepslate_tile_stairs";
    MinecraftBlockTypes["DeepslateTileWall"] = "minecraft:deepslate_tile_wall";
    MinecraftBlockTypes["DeepslateTiles"] = "minecraft:deepslate_tiles";
    MinecraftBlockTypes["Deny"] = "minecraft:deny";
    MinecraftBlockTypes["DetectorRail"] = "minecraft:detector_rail";
    MinecraftBlockTypes["DiamondBlock"] = "minecraft:diamond_block";
    MinecraftBlockTypes["DiamondOre"] = "minecraft:diamond_ore";
    MinecraftBlockTypes["DioriteStairs"] = "minecraft:diorite_stairs";
    MinecraftBlockTypes["Dirt"] = "minecraft:dirt";
    MinecraftBlockTypes["DirtWithRoots"] = "minecraft:dirt_with_roots";
    MinecraftBlockTypes["Dispenser"] = "minecraft:dispenser";
    MinecraftBlockTypes["DoubleCutCopperSlab"] = "minecraft:double_cut_copper_slab";
    MinecraftBlockTypes["DoublePlant"] = "minecraft:double_plant";
    MinecraftBlockTypes["DoubleStoneBlockSlab"] = "minecraft:double_stone_block_slab";
    MinecraftBlockTypes["DoubleStoneBlockSlab2"] = "minecraft:double_stone_block_slab2";
    MinecraftBlockTypes["DoubleStoneBlockSlab3"] = "minecraft:double_stone_block_slab3";
    MinecraftBlockTypes["DoubleStoneBlockSlab4"] = "minecraft:double_stone_block_slab4";
    MinecraftBlockTypes["DoubleWoodenSlab"] = "minecraft:double_wooden_slab";
    MinecraftBlockTypes["DragonEgg"] = "minecraft:dragon_egg";
    MinecraftBlockTypes["DriedKelpBlock"] = "minecraft:dried_kelp_block";
    MinecraftBlockTypes["DripstoneBlock"] = "minecraft:dripstone_block";
    MinecraftBlockTypes["Dropper"] = "minecraft:dropper";
    MinecraftBlockTypes["Element0"] = "minecraft:element_0";
    MinecraftBlockTypes["Element1"] = "minecraft:element_1";
    MinecraftBlockTypes["Element10"] = "minecraft:element_10";
    MinecraftBlockTypes["Element100"] = "minecraft:element_100";
    MinecraftBlockTypes["Element101"] = "minecraft:element_101";
    MinecraftBlockTypes["Element102"] = "minecraft:element_102";
    MinecraftBlockTypes["Element103"] = "minecraft:element_103";
    MinecraftBlockTypes["Element104"] = "minecraft:element_104";
    MinecraftBlockTypes["Element105"] = "minecraft:element_105";
    MinecraftBlockTypes["Element106"] = "minecraft:element_106";
    MinecraftBlockTypes["Element107"] = "minecraft:element_107";
    MinecraftBlockTypes["Element108"] = "minecraft:element_108";
    MinecraftBlockTypes["Element109"] = "minecraft:element_109";
    MinecraftBlockTypes["Element11"] = "minecraft:element_11";
    MinecraftBlockTypes["Element110"] = "minecraft:element_110";
    MinecraftBlockTypes["Element111"] = "minecraft:element_111";
    MinecraftBlockTypes["Element112"] = "minecraft:element_112";
    MinecraftBlockTypes["Element113"] = "minecraft:element_113";
    MinecraftBlockTypes["Element114"] = "minecraft:element_114";
    MinecraftBlockTypes["Element115"] = "minecraft:element_115";
    MinecraftBlockTypes["Element116"] = "minecraft:element_116";
    MinecraftBlockTypes["Element117"] = "minecraft:element_117";
    MinecraftBlockTypes["Element118"] = "minecraft:element_118";
    MinecraftBlockTypes["Element12"] = "minecraft:element_12";
    MinecraftBlockTypes["Element13"] = "minecraft:element_13";
    MinecraftBlockTypes["Element14"] = "minecraft:element_14";
    MinecraftBlockTypes["Element15"] = "minecraft:element_15";
    MinecraftBlockTypes["Element16"] = "minecraft:element_16";
    MinecraftBlockTypes["Element17"] = "minecraft:element_17";
    MinecraftBlockTypes["Element18"] = "minecraft:element_18";
    MinecraftBlockTypes["Element19"] = "minecraft:element_19";
    MinecraftBlockTypes["Element2"] = "minecraft:element_2";
    MinecraftBlockTypes["Element20"] = "minecraft:element_20";
    MinecraftBlockTypes["Element21"] = "minecraft:element_21";
    MinecraftBlockTypes["Element22"] = "minecraft:element_22";
    MinecraftBlockTypes["Element23"] = "minecraft:element_23";
    MinecraftBlockTypes["Element24"] = "minecraft:element_24";
    MinecraftBlockTypes["Element25"] = "minecraft:element_25";
    MinecraftBlockTypes["Element26"] = "minecraft:element_26";
    MinecraftBlockTypes["Element27"] = "minecraft:element_27";
    MinecraftBlockTypes["Element28"] = "minecraft:element_28";
    MinecraftBlockTypes["Element29"] = "minecraft:element_29";
    MinecraftBlockTypes["Element3"] = "minecraft:element_3";
    MinecraftBlockTypes["Element30"] = "minecraft:element_30";
    MinecraftBlockTypes["Element31"] = "minecraft:element_31";
    MinecraftBlockTypes["Element32"] = "minecraft:element_32";
    MinecraftBlockTypes["Element33"] = "minecraft:element_33";
    MinecraftBlockTypes["Element34"] = "minecraft:element_34";
    MinecraftBlockTypes["Element35"] = "minecraft:element_35";
    MinecraftBlockTypes["Element36"] = "minecraft:element_36";
    MinecraftBlockTypes["Element37"] = "minecraft:element_37";
    MinecraftBlockTypes["Element38"] = "minecraft:element_38";
    MinecraftBlockTypes["Element39"] = "minecraft:element_39";
    MinecraftBlockTypes["Element4"] = "minecraft:element_4";
    MinecraftBlockTypes["Element40"] = "minecraft:element_40";
    MinecraftBlockTypes["Element41"] = "minecraft:element_41";
    MinecraftBlockTypes["Element42"] = "minecraft:element_42";
    MinecraftBlockTypes["Element43"] = "minecraft:element_43";
    MinecraftBlockTypes["Element44"] = "minecraft:element_44";
    MinecraftBlockTypes["Element45"] = "minecraft:element_45";
    MinecraftBlockTypes["Element46"] = "minecraft:element_46";
    MinecraftBlockTypes["Element47"] = "minecraft:element_47";
    MinecraftBlockTypes["Element48"] = "minecraft:element_48";
    MinecraftBlockTypes["Element49"] = "minecraft:element_49";
    MinecraftBlockTypes["Element5"] = "minecraft:element_5";
    MinecraftBlockTypes["Element50"] = "minecraft:element_50";
    MinecraftBlockTypes["Element51"] = "minecraft:element_51";
    MinecraftBlockTypes["Element52"] = "minecraft:element_52";
    MinecraftBlockTypes["Element53"] = "minecraft:element_53";
    MinecraftBlockTypes["Element54"] = "minecraft:element_54";
    MinecraftBlockTypes["Element55"] = "minecraft:element_55";
    MinecraftBlockTypes["Element56"] = "minecraft:element_56";
    MinecraftBlockTypes["Element57"] = "minecraft:element_57";
    MinecraftBlockTypes["Element58"] = "minecraft:element_58";
    MinecraftBlockTypes["Element59"] = "minecraft:element_59";
    MinecraftBlockTypes["Element6"] = "minecraft:element_6";
    MinecraftBlockTypes["Element60"] = "minecraft:element_60";
    MinecraftBlockTypes["Element61"] = "minecraft:element_61";
    MinecraftBlockTypes["Element62"] = "minecraft:element_62";
    MinecraftBlockTypes["Element63"] = "minecraft:element_63";
    MinecraftBlockTypes["Element64"] = "minecraft:element_64";
    MinecraftBlockTypes["Element65"] = "minecraft:element_65";
    MinecraftBlockTypes["Element66"] = "minecraft:element_66";
    MinecraftBlockTypes["Element67"] = "minecraft:element_67";
    MinecraftBlockTypes["Element68"] = "minecraft:element_68";
    MinecraftBlockTypes["Element69"] = "minecraft:element_69";
    MinecraftBlockTypes["Element7"] = "minecraft:element_7";
    MinecraftBlockTypes["Element70"] = "minecraft:element_70";
    MinecraftBlockTypes["Element71"] = "minecraft:element_71";
    MinecraftBlockTypes["Element72"] = "minecraft:element_72";
    MinecraftBlockTypes["Element73"] = "minecraft:element_73";
    MinecraftBlockTypes["Element74"] = "minecraft:element_74";
    MinecraftBlockTypes["Element75"] = "minecraft:element_75";
    MinecraftBlockTypes["Element76"] = "minecraft:element_76";
    MinecraftBlockTypes["Element77"] = "minecraft:element_77";
    MinecraftBlockTypes["Element78"] = "minecraft:element_78";
    MinecraftBlockTypes["Element79"] = "minecraft:element_79";
    MinecraftBlockTypes["Element8"] = "minecraft:element_8";
    MinecraftBlockTypes["Element80"] = "minecraft:element_80";
    MinecraftBlockTypes["Element81"] = "minecraft:element_81";
    MinecraftBlockTypes["Element82"] = "minecraft:element_82";
    MinecraftBlockTypes["Element83"] = "minecraft:element_83";
    MinecraftBlockTypes["Element84"] = "minecraft:element_84";
    MinecraftBlockTypes["Element85"] = "minecraft:element_85";
    MinecraftBlockTypes["Element86"] = "minecraft:element_86";
    MinecraftBlockTypes["Element87"] = "minecraft:element_87";
    MinecraftBlockTypes["Element88"] = "minecraft:element_88";
    MinecraftBlockTypes["Element89"] = "minecraft:element_89";
    MinecraftBlockTypes["Element9"] = "minecraft:element_9";
    MinecraftBlockTypes["Element90"] = "minecraft:element_90";
    MinecraftBlockTypes["Element91"] = "minecraft:element_91";
    MinecraftBlockTypes["Element92"] = "minecraft:element_92";
    MinecraftBlockTypes["Element93"] = "minecraft:element_93";
    MinecraftBlockTypes["Element94"] = "minecraft:element_94";
    MinecraftBlockTypes["Element95"] = "minecraft:element_95";
    MinecraftBlockTypes["Element96"] = "minecraft:element_96";
    MinecraftBlockTypes["Element97"] = "minecraft:element_97";
    MinecraftBlockTypes["Element98"] = "minecraft:element_98";
    MinecraftBlockTypes["Element99"] = "minecraft:element_99";
    MinecraftBlockTypes["EmeraldBlock"] = "minecraft:emerald_block";
    MinecraftBlockTypes["EmeraldOre"] = "minecraft:emerald_ore";
    MinecraftBlockTypes["EnchantingTable"] = "minecraft:enchanting_table";
    MinecraftBlockTypes["EndBrickStairs"] = "minecraft:end_brick_stairs";
    MinecraftBlockTypes["EndBricks"] = "minecraft:end_bricks";
    MinecraftBlockTypes["EndGateway"] = "minecraft:end_gateway";
    MinecraftBlockTypes["EndPortal"] = "minecraft:end_portal";
    MinecraftBlockTypes["EndPortalFrame"] = "minecraft:end_portal_frame";
    MinecraftBlockTypes["EndRod"] = "minecraft:end_rod";
    MinecraftBlockTypes["EndStone"] = "minecraft:end_stone";
    MinecraftBlockTypes["EnderChest"] = "minecraft:ender_chest";
    MinecraftBlockTypes["ExposedCopper"] = "minecraft:exposed_copper";
    MinecraftBlockTypes["ExposedCutCopper"] = "minecraft:exposed_cut_copper";
    MinecraftBlockTypes["ExposedCutCopperSlab"] = "minecraft:exposed_cut_copper_slab";
    MinecraftBlockTypes["ExposedCutCopperStairs"] = "minecraft:exposed_cut_copper_stairs";
    MinecraftBlockTypes["ExposedDoubleCutCopperSlab"] = "minecraft:exposed_double_cut_copper_slab";
    MinecraftBlockTypes["Farmland"] = "minecraft:farmland";
    MinecraftBlockTypes["FenceGate"] = "minecraft:fence_gate";
    MinecraftBlockTypes["Fire"] = "minecraft:fire";
    MinecraftBlockTypes["FireCoral"] = "minecraft:fire_coral";
    MinecraftBlockTypes["FletchingTable"] = "minecraft:fletching_table";
    MinecraftBlockTypes["FlowerPot"] = "minecraft:flower_pot";
    MinecraftBlockTypes["FloweringAzalea"] = "minecraft:flowering_azalea";
    MinecraftBlockTypes["FlowingLava"] = "minecraft:flowing_lava";
    MinecraftBlockTypes["FlowingWater"] = "minecraft:flowing_water";
    MinecraftBlockTypes["Frame"] = "minecraft:frame";
    MinecraftBlockTypes["FrogSpawn"] = "minecraft:frog_spawn";
    MinecraftBlockTypes["FrostedIce"] = "minecraft:frosted_ice";
    MinecraftBlockTypes["Furnace"] = "minecraft:furnace";
    MinecraftBlockTypes["GildedBlackstone"] = "minecraft:gilded_blackstone";
    MinecraftBlockTypes["Glass"] = "minecraft:glass";
    MinecraftBlockTypes["GlassPane"] = "minecraft:glass_pane";
    MinecraftBlockTypes["GlowFrame"] = "minecraft:glow_frame";
    MinecraftBlockTypes["GlowLichen"] = "minecraft:glow_lichen";
    MinecraftBlockTypes["Glowingobsidian"] = "minecraft:glowingobsidian";
    MinecraftBlockTypes["Glowstone"] = "minecraft:glowstone";
    MinecraftBlockTypes["GoldBlock"] = "minecraft:gold_block";
    MinecraftBlockTypes["GoldOre"] = "minecraft:gold_ore";
    MinecraftBlockTypes["GoldenRail"] = "minecraft:golden_rail";
    MinecraftBlockTypes["GraniteStairs"] = "minecraft:granite_stairs";
    MinecraftBlockTypes["Grass"] = "minecraft:grass";
    MinecraftBlockTypes["GrassPath"] = "minecraft:grass_path";
    MinecraftBlockTypes["Gravel"] = "minecraft:gravel";
    MinecraftBlockTypes["GrayCandle"] = "minecraft:gray_candle";
    MinecraftBlockTypes["GrayCandleCake"] = "minecraft:gray_candle_cake";
    MinecraftBlockTypes["GrayCarpet"] = "minecraft:gray_carpet";
    MinecraftBlockTypes["GrayGlazedTerracotta"] = "minecraft:gray_glazed_terracotta";
    MinecraftBlockTypes["GrayWool"] = "minecraft:gray_wool";
    MinecraftBlockTypes["GreenCandle"] = "minecraft:green_candle";
    MinecraftBlockTypes["GreenCandleCake"] = "minecraft:green_candle_cake";
    MinecraftBlockTypes["GreenCarpet"] = "minecraft:green_carpet";
    MinecraftBlockTypes["GreenGlazedTerracotta"] = "minecraft:green_glazed_terracotta";
    MinecraftBlockTypes["GreenWool"] = "minecraft:green_wool";
    MinecraftBlockTypes["Grindstone"] = "minecraft:grindstone";
    MinecraftBlockTypes["HangingRoots"] = "minecraft:hanging_roots";
    MinecraftBlockTypes["HardGlass"] = "minecraft:hard_glass";
    MinecraftBlockTypes["HardGlassPane"] = "minecraft:hard_glass_pane";
    MinecraftBlockTypes["HardStainedGlass"] = "minecraft:hard_stained_glass";
    MinecraftBlockTypes["HardStainedGlassPane"] = "minecraft:hard_stained_glass_pane";
    MinecraftBlockTypes["HardenedClay"] = "minecraft:hardened_clay";
    MinecraftBlockTypes["HayBlock"] = "minecraft:hay_block";
    MinecraftBlockTypes["HeavyWeightedPressurePlate"] = "minecraft:heavy_weighted_pressure_plate";
    MinecraftBlockTypes["HoneyBlock"] = "minecraft:honey_block";
    MinecraftBlockTypes["HoneycombBlock"] = "minecraft:honeycomb_block";
    MinecraftBlockTypes["Hopper"] = "minecraft:hopper";
    MinecraftBlockTypes["HornCoral"] = "minecraft:horn_coral";
    MinecraftBlockTypes["Ice"] = "minecraft:ice";
    MinecraftBlockTypes["InfestedDeepslate"] = "minecraft:infested_deepslate";
    MinecraftBlockTypes["InfoUpdate"] = "minecraft:info_update";
    MinecraftBlockTypes["InfoUpdate2"] = "minecraft:info_update2";
    MinecraftBlockTypes["InvisibleBedrock"] = "minecraft:invisible_bedrock";
    MinecraftBlockTypes["IronBars"] = "minecraft:iron_bars";
    MinecraftBlockTypes["IronBlock"] = "minecraft:iron_block";
    MinecraftBlockTypes["IronDoor"] = "minecraft:iron_door";
    MinecraftBlockTypes["IronOre"] = "minecraft:iron_ore";
    MinecraftBlockTypes["IronTrapdoor"] = "minecraft:iron_trapdoor";
    MinecraftBlockTypes["Jigsaw"] = "minecraft:jigsaw";
    MinecraftBlockTypes["Jukebox"] = "minecraft:jukebox";
    MinecraftBlockTypes["JungleButton"] = "minecraft:jungle_button";
    MinecraftBlockTypes["JungleDoor"] = "minecraft:jungle_door";
    MinecraftBlockTypes["JungleFence"] = "minecraft:jungle_fence";
    MinecraftBlockTypes["JungleFenceGate"] = "minecraft:jungle_fence_gate";
    MinecraftBlockTypes["JungleHangingSign"] = "minecraft:jungle_hanging_sign";
    MinecraftBlockTypes["JungleLog"] = "minecraft:jungle_log";
    MinecraftBlockTypes["JunglePressurePlate"] = "minecraft:jungle_pressure_plate";
    MinecraftBlockTypes["JungleStairs"] = "minecraft:jungle_stairs";
    MinecraftBlockTypes["JungleStandingSign"] = "minecraft:jungle_standing_sign";
    MinecraftBlockTypes["JungleTrapdoor"] = "minecraft:jungle_trapdoor";
    MinecraftBlockTypes["JungleWallSign"] = "minecraft:jungle_wall_sign";
    MinecraftBlockTypes["Kelp"] = "minecraft:kelp";
    MinecraftBlockTypes["Ladder"] = "minecraft:ladder";
    MinecraftBlockTypes["Lantern"] = "minecraft:lantern";
    MinecraftBlockTypes["LapisBlock"] = "minecraft:lapis_block";
    MinecraftBlockTypes["LapisOre"] = "minecraft:lapis_ore";
    MinecraftBlockTypes["LargeAmethystBud"] = "minecraft:large_amethyst_bud";
    MinecraftBlockTypes["Lava"] = "minecraft:lava";
    MinecraftBlockTypes["Leaves"] = "minecraft:leaves";
    MinecraftBlockTypes["Leaves2"] = "minecraft:leaves2";
    MinecraftBlockTypes["Lectern"] = "minecraft:lectern";
    MinecraftBlockTypes["Lever"] = "minecraft:lever";
    MinecraftBlockTypes["LightBlock"] = "minecraft:light_block";
    MinecraftBlockTypes["LightBlueCandle"] = "minecraft:light_blue_candle";
    MinecraftBlockTypes["LightBlueCandleCake"] = "minecraft:light_blue_candle_cake";
    MinecraftBlockTypes["LightBlueCarpet"] = "minecraft:light_blue_carpet";
    MinecraftBlockTypes["LightBlueGlazedTerracotta"] = "minecraft:light_blue_glazed_terracotta";
    MinecraftBlockTypes["LightBlueWool"] = "minecraft:light_blue_wool";
    MinecraftBlockTypes["LightGrayCandle"] = "minecraft:light_gray_candle";
    MinecraftBlockTypes["LightGrayCandleCake"] = "minecraft:light_gray_candle_cake";
    MinecraftBlockTypes["LightGrayCarpet"] = "minecraft:light_gray_carpet";
    MinecraftBlockTypes["LightGrayWool"] = "minecraft:light_gray_wool";
    MinecraftBlockTypes["LightWeightedPressurePlate"] = "minecraft:light_weighted_pressure_plate";
    MinecraftBlockTypes["LightningRod"] = "minecraft:lightning_rod";
    MinecraftBlockTypes["LimeCandle"] = "minecraft:lime_candle";
    MinecraftBlockTypes["LimeCandleCake"] = "minecraft:lime_candle_cake";
    MinecraftBlockTypes["LimeCarpet"] = "minecraft:lime_carpet";
    MinecraftBlockTypes["LimeGlazedTerracotta"] = "minecraft:lime_glazed_terracotta";
    MinecraftBlockTypes["LimeWool"] = "minecraft:lime_wool";
    MinecraftBlockTypes["LitBlastFurnace"] = "minecraft:lit_blast_furnace";
    MinecraftBlockTypes["LitDeepslateRedstoneOre"] = "minecraft:lit_deepslate_redstone_ore";
    MinecraftBlockTypes["LitFurnace"] = "minecraft:lit_furnace";
    MinecraftBlockTypes["LitPumpkin"] = "minecraft:lit_pumpkin";
    MinecraftBlockTypes["LitRedstoneLamp"] = "minecraft:lit_redstone_lamp";
    MinecraftBlockTypes["LitRedstoneOre"] = "minecraft:lit_redstone_ore";
    MinecraftBlockTypes["LitSmoker"] = "minecraft:lit_smoker";
    MinecraftBlockTypes["Lodestone"] = "minecraft:lodestone";
    MinecraftBlockTypes["Loom"] = "minecraft:loom";
    MinecraftBlockTypes["MagentaCandle"] = "minecraft:magenta_candle";
    MinecraftBlockTypes["MagentaCandleCake"] = "minecraft:magenta_candle_cake";
    MinecraftBlockTypes["MagentaCarpet"] = "minecraft:magenta_carpet";
    MinecraftBlockTypes["MagentaGlazedTerracotta"] = "minecraft:magenta_glazed_terracotta";
    MinecraftBlockTypes["MagentaWool"] = "minecraft:magenta_wool";
    MinecraftBlockTypes["Magma"] = "minecraft:magma";
    MinecraftBlockTypes["MangroveButton"] = "minecraft:mangrove_button";
    MinecraftBlockTypes["MangroveDoor"] = "minecraft:mangrove_door";
    MinecraftBlockTypes["MangroveDoubleSlab"] = "minecraft:mangrove_double_slab";
    MinecraftBlockTypes["MangroveFence"] = "minecraft:mangrove_fence";
    MinecraftBlockTypes["MangroveFenceGate"] = "minecraft:mangrove_fence_gate";
    MinecraftBlockTypes["MangroveHangingSign"] = "minecraft:mangrove_hanging_sign";
    MinecraftBlockTypes["MangroveLeaves"] = "minecraft:mangrove_leaves";
    MinecraftBlockTypes["MangroveLog"] = "minecraft:mangrove_log";
    MinecraftBlockTypes["MangrovePlanks"] = "minecraft:mangrove_planks";
    MinecraftBlockTypes["MangrovePressurePlate"] = "minecraft:mangrove_pressure_plate";
    MinecraftBlockTypes["MangrovePropagule"] = "minecraft:mangrove_propagule";
    MinecraftBlockTypes["MangroveRoots"] = "minecraft:mangrove_roots";
    MinecraftBlockTypes["MangroveSlab"] = "minecraft:mangrove_slab";
    MinecraftBlockTypes["MangroveStairs"] = "minecraft:mangrove_stairs";
    MinecraftBlockTypes["MangroveStandingSign"] = "minecraft:mangrove_standing_sign";
    MinecraftBlockTypes["MangroveTrapdoor"] = "minecraft:mangrove_trapdoor";
    MinecraftBlockTypes["MangroveWallSign"] = "minecraft:mangrove_wall_sign";
    MinecraftBlockTypes["MangroveWood"] = "minecraft:mangrove_wood";
    MinecraftBlockTypes["MediumAmethystBud"] = "minecraft:medium_amethyst_bud";
    MinecraftBlockTypes["MelonBlock"] = "minecraft:melon_block";
    MinecraftBlockTypes["MelonStem"] = "minecraft:melon_stem";
    MinecraftBlockTypes["MobSpawner"] = "minecraft:mob_spawner";
    MinecraftBlockTypes["MonsterEgg"] = "minecraft:monster_egg";
    MinecraftBlockTypes["MossBlock"] = "minecraft:moss_block";
    MinecraftBlockTypes["MossCarpet"] = "minecraft:moss_carpet";
    MinecraftBlockTypes["MossyCobblestone"] = "minecraft:mossy_cobblestone";
    MinecraftBlockTypes["MossyCobblestoneStairs"] = "minecraft:mossy_cobblestone_stairs";
    MinecraftBlockTypes["MossyStoneBrickStairs"] = "minecraft:mossy_stone_brick_stairs";
    MinecraftBlockTypes["MovingBlock"] = "minecraft:moving_block";
    MinecraftBlockTypes["Mud"] = "minecraft:mud";
    MinecraftBlockTypes["MudBrickDoubleSlab"] = "minecraft:mud_brick_double_slab";
    MinecraftBlockTypes["MudBrickSlab"] = "minecraft:mud_brick_slab";
    MinecraftBlockTypes["MudBrickStairs"] = "minecraft:mud_brick_stairs";
    MinecraftBlockTypes["MudBrickWall"] = "minecraft:mud_brick_wall";
    MinecraftBlockTypes["MudBricks"] = "minecraft:mud_bricks";
    MinecraftBlockTypes["MuddyMangroveRoots"] = "minecraft:muddy_mangrove_roots";
    MinecraftBlockTypes["Mycelium"] = "minecraft:mycelium";
    MinecraftBlockTypes["NetherBrick"] = "minecraft:nether_brick";
    MinecraftBlockTypes["NetherBrickFence"] = "minecraft:nether_brick_fence";
    MinecraftBlockTypes["NetherBrickStairs"] = "minecraft:nether_brick_stairs";
    MinecraftBlockTypes["NetherGoldOre"] = "minecraft:nether_gold_ore";
    MinecraftBlockTypes["NetherSprouts"] = "minecraft:nether_sprouts";
    MinecraftBlockTypes["NetherWart"] = "minecraft:nether_wart";
    MinecraftBlockTypes["NetherWartBlock"] = "minecraft:nether_wart_block";
    MinecraftBlockTypes["NetheriteBlock"] = "minecraft:netherite_block";
    MinecraftBlockTypes["Netherrack"] = "minecraft:netherrack";
    MinecraftBlockTypes["Netherreactor"] = "minecraft:netherreactor";
    MinecraftBlockTypes["NormalStoneStairs"] = "minecraft:normal_stone_stairs";
    MinecraftBlockTypes["Noteblock"] = "minecraft:noteblock";
    MinecraftBlockTypes["OakFence"] = "minecraft:oak_fence";
    MinecraftBlockTypes["OakHangingSign"] = "minecraft:oak_hanging_sign";
    MinecraftBlockTypes["OakLog"] = "minecraft:oak_log";
    MinecraftBlockTypes["OakStairs"] = "minecraft:oak_stairs";
    MinecraftBlockTypes["Observer"] = "minecraft:observer";
    MinecraftBlockTypes["Obsidian"] = "minecraft:obsidian";
    MinecraftBlockTypes["OchreFroglight"] = "minecraft:ochre_froglight";
    MinecraftBlockTypes["OrangeCandle"] = "minecraft:orange_candle";
    MinecraftBlockTypes["OrangeCandleCake"] = "minecraft:orange_candle_cake";
    MinecraftBlockTypes["OrangeCarpet"] = "minecraft:orange_carpet";
    MinecraftBlockTypes["OrangeGlazedTerracotta"] = "minecraft:orange_glazed_terracotta";
    MinecraftBlockTypes["OrangeWool"] = "minecraft:orange_wool";
    MinecraftBlockTypes["OxidizedCopper"] = "minecraft:oxidized_copper";
    MinecraftBlockTypes["OxidizedCutCopper"] = "minecraft:oxidized_cut_copper";
    MinecraftBlockTypes["OxidizedCutCopperSlab"] = "minecraft:oxidized_cut_copper_slab";
    MinecraftBlockTypes["OxidizedCutCopperStairs"] = "minecraft:oxidized_cut_copper_stairs";
    MinecraftBlockTypes["OxidizedDoubleCutCopperSlab"] = "minecraft:oxidized_double_cut_copper_slab";
    MinecraftBlockTypes["PackedIce"] = "minecraft:packed_ice";
    MinecraftBlockTypes["PackedMud"] = "minecraft:packed_mud";
    MinecraftBlockTypes["PearlescentFroglight"] = "minecraft:pearlescent_froglight";
    MinecraftBlockTypes["PinkCandle"] = "minecraft:pink_candle";
    MinecraftBlockTypes["PinkCandleCake"] = "minecraft:pink_candle_cake";
    MinecraftBlockTypes["PinkCarpet"] = "minecraft:pink_carpet";
    MinecraftBlockTypes["PinkGlazedTerracotta"] = "minecraft:pink_glazed_terracotta";
    MinecraftBlockTypes["PinkPetals"] = "minecraft:pink_petals";
    MinecraftBlockTypes["PinkWool"] = "minecraft:pink_wool";
    MinecraftBlockTypes["Piston"] = "minecraft:piston";
    MinecraftBlockTypes["PistonArmCollision"] = "minecraft:piston_arm_collision";
    MinecraftBlockTypes["PitcherCrop"] = "minecraft:pitcher_crop";
    MinecraftBlockTypes["PitcherPlant"] = "minecraft:pitcher_plant";
    MinecraftBlockTypes["Planks"] = "minecraft:planks";
    MinecraftBlockTypes["Podzol"] = "minecraft:podzol";
    MinecraftBlockTypes["PointedDripstone"] = "minecraft:pointed_dripstone";
    MinecraftBlockTypes["PolishedAndesiteStairs"] = "minecraft:polished_andesite_stairs";
    MinecraftBlockTypes["PolishedBasalt"] = "minecraft:polished_basalt";
    MinecraftBlockTypes["PolishedBlackstone"] = "minecraft:polished_blackstone";
    MinecraftBlockTypes["PolishedBlackstoneBrickDoubleSlab"] = "minecraft:polished_blackstone_brick_double_slab";
    MinecraftBlockTypes["PolishedBlackstoneBrickSlab"] = "minecraft:polished_blackstone_brick_slab";
    MinecraftBlockTypes["PolishedBlackstoneBrickStairs"] = "minecraft:polished_blackstone_brick_stairs";
    MinecraftBlockTypes["PolishedBlackstoneBrickWall"] = "minecraft:polished_blackstone_brick_wall";
    MinecraftBlockTypes["PolishedBlackstoneBricks"] = "minecraft:polished_blackstone_bricks";
    MinecraftBlockTypes["PolishedBlackstoneButton"] = "minecraft:polished_blackstone_button";
    MinecraftBlockTypes["PolishedBlackstoneDoubleSlab"] = "minecraft:polished_blackstone_double_slab";
    MinecraftBlockTypes["PolishedBlackstonePressurePlate"] = "minecraft:polished_blackstone_pressure_plate";
    MinecraftBlockTypes["PolishedBlackstoneSlab"] = "minecraft:polished_blackstone_slab";
    MinecraftBlockTypes["PolishedBlackstoneStairs"] = "minecraft:polished_blackstone_stairs";
    MinecraftBlockTypes["PolishedBlackstoneWall"] = "minecraft:polished_blackstone_wall";
    MinecraftBlockTypes["PolishedDeepslate"] = "minecraft:polished_deepslate";
    MinecraftBlockTypes["PolishedDeepslateDoubleSlab"] = "minecraft:polished_deepslate_double_slab";
    MinecraftBlockTypes["PolishedDeepslateSlab"] = "minecraft:polished_deepslate_slab";
    MinecraftBlockTypes["PolishedDeepslateStairs"] = "minecraft:polished_deepslate_stairs";
    MinecraftBlockTypes["PolishedDeepslateWall"] = "minecraft:polished_deepslate_wall";
    MinecraftBlockTypes["PolishedDioriteStairs"] = "minecraft:polished_diorite_stairs";
    MinecraftBlockTypes["PolishedGraniteStairs"] = "minecraft:polished_granite_stairs";
    MinecraftBlockTypes["Portal"] = "minecraft:portal";
    MinecraftBlockTypes["Potatoes"] = "minecraft:potatoes";
    MinecraftBlockTypes["PowderSnow"] = "minecraft:powder_snow";
    MinecraftBlockTypes["PoweredComparator"] = "minecraft:powered_comparator";
    MinecraftBlockTypes["PoweredRepeater"] = "minecraft:powered_repeater";
    MinecraftBlockTypes["Prismarine"] = "minecraft:prismarine";
    MinecraftBlockTypes["PrismarineBricksStairs"] = "minecraft:prismarine_bricks_stairs";
    MinecraftBlockTypes["PrismarineStairs"] = "minecraft:prismarine_stairs";
    MinecraftBlockTypes["Pumpkin"] = "minecraft:pumpkin";
    MinecraftBlockTypes["PumpkinStem"] = "minecraft:pumpkin_stem";
    MinecraftBlockTypes["PurpleCandle"] = "minecraft:purple_candle";
    MinecraftBlockTypes["PurpleCandleCake"] = "minecraft:purple_candle_cake";
    MinecraftBlockTypes["PurpleCarpet"] = "minecraft:purple_carpet";
    MinecraftBlockTypes["PurpleGlazedTerracotta"] = "minecraft:purple_glazed_terracotta";
    MinecraftBlockTypes["PurpleWool"] = "minecraft:purple_wool";
    MinecraftBlockTypes["PurpurBlock"] = "minecraft:purpur_block";
    MinecraftBlockTypes["PurpurStairs"] = "minecraft:purpur_stairs";
    MinecraftBlockTypes["QuartzBlock"] = "minecraft:quartz_block";
    MinecraftBlockTypes["QuartzBricks"] = "minecraft:quartz_bricks";
    MinecraftBlockTypes["QuartzOre"] = "minecraft:quartz_ore";
    MinecraftBlockTypes["QuartzStairs"] = "minecraft:quartz_stairs";
    MinecraftBlockTypes["Rail"] = "minecraft:rail";
    MinecraftBlockTypes["RawCopperBlock"] = "minecraft:raw_copper_block";
    MinecraftBlockTypes["RawGoldBlock"] = "minecraft:raw_gold_block";
    MinecraftBlockTypes["RawIronBlock"] = "minecraft:raw_iron_block";
    MinecraftBlockTypes["RedCandle"] = "minecraft:red_candle";
    MinecraftBlockTypes["RedCandleCake"] = "minecraft:red_candle_cake";
    MinecraftBlockTypes["RedCarpet"] = "minecraft:red_carpet";
    MinecraftBlockTypes["RedFlower"] = "minecraft:red_flower";
    MinecraftBlockTypes["RedGlazedTerracotta"] = "minecraft:red_glazed_terracotta";
    MinecraftBlockTypes["RedMushroom"] = "minecraft:red_mushroom";
    MinecraftBlockTypes["RedMushroomBlock"] = "minecraft:red_mushroom_block";
    MinecraftBlockTypes["RedNetherBrick"] = "minecraft:red_nether_brick";
    MinecraftBlockTypes["RedNetherBrickStairs"] = "minecraft:red_nether_brick_stairs";
    MinecraftBlockTypes["RedSandstone"] = "minecraft:red_sandstone";
    MinecraftBlockTypes["RedSandstoneStairs"] = "minecraft:red_sandstone_stairs";
    MinecraftBlockTypes["RedWool"] = "minecraft:red_wool";
    MinecraftBlockTypes["RedstoneBlock"] = "minecraft:redstone_block";
    MinecraftBlockTypes["RedstoneLamp"] = "minecraft:redstone_lamp";
    MinecraftBlockTypes["RedstoneOre"] = "minecraft:redstone_ore";
    MinecraftBlockTypes["RedstoneTorch"] = "minecraft:redstone_torch";
    MinecraftBlockTypes["RedstoneWire"] = "minecraft:redstone_wire";
    MinecraftBlockTypes["Reeds"] = "minecraft:reeds";
    MinecraftBlockTypes["ReinforcedDeepslate"] = "minecraft:reinforced_deepslate";
    MinecraftBlockTypes["RepeatingCommandBlock"] = "minecraft:repeating_command_block";
    MinecraftBlockTypes["Reserved6"] = "minecraft:reserved6";
    MinecraftBlockTypes["RespawnAnchor"] = "minecraft:respawn_anchor";
    MinecraftBlockTypes["Sand"] = "minecraft:sand";
    MinecraftBlockTypes["Sandstone"] = "minecraft:sandstone";
    MinecraftBlockTypes["SandstoneStairs"] = "minecraft:sandstone_stairs";
    MinecraftBlockTypes["Sapling"] = "minecraft:sapling";
    MinecraftBlockTypes["Scaffolding"] = "minecraft:scaffolding";
    MinecraftBlockTypes["Sculk"] = "minecraft:sculk";
    MinecraftBlockTypes["SculkCatalyst"] = "minecraft:sculk_catalyst";
    MinecraftBlockTypes["SculkSensor"] = "minecraft:sculk_sensor";
    MinecraftBlockTypes["SculkShrieker"] = "minecraft:sculk_shrieker";
    MinecraftBlockTypes["SculkVein"] = "minecraft:sculk_vein";
    MinecraftBlockTypes["SeaLantern"] = "minecraft:sea_lantern";
    MinecraftBlockTypes["SeaPickle"] = "minecraft:sea_pickle";
    MinecraftBlockTypes["Seagrass"] = "minecraft:seagrass";
    MinecraftBlockTypes["Shroomlight"] = "minecraft:shroomlight";
    MinecraftBlockTypes["ShulkerBox"] = "minecraft:shulker_box";
    MinecraftBlockTypes["SilverGlazedTerracotta"] = "minecraft:silver_glazed_terracotta";
    MinecraftBlockTypes["Skull"] = "minecraft:skull";
    MinecraftBlockTypes["Slime"] = "minecraft:slime";
    MinecraftBlockTypes["SmallAmethystBud"] = "minecraft:small_amethyst_bud";
    MinecraftBlockTypes["SmallDripleafBlock"] = "minecraft:small_dripleaf_block";
    MinecraftBlockTypes["SmithingTable"] = "minecraft:smithing_table";
    MinecraftBlockTypes["Smoker"] = "minecraft:smoker";
    MinecraftBlockTypes["SmoothBasalt"] = "minecraft:smooth_basalt";
    MinecraftBlockTypes["SmoothQuartzStairs"] = "minecraft:smooth_quartz_stairs";
    MinecraftBlockTypes["SmoothRedSandstoneStairs"] = "minecraft:smooth_red_sandstone_stairs";
    MinecraftBlockTypes["SmoothSandstoneStairs"] = "minecraft:smooth_sandstone_stairs";
    MinecraftBlockTypes["SmoothStone"] = "minecraft:smooth_stone";
    MinecraftBlockTypes["SnifferEgg"] = "minecraft:sniffer_egg";
    MinecraftBlockTypes["Snow"] = "minecraft:snow";
    MinecraftBlockTypes["SnowLayer"] = "minecraft:snow_layer";
    MinecraftBlockTypes["SoulCampfire"] = "minecraft:soul_campfire";
    MinecraftBlockTypes["SoulFire"] = "minecraft:soul_fire";
    MinecraftBlockTypes["SoulLantern"] = "minecraft:soul_lantern";
    MinecraftBlockTypes["SoulSand"] = "minecraft:soul_sand";
    MinecraftBlockTypes["SoulSoil"] = "minecraft:soul_soil";
    MinecraftBlockTypes["SoulTorch"] = "minecraft:soul_torch";
    MinecraftBlockTypes["Sponge"] = "minecraft:sponge";
    MinecraftBlockTypes["SporeBlossom"] = "minecraft:spore_blossom";
    MinecraftBlockTypes["SpruceButton"] = "minecraft:spruce_button";
    MinecraftBlockTypes["SpruceDoor"] = "minecraft:spruce_door";
    MinecraftBlockTypes["SpruceFence"] = "minecraft:spruce_fence";
    MinecraftBlockTypes["SpruceFenceGate"] = "minecraft:spruce_fence_gate";
    MinecraftBlockTypes["SpruceHangingSign"] = "minecraft:spruce_hanging_sign";
    MinecraftBlockTypes["SpruceLog"] = "minecraft:spruce_log";
    MinecraftBlockTypes["SprucePressurePlate"] = "minecraft:spruce_pressure_plate";
    MinecraftBlockTypes["SpruceStairs"] = "minecraft:spruce_stairs";
    MinecraftBlockTypes["SpruceStandingSign"] = "minecraft:spruce_standing_sign";
    MinecraftBlockTypes["SpruceTrapdoor"] = "minecraft:spruce_trapdoor";
    MinecraftBlockTypes["SpruceWallSign"] = "minecraft:spruce_wall_sign";
    MinecraftBlockTypes["StainedGlass"] = "minecraft:stained_glass";
    MinecraftBlockTypes["StainedGlassPane"] = "minecraft:stained_glass_pane";
    MinecraftBlockTypes["StainedHardenedClay"] = "minecraft:stained_hardened_clay";
    MinecraftBlockTypes["StandingBanner"] = "minecraft:standing_banner";
    MinecraftBlockTypes["StandingSign"] = "minecraft:standing_sign";
    MinecraftBlockTypes["StickyPiston"] = "minecraft:sticky_piston";
    MinecraftBlockTypes["StickyPistonArmCollision"] = "minecraft:sticky_piston_arm_collision";
    MinecraftBlockTypes["Stone"] = "minecraft:stone";
    MinecraftBlockTypes["StoneBlockSlab"] = "minecraft:stone_block_slab";
    MinecraftBlockTypes["StoneBlockSlab2"] = "minecraft:stone_block_slab2";
    MinecraftBlockTypes["StoneBlockSlab3"] = "minecraft:stone_block_slab3";
    MinecraftBlockTypes["StoneBlockSlab4"] = "minecraft:stone_block_slab4";
    MinecraftBlockTypes["StoneBrickStairs"] = "minecraft:stone_brick_stairs";
    MinecraftBlockTypes["StoneButton"] = "minecraft:stone_button";
    MinecraftBlockTypes["StonePressurePlate"] = "minecraft:stone_pressure_plate";
    MinecraftBlockTypes["StoneStairs"] = "minecraft:stone_stairs";
    MinecraftBlockTypes["Stonebrick"] = "minecraft:stonebrick";
    MinecraftBlockTypes["Stonecutter"] = "minecraft:stonecutter";
    MinecraftBlockTypes["StonecutterBlock"] = "minecraft:stonecutter_block";
    MinecraftBlockTypes["StrippedAcaciaLog"] = "minecraft:stripped_acacia_log";
    MinecraftBlockTypes["StrippedBambooBlock"] = "minecraft:stripped_bamboo_block";
    MinecraftBlockTypes["StrippedBirchLog"] = "minecraft:stripped_birch_log";
    MinecraftBlockTypes["StrippedCherryLog"] = "minecraft:stripped_cherry_log";
    MinecraftBlockTypes["StrippedCherryWood"] = "minecraft:stripped_cherry_wood";
    MinecraftBlockTypes["StrippedCrimsonHyphae"] = "minecraft:stripped_crimson_hyphae";
    MinecraftBlockTypes["StrippedCrimsonStem"] = "minecraft:stripped_crimson_stem";
    MinecraftBlockTypes["StrippedDarkOakLog"] = "minecraft:stripped_dark_oak_log";
    MinecraftBlockTypes["StrippedJungleLog"] = "minecraft:stripped_jungle_log";
    MinecraftBlockTypes["StrippedMangroveLog"] = "minecraft:stripped_mangrove_log";
    MinecraftBlockTypes["StrippedMangroveWood"] = "minecraft:stripped_mangrove_wood";
    MinecraftBlockTypes["StrippedOakLog"] = "minecraft:stripped_oak_log";
    MinecraftBlockTypes["StrippedSpruceLog"] = "minecraft:stripped_spruce_log";
    MinecraftBlockTypes["StrippedWarpedHyphae"] = "minecraft:stripped_warped_hyphae";
    MinecraftBlockTypes["StrippedWarpedStem"] = "minecraft:stripped_warped_stem";
    MinecraftBlockTypes["StructureBlock"] = "minecraft:structure_block";
    MinecraftBlockTypes["StructureVoid"] = "minecraft:structure_void";
    MinecraftBlockTypes["SuspiciousGravel"] = "minecraft:suspicious_gravel";
    MinecraftBlockTypes["SuspiciousSand"] = "minecraft:suspicious_sand";
    MinecraftBlockTypes["SweetBerryBush"] = "minecraft:sweet_berry_bush";
    MinecraftBlockTypes["Tallgrass"] = "minecraft:tallgrass";
    MinecraftBlockTypes["Target"] = "minecraft:target";
    MinecraftBlockTypes["TintedGlass"] = "minecraft:tinted_glass";
    MinecraftBlockTypes["Tnt"] = "minecraft:tnt";
    MinecraftBlockTypes["Torch"] = "minecraft:torch";
    MinecraftBlockTypes["Torchflower"] = "minecraft:torchflower";
    MinecraftBlockTypes["TorchflowerCrop"] = "minecraft:torchflower_crop";
    MinecraftBlockTypes["Trapdoor"] = "minecraft:trapdoor";
    MinecraftBlockTypes["TrappedChest"] = "minecraft:trapped_chest";
    MinecraftBlockTypes["TripWire"] = "minecraft:trip_wire";
    MinecraftBlockTypes["TripwireHook"] = "minecraft:tripwire_hook";
    MinecraftBlockTypes["TubeCoral"] = "minecraft:tube_coral";
    MinecraftBlockTypes["Tuff"] = "minecraft:tuff";
    MinecraftBlockTypes["TurtleEgg"] = "minecraft:turtle_egg";
    MinecraftBlockTypes["TwistingVines"] = "minecraft:twisting_vines";
    MinecraftBlockTypes["UnderwaterTorch"] = "minecraft:underwater_torch";
    MinecraftBlockTypes["UndyedShulkerBox"] = "minecraft:undyed_shulker_box";
    MinecraftBlockTypes["Unknown"] = "minecraft:unknown";
    MinecraftBlockTypes["UnlitRedstoneTorch"] = "minecraft:unlit_redstone_torch";
    MinecraftBlockTypes["UnpoweredComparator"] = "minecraft:unpowered_comparator";
    MinecraftBlockTypes["UnpoweredRepeater"] = "minecraft:unpowered_repeater";
    MinecraftBlockTypes["VerdantFroglight"] = "minecraft:verdant_froglight";
    MinecraftBlockTypes["Vine"] = "minecraft:vine";
    MinecraftBlockTypes["WallBanner"] = "minecraft:wall_banner";
    MinecraftBlockTypes["WallSign"] = "minecraft:wall_sign";
    MinecraftBlockTypes["WarpedButton"] = "minecraft:warped_button";
    MinecraftBlockTypes["WarpedDoor"] = "minecraft:warped_door";
    MinecraftBlockTypes["WarpedDoubleSlab"] = "minecraft:warped_double_slab";
    MinecraftBlockTypes["WarpedFence"] = "minecraft:warped_fence";
    MinecraftBlockTypes["WarpedFenceGate"] = "minecraft:warped_fence_gate";
    MinecraftBlockTypes["WarpedFungus"] = "minecraft:warped_fungus";
    MinecraftBlockTypes["WarpedHangingSign"] = "minecraft:warped_hanging_sign";
    MinecraftBlockTypes["WarpedHyphae"] = "minecraft:warped_hyphae";
    MinecraftBlockTypes["WarpedNylium"] = "minecraft:warped_nylium";
    MinecraftBlockTypes["WarpedPlanks"] = "minecraft:warped_planks";
    MinecraftBlockTypes["WarpedPressurePlate"] = "minecraft:warped_pressure_plate";
    MinecraftBlockTypes["WarpedRoots"] = "minecraft:warped_roots";
    MinecraftBlockTypes["WarpedSlab"] = "minecraft:warped_slab";
    MinecraftBlockTypes["WarpedStairs"] = "minecraft:warped_stairs";
    MinecraftBlockTypes["WarpedStandingSign"] = "minecraft:warped_standing_sign";
    MinecraftBlockTypes["WarpedStem"] = "minecraft:warped_stem";
    MinecraftBlockTypes["WarpedTrapdoor"] = "minecraft:warped_trapdoor";
    MinecraftBlockTypes["WarpedWallSign"] = "minecraft:warped_wall_sign";
    MinecraftBlockTypes["WarpedWartBlock"] = "minecraft:warped_wart_block";
    MinecraftBlockTypes["Water"] = "minecraft:water";
    MinecraftBlockTypes["Waterlily"] = "minecraft:waterlily";
    MinecraftBlockTypes["WaxedCopper"] = "minecraft:waxed_copper";
    MinecraftBlockTypes["WaxedCutCopper"] = "minecraft:waxed_cut_copper";
    MinecraftBlockTypes["WaxedCutCopperSlab"] = "minecraft:waxed_cut_copper_slab";
    MinecraftBlockTypes["WaxedCutCopperStairs"] = "minecraft:waxed_cut_copper_stairs";
    MinecraftBlockTypes["WaxedDoubleCutCopperSlab"] = "minecraft:waxed_double_cut_copper_slab";
    MinecraftBlockTypes["WaxedExposedCopper"] = "minecraft:waxed_exposed_copper";
    MinecraftBlockTypes["WaxedExposedCutCopper"] = "minecraft:waxed_exposed_cut_copper";
    MinecraftBlockTypes["WaxedExposedCutCopperSlab"] = "minecraft:waxed_exposed_cut_copper_slab";
    MinecraftBlockTypes["WaxedExposedCutCopperStairs"] = "minecraft:waxed_exposed_cut_copper_stairs";
    MinecraftBlockTypes["WaxedExposedDoubleCutCopperSlab"] = "minecraft:waxed_exposed_double_cut_copper_slab";
    MinecraftBlockTypes["WaxedOxidizedCopper"] = "minecraft:waxed_oxidized_copper";
    MinecraftBlockTypes["WaxedOxidizedCutCopper"] = "minecraft:waxed_oxidized_cut_copper";
    MinecraftBlockTypes["WaxedOxidizedCutCopperSlab"] = "minecraft:waxed_oxidized_cut_copper_slab";
    MinecraftBlockTypes["WaxedOxidizedCutCopperStairs"] = "minecraft:waxed_oxidized_cut_copper_stairs";
    MinecraftBlockTypes["WaxedOxidizedDoubleCutCopperSlab"] = "minecraft:waxed_oxidized_double_cut_copper_slab";
    MinecraftBlockTypes["WaxedWeatheredCopper"] = "minecraft:waxed_weathered_copper";
    MinecraftBlockTypes["WaxedWeatheredCutCopper"] = "minecraft:waxed_weathered_cut_copper";
    MinecraftBlockTypes["WaxedWeatheredCutCopperSlab"] = "minecraft:waxed_weathered_cut_copper_slab";
    MinecraftBlockTypes["WaxedWeatheredCutCopperStairs"] = "minecraft:waxed_weathered_cut_copper_stairs";
    MinecraftBlockTypes["WaxedWeatheredDoubleCutCopperSlab"] = "minecraft:waxed_weathered_double_cut_copper_slab";
    MinecraftBlockTypes["WeatheredCopper"] = "minecraft:weathered_copper";
    MinecraftBlockTypes["WeatheredCutCopper"] = "minecraft:weathered_cut_copper";
    MinecraftBlockTypes["WeatheredCutCopperSlab"] = "minecraft:weathered_cut_copper_slab";
    MinecraftBlockTypes["WeatheredCutCopperStairs"] = "minecraft:weathered_cut_copper_stairs";
    MinecraftBlockTypes["WeatheredDoubleCutCopperSlab"] = "minecraft:weathered_double_cut_copper_slab";
    MinecraftBlockTypes["Web"] = "minecraft:web";
    MinecraftBlockTypes["WeepingVines"] = "minecraft:weeping_vines";
    MinecraftBlockTypes["Wheat"] = "minecraft:wheat";
    MinecraftBlockTypes["WhiteCandle"] = "minecraft:white_candle";
    MinecraftBlockTypes["WhiteCandleCake"] = "minecraft:white_candle_cake";
    MinecraftBlockTypes["WhiteCarpet"] = "minecraft:white_carpet";
    MinecraftBlockTypes["WhiteGlazedTerracotta"] = "minecraft:white_glazed_terracotta";
    MinecraftBlockTypes["WhiteWool"] = "minecraft:white_wool";
    MinecraftBlockTypes["WitherRose"] = "minecraft:wither_rose";
    MinecraftBlockTypes["Wood"] = "minecraft:wood";
    MinecraftBlockTypes["WoodenButton"] = "minecraft:wooden_button";
    MinecraftBlockTypes["WoodenDoor"] = "minecraft:wooden_door";
    MinecraftBlockTypes["WoodenPressurePlate"] = "minecraft:wooden_pressure_plate";
    MinecraftBlockTypes["WoodenSlab"] = "minecraft:wooden_slab";
    MinecraftBlockTypes["YellowCandle"] = "minecraft:yellow_candle";
    MinecraftBlockTypes["YellowCandleCake"] = "minecraft:yellow_candle_cake";
    MinecraftBlockTypes["YellowCarpet"] = "minecraft:yellow_carpet";
    MinecraftBlockTypes["YellowFlower"] = "minecraft:yellow_flower";
    MinecraftBlockTypes["YellowGlazedTerracotta"] = "minecraft:yellow_glazed_terracotta";
    MinecraftBlockTypes["YellowWool"] = "minecraft:yellow_wool";
})(MinecraftBlockTypes || (MinecraftBlockTypes = {}));

var MinecraftDimensionTypes;

(function(MinecraftDimensionTypes) {
    MinecraftDimensionTypes["Nether"] = "minecraft:nether";
    MinecraftDimensionTypes["Overworld"] = "minecraft:overworld";
    MinecraftDimensionTypes["TheEnd"] = "minecraft:the_end";
})(MinecraftDimensionTypes || (MinecraftDimensionTypes = {}));

var MinecraftEffectTypes;

(function(MinecraftEffectTypes) {
    MinecraftEffectTypes["Absorption"] = "absorption";
    MinecraftEffectTypes["BadOmen"] = "bad_omen";
    MinecraftEffectTypes["Blindness"] = "blindness";
    MinecraftEffectTypes["ConduitPower"] = "conduit_power";
    MinecraftEffectTypes["Darkness"] = "darkness";
    MinecraftEffectTypes["Empty"] = "empty";
    MinecraftEffectTypes["FatalPoison"] = "fatal_poison";
    MinecraftEffectTypes["FireResistance"] = "fire_resistance";
    MinecraftEffectTypes["Haste"] = "haste";
    MinecraftEffectTypes["HealthBoost"] = "health_boost";
    MinecraftEffectTypes["Hunger"] = "hunger";
    MinecraftEffectTypes["InstantDamage"] = "instant_damage";
    MinecraftEffectTypes["InstantHealth"] = "instant_health";
    MinecraftEffectTypes["Invisibility"] = "invisibility";
    MinecraftEffectTypes["JumpBoost"] = "jump_boost";
    MinecraftEffectTypes["Levitation"] = "levitation";
    MinecraftEffectTypes["MiningFatigue"] = "mining_fatigue";
    MinecraftEffectTypes["Nausea"] = "nausea";
    MinecraftEffectTypes["NightVision"] = "night_vision";
    MinecraftEffectTypes["Poison"] = "poison";
    MinecraftEffectTypes["Regeneration"] = "regeneration";
    MinecraftEffectTypes["Resistance"] = "resistance";
    MinecraftEffectTypes["Saturation"] = "saturation";
    MinecraftEffectTypes["SlowFalling"] = "slow_falling";
    MinecraftEffectTypes["Slowness"] = "slowness";
    MinecraftEffectTypes["Speed"] = "speed";
    MinecraftEffectTypes["Strength"] = "strength";
    MinecraftEffectTypes["VillageHero"] = "village_hero";
    MinecraftEffectTypes["WaterBreathing"] = "water_breathing";
    MinecraftEffectTypes["Weakness"] = "weakness";
    MinecraftEffectTypes["Wither"] = "wither";
})(MinecraftEffectTypes || (MinecraftEffectTypes = {}));

var MinecraftEnchantmentTypes;

(function(MinecraftEnchantmentTypes) {
    MinecraftEnchantmentTypes["AquaAffinity"] = "aqua_affinity";
    MinecraftEnchantmentTypes["BaneOfArthropods"] = "bane_of_arthropods";
    MinecraftEnchantmentTypes["Binding"] = "binding";
    MinecraftEnchantmentTypes["BlastProtection"] = "blast_protection";
    MinecraftEnchantmentTypes["Channeling"] = "channeling";
    MinecraftEnchantmentTypes["DepthStrider"] = "depth_strider";
    MinecraftEnchantmentTypes["Efficiency"] = "efficiency";
    MinecraftEnchantmentTypes["FeatherFalling"] = "feather_falling";
    MinecraftEnchantmentTypes["FireAspect"] = "fire_aspect";
    MinecraftEnchantmentTypes["FireProtection"] = "fire_protection";
    MinecraftEnchantmentTypes["Flame"] = "flame";
    MinecraftEnchantmentTypes["Fortune"] = "fortune";
    MinecraftEnchantmentTypes["FrostWalker"] = "frost_walker";
    MinecraftEnchantmentTypes["Impaling"] = "impaling";
    MinecraftEnchantmentTypes["Infinity"] = "infinity";
    MinecraftEnchantmentTypes["Knockback"] = "knockback";
    MinecraftEnchantmentTypes["Looting"] = "looting";
    MinecraftEnchantmentTypes["Loyalty"] = "loyalty";
    MinecraftEnchantmentTypes["LuckOfTheSea"] = "luck_of_the_sea";
    MinecraftEnchantmentTypes["Lure"] = "lure";
    MinecraftEnchantmentTypes["Mending"] = "mending";
    MinecraftEnchantmentTypes["Multishot"] = "multishot";
    MinecraftEnchantmentTypes["Piercing"] = "piercing";
    MinecraftEnchantmentTypes["Power"] = "power";
    MinecraftEnchantmentTypes["ProjectileProtection"] = "projectile_protection";
    MinecraftEnchantmentTypes["Protection"] = "protection";
    MinecraftEnchantmentTypes["Punch"] = "punch";
    MinecraftEnchantmentTypes["QuickCharge"] = "quick_charge";
    MinecraftEnchantmentTypes["Respiration"] = "respiration";
    MinecraftEnchantmentTypes["Riptide"] = "riptide";
    MinecraftEnchantmentTypes["Sharpness"] = "sharpness";
    MinecraftEnchantmentTypes["SilkTouch"] = "silk_touch";
    MinecraftEnchantmentTypes["Smite"] = "smite";
    MinecraftEnchantmentTypes["SoulSpeed"] = "soul_speed";
    MinecraftEnchantmentTypes["SwiftSneak"] = "swift_sneak";
    MinecraftEnchantmentTypes["Thorns"] = "thorns";
    MinecraftEnchantmentTypes["Unbreaking"] = "unbreaking";
    MinecraftEnchantmentTypes["Vanishing"] = "vanishing";
})(MinecraftEnchantmentTypes || (MinecraftEnchantmentTypes = {}));

var MinecraftEntityTypes;

(function(MinecraftEntityTypes) {
    MinecraftEntityTypes["Agent"] = "agent";
    MinecraftEntityTypes["Allay"] = "allay";
    MinecraftEntityTypes["AreaEffectCloud"] = "area_effect_cloud";
    MinecraftEntityTypes["ArmorStand"] = "armor_stand";
    MinecraftEntityTypes["Arrow"] = "arrow";
    MinecraftEntityTypes["Axolotl"] = "axolotl";
    MinecraftEntityTypes["Bat"] = "bat";
    MinecraftEntityTypes["Bee"] = "bee";
    MinecraftEntityTypes["Blaze"] = "blaze";
    MinecraftEntityTypes["Boat"] = "boat";
    MinecraftEntityTypes["Camel"] = "camel";
    MinecraftEntityTypes["Cat"] = "cat";
    MinecraftEntityTypes["CaveSpider"] = "cave_spider";
    MinecraftEntityTypes["ChestBoat"] = "chest_boat";
    MinecraftEntityTypes["ChestMinecart"] = "chest_minecart";
    MinecraftEntityTypes["Chicken"] = "chicken";
    MinecraftEntityTypes["Cod"] = "cod";
    MinecraftEntityTypes["CommandBlockMinecart"] = "command_block_minecart";
    MinecraftEntityTypes["Cow"] = "cow";
    MinecraftEntityTypes["Creeper"] = "creeper";
    MinecraftEntityTypes["Dolphin"] = "dolphin";
    MinecraftEntityTypes["Donkey"] = "donkey";
    MinecraftEntityTypes["DragonFireball"] = "dragon_fireball";
    MinecraftEntityTypes["Drowned"] = "drowned";
    MinecraftEntityTypes["Egg"] = "egg";
    MinecraftEntityTypes["ElderGuardian"] = "elder_guardian";
    MinecraftEntityTypes["EnderCrystal"] = "ender_crystal";
    MinecraftEntityTypes["EnderDragon"] = "ender_dragon";
    MinecraftEntityTypes["EnderPearl"] = "ender_pearl";
    MinecraftEntityTypes["Enderman"] = "enderman";
    MinecraftEntityTypes["Endermite"] = "endermite";
    MinecraftEntityTypes["EvocationIllager"] = "evocation_illager";
    MinecraftEntityTypes["EyeOfEnderSignal"] = "eye_of_ender_signal";
    MinecraftEntityTypes["Fireball"] = "fireball";
    MinecraftEntityTypes["FireworksRocket"] = "fireworks_rocket";
    MinecraftEntityTypes["FishingHook"] = "fishing_hook";
    MinecraftEntityTypes["Fox"] = "fox";
    MinecraftEntityTypes["Frog"] = "frog";
    MinecraftEntityTypes["Ghast"] = "ghast";
    MinecraftEntityTypes["GlowSquid"] = "glow_squid";
    MinecraftEntityTypes["Goat"] = "goat";
    MinecraftEntityTypes["Guardian"] = "guardian";
    MinecraftEntityTypes["Hoglin"] = "hoglin";
    MinecraftEntityTypes["HopperMinecart"] = "hopper_minecart";
    MinecraftEntityTypes["Horse"] = "horse";
    MinecraftEntityTypes["Husk"] = "husk";
    MinecraftEntityTypes["IronGolem"] = "iron_golem";
    MinecraftEntityTypes["LightningBolt"] = "lightning_bolt";
    MinecraftEntityTypes["LingeringPotion"] = "lingering_potion";
    MinecraftEntityTypes["Llama"] = "llama";
    MinecraftEntityTypes["LlamaSpit"] = "llama_spit";
    MinecraftEntityTypes["MagmaCube"] = "magma_cube";
    MinecraftEntityTypes["Minecart"] = "minecart";
    MinecraftEntityTypes["Mooshroom"] = "mooshroom";
    MinecraftEntityTypes["Mule"] = "mule";
    MinecraftEntityTypes["Npc"] = "npc";
    MinecraftEntityTypes["Ocelot"] = "ocelot";
    MinecraftEntityTypes["Panda"] = "panda";
    MinecraftEntityTypes["Parrot"] = "parrot";
    MinecraftEntityTypes["Phantom"] = "phantom";
    MinecraftEntityTypes["Pig"] = "pig";
    MinecraftEntityTypes["Piglin"] = "piglin";
    MinecraftEntityTypes["PiglinBrute"] = "piglin_brute";
    MinecraftEntityTypes["Pillager"] = "pillager";
    MinecraftEntityTypes["Player"] = "player";
    MinecraftEntityTypes["PolarBear"] = "polar_bear";
    MinecraftEntityTypes["Pufferfish"] = "pufferfish";
    MinecraftEntityTypes["Rabbit"] = "rabbit";
    MinecraftEntityTypes["Ravager"] = "ravager";
    MinecraftEntityTypes["Salmon"] = "salmon";
    MinecraftEntityTypes["Sheep"] = "sheep";
    MinecraftEntityTypes["Shulker"] = "shulker";
    MinecraftEntityTypes["ShulkerBullet"] = "shulker_bullet";
    MinecraftEntityTypes["Silverfish"] = "silverfish";
    MinecraftEntityTypes["Skeleton"] = "skeleton";
    MinecraftEntityTypes["SkeletonHorse"] = "skeleton_horse";
    MinecraftEntityTypes["Slime"] = "slime";
    MinecraftEntityTypes["SmallFireball"] = "small_fireball";
    MinecraftEntityTypes["Sniffer"] = "sniffer";
    MinecraftEntityTypes["SnowGolem"] = "snow_golem";
    MinecraftEntityTypes["Snowball"] = "snowball";
    MinecraftEntityTypes["Spider"] = "spider";
    MinecraftEntityTypes["SplashPotion"] = "splash_potion";
    MinecraftEntityTypes["Squid"] = "squid";
    MinecraftEntityTypes["Stray"] = "stray";
    MinecraftEntityTypes["Strider"] = "strider";
    MinecraftEntityTypes["Tadpole"] = "tadpole";
    MinecraftEntityTypes["ThrownTrident"] = "thrown_trident";
    MinecraftEntityTypes["Tnt"] = "tnt";
    MinecraftEntityTypes["TntMinecart"] = "tnt_minecart";
    MinecraftEntityTypes["TraderLlama"] = "trader_llama";
    MinecraftEntityTypes["TripodCamera"] = "tripod_camera";
    MinecraftEntityTypes["Tropicalfish"] = "tropicalfish";
    MinecraftEntityTypes["Turtle"] = "turtle";
    MinecraftEntityTypes["Vex"] = "vex";
    MinecraftEntityTypes["Villager"] = "villager";
    MinecraftEntityTypes["VillagerV2"] = "villager_v2";
    MinecraftEntityTypes["Vindicator"] = "vindicator";
    MinecraftEntityTypes["WanderingTrader"] = "wandering_trader";
    MinecraftEntityTypes["Warden"] = "warden";
    MinecraftEntityTypes["Witch"] = "witch";
    MinecraftEntityTypes["Wither"] = "wither";
    MinecraftEntityTypes["WitherSkeleton"] = "wither_skeleton";
    MinecraftEntityTypes["WitherSkull"] = "wither_skull";
    MinecraftEntityTypes["WitherSkullDangerous"] = "wither_skull_dangerous";
    MinecraftEntityTypes["Wolf"] = "wolf";
    MinecraftEntityTypes["XpBottle"] = "xp_bottle";
    MinecraftEntityTypes["XpOrb"] = "xp_orb";
    MinecraftEntityTypes["Zoglin"] = "zoglin";
    MinecraftEntityTypes["Zombie"] = "zombie";
    MinecraftEntityTypes["ZombieHorse"] = "zombie_horse";
    MinecraftEntityTypes["ZombiePigman"] = "zombie_pigman";
    MinecraftEntityTypes["ZombieVillager"] = "zombie_villager";
    MinecraftEntityTypes["ZombieVillagerV2"] = "zombie_villager_v2";
})(MinecraftEntityTypes || (MinecraftEntityTypes = {}));

var MinecraftItemTypes;

(function(MinecraftItemTypes) {
    MinecraftItemTypes["AcaciaBoat"] = "minecraft:acacia_boat";
    MinecraftItemTypes["AcaciaButton"] = "minecraft:acacia_button";
    MinecraftItemTypes["AcaciaChestBoat"] = "minecraft:acacia_chest_boat";
    MinecraftItemTypes["AcaciaDoor"] = "minecraft:acacia_door";
    MinecraftItemTypes["AcaciaFence"] = "minecraft:acacia_fence";
    MinecraftItemTypes["AcaciaFenceGate"] = "minecraft:acacia_fence_gate";
    MinecraftItemTypes["AcaciaHangingSign"] = "minecraft:acacia_hanging_sign";
    MinecraftItemTypes["AcaciaLog"] = "minecraft:acacia_log";
    MinecraftItemTypes["AcaciaPressurePlate"] = "minecraft:acacia_pressure_plate";
    MinecraftItemTypes["AcaciaSign"] = "minecraft:acacia_sign";
    MinecraftItemTypes["AcaciaStairs"] = "minecraft:acacia_stairs";
    MinecraftItemTypes["AcaciaTrapdoor"] = "minecraft:acacia_trapdoor";
    MinecraftItemTypes["ActivatorRail"] = "minecraft:activator_rail";
    MinecraftItemTypes["AllaySpawnEgg"] = "minecraft:allay_spawn_egg";
    MinecraftItemTypes["Allow"] = "minecraft:allow";
    MinecraftItemTypes["AmethystBlock"] = "minecraft:amethyst_block";
    MinecraftItemTypes["AmethystCluster"] = "minecraft:amethyst_cluster";
    MinecraftItemTypes["AmethystShard"] = "minecraft:amethyst_shard";
    MinecraftItemTypes["AncientDebris"] = "minecraft:ancient_debris";
    MinecraftItemTypes["AndesiteStairs"] = "minecraft:andesite_stairs";
    MinecraftItemTypes["AnglerPotteryShard"] = "minecraft:angler_pottery_shard";
    MinecraftItemTypes["Anvil"] = "minecraft:anvil";
    MinecraftItemTypes["Apple"] = "minecraft:apple";
    MinecraftItemTypes["ArcherPotteryShard"] = "minecraft:archer_pottery_shard";
    MinecraftItemTypes["ArmorStand"] = "minecraft:armor_stand";
    MinecraftItemTypes["ArmsUpPotteryShard"] = "minecraft:arms_up_pottery_shard";
    MinecraftItemTypes["Arrow"] = "minecraft:arrow";
    MinecraftItemTypes["AxolotlBucket"] = "minecraft:axolotl_bucket";
    MinecraftItemTypes["AxolotlSpawnEgg"] = "minecraft:axolotl_spawn_egg";
    MinecraftItemTypes["Azalea"] = "minecraft:azalea";
    MinecraftItemTypes["AzaleaLeaves"] = "minecraft:azalea_leaves";
    MinecraftItemTypes["AzaleaLeavesFlowered"] = "minecraft:azalea_leaves_flowered";
    MinecraftItemTypes["BakedPotato"] = "minecraft:baked_potato";
    MinecraftItemTypes["Bamboo"] = "minecraft:bamboo";
    MinecraftItemTypes["BambooBlock"] = "minecraft:bamboo_block";
    MinecraftItemTypes["BambooButton"] = "minecraft:bamboo_button";
    MinecraftItemTypes["BambooChestRaft"] = "minecraft:bamboo_chest_raft";
    MinecraftItemTypes["BambooDoor"] = "minecraft:bamboo_door";
    MinecraftItemTypes["BambooFence"] = "minecraft:bamboo_fence";
    MinecraftItemTypes["BambooFenceGate"] = "minecraft:bamboo_fence_gate";
    MinecraftItemTypes["BambooHangingSign"] = "minecraft:bamboo_hanging_sign";
    MinecraftItemTypes["BambooMosaic"] = "minecraft:bamboo_mosaic";
    MinecraftItemTypes["BambooMosaicSlab"] = "minecraft:bamboo_mosaic_slab";
    MinecraftItemTypes["BambooMosaicStairs"] = "minecraft:bamboo_mosaic_stairs";
    MinecraftItemTypes["BambooPlanks"] = "minecraft:bamboo_planks";
    MinecraftItemTypes["BambooPressurePlate"] = "minecraft:bamboo_pressure_plate";
    MinecraftItemTypes["BambooRaft"] = "minecraft:bamboo_raft";
    MinecraftItemTypes["BambooSign"] = "minecraft:bamboo_sign";
    MinecraftItemTypes["BambooSlab"] = "minecraft:bamboo_slab";
    MinecraftItemTypes["BambooStairs"] = "minecraft:bamboo_stairs";
    MinecraftItemTypes["BambooTrapdoor"] = "minecraft:bamboo_trapdoor";
    MinecraftItemTypes["Banner"] = "minecraft:banner";
    MinecraftItemTypes["BannerPattern"] = "minecraft:banner_pattern";
    MinecraftItemTypes["Barrel"] = "minecraft:barrel";
    MinecraftItemTypes["Barrier"] = "minecraft:barrier";
    MinecraftItemTypes["Basalt"] = "minecraft:basalt";
    MinecraftItemTypes["BatSpawnEgg"] = "minecraft:bat_spawn_egg";
    MinecraftItemTypes["Beacon"] = "minecraft:beacon";
    MinecraftItemTypes["Bed"] = "minecraft:bed";
    MinecraftItemTypes["Bedrock"] = "minecraft:bedrock";
    MinecraftItemTypes["BeeNest"] = "minecraft:bee_nest";
    MinecraftItemTypes["BeeSpawnEgg"] = "minecraft:bee_spawn_egg";
    MinecraftItemTypes["Beef"] = "minecraft:beef";
    MinecraftItemTypes["Beehive"] = "minecraft:beehive";
    MinecraftItemTypes["Beetroot"] = "minecraft:beetroot";
    MinecraftItemTypes["BeetrootSeeds"] = "minecraft:beetroot_seeds";
    MinecraftItemTypes["BeetrootSoup"] = "minecraft:beetroot_soup";
    MinecraftItemTypes["Bell"] = "minecraft:bell";
    MinecraftItemTypes["BigDripleaf"] = "minecraft:big_dripleaf";
    MinecraftItemTypes["BirchBoat"] = "minecraft:birch_boat";
    MinecraftItemTypes["BirchButton"] = "minecraft:birch_button";
    MinecraftItemTypes["BirchChestBoat"] = "minecraft:birch_chest_boat";
    MinecraftItemTypes["BirchDoor"] = "minecraft:birch_door";
    MinecraftItemTypes["BirchFence"] = "minecraft:birch_fence";
    MinecraftItemTypes["BirchFenceGate"] = "minecraft:birch_fence_gate";
    MinecraftItemTypes["BirchHangingSign"] = "minecraft:birch_hanging_sign";
    MinecraftItemTypes["BirchLog"] = "minecraft:birch_log";
    MinecraftItemTypes["BirchPressurePlate"] = "minecraft:birch_pressure_plate";
    MinecraftItemTypes["BirchSign"] = "minecraft:birch_sign";
    MinecraftItemTypes["BirchStairs"] = "minecraft:birch_stairs";
    MinecraftItemTypes["BirchTrapdoor"] = "minecraft:birch_trapdoor";
    MinecraftItemTypes["BlackCandle"] = "minecraft:black_candle";
    MinecraftItemTypes["BlackCarpet"] = "minecraft:black_carpet";
    MinecraftItemTypes["BlackDye"] = "minecraft:black_dye";
    MinecraftItemTypes["BlackGlazedTerracotta"] = "minecraft:black_glazed_terracotta";
    MinecraftItemTypes["BlackWool"] = "minecraft:black_wool";
    MinecraftItemTypes["Blackstone"] = "minecraft:blackstone";
    MinecraftItemTypes["BlackstoneSlab"] = "minecraft:blackstone_slab";
    MinecraftItemTypes["BlackstoneStairs"] = "minecraft:blackstone_stairs";
    MinecraftItemTypes["BlackstoneWall"] = "minecraft:blackstone_wall";
    MinecraftItemTypes["BladePotteryShard"] = "minecraft:blade_pottery_shard";
    MinecraftItemTypes["BlastFurnace"] = "minecraft:blast_furnace";
    MinecraftItemTypes["BlazePowder"] = "minecraft:blaze_powder";
    MinecraftItemTypes["BlazeRod"] = "minecraft:blaze_rod";
    MinecraftItemTypes["BlazeSpawnEgg"] = "minecraft:blaze_spawn_egg";
    MinecraftItemTypes["BlueCandle"] = "minecraft:blue_candle";
    MinecraftItemTypes["BlueCarpet"] = "minecraft:blue_carpet";
    MinecraftItemTypes["BlueDye"] = "minecraft:blue_dye";
    MinecraftItemTypes["BlueGlazedTerracotta"] = "minecraft:blue_glazed_terracotta";
    MinecraftItemTypes["BlueIce"] = "minecraft:blue_ice";
    MinecraftItemTypes["BlueWool"] = "minecraft:blue_wool";
    MinecraftItemTypes["Boat"] = "minecraft:boat";
    MinecraftItemTypes["Bone"] = "minecraft:bone";
    MinecraftItemTypes["BoneBlock"] = "minecraft:bone_block";
    MinecraftItemTypes["BoneMeal"] = "minecraft:bone_meal";
    MinecraftItemTypes["Book"] = "minecraft:book";
    MinecraftItemTypes["Bookshelf"] = "minecraft:bookshelf";
    MinecraftItemTypes["BorderBlock"] = "minecraft:border_block";
    MinecraftItemTypes["BordureIndentedBannerPattern"] = "minecraft:bordure_indented_banner_pattern";
    MinecraftItemTypes["Bow"] = "minecraft:bow";
    MinecraftItemTypes["Bowl"] = "minecraft:bowl";
    MinecraftItemTypes["BrainCoral"] = "minecraft:brain_coral";
    MinecraftItemTypes["Bread"] = "minecraft:bread";
    MinecraftItemTypes["BrewerPotteryShard"] = "minecraft:brewer_pottery_shard";
    MinecraftItemTypes["BrewingStand"] = "minecraft:brewing_stand";
    MinecraftItemTypes["Brick"] = "minecraft:brick";
    MinecraftItemTypes["BrickBlock"] = "minecraft:brick_block";
    MinecraftItemTypes["BrickStairs"] = "minecraft:brick_stairs";
    MinecraftItemTypes["BrownCandle"] = "minecraft:brown_candle";
    MinecraftItemTypes["BrownCarpet"] = "minecraft:brown_carpet";
    MinecraftItemTypes["BrownDye"] = "minecraft:brown_dye";
    MinecraftItemTypes["BrownGlazedTerracotta"] = "minecraft:brown_glazed_terracotta";
    MinecraftItemTypes["BrownMushroom"] = "minecraft:brown_mushroom";
    MinecraftItemTypes["BrownMushroomBlock"] = "minecraft:brown_mushroom_block";
    MinecraftItemTypes["BrownWool"] = "minecraft:brown_wool";
    MinecraftItemTypes["Brush"] = "minecraft:brush";
    MinecraftItemTypes["BubbleCoral"] = "minecraft:bubble_coral";
    MinecraftItemTypes["Bucket"] = "minecraft:bucket";
    MinecraftItemTypes["BuddingAmethyst"] = "minecraft:budding_amethyst";
    MinecraftItemTypes["BurnPotteryShard"] = "minecraft:burn_pottery_shard";
    MinecraftItemTypes["Cactus"] = "minecraft:cactus";
    MinecraftItemTypes["Cake"] = "minecraft:cake";
    MinecraftItemTypes["Calcite"] = "minecraft:calcite";
    MinecraftItemTypes["CalibratedSculkSensor"] = "minecraft:calibrated_sculk_sensor";
    MinecraftItemTypes["CamelSpawnEgg"] = "minecraft:camel_spawn_egg";
    MinecraftItemTypes["Campfire"] = "minecraft:campfire";
    MinecraftItemTypes["Candle"] = "minecraft:candle";
    MinecraftItemTypes["Carpet"] = "minecraft:carpet";
    MinecraftItemTypes["Carrot"] = "minecraft:carrot";
    MinecraftItemTypes["CarrotOnAStick"] = "minecraft:carrot_on_a_stick";
    MinecraftItemTypes["CartographyTable"] = "minecraft:cartography_table";
    MinecraftItemTypes["CarvedPumpkin"] = "minecraft:carved_pumpkin";
    MinecraftItemTypes["CatSpawnEgg"] = "minecraft:cat_spawn_egg";
    MinecraftItemTypes["Cauldron"] = "minecraft:cauldron";
    MinecraftItemTypes["CaveSpiderSpawnEgg"] = "minecraft:cave_spider_spawn_egg";
    MinecraftItemTypes["Chain"] = "minecraft:chain";
    MinecraftItemTypes["ChainCommandBlock"] = "minecraft:chain_command_block";
    MinecraftItemTypes["ChainmailBoots"] = "minecraft:chainmail_boots";
    MinecraftItemTypes["ChainmailChestplate"] = "minecraft:chainmail_chestplate";
    MinecraftItemTypes["ChainmailHelmet"] = "minecraft:chainmail_helmet";
    MinecraftItemTypes["ChainmailLeggings"] = "minecraft:chainmail_leggings";
    MinecraftItemTypes["Charcoal"] = "minecraft:charcoal";
    MinecraftItemTypes["CherryBoat"] = "minecraft:cherry_boat";
    MinecraftItemTypes["CherryButton"] = "minecraft:cherry_button";
    MinecraftItemTypes["CherryChestBoat"] = "minecraft:cherry_chest_boat";
    MinecraftItemTypes["CherryDoor"] = "minecraft:cherry_door";
    MinecraftItemTypes["CherryFence"] = "minecraft:cherry_fence";
    MinecraftItemTypes["CherryFenceGate"] = "minecraft:cherry_fence_gate";
    MinecraftItemTypes["CherryHangingSign"] = "minecraft:cherry_hanging_sign";
    MinecraftItemTypes["CherryLeaves"] = "minecraft:cherry_leaves";
    MinecraftItemTypes["CherryLog"] = "minecraft:cherry_log";
    MinecraftItemTypes["CherryPlanks"] = "minecraft:cherry_planks";
    MinecraftItemTypes["CherryPressurePlate"] = "minecraft:cherry_pressure_plate";
    MinecraftItemTypes["CherrySapling"] = "minecraft:cherry_sapling";
    MinecraftItemTypes["CherrySign"] = "minecraft:cherry_sign";
    MinecraftItemTypes["CherrySlab"] = "minecraft:cherry_slab";
    MinecraftItemTypes["CherryStairs"] = "minecraft:cherry_stairs";
    MinecraftItemTypes["CherryTrapdoor"] = "minecraft:cherry_trapdoor";
    MinecraftItemTypes["CherryWood"] = "minecraft:cherry_wood";
    MinecraftItemTypes["Chest"] = "minecraft:chest";
    MinecraftItemTypes["ChestBoat"] = "minecraft:chest_boat";
    MinecraftItemTypes["ChestMinecart"] = "minecraft:chest_minecart";
    MinecraftItemTypes["Chicken"] = "minecraft:chicken";
    MinecraftItemTypes["ChickenSpawnEgg"] = "minecraft:chicken_spawn_egg";
    MinecraftItemTypes["ChiseledBookshelf"] = "minecraft:chiseled_bookshelf";
    MinecraftItemTypes["ChiseledDeepslate"] = "minecraft:chiseled_deepslate";
    MinecraftItemTypes["ChiseledNetherBricks"] = "minecraft:chiseled_nether_bricks";
    MinecraftItemTypes["ChiseledPolishedBlackstone"] = "minecraft:chiseled_polished_blackstone";
    MinecraftItemTypes["ChorusFlower"] = "minecraft:chorus_flower";
    MinecraftItemTypes["ChorusFruit"] = "minecraft:chorus_fruit";
    MinecraftItemTypes["ChorusPlant"] = "minecraft:chorus_plant";
    MinecraftItemTypes["Clay"] = "minecraft:clay";
    MinecraftItemTypes["ClayBall"] = "minecraft:clay_ball";
    MinecraftItemTypes["Clock"] = "minecraft:clock";
    MinecraftItemTypes["Coal"] = "minecraft:coal";
    MinecraftItemTypes["CoalBlock"] = "minecraft:coal_block";
    MinecraftItemTypes["CoalOre"] = "minecraft:coal_ore";
    MinecraftItemTypes["CoastArmorTrimSmithingTemplate"] = "minecraft:coast_armor_trim_smithing_template";
    MinecraftItemTypes["CobbledDeepslate"] = "minecraft:cobbled_deepslate";
    MinecraftItemTypes["CobbledDeepslateSlab"] = "minecraft:cobbled_deepslate_slab";
    MinecraftItemTypes["CobbledDeepslateStairs"] = "minecraft:cobbled_deepslate_stairs";
    MinecraftItemTypes["CobbledDeepslateWall"] = "minecraft:cobbled_deepslate_wall";
    MinecraftItemTypes["Cobblestone"] = "minecraft:cobblestone";
    MinecraftItemTypes["CobblestoneWall"] = "minecraft:cobblestone_wall";
    MinecraftItemTypes["CocoaBeans"] = "minecraft:cocoa_beans";
    MinecraftItemTypes["Cod"] = "minecraft:cod";
    MinecraftItemTypes["CodBucket"] = "minecraft:cod_bucket";
    MinecraftItemTypes["CodSpawnEgg"] = "minecraft:cod_spawn_egg";
    MinecraftItemTypes["CommandBlock"] = "minecraft:command_block";
    MinecraftItemTypes["CommandBlockMinecart"] = "minecraft:command_block_minecart";
    MinecraftItemTypes["Comparator"] = "minecraft:comparator";
    MinecraftItemTypes["Compass"] = "minecraft:compass";
    MinecraftItemTypes["Composter"] = "minecraft:composter";
    MinecraftItemTypes["Concrete"] = "minecraft:concrete";
    MinecraftItemTypes["ConcretePowder"] = "minecraft:concrete_powder";
    MinecraftItemTypes["Conduit"] = "minecraft:conduit";
    MinecraftItemTypes["CookedBeef"] = "minecraft:cooked_beef";
    MinecraftItemTypes["CookedChicken"] = "minecraft:cooked_chicken";
    MinecraftItemTypes["CookedCod"] = "minecraft:cooked_cod";
    MinecraftItemTypes["CookedMutton"] = "minecraft:cooked_mutton";
    MinecraftItemTypes["CookedPorkchop"] = "minecraft:cooked_porkchop";
    MinecraftItemTypes["CookedRabbit"] = "minecraft:cooked_rabbit";
    MinecraftItemTypes["CookedSalmon"] = "minecraft:cooked_salmon";
    MinecraftItemTypes["Cookie"] = "minecraft:cookie";
    MinecraftItemTypes["CopperBlock"] = "minecraft:copper_block";
    MinecraftItemTypes["CopperIngot"] = "minecraft:copper_ingot";
    MinecraftItemTypes["CopperOre"] = "minecraft:copper_ore";
    MinecraftItemTypes["Coral"] = "minecraft:coral";
    MinecraftItemTypes["CoralBlock"] = "minecraft:coral_block";
    MinecraftItemTypes["CoralFan"] = "minecraft:coral_fan";
    MinecraftItemTypes["CoralFanDead"] = "minecraft:coral_fan_dead";
    MinecraftItemTypes["CowSpawnEgg"] = "minecraft:cow_spawn_egg";
    MinecraftItemTypes["CrackedDeepslateBricks"] = "minecraft:cracked_deepslate_bricks";
    MinecraftItemTypes["CrackedDeepslateTiles"] = "minecraft:cracked_deepslate_tiles";
    MinecraftItemTypes["CrackedNetherBricks"] = "minecraft:cracked_nether_bricks";
    MinecraftItemTypes["CrackedPolishedBlackstoneBricks"] = "minecraft:cracked_polished_blackstone_bricks";
    MinecraftItemTypes["CraftingTable"] = "minecraft:crafting_table";
    MinecraftItemTypes["CreeperBannerPattern"] = "minecraft:creeper_banner_pattern";
    MinecraftItemTypes["CreeperSpawnEgg"] = "minecraft:creeper_spawn_egg";
    MinecraftItemTypes["CrimsonButton"] = "minecraft:crimson_button";
    MinecraftItemTypes["CrimsonDoor"] = "minecraft:crimson_door";
    MinecraftItemTypes["CrimsonFence"] = "minecraft:crimson_fence";
    MinecraftItemTypes["CrimsonFenceGate"] = "minecraft:crimson_fence_gate";
    MinecraftItemTypes["CrimsonFungus"] = "minecraft:crimson_fungus";
    MinecraftItemTypes["CrimsonHangingSign"] = "minecraft:crimson_hanging_sign";
    MinecraftItemTypes["CrimsonHyphae"] = "minecraft:crimson_hyphae";
    MinecraftItemTypes["CrimsonNylium"] = "minecraft:crimson_nylium";
    MinecraftItemTypes["CrimsonPlanks"] = "minecraft:crimson_planks";
    MinecraftItemTypes["CrimsonPressurePlate"] = "minecraft:crimson_pressure_plate";
    MinecraftItemTypes["CrimsonRoots"] = "minecraft:crimson_roots";
    MinecraftItemTypes["CrimsonSign"] = "minecraft:crimson_sign";
    MinecraftItemTypes["CrimsonSlab"] = "minecraft:crimson_slab";
    MinecraftItemTypes["CrimsonStairs"] = "minecraft:crimson_stairs";
    MinecraftItemTypes["CrimsonStem"] = "minecraft:crimson_stem";
    MinecraftItemTypes["CrimsonTrapdoor"] = "minecraft:crimson_trapdoor";
    MinecraftItemTypes["Crossbow"] = "minecraft:crossbow";
    MinecraftItemTypes["CryingObsidian"] = "minecraft:crying_obsidian";
    MinecraftItemTypes["CutCopper"] = "minecraft:cut_copper";
    MinecraftItemTypes["CutCopperSlab"] = "minecraft:cut_copper_slab";
    MinecraftItemTypes["CutCopperStairs"] = "minecraft:cut_copper_stairs";
    MinecraftItemTypes["CyanCandle"] = "minecraft:cyan_candle";
    MinecraftItemTypes["CyanCarpet"] = "minecraft:cyan_carpet";
    MinecraftItemTypes["CyanDye"] = "minecraft:cyan_dye";
    MinecraftItemTypes["CyanGlazedTerracotta"] = "minecraft:cyan_glazed_terracotta";
    MinecraftItemTypes["CyanWool"] = "minecraft:cyan_wool";
    MinecraftItemTypes["DangerPotteryShard"] = "minecraft:danger_pottery_shard";
    MinecraftItemTypes["DarkOakBoat"] = "minecraft:dark_oak_boat";
    MinecraftItemTypes["DarkOakButton"] = "minecraft:dark_oak_button";
    MinecraftItemTypes["DarkOakChestBoat"] = "minecraft:dark_oak_chest_boat";
    MinecraftItemTypes["DarkOakDoor"] = "minecraft:dark_oak_door";
    MinecraftItemTypes["DarkOakFence"] = "minecraft:dark_oak_fence";
    MinecraftItemTypes["DarkOakFenceGate"] = "minecraft:dark_oak_fence_gate";
    MinecraftItemTypes["DarkOakHangingSign"] = "minecraft:dark_oak_hanging_sign";
    MinecraftItemTypes["DarkOakLog"] = "minecraft:dark_oak_log";
    MinecraftItemTypes["DarkOakPressurePlate"] = "minecraft:dark_oak_pressure_plate";
    MinecraftItemTypes["DarkOakSign"] = "minecraft:dark_oak_sign";
    MinecraftItemTypes["DarkOakStairs"] = "minecraft:dark_oak_stairs";
    MinecraftItemTypes["DarkOakTrapdoor"] = "minecraft:dark_oak_trapdoor";
    MinecraftItemTypes["DarkPrismarineStairs"] = "minecraft:dark_prismarine_stairs";
    MinecraftItemTypes["DaylightDetector"] = "minecraft:daylight_detector";
    MinecraftItemTypes["DeadBrainCoral"] = "minecraft:dead_brain_coral";
    MinecraftItemTypes["DeadBubbleCoral"] = "minecraft:dead_bubble_coral";
    MinecraftItemTypes["DeadFireCoral"] = "minecraft:dead_fire_coral";
    MinecraftItemTypes["DeadHornCoral"] = "minecraft:dead_horn_coral";
    MinecraftItemTypes["DeadTubeCoral"] = "minecraft:dead_tube_coral";
    MinecraftItemTypes["Deadbush"] = "minecraft:deadbush";
    MinecraftItemTypes["DecoratedPot"] = "minecraft:decorated_pot";
    MinecraftItemTypes["Deepslate"] = "minecraft:deepslate";
    MinecraftItemTypes["DeepslateBrickSlab"] = "minecraft:deepslate_brick_slab";
    MinecraftItemTypes["DeepslateBrickStairs"] = "minecraft:deepslate_brick_stairs";
    MinecraftItemTypes["DeepslateBrickWall"] = "minecraft:deepslate_brick_wall";
    MinecraftItemTypes["DeepslateBricks"] = "minecraft:deepslate_bricks";
    MinecraftItemTypes["DeepslateCoalOre"] = "minecraft:deepslate_coal_ore";
    MinecraftItemTypes["DeepslateCopperOre"] = "minecraft:deepslate_copper_ore";
    MinecraftItemTypes["DeepslateDiamondOre"] = "minecraft:deepslate_diamond_ore";
    MinecraftItemTypes["DeepslateEmeraldOre"] = "minecraft:deepslate_emerald_ore";
    MinecraftItemTypes["DeepslateGoldOre"] = "minecraft:deepslate_gold_ore";
    MinecraftItemTypes["DeepslateIronOre"] = "minecraft:deepslate_iron_ore";
    MinecraftItemTypes["DeepslateLapisOre"] = "minecraft:deepslate_lapis_ore";
    MinecraftItemTypes["DeepslateRedstoneOre"] = "minecraft:deepslate_redstone_ore";
    MinecraftItemTypes["DeepslateTileSlab"] = "minecraft:deepslate_tile_slab";
    MinecraftItemTypes["DeepslateTileStairs"] = "minecraft:deepslate_tile_stairs";
    MinecraftItemTypes["DeepslateTileWall"] = "minecraft:deepslate_tile_wall";
    MinecraftItemTypes["DeepslateTiles"] = "minecraft:deepslate_tiles";
    MinecraftItemTypes["Deny"] = "minecraft:deny";
    MinecraftItemTypes["DetectorRail"] = "minecraft:detector_rail";
    MinecraftItemTypes["Diamond"] = "minecraft:diamond";
    MinecraftItemTypes["DiamondAxe"] = "minecraft:diamond_axe";
    MinecraftItemTypes["DiamondBlock"] = "minecraft:diamond_block";
    MinecraftItemTypes["DiamondBoots"] = "minecraft:diamond_boots";
    MinecraftItemTypes["DiamondChestplate"] = "minecraft:diamond_chestplate";
    MinecraftItemTypes["DiamondHelmet"] = "minecraft:diamond_helmet";
    MinecraftItemTypes["DiamondHoe"] = "minecraft:diamond_hoe";
    MinecraftItemTypes["DiamondHorseArmor"] = "minecraft:diamond_horse_armor";
    MinecraftItemTypes["DiamondLeggings"] = "minecraft:diamond_leggings";
    MinecraftItemTypes["DiamondOre"] = "minecraft:diamond_ore";
    MinecraftItemTypes["DiamondPickaxe"] = "minecraft:diamond_pickaxe";
    MinecraftItemTypes["DiamondShovel"] = "minecraft:diamond_shovel";
    MinecraftItemTypes["DiamondSword"] = "minecraft:diamond_sword";
    MinecraftItemTypes["DioriteStairs"] = "minecraft:diorite_stairs";
    MinecraftItemTypes["Dirt"] = "minecraft:dirt";
    MinecraftItemTypes["DirtWithRoots"] = "minecraft:dirt_with_roots";
    MinecraftItemTypes["DiscFragment5"] = "minecraft:disc_fragment_5";
    MinecraftItemTypes["Dispenser"] = "minecraft:dispenser";
    MinecraftItemTypes["DolphinSpawnEgg"] = "minecraft:dolphin_spawn_egg";
    MinecraftItemTypes["DonkeySpawnEgg"] = "minecraft:donkey_spawn_egg";
    MinecraftItemTypes["DoublePlant"] = "minecraft:double_plant";
    MinecraftItemTypes["DragonBreath"] = "minecraft:dragon_breath";
    MinecraftItemTypes["DragonEgg"] = "minecraft:dragon_egg";
    MinecraftItemTypes["DriedKelp"] = "minecraft:dried_kelp";
    MinecraftItemTypes["DriedKelpBlock"] = "minecraft:dried_kelp_block";
    MinecraftItemTypes["DripstoneBlock"] = "minecraft:dripstone_block";
    MinecraftItemTypes["Dropper"] = "minecraft:dropper";
    MinecraftItemTypes["DrownedSpawnEgg"] = "minecraft:drowned_spawn_egg";
    MinecraftItemTypes["DuneArmorTrimSmithingTemplate"] = "minecraft:dune_armor_trim_smithing_template";
    MinecraftItemTypes["Dye"] = "minecraft:dye";
    MinecraftItemTypes["EchoShard"] = "minecraft:echo_shard";
    MinecraftItemTypes["Egg"] = "minecraft:egg";
    MinecraftItemTypes["ElderGuardianSpawnEgg"] = "minecraft:elder_guardian_spawn_egg";
    MinecraftItemTypes["Elytra"] = "minecraft:elytra";
    MinecraftItemTypes["Emerald"] = "minecraft:emerald";
    MinecraftItemTypes["EmeraldBlock"] = "minecraft:emerald_block";
    MinecraftItemTypes["EmeraldOre"] = "minecraft:emerald_ore";
    MinecraftItemTypes["EmptyMap"] = "minecraft:empty_map";
    MinecraftItemTypes["EnchantedBook"] = "minecraft:enchanted_book";
    MinecraftItemTypes["EnchantedGoldenApple"] = "minecraft:enchanted_golden_apple";
    MinecraftItemTypes["EnchantingTable"] = "minecraft:enchanting_table";
    MinecraftItemTypes["EndBrickStairs"] = "minecraft:end_brick_stairs";
    MinecraftItemTypes["EndBricks"] = "minecraft:end_bricks";
    MinecraftItemTypes["EndCrystal"] = "minecraft:end_crystal";
    MinecraftItemTypes["EndPortalFrame"] = "minecraft:end_portal_frame";
    MinecraftItemTypes["EndRod"] = "minecraft:end_rod";
    MinecraftItemTypes["EndStone"] = "minecraft:end_stone";
    MinecraftItemTypes["EnderChest"] = "minecraft:ender_chest";
    MinecraftItemTypes["EnderDragonSpawnEgg"] = "minecraft:ender_dragon_spawn_egg";
    MinecraftItemTypes["EnderEye"] = "minecraft:ender_eye";
    MinecraftItemTypes["EnderPearl"] = "minecraft:ender_pearl";
    MinecraftItemTypes["EndermanSpawnEgg"] = "minecraft:enderman_spawn_egg";
    MinecraftItemTypes["EndermiteSpawnEgg"] = "minecraft:endermite_spawn_egg";
    MinecraftItemTypes["EvokerSpawnEgg"] = "minecraft:evoker_spawn_egg";
    MinecraftItemTypes["ExperienceBottle"] = "minecraft:experience_bottle";
    MinecraftItemTypes["ExplorerPotteryShard"] = "minecraft:explorer_pottery_shard";
    MinecraftItemTypes["ExposedCopper"] = "minecraft:exposed_copper";
    MinecraftItemTypes["ExposedCutCopper"] = "minecraft:exposed_cut_copper";
    MinecraftItemTypes["ExposedCutCopperSlab"] = "minecraft:exposed_cut_copper_slab";
    MinecraftItemTypes["ExposedCutCopperStairs"] = "minecraft:exposed_cut_copper_stairs";
    MinecraftItemTypes["EyeArmorTrimSmithingTemplate"] = "minecraft:eye_armor_trim_smithing_template";
    MinecraftItemTypes["Farmland"] = "minecraft:farmland";
    MinecraftItemTypes["Feather"] = "minecraft:feather";
    MinecraftItemTypes["Fence"] = "minecraft:fence";
    MinecraftItemTypes["FenceGate"] = "minecraft:fence_gate";
    MinecraftItemTypes["FermentedSpiderEye"] = "minecraft:fermented_spider_eye";
    MinecraftItemTypes["FieldMasonedBannerPattern"] = "minecraft:field_masoned_banner_pattern";
    MinecraftItemTypes["FilledMap"] = "minecraft:filled_map";
    MinecraftItemTypes["FireCharge"] = "minecraft:fire_charge";
    MinecraftItemTypes["FireCoral"] = "minecraft:fire_coral";
    MinecraftItemTypes["FireworkRocket"] = "minecraft:firework_rocket";
    MinecraftItemTypes["FireworkStar"] = "minecraft:firework_star";
    MinecraftItemTypes["FishingRod"] = "minecraft:fishing_rod";
    MinecraftItemTypes["FletchingTable"] = "minecraft:fletching_table";
    MinecraftItemTypes["Flint"] = "minecraft:flint";
    MinecraftItemTypes["FlintAndSteel"] = "minecraft:flint_and_steel";
    MinecraftItemTypes["FlowerBannerPattern"] = "minecraft:flower_banner_pattern";
    MinecraftItemTypes["FlowerPot"] = "minecraft:flower_pot";
    MinecraftItemTypes["FloweringAzalea"] = "minecraft:flowering_azalea";
    MinecraftItemTypes["FoxSpawnEgg"] = "minecraft:fox_spawn_egg";
    MinecraftItemTypes["Frame"] = "minecraft:frame";
    MinecraftItemTypes["FriendPotteryShard"] = "minecraft:friend_pottery_shard";
    MinecraftItemTypes["FrogSpawn"] = "minecraft:frog_spawn";
    MinecraftItemTypes["FrogSpawnEgg"] = "minecraft:frog_spawn_egg";
    MinecraftItemTypes["FrostedIce"] = "minecraft:frosted_ice";
    MinecraftItemTypes["Furnace"] = "minecraft:furnace";
    MinecraftItemTypes["GhastSpawnEgg"] = "minecraft:ghast_spawn_egg";
    MinecraftItemTypes["GhastTear"] = "minecraft:ghast_tear";
    MinecraftItemTypes["GildedBlackstone"] = "minecraft:gilded_blackstone";
    MinecraftItemTypes["Glass"] = "minecraft:glass";
    MinecraftItemTypes["GlassBottle"] = "minecraft:glass_bottle";
    MinecraftItemTypes["GlassPane"] = "minecraft:glass_pane";
    MinecraftItemTypes["GlisteringMelonSlice"] = "minecraft:glistering_melon_slice";
    MinecraftItemTypes["GlobeBannerPattern"] = "minecraft:globe_banner_pattern";
    MinecraftItemTypes["GlowBerries"] = "minecraft:glow_berries";
    MinecraftItemTypes["GlowFrame"] = "minecraft:glow_frame";
    MinecraftItemTypes["GlowInkSac"] = "minecraft:glow_ink_sac";
    MinecraftItemTypes["GlowLichen"] = "minecraft:glow_lichen";
    MinecraftItemTypes["GlowSquidSpawnEgg"] = "minecraft:glow_squid_spawn_egg";
    MinecraftItemTypes["Glowstone"] = "minecraft:glowstone";
    MinecraftItemTypes["GlowstoneDust"] = "minecraft:glowstone_dust";
    MinecraftItemTypes["GoatHorn"] = "minecraft:goat_horn";
    MinecraftItemTypes["GoatSpawnEgg"] = "minecraft:goat_spawn_egg";
    MinecraftItemTypes["GoldBlock"] = "minecraft:gold_block";
    MinecraftItemTypes["GoldIngot"] = "minecraft:gold_ingot";
    MinecraftItemTypes["GoldNugget"] = "minecraft:gold_nugget";
    MinecraftItemTypes["GoldOre"] = "minecraft:gold_ore";
    MinecraftItemTypes["GoldenApple"] = "minecraft:golden_apple";
    MinecraftItemTypes["GoldenAxe"] = "minecraft:golden_axe";
    MinecraftItemTypes["GoldenBoots"] = "minecraft:golden_boots";
    MinecraftItemTypes["GoldenCarrot"] = "minecraft:golden_carrot";
    MinecraftItemTypes["GoldenChestplate"] = "minecraft:golden_chestplate";
    MinecraftItemTypes["GoldenHelmet"] = "minecraft:golden_helmet";
    MinecraftItemTypes["GoldenHoe"] = "minecraft:golden_hoe";
    MinecraftItemTypes["GoldenHorseArmor"] = "minecraft:golden_horse_armor";
    MinecraftItemTypes["GoldenLeggings"] = "minecraft:golden_leggings";
    MinecraftItemTypes["GoldenPickaxe"] = "minecraft:golden_pickaxe";
    MinecraftItemTypes["GoldenRail"] = "minecraft:golden_rail";
    MinecraftItemTypes["GoldenShovel"] = "minecraft:golden_shovel";
    MinecraftItemTypes["GoldenSword"] = "minecraft:golden_sword";
    MinecraftItemTypes["GraniteStairs"] = "minecraft:granite_stairs";
    MinecraftItemTypes["Grass"] = "minecraft:grass";
    MinecraftItemTypes["GrassPath"] = "minecraft:grass_path";
    MinecraftItemTypes["Gravel"] = "minecraft:gravel";
    MinecraftItemTypes["GrayCandle"] = "minecraft:gray_candle";
    MinecraftItemTypes["GrayCarpet"] = "minecraft:gray_carpet";
    MinecraftItemTypes["GrayDye"] = "minecraft:gray_dye";
    MinecraftItemTypes["GrayGlazedTerracotta"] = "minecraft:gray_glazed_terracotta";
    MinecraftItemTypes["GrayWool"] = "minecraft:gray_wool";
    MinecraftItemTypes["GreenCandle"] = "minecraft:green_candle";
    MinecraftItemTypes["GreenCarpet"] = "minecraft:green_carpet";
    MinecraftItemTypes["GreenDye"] = "minecraft:green_dye";
    MinecraftItemTypes["GreenGlazedTerracotta"] = "minecraft:green_glazed_terracotta";
    MinecraftItemTypes["GreenWool"] = "minecraft:green_wool";
    MinecraftItemTypes["Grindstone"] = "minecraft:grindstone";
    MinecraftItemTypes["GuardianSpawnEgg"] = "minecraft:guardian_spawn_egg";
    MinecraftItemTypes["Gunpowder"] = "minecraft:gunpowder";
    MinecraftItemTypes["HangingRoots"] = "minecraft:hanging_roots";
    MinecraftItemTypes["HardenedClay"] = "minecraft:hardened_clay";
    MinecraftItemTypes["HayBlock"] = "minecraft:hay_block";
    MinecraftItemTypes["HeartOfTheSea"] = "minecraft:heart_of_the_sea";
    MinecraftItemTypes["HeartPotteryShard"] = "minecraft:heart_pottery_shard";
    MinecraftItemTypes["HeartbreakPotteryShard"] = "minecraft:heartbreak_pottery_shard";
    MinecraftItemTypes["HeavyWeightedPressurePlate"] = "minecraft:heavy_weighted_pressure_plate";
    MinecraftItemTypes["HoglinSpawnEgg"] = "minecraft:hoglin_spawn_egg";
    MinecraftItemTypes["HoneyBlock"] = "minecraft:honey_block";
    MinecraftItemTypes["HoneyBottle"] = "minecraft:honey_bottle";
    MinecraftItemTypes["Honeycomb"] = "minecraft:honeycomb";
    MinecraftItemTypes["HoneycombBlock"] = "minecraft:honeycomb_block";
    MinecraftItemTypes["Hopper"] = "minecraft:hopper";
    MinecraftItemTypes["HopperMinecart"] = "minecraft:hopper_minecart";
    MinecraftItemTypes["HornCoral"] = "minecraft:horn_coral";
    MinecraftItemTypes["HorseSpawnEgg"] = "minecraft:horse_spawn_egg";
    MinecraftItemTypes["HostArmorTrimSmithingTemplate"] = "minecraft:host_armor_trim_smithing_template";
    MinecraftItemTypes["HowlPotteryShard"] = "minecraft:howl_pottery_shard";
    MinecraftItemTypes["HuskSpawnEgg"] = "minecraft:husk_spawn_egg";
    MinecraftItemTypes["Ice"] = "minecraft:ice";
    MinecraftItemTypes["InfestedDeepslate"] = "minecraft:infested_deepslate";
    MinecraftItemTypes["InkSac"] = "minecraft:ink_sac";
    MinecraftItemTypes["IronAxe"] = "minecraft:iron_axe";
    MinecraftItemTypes["IronBars"] = "minecraft:iron_bars";
    MinecraftItemTypes["IronBlock"] = "minecraft:iron_block";
    MinecraftItemTypes["IronBoots"] = "minecraft:iron_boots";
    MinecraftItemTypes["IronChestplate"] = "minecraft:iron_chestplate";
    MinecraftItemTypes["IronDoor"] = "minecraft:iron_door";
    MinecraftItemTypes["IronGolemSpawnEgg"] = "minecraft:iron_golem_spawn_egg";
    MinecraftItemTypes["IronHelmet"] = "minecraft:iron_helmet";
    MinecraftItemTypes["IronHoe"] = "minecraft:iron_hoe";
    MinecraftItemTypes["IronHorseArmor"] = "minecraft:iron_horse_armor";
    MinecraftItemTypes["IronIngot"] = "minecraft:iron_ingot";
    MinecraftItemTypes["IronLeggings"] = "minecraft:iron_leggings";
    MinecraftItemTypes["IronNugget"] = "minecraft:iron_nugget";
    MinecraftItemTypes["IronOre"] = "minecraft:iron_ore";
    MinecraftItemTypes["IronPickaxe"] = "minecraft:iron_pickaxe";
    MinecraftItemTypes["IronShovel"] = "minecraft:iron_shovel";
    MinecraftItemTypes["IronSword"] = "minecraft:iron_sword";
    MinecraftItemTypes["IronTrapdoor"] = "minecraft:iron_trapdoor";
    MinecraftItemTypes["Jigsaw"] = "minecraft:jigsaw";
    MinecraftItemTypes["Jukebox"] = "minecraft:jukebox";
    MinecraftItemTypes["JungleBoat"] = "minecraft:jungle_boat";
    MinecraftItemTypes["JungleButton"] = "minecraft:jungle_button";
    MinecraftItemTypes["JungleChestBoat"] = "minecraft:jungle_chest_boat";
    MinecraftItemTypes["JungleDoor"] = "minecraft:jungle_door";
    MinecraftItemTypes["JungleFence"] = "minecraft:jungle_fence";
    MinecraftItemTypes["JungleFenceGate"] = "minecraft:jungle_fence_gate";
    MinecraftItemTypes["JungleHangingSign"] = "minecraft:jungle_hanging_sign";
    MinecraftItemTypes["JungleLog"] = "minecraft:jungle_log";
    MinecraftItemTypes["JunglePressurePlate"] = "minecraft:jungle_pressure_plate";
    MinecraftItemTypes["JungleSign"] = "minecraft:jungle_sign";
    MinecraftItemTypes["JungleStairs"] = "minecraft:jungle_stairs";
    MinecraftItemTypes["JungleTrapdoor"] = "minecraft:jungle_trapdoor";
    MinecraftItemTypes["Kelp"] = "minecraft:kelp";
    MinecraftItemTypes["Ladder"] = "minecraft:ladder";
    MinecraftItemTypes["Lantern"] = "minecraft:lantern";
    MinecraftItemTypes["LapisBlock"] = "minecraft:lapis_block";
    MinecraftItemTypes["LapisLazuli"] = "minecraft:lapis_lazuli";
    MinecraftItemTypes["LapisOre"] = "minecraft:lapis_ore";
    MinecraftItemTypes["LargeAmethystBud"] = "minecraft:large_amethyst_bud";
    MinecraftItemTypes["LavaBucket"] = "minecraft:lava_bucket";
    MinecraftItemTypes["Lead"] = "minecraft:lead";
    MinecraftItemTypes["Leather"] = "minecraft:leather";
    MinecraftItemTypes["LeatherBoots"] = "minecraft:leather_boots";
    MinecraftItemTypes["LeatherChestplate"] = "minecraft:leather_chestplate";
    MinecraftItemTypes["LeatherHelmet"] = "minecraft:leather_helmet";
    MinecraftItemTypes["LeatherHorseArmor"] = "minecraft:leather_horse_armor";
    MinecraftItemTypes["LeatherLeggings"] = "minecraft:leather_leggings";
    MinecraftItemTypes["Leaves"] = "minecraft:leaves";
    MinecraftItemTypes["Leaves2"] = "minecraft:leaves2";
    MinecraftItemTypes["Lectern"] = "minecraft:lectern";
    MinecraftItemTypes["Lever"] = "minecraft:lever";
    MinecraftItemTypes["LightBlock"] = "minecraft:light_block";
    MinecraftItemTypes["LightBlueCandle"] = "minecraft:light_blue_candle";
    MinecraftItemTypes["LightBlueCarpet"] = "minecraft:light_blue_carpet";
    MinecraftItemTypes["LightBlueDye"] = "minecraft:light_blue_dye";
    MinecraftItemTypes["LightBlueGlazedTerracotta"] = "minecraft:light_blue_glazed_terracotta";
    MinecraftItemTypes["LightBlueWool"] = "minecraft:light_blue_wool";
    MinecraftItemTypes["LightGrayCandle"] = "minecraft:light_gray_candle";
    MinecraftItemTypes["LightGrayCarpet"] = "minecraft:light_gray_carpet";
    MinecraftItemTypes["LightGrayDye"] = "minecraft:light_gray_dye";
    MinecraftItemTypes["LightGrayWool"] = "minecraft:light_gray_wool";
    MinecraftItemTypes["LightWeightedPressurePlate"] = "minecraft:light_weighted_pressure_plate";
    MinecraftItemTypes["LightningRod"] = "minecraft:lightning_rod";
    MinecraftItemTypes["LimeCandle"] = "minecraft:lime_candle";
    MinecraftItemTypes["LimeCarpet"] = "minecraft:lime_carpet";
    MinecraftItemTypes["LimeDye"] = "minecraft:lime_dye";
    MinecraftItemTypes["LimeGlazedTerracotta"] = "minecraft:lime_glazed_terracotta";
    MinecraftItemTypes["LimeWool"] = "minecraft:lime_wool";
    MinecraftItemTypes["LingeringPotion"] = "minecraft:lingering_potion";
    MinecraftItemTypes["LitPumpkin"] = "minecraft:lit_pumpkin";
    MinecraftItemTypes["LlamaSpawnEgg"] = "minecraft:llama_spawn_egg";
    MinecraftItemTypes["Lodestone"] = "minecraft:lodestone";
    MinecraftItemTypes["LodestoneCompass"] = "minecraft:lodestone_compass";
    MinecraftItemTypes["Log"] = "minecraft:log";
    MinecraftItemTypes["Log2"] = "minecraft:log2";
    MinecraftItemTypes["Loom"] = "minecraft:loom";
    MinecraftItemTypes["MagentaCandle"] = "minecraft:magenta_candle";
    MinecraftItemTypes["MagentaCarpet"] = "minecraft:magenta_carpet";
    MinecraftItemTypes["MagentaDye"] = "minecraft:magenta_dye";
    MinecraftItemTypes["MagentaGlazedTerracotta"] = "minecraft:magenta_glazed_terracotta";
    MinecraftItemTypes["MagentaWool"] = "minecraft:magenta_wool";
    MinecraftItemTypes["Magma"] = "minecraft:magma";
    MinecraftItemTypes["MagmaCream"] = "minecraft:magma_cream";
    MinecraftItemTypes["MagmaCubeSpawnEgg"] = "minecraft:magma_cube_spawn_egg";
    MinecraftItemTypes["MangroveBoat"] = "minecraft:mangrove_boat";
    MinecraftItemTypes["MangroveButton"] = "minecraft:mangrove_button";
    MinecraftItemTypes["MangroveChestBoat"] = "minecraft:mangrove_chest_boat";
    MinecraftItemTypes["MangroveDoor"] = "minecraft:mangrove_door";
    MinecraftItemTypes["MangroveFence"] = "minecraft:mangrove_fence";
    MinecraftItemTypes["MangroveFenceGate"] = "minecraft:mangrove_fence_gate";
    MinecraftItemTypes["MangroveHangingSign"] = "minecraft:mangrove_hanging_sign";
    MinecraftItemTypes["MangroveLeaves"] = "minecraft:mangrove_leaves";
    MinecraftItemTypes["MangroveLog"] = "minecraft:mangrove_log";
    MinecraftItemTypes["MangrovePlanks"] = "minecraft:mangrove_planks";
    MinecraftItemTypes["MangrovePressurePlate"] = "minecraft:mangrove_pressure_plate";
    MinecraftItemTypes["MangrovePropagule"] = "minecraft:mangrove_propagule";
    MinecraftItemTypes["MangroveRoots"] = "minecraft:mangrove_roots";
    MinecraftItemTypes["MangroveSign"] = "minecraft:mangrove_sign";
    MinecraftItemTypes["MangroveSlab"] = "minecraft:mangrove_slab";
    MinecraftItemTypes["MangroveStairs"] = "minecraft:mangrove_stairs";
    MinecraftItemTypes["MangroveTrapdoor"] = "minecraft:mangrove_trapdoor";
    MinecraftItemTypes["MangroveWood"] = "minecraft:mangrove_wood";
    MinecraftItemTypes["MediumAmethystBud"] = "minecraft:medium_amethyst_bud";
    MinecraftItemTypes["MelonBlock"] = "minecraft:melon_block";
    MinecraftItemTypes["MelonSeeds"] = "minecraft:melon_seeds";
    MinecraftItemTypes["MelonSlice"] = "minecraft:melon_slice";
    MinecraftItemTypes["MilkBucket"] = "minecraft:milk_bucket";
    MinecraftItemTypes["Minecart"] = "minecraft:minecart";
    MinecraftItemTypes["MinerPotteryShard"] = "minecraft:miner_pottery_shard";
    MinecraftItemTypes["MobSpawner"] = "minecraft:mob_spawner";
    MinecraftItemTypes["MojangBannerPattern"] = "minecraft:mojang_banner_pattern";
    MinecraftItemTypes["MonsterEgg"] = "minecraft:monster_egg";
    MinecraftItemTypes["MooshroomSpawnEgg"] = "minecraft:mooshroom_spawn_egg";
    MinecraftItemTypes["MossBlock"] = "minecraft:moss_block";
    MinecraftItemTypes["MossCarpet"] = "minecraft:moss_carpet";
    MinecraftItemTypes["MossyCobblestone"] = "minecraft:mossy_cobblestone";
    MinecraftItemTypes["MossyCobblestoneStairs"] = "minecraft:mossy_cobblestone_stairs";
    MinecraftItemTypes["MossyStoneBrickStairs"] = "minecraft:mossy_stone_brick_stairs";
    MinecraftItemTypes["MournerPotteryShard"] = "minecraft:mourner_pottery_shard";
    MinecraftItemTypes["Mud"] = "minecraft:mud";
    MinecraftItemTypes["MudBrickSlab"] = "minecraft:mud_brick_slab";
    MinecraftItemTypes["MudBrickStairs"] = "minecraft:mud_brick_stairs";
    MinecraftItemTypes["MudBrickWall"] = "minecraft:mud_brick_wall";
    MinecraftItemTypes["MudBricks"] = "minecraft:mud_bricks";
    MinecraftItemTypes["MuddyMangroveRoots"] = "minecraft:muddy_mangrove_roots";
    MinecraftItemTypes["MuleSpawnEgg"] = "minecraft:mule_spawn_egg";
    MinecraftItemTypes["MushroomStew"] = "minecraft:mushroom_stew";
    MinecraftItemTypes["MusicDisc11"] = "minecraft:music_disc_11";
    MinecraftItemTypes["MusicDisc13"] = "minecraft:music_disc_13";
    MinecraftItemTypes["MusicDisc5"] = "minecraft:music_disc_5";
    MinecraftItemTypes["MusicDiscBlocks"] = "minecraft:music_disc_blocks";
    MinecraftItemTypes["MusicDiscCat"] = "minecraft:music_disc_cat";
    MinecraftItemTypes["MusicDiscChirp"] = "minecraft:music_disc_chirp";
    MinecraftItemTypes["MusicDiscFar"] = "minecraft:music_disc_far";
    MinecraftItemTypes["MusicDiscMall"] = "minecraft:music_disc_mall";
    MinecraftItemTypes["MusicDiscMellohi"] = "minecraft:music_disc_mellohi";
    MinecraftItemTypes["MusicDiscOtherside"] = "minecraft:music_disc_otherside";
    MinecraftItemTypes["MusicDiscPigstep"] = "minecraft:music_disc_pigstep";
    MinecraftItemTypes["MusicDiscStal"] = "minecraft:music_disc_stal";
    MinecraftItemTypes["MusicDiscStrad"] = "minecraft:music_disc_strad";
    MinecraftItemTypes["MusicDiscWait"] = "minecraft:music_disc_wait";
    MinecraftItemTypes["MusicDiscWard"] = "minecraft:music_disc_ward";
    MinecraftItemTypes["Mutton"] = "minecraft:mutton";
    MinecraftItemTypes["Mycelium"] = "minecraft:mycelium";
    MinecraftItemTypes["NameTag"] = "minecraft:name_tag";
    MinecraftItemTypes["NautilusShell"] = "minecraft:nautilus_shell";
    MinecraftItemTypes["NetherBrick"] = "minecraft:nether_brick";
    MinecraftItemTypes["NetherBrickFence"] = "minecraft:nether_brick_fence";
    MinecraftItemTypes["NetherBrickStairs"] = "minecraft:nether_brick_stairs";
    MinecraftItemTypes["NetherGoldOre"] = "minecraft:nether_gold_ore";
    MinecraftItemTypes["NetherSprouts"] = "minecraft:nether_sprouts";
    MinecraftItemTypes["NetherStar"] = "minecraft:nether_star";
    MinecraftItemTypes["NetherWart"] = "minecraft:nether_wart";
    MinecraftItemTypes["NetherWartBlock"] = "minecraft:nether_wart_block";
    MinecraftItemTypes["Netherbrick"] = "minecraft:netherbrick";
    MinecraftItemTypes["NetheriteAxe"] = "minecraft:netherite_axe";
    MinecraftItemTypes["NetheriteBlock"] = "minecraft:netherite_block";
    MinecraftItemTypes["NetheriteBoots"] = "minecraft:netherite_boots";
    MinecraftItemTypes["NetheriteChestplate"] = "minecraft:netherite_chestplate";
    MinecraftItemTypes["NetheriteHelmet"] = "minecraft:netherite_helmet";
    MinecraftItemTypes["NetheriteHoe"] = "minecraft:netherite_hoe";
    MinecraftItemTypes["NetheriteIngot"] = "minecraft:netherite_ingot";
    MinecraftItemTypes["NetheriteLeggings"] = "minecraft:netherite_leggings";
    MinecraftItemTypes["NetheritePickaxe"] = "minecraft:netherite_pickaxe";
    MinecraftItemTypes["NetheriteScrap"] = "minecraft:netherite_scrap";
    MinecraftItemTypes["NetheriteShovel"] = "minecraft:netherite_shovel";
    MinecraftItemTypes["NetheriteSword"] = "minecraft:netherite_sword";
    MinecraftItemTypes["NetheriteUpgradeSmithingTemplate"] = "minecraft:netherite_upgrade_smithing_template";
    MinecraftItemTypes["Netherrack"] = "minecraft:netherrack";
    MinecraftItemTypes["NormalStoneStairs"] = "minecraft:normal_stone_stairs";
    MinecraftItemTypes["Noteblock"] = "minecraft:noteblock";
    MinecraftItemTypes["OakBoat"] = "minecraft:oak_boat";
    MinecraftItemTypes["OakChestBoat"] = "minecraft:oak_chest_boat";
    MinecraftItemTypes["OakFence"] = "minecraft:oak_fence";
    MinecraftItemTypes["OakHangingSign"] = "minecraft:oak_hanging_sign";
    MinecraftItemTypes["OakLog"] = "minecraft:oak_log";
    MinecraftItemTypes["OakSign"] = "minecraft:oak_sign";
    MinecraftItemTypes["OakStairs"] = "minecraft:oak_stairs";
    MinecraftItemTypes["Observer"] = "minecraft:observer";
    MinecraftItemTypes["Obsidian"] = "minecraft:obsidian";
    MinecraftItemTypes["OcelotSpawnEgg"] = "minecraft:ocelot_spawn_egg";
    MinecraftItemTypes["OchreFroglight"] = "minecraft:ochre_froglight";
    MinecraftItemTypes["OrangeCandle"] = "minecraft:orange_candle";
    MinecraftItemTypes["OrangeCarpet"] = "minecraft:orange_carpet";
    MinecraftItemTypes["OrangeDye"] = "minecraft:orange_dye";
    MinecraftItemTypes["OrangeGlazedTerracotta"] = "minecraft:orange_glazed_terracotta";
    MinecraftItemTypes["OrangeWool"] = "minecraft:orange_wool";
    MinecraftItemTypes["OxidizedCopper"] = "minecraft:oxidized_copper";
    MinecraftItemTypes["OxidizedCutCopper"] = "minecraft:oxidized_cut_copper";
    MinecraftItemTypes["OxidizedCutCopperSlab"] = "minecraft:oxidized_cut_copper_slab";
    MinecraftItemTypes["OxidizedCutCopperStairs"] = "minecraft:oxidized_cut_copper_stairs";
    MinecraftItemTypes["PackedIce"] = "minecraft:packed_ice";
    MinecraftItemTypes["PackedMud"] = "minecraft:packed_mud";
    MinecraftItemTypes["Painting"] = "minecraft:painting";
    MinecraftItemTypes["PandaSpawnEgg"] = "minecraft:panda_spawn_egg";
    MinecraftItemTypes["Paper"] = "minecraft:paper";
    MinecraftItemTypes["ParrotSpawnEgg"] = "minecraft:parrot_spawn_egg";
    MinecraftItemTypes["PearlescentFroglight"] = "minecraft:pearlescent_froglight";
    MinecraftItemTypes["PhantomMembrane"] = "minecraft:phantom_membrane";
    MinecraftItemTypes["PhantomSpawnEgg"] = "minecraft:phantom_spawn_egg";
    MinecraftItemTypes["PigSpawnEgg"] = "minecraft:pig_spawn_egg";
    MinecraftItemTypes["PiglinBannerPattern"] = "minecraft:piglin_banner_pattern";
    MinecraftItemTypes["PiglinBruteSpawnEgg"] = "minecraft:piglin_brute_spawn_egg";
    MinecraftItemTypes["PiglinSpawnEgg"] = "minecraft:piglin_spawn_egg";
    MinecraftItemTypes["PillagerSpawnEgg"] = "minecraft:pillager_spawn_egg";
    MinecraftItemTypes["PinkCandle"] = "minecraft:pink_candle";
    MinecraftItemTypes["PinkCarpet"] = "minecraft:pink_carpet";
    MinecraftItemTypes["PinkDye"] = "minecraft:pink_dye";
    MinecraftItemTypes["PinkGlazedTerracotta"] = "minecraft:pink_glazed_terracotta";
    MinecraftItemTypes["PinkPetals"] = "minecraft:pink_petals";
    MinecraftItemTypes["PinkWool"] = "minecraft:pink_wool";
    MinecraftItemTypes["Piston"] = "minecraft:piston";
    MinecraftItemTypes["PitcherPlant"] = "minecraft:pitcher_plant";
    MinecraftItemTypes["PitcherPod"] = "minecraft:pitcher_pod";
    MinecraftItemTypes["Planks"] = "minecraft:planks";
    MinecraftItemTypes["PlentyPotteryShard"] = "minecraft:plenty_pottery_shard";
    MinecraftItemTypes["Podzol"] = "minecraft:podzol";
    MinecraftItemTypes["PointedDripstone"] = "minecraft:pointed_dripstone";
    MinecraftItemTypes["PoisonousPotato"] = "minecraft:poisonous_potato";
    MinecraftItemTypes["PolarBearSpawnEgg"] = "minecraft:polar_bear_spawn_egg";
    MinecraftItemTypes["PolishedAndesiteStairs"] = "minecraft:polished_andesite_stairs";
    MinecraftItemTypes["PolishedBasalt"] = "minecraft:polished_basalt";
    MinecraftItemTypes["PolishedBlackstone"] = "minecraft:polished_blackstone";
    MinecraftItemTypes["PolishedBlackstoneBrickSlab"] = "minecraft:polished_blackstone_brick_slab";
    MinecraftItemTypes["PolishedBlackstoneBrickStairs"] = "minecraft:polished_blackstone_brick_stairs";
    MinecraftItemTypes["PolishedBlackstoneBrickWall"] = "minecraft:polished_blackstone_brick_wall";
    MinecraftItemTypes["PolishedBlackstoneBricks"] = "minecraft:polished_blackstone_bricks";
    MinecraftItemTypes["PolishedBlackstoneButton"] = "minecraft:polished_blackstone_button";
    MinecraftItemTypes["PolishedBlackstonePressurePlate"] = "minecraft:polished_blackstone_pressure_plate";
    MinecraftItemTypes["PolishedBlackstoneSlab"] = "minecraft:polished_blackstone_slab";
    MinecraftItemTypes["PolishedBlackstoneStairs"] = "minecraft:polished_blackstone_stairs";
    MinecraftItemTypes["PolishedBlackstoneWall"] = "minecraft:polished_blackstone_wall";
    MinecraftItemTypes["PolishedDeepslate"] = "minecraft:polished_deepslate";
    MinecraftItemTypes["PolishedDeepslateSlab"] = "minecraft:polished_deepslate_slab";
    MinecraftItemTypes["PolishedDeepslateStairs"] = "minecraft:polished_deepslate_stairs";
    MinecraftItemTypes["PolishedDeepslateWall"] = "minecraft:polished_deepslate_wall";
    MinecraftItemTypes["PolishedDioriteStairs"] = "minecraft:polished_diorite_stairs";
    MinecraftItemTypes["PolishedGraniteStairs"] = "minecraft:polished_granite_stairs";
    MinecraftItemTypes["PoppedChorusFruit"] = "minecraft:popped_chorus_fruit";
    MinecraftItemTypes["Porkchop"] = "minecraft:porkchop";
    MinecraftItemTypes["Potato"] = "minecraft:potato";
    MinecraftItemTypes["Potion"] = "minecraft:potion";
    MinecraftItemTypes["PowderSnowBucket"] = "minecraft:powder_snow_bucket";
    MinecraftItemTypes["Prismarine"] = "minecraft:prismarine";
    MinecraftItemTypes["PrismarineBricksStairs"] = "minecraft:prismarine_bricks_stairs";
    MinecraftItemTypes["PrismarineCrystals"] = "minecraft:prismarine_crystals";
    MinecraftItemTypes["PrismarineShard"] = "minecraft:prismarine_shard";
    MinecraftItemTypes["PrismarineStairs"] = "minecraft:prismarine_stairs";
    MinecraftItemTypes["PrizePotteryShard"] = "minecraft:prize_pottery_shard";
    MinecraftItemTypes["Pufferfish"] = "minecraft:pufferfish";
    MinecraftItemTypes["PufferfishBucket"] = "minecraft:pufferfish_bucket";
    MinecraftItemTypes["PufferfishSpawnEgg"] = "minecraft:pufferfish_spawn_egg";
    MinecraftItemTypes["Pumpkin"] = "minecraft:pumpkin";
    MinecraftItemTypes["PumpkinPie"] = "minecraft:pumpkin_pie";
    MinecraftItemTypes["PumpkinSeeds"] = "minecraft:pumpkin_seeds";
    MinecraftItemTypes["PurpleCandle"] = "minecraft:purple_candle";
    MinecraftItemTypes["PurpleCarpet"] = "minecraft:purple_carpet";
    MinecraftItemTypes["PurpleDye"] = "minecraft:purple_dye";
    MinecraftItemTypes["PurpleGlazedTerracotta"] = "minecraft:purple_glazed_terracotta";
    MinecraftItemTypes["PurpleWool"] = "minecraft:purple_wool";
    MinecraftItemTypes["PurpurBlock"] = "minecraft:purpur_block";
    MinecraftItemTypes["PurpurStairs"] = "minecraft:purpur_stairs";
    MinecraftItemTypes["Quartz"] = "minecraft:quartz";
    MinecraftItemTypes["QuartzBlock"] = "minecraft:quartz_block";
    MinecraftItemTypes["QuartzBricks"] = "minecraft:quartz_bricks";
    MinecraftItemTypes["QuartzOre"] = "minecraft:quartz_ore";
    MinecraftItemTypes["QuartzStairs"] = "minecraft:quartz_stairs";
    MinecraftItemTypes["Rabbit"] = "minecraft:rabbit";
    MinecraftItemTypes["RabbitFoot"] = "minecraft:rabbit_foot";
    MinecraftItemTypes["RabbitHide"] = "minecraft:rabbit_hide";
    MinecraftItemTypes["RabbitSpawnEgg"] = "minecraft:rabbit_spawn_egg";
    MinecraftItemTypes["RabbitStew"] = "minecraft:rabbit_stew";
    MinecraftItemTypes["Rail"] = "minecraft:rail";
    MinecraftItemTypes["RaiserArmorTrimSmithingTemplate"] = "minecraft:raiser_armor_trim_smithing_template";
    MinecraftItemTypes["RavagerSpawnEgg"] = "minecraft:ravager_spawn_egg";
    MinecraftItemTypes["RawCopper"] = "minecraft:raw_copper";
    MinecraftItemTypes["RawCopperBlock"] = "minecraft:raw_copper_block";
    MinecraftItemTypes["RawGold"] = "minecraft:raw_gold";
    MinecraftItemTypes["RawGoldBlock"] = "minecraft:raw_gold_block";
    MinecraftItemTypes["RawIron"] = "minecraft:raw_iron";
    MinecraftItemTypes["RawIronBlock"] = "minecraft:raw_iron_block";
    MinecraftItemTypes["RecoveryCompass"] = "minecraft:recovery_compass";
    MinecraftItemTypes["RedCandle"] = "minecraft:red_candle";
    MinecraftItemTypes["RedCarpet"] = "minecraft:red_carpet";
    MinecraftItemTypes["RedDye"] = "minecraft:red_dye";
    MinecraftItemTypes["RedFlower"] = "minecraft:red_flower";
    MinecraftItemTypes["RedGlazedTerracotta"] = "minecraft:red_glazed_terracotta";
    MinecraftItemTypes["RedMushroom"] = "minecraft:red_mushroom";
    MinecraftItemTypes["RedMushroomBlock"] = "minecraft:red_mushroom_block";
    MinecraftItemTypes["RedNetherBrick"] = "minecraft:red_nether_brick";
    MinecraftItemTypes["RedNetherBrickStairs"] = "minecraft:red_nether_brick_stairs";
    MinecraftItemTypes["RedSandstone"] = "minecraft:red_sandstone";
    MinecraftItemTypes["RedSandstoneStairs"] = "minecraft:red_sandstone_stairs";
    MinecraftItemTypes["RedWool"] = "minecraft:red_wool";
    MinecraftItemTypes["Redstone"] = "minecraft:redstone";
    MinecraftItemTypes["RedstoneBlock"] = "minecraft:redstone_block";
    MinecraftItemTypes["RedstoneLamp"] = "minecraft:redstone_lamp";
    MinecraftItemTypes["RedstoneOre"] = "minecraft:redstone_ore";
    MinecraftItemTypes["RedstoneTorch"] = "minecraft:redstone_torch";
    MinecraftItemTypes["ReinforcedDeepslate"] = "minecraft:reinforced_deepslate";
    MinecraftItemTypes["Repeater"] = "minecraft:repeater";
    MinecraftItemTypes["RepeatingCommandBlock"] = "minecraft:repeating_command_block";
    MinecraftItemTypes["RespawnAnchor"] = "minecraft:respawn_anchor";
    MinecraftItemTypes["RibArmorTrimSmithingTemplate"] = "minecraft:rib_armor_trim_smithing_template";
    MinecraftItemTypes["RottenFlesh"] = "minecraft:rotten_flesh";
    MinecraftItemTypes["Saddle"] = "minecraft:saddle";
    MinecraftItemTypes["Salmon"] = "minecraft:salmon";
    MinecraftItemTypes["SalmonBucket"] = "minecraft:salmon_bucket";
    MinecraftItemTypes["SalmonSpawnEgg"] = "minecraft:salmon_spawn_egg";
    MinecraftItemTypes["Sand"] = "minecraft:sand";
    MinecraftItemTypes["Sandstone"] = "minecraft:sandstone";
    MinecraftItemTypes["SandstoneStairs"] = "minecraft:sandstone_stairs";
    MinecraftItemTypes["Sapling"] = "minecraft:sapling";
    MinecraftItemTypes["Scaffolding"] = "minecraft:scaffolding";
    MinecraftItemTypes["Sculk"] = "minecraft:sculk";
    MinecraftItemTypes["SculkCatalyst"] = "minecraft:sculk_catalyst";
    MinecraftItemTypes["SculkSensor"] = "minecraft:sculk_sensor";
    MinecraftItemTypes["SculkShrieker"] = "minecraft:sculk_shrieker";
    MinecraftItemTypes["SculkVein"] = "minecraft:sculk_vein";
    MinecraftItemTypes["Scute"] = "minecraft:scute";
    MinecraftItemTypes["SeaLantern"] = "minecraft:sea_lantern";
    MinecraftItemTypes["SeaPickle"] = "minecraft:sea_pickle";
    MinecraftItemTypes["Seagrass"] = "minecraft:seagrass";
    MinecraftItemTypes["SentryArmorTrimSmithingTemplate"] = "minecraft:sentry_armor_trim_smithing_template";
    MinecraftItemTypes["ShaperArmorTrimSmithingTemplate"] = "minecraft:shaper_armor_trim_smithing_template";
    MinecraftItemTypes["SheafPotteryShard"] = "minecraft:sheaf_pottery_shard";
    MinecraftItemTypes["Shears"] = "minecraft:shears";
    MinecraftItemTypes["SheepSpawnEgg"] = "minecraft:sheep_spawn_egg";
    MinecraftItemTypes["ShelterPotteryShard"] = "minecraft:shelter_pottery_shard";
    MinecraftItemTypes["Shield"] = "minecraft:shield";
    MinecraftItemTypes["Shroomlight"] = "minecraft:shroomlight";
    MinecraftItemTypes["ShulkerBox"] = "minecraft:shulker_box";
    MinecraftItemTypes["ShulkerShell"] = "minecraft:shulker_shell";
    MinecraftItemTypes["ShulkerSpawnEgg"] = "minecraft:shulker_spawn_egg";
    MinecraftItemTypes["SilenceArmorTrimSmithingTemplate"] = "minecraft:silence_armor_trim_smithing_template";
    MinecraftItemTypes["SilverGlazedTerracotta"] = "minecraft:silver_glazed_terracotta";
    MinecraftItemTypes["SilverfishSpawnEgg"] = "minecraft:silverfish_spawn_egg";
    MinecraftItemTypes["SkeletonHorseSpawnEgg"] = "minecraft:skeleton_horse_spawn_egg";
    MinecraftItemTypes["SkeletonSpawnEgg"] = "minecraft:skeleton_spawn_egg";
    MinecraftItemTypes["Skull"] = "minecraft:skull";
    MinecraftItemTypes["SkullBannerPattern"] = "minecraft:skull_banner_pattern";
    MinecraftItemTypes["SkullPotteryShard"] = "minecraft:skull_pottery_shard";
    MinecraftItemTypes["Slime"] = "minecraft:slime";
    MinecraftItemTypes["SlimeBall"] = "minecraft:slime_ball";
    MinecraftItemTypes["SlimeSpawnEgg"] = "minecraft:slime_spawn_egg";
    MinecraftItemTypes["SmallAmethystBud"] = "minecraft:small_amethyst_bud";
    MinecraftItemTypes["SmallDripleafBlock"] = "minecraft:small_dripleaf_block";
    MinecraftItemTypes["SmithingTable"] = "minecraft:smithing_table";
    MinecraftItemTypes["Smoker"] = "minecraft:smoker";
    MinecraftItemTypes["SmoothBasalt"] = "minecraft:smooth_basalt";
    MinecraftItemTypes["SmoothQuartzStairs"] = "minecraft:smooth_quartz_stairs";
    MinecraftItemTypes["SmoothRedSandstoneStairs"] = "minecraft:smooth_red_sandstone_stairs";
    MinecraftItemTypes["SmoothSandstoneStairs"] = "minecraft:smooth_sandstone_stairs";
    MinecraftItemTypes["SmoothStone"] = "minecraft:smooth_stone";
    MinecraftItemTypes["SnifferEgg"] = "minecraft:sniffer_egg";
    MinecraftItemTypes["SnifferSpawnEgg"] = "minecraft:sniffer_spawn_egg";
    MinecraftItemTypes["SnortPotteryShard"] = "minecraft:snort_pottery_shard";
    MinecraftItemTypes["SnoutArmorTrimSmithingTemplate"] = "minecraft:snout_armor_trim_smithing_template";
    MinecraftItemTypes["Snow"] = "minecraft:snow";
    MinecraftItemTypes["SnowGolemSpawnEgg"] = "minecraft:snow_golem_spawn_egg";
    MinecraftItemTypes["SnowLayer"] = "minecraft:snow_layer";
    MinecraftItemTypes["Snowball"] = "minecraft:snowball";
    MinecraftItemTypes["SoulCampfire"] = "minecraft:soul_campfire";
    MinecraftItemTypes["SoulLantern"] = "minecraft:soul_lantern";
    MinecraftItemTypes["SoulSand"] = "minecraft:soul_sand";
    MinecraftItemTypes["SoulSoil"] = "minecraft:soul_soil";
    MinecraftItemTypes["SoulTorch"] = "minecraft:soul_torch";
    MinecraftItemTypes["SpawnEgg"] = "minecraft:spawn_egg";
    MinecraftItemTypes["SpiderEye"] = "minecraft:spider_eye";
    MinecraftItemTypes["SpiderSpawnEgg"] = "minecraft:spider_spawn_egg";
    MinecraftItemTypes["SpireArmorTrimSmithingTemplate"] = "minecraft:spire_armor_trim_smithing_template";
    MinecraftItemTypes["SplashPotion"] = "minecraft:splash_potion";
    MinecraftItemTypes["Sponge"] = "minecraft:sponge";
    MinecraftItemTypes["SporeBlossom"] = "minecraft:spore_blossom";
    MinecraftItemTypes["SpruceBoat"] = "minecraft:spruce_boat";
    MinecraftItemTypes["SpruceButton"] = "minecraft:spruce_button";
    MinecraftItemTypes["SpruceChestBoat"] = "minecraft:spruce_chest_boat";
    MinecraftItemTypes["SpruceDoor"] = "minecraft:spruce_door";
    MinecraftItemTypes["SpruceFence"] = "minecraft:spruce_fence";
    MinecraftItemTypes["SpruceFenceGate"] = "minecraft:spruce_fence_gate";
    MinecraftItemTypes["SpruceHangingSign"] = "minecraft:spruce_hanging_sign";
    MinecraftItemTypes["SpruceLog"] = "minecraft:spruce_log";
    MinecraftItemTypes["SprucePressurePlate"] = "minecraft:spruce_pressure_plate";
    MinecraftItemTypes["SpruceSign"] = "minecraft:spruce_sign";
    MinecraftItemTypes["SpruceStairs"] = "minecraft:spruce_stairs";
    MinecraftItemTypes["SpruceTrapdoor"] = "minecraft:spruce_trapdoor";
    MinecraftItemTypes["Spyglass"] = "minecraft:spyglass";
    MinecraftItemTypes["SquidSpawnEgg"] = "minecraft:squid_spawn_egg";
    MinecraftItemTypes["StainedGlass"] = "minecraft:stained_glass";
    MinecraftItemTypes["StainedGlassPane"] = "minecraft:stained_glass_pane";
    MinecraftItemTypes["StainedHardenedClay"] = "minecraft:stained_hardened_clay";
    MinecraftItemTypes["Stick"] = "minecraft:stick";
    MinecraftItemTypes["StickyPiston"] = "minecraft:sticky_piston";
    MinecraftItemTypes["Stone"] = "minecraft:stone";
    MinecraftItemTypes["StoneAxe"] = "minecraft:stone_axe";
    MinecraftItemTypes["StoneBlockSlab"] = "minecraft:stone_block_slab";
    MinecraftItemTypes["StoneBlockSlab2"] = "minecraft:stone_block_slab2";
    MinecraftItemTypes["StoneBlockSlab3"] = "minecraft:stone_block_slab3";
    MinecraftItemTypes["StoneBlockSlab4"] = "minecraft:stone_block_slab4";
    MinecraftItemTypes["StoneBrickStairs"] = "minecraft:stone_brick_stairs";
    MinecraftItemTypes["StoneButton"] = "minecraft:stone_button";
    MinecraftItemTypes["StoneHoe"] = "minecraft:stone_hoe";
    MinecraftItemTypes["StonePickaxe"] = "minecraft:stone_pickaxe";
    MinecraftItemTypes["StonePressurePlate"] = "minecraft:stone_pressure_plate";
    MinecraftItemTypes["StoneShovel"] = "minecraft:stone_shovel";
    MinecraftItemTypes["StoneStairs"] = "minecraft:stone_stairs";
    MinecraftItemTypes["StoneSword"] = "minecraft:stone_sword";
    MinecraftItemTypes["Stonebrick"] = "minecraft:stonebrick";
    MinecraftItemTypes["StonecutterBlock"] = "minecraft:stonecutter_block";
    MinecraftItemTypes["StraySpawnEgg"] = "minecraft:stray_spawn_egg";
    MinecraftItemTypes["StriderSpawnEgg"] = "minecraft:strider_spawn_egg";
    MinecraftItemTypes["String"] = "minecraft:string";
    MinecraftItemTypes["StrippedAcaciaLog"] = "minecraft:stripped_acacia_log";
    MinecraftItemTypes["StrippedBambooBlock"] = "minecraft:stripped_bamboo_block";
    MinecraftItemTypes["StrippedBirchLog"] = "minecraft:stripped_birch_log";
    MinecraftItemTypes["StrippedCherryLog"] = "minecraft:stripped_cherry_log";
    MinecraftItemTypes["StrippedCherryWood"] = "minecraft:stripped_cherry_wood";
    MinecraftItemTypes["StrippedCrimsonHyphae"] = "minecraft:stripped_crimson_hyphae";
    MinecraftItemTypes["StrippedCrimsonStem"] = "minecraft:stripped_crimson_stem";
    MinecraftItemTypes["StrippedDarkOakLog"] = "minecraft:stripped_dark_oak_log";
    MinecraftItemTypes["StrippedJungleLog"] = "minecraft:stripped_jungle_log";
    MinecraftItemTypes["StrippedMangroveLog"] = "minecraft:stripped_mangrove_log";
    MinecraftItemTypes["StrippedMangroveWood"] = "minecraft:stripped_mangrove_wood";
    MinecraftItemTypes["StrippedOakLog"] = "minecraft:stripped_oak_log";
    MinecraftItemTypes["StrippedSpruceLog"] = "minecraft:stripped_spruce_log";
    MinecraftItemTypes["StrippedWarpedHyphae"] = "minecraft:stripped_warped_hyphae";
    MinecraftItemTypes["StrippedWarpedStem"] = "minecraft:stripped_warped_stem";
    MinecraftItemTypes["StructureBlock"] = "minecraft:structure_block";
    MinecraftItemTypes["StructureVoid"] = "minecraft:structure_void";
    MinecraftItemTypes["Sugar"] = "minecraft:sugar";
    MinecraftItemTypes["SugarCane"] = "minecraft:sugar_cane";
    MinecraftItemTypes["SuspiciousGravel"] = "minecraft:suspicious_gravel";
    MinecraftItemTypes["SuspiciousSand"] = "minecraft:suspicious_sand";
    MinecraftItemTypes["SuspiciousStew"] = "minecraft:suspicious_stew";
    MinecraftItemTypes["SweetBerries"] = "minecraft:sweet_berries";
    MinecraftItemTypes["TadpoleBucket"] = "minecraft:tadpole_bucket";
    MinecraftItemTypes["TadpoleSpawnEgg"] = "minecraft:tadpole_spawn_egg";
    MinecraftItemTypes["Tallgrass"] = "minecraft:tallgrass";
    MinecraftItemTypes["Target"] = "minecraft:target";
    MinecraftItemTypes["TideArmorTrimSmithingTemplate"] = "minecraft:tide_armor_trim_smithing_template";
    MinecraftItemTypes["TintedGlass"] = "minecraft:tinted_glass";
    MinecraftItemTypes["Tnt"] = "minecraft:tnt";
    MinecraftItemTypes["TntMinecart"] = "minecraft:tnt_minecart";
    MinecraftItemTypes["Torch"] = "minecraft:torch";
    MinecraftItemTypes["Torchflower"] = "minecraft:torchflower";
    MinecraftItemTypes["TorchflowerSeeds"] = "minecraft:torchflower_seeds";
    MinecraftItemTypes["TotemOfUndying"] = "minecraft:totem_of_undying";
    MinecraftItemTypes["TraderLlamaSpawnEgg"] = "minecraft:trader_llama_spawn_egg";
    MinecraftItemTypes["Trapdoor"] = "minecraft:trapdoor";
    MinecraftItemTypes["TrappedChest"] = "minecraft:trapped_chest";
    MinecraftItemTypes["Trident"] = "minecraft:trident";
    MinecraftItemTypes["TripwireHook"] = "minecraft:tripwire_hook";
    MinecraftItemTypes["TropicalFish"] = "minecraft:tropical_fish";
    MinecraftItemTypes["TropicalFishBucket"] = "minecraft:tropical_fish_bucket";
    MinecraftItemTypes["TropicalFishSpawnEgg"] = "minecraft:tropical_fish_spawn_egg";
    MinecraftItemTypes["TubeCoral"] = "minecraft:tube_coral";
    MinecraftItemTypes["Tuff"] = "minecraft:tuff";
    MinecraftItemTypes["TurtleEgg"] = "minecraft:turtle_egg";
    MinecraftItemTypes["TurtleHelmet"] = "minecraft:turtle_helmet";
    MinecraftItemTypes["TurtleSpawnEgg"] = "minecraft:turtle_spawn_egg";
    MinecraftItemTypes["TwistingVines"] = "minecraft:twisting_vines";
    MinecraftItemTypes["UndyedShulkerBox"] = "minecraft:undyed_shulker_box";
    MinecraftItemTypes["VerdantFroglight"] = "minecraft:verdant_froglight";
    MinecraftItemTypes["VexArmorTrimSmithingTemplate"] = "minecraft:vex_armor_trim_smithing_template";
    MinecraftItemTypes["VexSpawnEgg"] = "minecraft:vex_spawn_egg";
    MinecraftItemTypes["VillagerSpawnEgg"] = "minecraft:villager_spawn_egg";
    MinecraftItemTypes["VindicatorSpawnEgg"] = "minecraft:vindicator_spawn_egg";
    MinecraftItemTypes["Vine"] = "minecraft:vine";
    MinecraftItemTypes["WanderingTraderSpawnEgg"] = "minecraft:wandering_trader_spawn_egg";
    MinecraftItemTypes["WardArmorTrimSmithingTemplate"] = "minecraft:ward_armor_trim_smithing_template";
    MinecraftItemTypes["WardenSpawnEgg"] = "minecraft:warden_spawn_egg";
    MinecraftItemTypes["WarpedButton"] = "minecraft:warped_button";
    MinecraftItemTypes["WarpedDoor"] = "minecraft:warped_door";
    MinecraftItemTypes["WarpedFence"] = "minecraft:warped_fence";
    MinecraftItemTypes["WarpedFenceGate"] = "minecraft:warped_fence_gate";
    MinecraftItemTypes["WarpedFungus"] = "minecraft:warped_fungus";
    MinecraftItemTypes["WarpedFungusOnAStick"] = "minecraft:warped_fungus_on_a_stick";
    MinecraftItemTypes["WarpedHangingSign"] = "minecraft:warped_hanging_sign";
    MinecraftItemTypes["WarpedHyphae"] = "minecraft:warped_hyphae";
    MinecraftItemTypes["WarpedNylium"] = "minecraft:warped_nylium";
    MinecraftItemTypes["WarpedPlanks"] = "minecraft:warped_planks";
    MinecraftItemTypes["WarpedPressurePlate"] = "minecraft:warped_pressure_plate";
    MinecraftItemTypes["WarpedRoots"] = "minecraft:warped_roots";
    MinecraftItemTypes["WarpedSign"] = "minecraft:warped_sign";
    MinecraftItemTypes["WarpedSlab"] = "minecraft:warped_slab";
    MinecraftItemTypes["WarpedStairs"] = "minecraft:warped_stairs";
    MinecraftItemTypes["WarpedStem"] = "minecraft:warped_stem";
    MinecraftItemTypes["WarpedTrapdoor"] = "minecraft:warped_trapdoor";
    MinecraftItemTypes["WarpedWartBlock"] = "minecraft:warped_wart_block";
    MinecraftItemTypes["WaterBucket"] = "minecraft:water_bucket";
    MinecraftItemTypes["Waterlily"] = "minecraft:waterlily";
    MinecraftItemTypes["WaxedCopper"] = "minecraft:waxed_copper";
    MinecraftItemTypes["WaxedCutCopper"] = "minecraft:waxed_cut_copper";
    MinecraftItemTypes["WaxedCutCopperSlab"] = "minecraft:waxed_cut_copper_slab";
    MinecraftItemTypes["WaxedCutCopperStairs"] = "minecraft:waxed_cut_copper_stairs";
    MinecraftItemTypes["WaxedExposedCopper"] = "minecraft:waxed_exposed_copper";
    MinecraftItemTypes["WaxedExposedCutCopper"] = "minecraft:waxed_exposed_cut_copper";
    MinecraftItemTypes["WaxedExposedCutCopperSlab"] = "minecraft:waxed_exposed_cut_copper_slab";
    MinecraftItemTypes["WaxedExposedCutCopperStairs"] = "minecraft:waxed_exposed_cut_copper_stairs";
    MinecraftItemTypes["WaxedOxidizedCopper"] = "minecraft:waxed_oxidized_copper";
    MinecraftItemTypes["WaxedOxidizedCutCopper"] = "minecraft:waxed_oxidized_cut_copper";
    MinecraftItemTypes["WaxedOxidizedCutCopperSlab"] = "minecraft:waxed_oxidized_cut_copper_slab";
    MinecraftItemTypes["WaxedOxidizedCutCopperStairs"] = "minecraft:waxed_oxidized_cut_copper_stairs";
    MinecraftItemTypes["WaxedWeatheredCopper"] = "minecraft:waxed_weathered_copper";
    MinecraftItemTypes["WaxedWeatheredCutCopper"] = "minecraft:waxed_weathered_cut_copper";
    MinecraftItemTypes["WaxedWeatheredCutCopperSlab"] = "minecraft:waxed_weathered_cut_copper_slab";
    MinecraftItemTypes["WaxedWeatheredCutCopperStairs"] = "minecraft:waxed_weathered_cut_copper_stairs";
    MinecraftItemTypes["WayfinderArmorTrimSmithingTemplate"] = "minecraft:wayfinder_armor_trim_smithing_template";
    MinecraftItemTypes["WeatheredCopper"] = "minecraft:weathered_copper";
    MinecraftItemTypes["WeatheredCutCopper"] = "minecraft:weathered_cut_copper";
    MinecraftItemTypes["WeatheredCutCopperSlab"] = "minecraft:weathered_cut_copper_slab";
    MinecraftItemTypes["WeatheredCutCopperStairs"] = "minecraft:weathered_cut_copper_stairs";
    MinecraftItemTypes["Web"] = "minecraft:web";
    MinecraftItemTypes["WeepingVines"] = "minecraft:weeping_vines";
    MinecraftItemTypes["Wheat"] = "minecraft:wheat";
    MinecraftItemTypes["WheatSeeds"] = "minecraft:wheat_seeds";
    MinecraftItemTypes["WhiteCandle"] = "minecraft:white_candle";
    MinecraftItemTypes["WhiteCarpet"] = "minecraft:white_carpet";
    MinecraftItemTypes["WhiteDye"] = "minecraft:white_dye";
    MinecraftItemTypes["WhiteGlazedTerracotta"] = "minecraft:white_glazed_terracotta";
    MinecraftItemTypes["WhiteWool"] = "minecraft:white_wool";
    MinecraftItemTypes["WildArmorTrimSmithingTemplate"] = "minecraft:wild_armor_trim_smithing_template";
    MinecraftItemTypes["WitchSpawnEgg"] = "minecraft:witch_spawn_egg";
    MinecraftItemTypes["WitherRose"] = "minecraft:wither_rose";
    MinecraftItemTypes["WitherSkeletonSpawnEgg"] = "minecraft:wither_skeleton_spawn_egg";
    MinecraftItemTypes["WitherSpawnEgg"] = "minecraft:wither_spawn_egg";
    MinecraftItemTypes["WolfSpawnEgg"] = "minecraft:wolf_spawn_egg";
    MinecraftItemTypes["Wood"] = "minecraft:wood";
    MinecraftItemTypes["WoodenAxe"] = "minecraft:wooden_axe";
    MinecraftItemTypes["WoodenButton"] = "minecraft:wooden_button";
    MinecraftItemTypes["WoodenDoor"] = "minecraft:wooden_door";
    MinecraftItemTypes["WoodenHoe"] = "minecraft:wooden_hoe";
    MinecraftItemTypes["WoodenPickaxe"] = "minecraft:wooden_pickaxe";
    MinecraftItemTypes["WoodenPressurePlate"] = "minecraft:wooden_pressure_plate";
    MinecraftItemTypes["WoodenShovel"] = "minecraft:wooden_shovel";
    MinecraftItemTypes["WoodenSlab"] = "minecraft:wooden_slab";
    MinecraftItemTypes["WoodenSword"] = "minecraft:wooden_sword";
    MinecraftItemTypes["Wool"] = "minecraft:wool";
    MinecraftItemTypes["WritableBook"] = "minecraft:writable_book";
    MinecraftItemTypes["YellowCandle"] = "minecraft:yellow_candle";
    MinecraftItemTypes["YellowCarpet"] = "minecraft:yellow_carpet";
    MinecraftItemTypes["YellowDye"] = "minecraft:yellow_dye";
    MinecraftItemTypes["YellowFlower"] = "minecraft:yellow_flower";
    MinecraftItemTypes["YellowGlazedTerracotta"] = "minecraft:yellow_glazed_terracotta";
    MinecraftItemTypes["YellowWool"] = "minecraft:yellow_wool";
    MinecraftItemTypes["ZoglinSpawnEgg"] = "minecraft:zoglin_spawn_egg";
    MinecraftItemTypes["ZombieHorseSpawnEgg"] = "minecraft:zombie_horse_spawn_egg";
    MinecraftItemTypes["ZombiePigmanSpawnEgg"] = "minecraft:zombie_pigman_spawn_egg";
    MinecraftItemTypes["ZombieSpawnEgg"] = "minecraft:zombie_spawn_egg";
    MinecraftItemTypes["ZombieVillagerSpawnEgg"] = "minecraft:zombie_villager_spawn_egg";
})(MinecraftItemTypes || (MinecraftItemTypes = {}));

async function deleteOperation(uiSession) {
    if (uiSession.extensionContext.selectionManager.selection.isEmpty) {
        uiSession.log.warning("Selection volume is empty - nothing to clear");
        return;
    }
    uiSession.extensionContext.transactionManager.openTransaction("Delete");
    try {
        uiSession.extensionContext.transactionManager.trackBlockChangeSelection(uiSession.extensionContext.selectionManager.selection);
    } catch (e) {
        uiSession.log.warning(`Unable to delete selection. ${stringFromException(e)}`);
        uiSession.extensionContext.transactionManager.discardOpenTransaction();
        return;
    }
    const player = uiSession.extensionContext.player;
    const dimension = player.dimension;
    await (0, server_editor_namespaceObject.executeLargeOperation)(uiSession.extensionContext.selectionManager.selection, (blockLocation => {
        const block = dimension.getBlock(blockLocation);
        if (block) {
            block.isWaterlogged = false;
            block.setType(MinecraftBlockTypes.Air);
        }
    })).catch((e => {
        uiSession.log.error(e.message);
        uiSession.extensionContext.transactionManager.discardOpenTransaction();
    })).then((() => {
        uiSession.extensionContext.transactionManager.commitOpenTransaction();
    }));
}

class ClipboardBehavior {
    constructor(uiSession, coreMenuItems, fallbackToolId) {
        this.uiSession = uiSession;
        this.fallbackToolId = fallbackToolId;
        this.pastePreviewLocation = {
            x: 0,
            y: 0,
            z: 0
        };
        this.rotationLookup = [ server_editor_namespaceObject.ClipboardRotation.None, server_editor_namespaceObject.ClipboardRotation.Rotate90, server_editor_namespaceObject.ClipboardRotation.Rotate180, server_editor_namespaceObject.ClipboardRotation.Rotate270 ];
        this.settings = this.getDefaultClipboardSettings();
        this.selectionPreview = uiSession.extensionContext.selectionManager.create();
        this.selectionPreview.setFillColor({
            red: 1,
            green: 1,
            blue: 0,
            alpha: .25
        });
        this.selectionPreview.setOutlineColor({
            red: 1,
            green: 0,
            blue: 1,
            alpha: 1
        });
        this.setup(uiSession, coreMenuItems);
    }
    getDefaultClipboardSettings() {
        return {
            rotationIndex: 0,
            mirrorX: false,
            mirrorZ: false,
            origin: {
                x: 0,
                y: 0,
                z: 0
            }
        };
    }
    setup(uiSession, coreMenuItems) {
        if (!uiSession.scratchStorage) {
            throw new Error("Unable to set up Clipboard due to missing CoreUIState.");
        }
        this.tool = uiSession.toolRail.addTool({
            displayAltText: "Paste Preview (CTRL + SHIFT + V)",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.toolRail.title"),
            icon: "pack://textures/editor/Paste.png?filtering=point",
            tooltipAltText: "Left mouse click or drag-to-paint",
            tooltipStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.toolRail.description")
        });
        this.tool.onModalToolActivation.subscribe((eventData => {
            this.selectionPreview.visible = eventData.isActiveTool;
            if (eventData.isActiveTool) {
                uiSession.extensionContext.cursor.resetToDefaultState();
                this.updateSelectionPreview(uiSession.extensionContext);
                this.tryUpdateToSelection(uiSession, false);
            }
        }));
        const pane = uiSession.createPropertyPane({
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.title"),
            titleAltText: "Paste"
        });
        this.settings = (0, server_editor_namespaceObject.bindDataSource)(pane, this.getDefaultClipboardSettings());
        const submitPastePreviewAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.doPaste(uiSession, this.generateWriteOptions(this.settings));
            }
        });
        pane.addButton(submitPastePreviewAction, {
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.submitButton"),
            titleAltText: "Confirm Paste"
        });
        const transformPane = pane.createPropertyPane({
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.title"),
            titleAltText: "Transform"
        });
        transformPane.addVector3(this.settings, "origin", {
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.origin.title"),
            titleAltText: "Origin",
            minX: Number.MIN_SAFE_INTEGER,
            minY: Number.MIN_SAFE_INTEGER,
            minZ: Number.MIN_SAFE_INTEGER,
            onChange: (_obj, _property, _oldValue, _newValue) => {
                this.updateSelectionPreview(uiSession.extensionContext);
            }
        });
        transformPane.addDropdown(this.settings, "rotationIndex", {
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.rotation.title"),
            titleAltText: "Rotate",
            dropdownItems: [ {
                displayAltText: "0°",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.rotation.none"),
                value: 0
            }, {
                displayAltText: "90°",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.rotation.90"),
                value: 1
            }, {
                displayAltText: "180°",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.rotation.180"),
                value: 2
            }, {
                displayAltText: "270°",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.rotation.270"),
                value: 3
            } ],
            onChange: (_obj, _property, _oldValue, _newValue) => {
                this.updateSelectionPreview(uiSession.extensionContext);
            }
        });
        transformPane.addBool(this.settings, "mirrorX", {
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.mirrorX"),
            titleAltText: "Mirror X",
            onChange: (_obj, _property, _oldValue, _newValue) => {
                this.updateSelectionPreview(uiSession.extensionContext);
            }
        });
        transformPane.addBool(this.settings, "mirrorZ", {
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("paste.pane.transform.mirrorZ"),
            titleAltText: "Mirror Z",
            onChange: (_obj, _property, _oldValue, _newValue) => {
                this.updateSelectionPreview(uiSession.extensionContext);
            }
        });
        this.tool.bindPropertyPane(pane);
        const copyAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.doCopy(uiSession);
            }
        });
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, copyAction, server_editor_namespaceObject.KeyboardKey.KEY_C, server_editor_namespaceObject.InputModifier.Control);
        const cutAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.doCopy(uiSession);
                deleteOperation(uiSession).catch((e => uiSession.log.error(e.message)));
            }
        });
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, cutAction, server_editor_namespaceObject.KeyboardKey.KEY_X, server_editor_namespaceObject.InputModifier.Control);
        const pasteAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                if (uiSession.toolRail.selectedOptionId === this.tool?.id) {
                    this.doPaste(uiSession, this.generateWriteOptions(this.settings));
                } else {
                    this.doQuickPaste(uiSession, false);
                }
            }
        });
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, pasteAction, server_editor_namespaceObject.KeyboardKey.KEY_V, server_editor_namespaceObject.InputModifier.Control);
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.selectPasteTool(uiSession, true);
            }
        }), server_editor_namespaceObject.KeyboardKey.KEY_V, server_editor_namespaceObject.InputModifier.Control | server_editor_namespaceObject.InputModifier.Shift);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.selectionPreview.clear();
                if (this.fallbackToolId !== undefined) {
                    uiSession.toolRail.setSelectedOptionId(this.fallbackToolId, true);
                }
            }
        }), server_editor_namespaceObject.KeyboardKey.KEY_D, server_editor_namespaceObject.InputModifier.Control);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.movePreview(uiSession.extensionContext, getAxisAlignedDirection(uiSession.extensionContext.player.getRotation().y));
            }
        }), server_editor_namespaceObject.KeyboardKey.UP);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.movePreview(uiSession.extensionContext, getAxisAlignedDirection(uiSession.extensionContext.player.getRotation().y + 180));
            }
        }), server_editor_namespaceObject.KeyboardKey.DOWN);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.movePreview(uiSession.extensionContext, getAxisAlignedDirection(uiSession.extensionContext.player.getRotation().y + 270));
            }
        }), server_editor_namespaceObject.KeyboardKey.LEFT);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.movePreview(uiSession.extensionContext, getAxisAlignedDirection(uiSession.extensionContext.player.getRotation().y + 90));
            }
        }), server_editor_namespaceObject.KeyboardKey.RIGHT);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.movePreview(uiSession.extensionContext, vector_utils_Vector3Utils.up);
            }
        }), server_editor_namespaceObject.KeyboardKey.PAGE_UP);
        this.tool.registerKeyBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.movePreview(uiSession.extensionContext, vector_utils_Vector3Utils.down);
            }
        }), server_editor_namespaceObject.KeyboardKey.PAGE_DOWN);
        this.tool.registerMouseButtonBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
            onExecute: (mouseRay, mouseProps) => {
                if (mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton) {
                    if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown) {
                        this.movePreviewToRay(uiSession.extensionContext, mouseRay);
                    }
                }
            }
        }));
        this.tool.registerMouseDragBinding(uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
            onExecute: (mouseRay, mouseProps) => {
                if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.Drag) {
                    this.movePreviewToRay(uiSession.extensionContext, mouseRay);
                }
            }
        }));
        this.tool.registerKeyBinding(submitPastePreviewAction, server_editor_namespaceObject.KeyboardKey.ENTER);
        coreMenuItems.edit.addItem({
            name: "menuBar.edit.cut",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.cut")
        }, cutAction);
        coreMenuItems.edit.addItem({
            name: "menuBar.edit.copy",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.copy")
        }, copyAction);
        coreMenuItems.edit.addItem({
            name: "menuBar.edit.quickPaste",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.quickPaste")
        }, pasteAction);
    }
    teardown() {
        this.pastePreviewLocation = vector_utils_Vector3Utils.zero;
        this.selectionPreview.clear();
        this.settings = this.getDefaultClipboardSettings();
        this.tool = undefined;
    }
    resetSettings() {
        this.settings.rotationIndex = 0;
        this.settings.mirrorX = false;
        this.settings.mirrorZ = false;
        this.settings.origin = vector_utils_Vector3Utils.zero;
    }
    selectPasteTool(uiSession, isPastePreview) {
        uiSession.toolRail.setSelectedOptionId(this.tool?.id, true);
        this.updateSelectionPreview(uiSession.extensionContext);
        this.tryUpdateToSelection(uiSession, isPastePreview);
    }
    doCopy(uiSession) {
        const selectionManager = uiSession.extensionContext.selectionManager;
        if (selectionManager.selection.isEmpty) {
            uiSession.log.warning("Unable to copy empty selection!");
            return;
        }
        const clipboardManager = uiSession.extensionContext.clipboardManager;
        clipboardManager.clipboard.readFromSelection(selectionManager.selection);
        uiSession.log.info("Selection Copied");
        this.resetSettings();
        if (uiSession.toolRail.selectedOptionId === this.tool?.id) {
            this.updateSelectionPreview(uiSession.extensionContext);
        }
    }
    doQuickPaste(uiSession, isPastePreview) {
        const extensionContext = uiSession.extensionContext;
        const clipboardManager = extensionContext.clipboardManager;
        if (clipboardManager.clipboard.isEmpty) {
            uiSession.log.warning("Clipboard is empty!");
            return;
        }
        const selectionManager = extensionContext.selectionManager;
        if (selectionManager.selection.isEmpty) {
            uiSession.toolRail.setSelectedOptionId(this.tool?.id, true);
            this.tryUpdateToSelection(uiSession, isPastePreview);
        } else {
            this.tryUpdateToSelection(uiSession, isPastePreview);
            this.doPaste(uiSession, this.generateWriteOptions(this.settings));
        }
    }
    doPaste(uiSession, writeOptions) {
        const clipboardManager = uiSession.extensionContext.clipboardManager;
        if (clipboardManager.clipboard.isEmpty) {
            uiSession.log.warning("Clipboard is empty!");
            return;
        }
        const transactionManager = uiSession.extensionContext.transactionManager;
        transactionManager.openTransaction("Paste");
        clipboardManager.clipboard.writeToWorld(this.pastePreviewLocation, writeOptions);
        transactionManager.commitOpenTransaction();
    }
    tryUpdateToSelection(uiSession, isPastePreview) {
        const selectionManager = uiSession.extensionContext.selectionManager;
        let rotation = this.getClipboardRotationFromDropdownIndex(this.settings.rotationIndex);
        let bounds;
        if (!selectionManager.selection.isEmpty) {
            bounds = selectionManager.selection.getBoundingBox();
            if (isPastePreview) {
                const rotationY = uiSession.extensionContext.player.getRotation().y;
                const directionRight = getRotationCorrectedDirectionVector(rotationY, Direction.Right);
                const directionBack = getRotationCorrectedDirectionVector(rotationY, Direction.Back);
                const backAndRight = server_namespaceObject.Vector.add(directionRight, directionBack);
                bounds = server_namespaceObject.BoundingBoxUtils.translate(bounds, {
                    x: backAndRight.x,
                    y: 0,
                    z: backAndRight.z
                });
            }
        } else {
            const cursorPosition = uiSession.extensionContext.cursor.getPosition();
            const clipboardSize = uiSession.extensionContext.clipboardManager.clipboard.getSize();
            bounds = {
                min: cursorPosition,
                max: vector_utils_Vector3Utils.add(cursorPosition, clipboardSize)
            };
            this.settings.rotationIndex = 0;
            rotation = server_editor_namespaceObject.ClipboardRotation.None;
        }
        switch (rotation) {
          case server_editor_namespaceObject.ClipboardRotation.None:
            {
                this.pastePreviewLocation = bounds.min;
                break;
            }

          case server_editor_namespaceObject.ClipboardRotation.Rotate90:
            {
                this.pastePreviewLocation = {
                    x: bounds.max.x,
                    y: bounds.min.y,
                    z: bounds.min.z
                };
                break;
            }

          case server_editor_namespaceObject.ClipboardRotation.Rotate180:
            {
                this.pastePreviewLocation = {
                    x: bounds.max.x,
                    y: bounds.min.y,
                    z: bounds.max.z
                };
                break;
            }

          case server_editor_namespaceObject.ClipboardRotation.Rotate270:
            {
                this.pastePreviewLocation = {
                    x: bounds.min.x,
                    y: bounds.min.y,
                    z: bounds.max.z
                };
                break;
            }

          default:
            {
                uiSession.log.error("Unknown Rotation, unable to paste.");
                return;
            }
        }
    }
    generateWriteOptions(settings) {
        const writeOptions = {};
        writeOptions.rotation = this.getClipboardRotationFromDropdownIndex(this.settings.rotationIndex);
        if (settings.mirrorX) {
            if (settings.mirrorZ) {
                writeOptions.mirror = server_editor_namespaceObject.ClipboardMirrorAxis.XZ;
            } else {
                writeOptions.mirror = server_editor_namespaceObject.ClipboardMirrorAxis.X;
            }
        } else if (settings.mirrorZ) {
            writeOptions.mirror = server_editor_namespaceObject.ClipboardMirrorAxis.Z;
        }
        writeOptions.anchor = {
            x: -1,
            y: -1,
            z: -1
        };
        writeOptions.offset = settings.origin;
        return writeOptions;
    }
    updateSelectionPreview(extensionContext) {
        const writeOptions = this.generateWriteOptions(this.settings);
        const clipboardManager = extensionContext.clipboardManager;
        this.selectionPreview.set(clipboardManager.clipboard.getPredictedWriteAsCompoundBlockVolume(this.pastePreviewLocation, writeOptions));
    }
    movePreviewToPlayer(extensionContext) {
        this.pastePreviewLocation = findPasteTarget(extensionContext.player);
        this.updateSelectionPreview(extensionContext);
    }
    movePreviewToRay(extensionContext, ray) {
        this.pastePreviewLocation = findPasteTarget(extensionContext.player, ray);
        this.updateSelectionPreview(extensionContext);
    }
    movePreview(extensionContext, offset) {
        this.pastePreviewLocation = vector_utils_Vector3Utils.add(this.pastePreviewLocation, offset);
        this.updateSelectionPreview(extensionContext);
    }
    getClipboardRotationFromDropdownIndex(index) {
        if (index < 0 || index >= this.rotationLookup.length) {
            this.uiSession.log.error("Unexpected rotation index, unable to convert to clipboard rotation.");
            return this.rotationLookup[0];
        }
        return this.rotationLookup[index % this.rotationLookup.length];
    }
}

const Clipboard_directionLookup = [ {
    x: 0,
    y: 0,
    z: 1
}, {
    x: -1,
    y: 0,
    z: 0
}, {
    x: 0,
    y: 0,
    z: -1
}, {
    x: 1,
    y: 0,
    z: 0
} ];

function getAxisAlignedDirection(rotation) {
    const directionQuadrant = Math.floor((rotation + 405) % 360 / 90);
    return Clipboard_directionLookup[directionQuadrant];
}

function findPasteTarget(player, ray) {
    const raycastOptions = {
        includeLiquidBlocks: false,
        includePassableBlocks: true,
        maxDistance: 100
    };
    const blockHit = ray ? player.dimension.getBlockFromRay(ray.location, ray.direction, raycastOptions) : player.getBlockFromViewDirection(raycastOptions);
    let destination;
    if (blockHit) {
        destination = blockHit.block.location;
    } else {
        const headLocation = player.getHeadLocation();
        destination = {
            x: headLocation.x,
            y: headLocation.y,
            z: headLocation.z
        };
        const viewDirection = player.getViewDirection();
        destination.x = destination.x + viewDirection.x * 3;
        destination.y = destination.y + viewDirection.y * 3;
        destination.z = destination.z + viewDirection.z * 3;
    }
    return destination;
}

class DeleteBehavior {
    constructor(uiSession, coreMenuItems) {
        const deleteAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                deleteOperation(uiSession).catch((e => uiSession.log.error(e.message)));
            }
        });
        coreMenuItems.edit.addItem({
            name: "menuBar.edit.delete",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.delete")
        }, deleteAction);
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, deleteAction, server_editor_namespaceObject.KeyboardKey.DELETE);
    }
    teardown() {}
}

var SelectionCursorMode;

(function(SelectionCursorMode) {
    SelectionCursorMode[SelectionCursorMode["Freeform"] = 0] = "Freeform";
    SelectionCursorMode[SelectionCursorMode["FixedDistance"] = 1] = "FixedDistance";
    SelectionCursorMode[SelectionCursorMode["AdjacentFace"] = 2] = "AdjacentFace";
})(SelectionCursorMode || (SelectionCursorMode = {}));

const Controls = {
    Up: server_editor_namespaceObject.KeyboardKey.PAGE_UP,
    Down: server_editor_namespaceObject.KeyboardKey.PAGE_DOWN,
    Forward: server_editor_namespaceObject.KeyboardKey.UP,
    Back: server_editor_namespaceObject.KeyboardKey.DOWN,
    Left: server_editor_namespaceObject.KeyboardKey.LEFT,
    Right: server_editor_namespaceObject.KeyboardKey.RIGHT,
    Select: server_editor_namespaceObject.KeyboardKey.ENTER,
    Clear: server_editor_namespaceObject.KeyboardKey.KEY_D
};

const TicksRefreshRate = 5;

class SelectionBehavior {
    get toolId() {
        return this.tool.id;
    }
    constructor(uiSession) {
        this.uiSession = uiSession;
        this.fnUnregisterToolBindings = () => {
            this.tool.unregisterInputBindings();
        };
        this.singleClick = (uiSession, mouseRay, shiftPressed, ctrlPressed, altPressed) => {
            const clickLoc = mouseRay.cursorBlockLocation;
            if (!shiftPressed && !ctrlPressed && !altPressed) {
                uiSession.extensionContext.selectionManager.selection.clear();
                uiSession.extensionContext.selectionManager.selection.pushVolume({
                    action: server_namespaceObject.CompoundBlockVolumeAction.Add,
                    volume: {
                        from: clickLoc,
                        to: clickLoc
                    }
                });
                this.lastAnchorPosition = clickLoc;
            } else if (shiftPressed && !ctrlPressed && !altPressed) {
                if (uiSession.extensionContext.selectionManager.selection.isEmpty) {
                    uiSession.extensionContext.selectionManager.selection.pushVolume({
                        action: server_namespaceObject.CompoundBlockVolumeAction.Add,
                        volume: {
                            from: clickLoc,
                            to: clickLoc
                        }
                    });
                    this.lastAnchorPosition = clickLoc;
                } else {
                    const lastAnchorPosition = this.lastAnchorPosition;
                    const lastVolume = uiSession.extensionContext.selectionManager.selection.peekLastVolume();
                    uiSession.extensionContext.selectionManager.selection.popVolume();
                    try {
                        uiSession.extensionContext.selectionManager.selection.pushVolume({
                            action: server_namespaceObject.CompoundBlockVolumeAction.Add,
                            volume: {
                                from: lastAnchorPosition,
                                to: clickLoc
                            }
                        });
                    } catch {
                        if (lastVolume) {
                            uiSession.extensionContext.selectionManager.selection.pushVolume(lastVolume);
                        }
                    }
                }
            } else if (ctrlPressed && !shiftPressed && !altPressed) {
                let success = true;
                try {
                    uiSession.extensionContext.selectionManager.selection.pushVolume({
                        action: server_namespaceObject.CompoundBlockVolumeAction.Add,
                        volume: {
                            from: clickLoc,
                            to: clickLoc
                        }
                    });
                } catch {
                    success = false;
                }
                if (success) {
                    this.lastAnchorPosition = clickLoc;
                }
            } else if (altPressed && !shiftPressed && !ctrlPressed) {
                const currentItem = uiSession.extensionContext.selectionManager.selection.peekLastVolume();
                if (!currentItem) {
                    uiSession.extensionContext.selectionManager.selection.pushVolume({
                        action: server_namespaceObject.CompoundBlockVolumeAction.Add,
                        volume: {
                            from: clickLoc,
                            to: clickLoc
                        }
                    });
                    this.lastAnchorPosition = clickLoc;
                } else {
                    const currentVolume = currentItem.volume;
                    const currentBounds = server_namespaceObject.BlockVolumeUtils.getBoundingBox(currentVolume);
                    const translatedRayLocation = vector_utils_Vector3Utils.subtract(mouseRay.location, currentBounds.min);
                    const XYPlaneNormal = getRelativeXYAxisAsNormal(uiSession.extensionContext.player.getRotation().y);
                    const intersection = intersectRayPlane(translatedRayLocation, mouseRay.direction, XYPlaneNormal, 0);
                    if (intersection) {
                        const translatedIntersection = vector_utils_Vector3Utils.add(intersection, currentBounds.min);
                        const newY = Math.ceil(translatedIntersection.y) - 1;
                        uiSession.extensionContext.selectionManager.selection.popVolume();
                        uiSession.extensionContext.selectionManager.selection.pushVolume({
                            action: currentItem.action,
                            volume: {
                                from: {
                                    x: currentBounds.min.x,
                                    y: currentBounds.min.y,
                                    z: currentBounds.min.z
                                },
                                to: {
                                    x: currentBounds.max.x,
                                    y: newY,
                                    z: currentBounds.max.z
                                }
                            }
                        });
                    }
                }
            }
        };
        this.moveTopSelection = (uiSession, lastAnchor, direction) => {
            const lastVolumeItem = uiSession.extensionContext.selectionManager.selection.peekLastVolume();
            if (!lastVolumeItem) {
                return undefined;
            }
            const lastVolume = lastVolumeItem.volume;
            uiSession.extensionContext.selectionManager.selection.popVolume();
            const rotationY = uiSession.extensionContext.player.getRotation().y;
            const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction);
            const newVolume = server_namespaceObject.BlockVolumeUtils.translate(lastVolume, {
                x: correctedVector.x,
                y: correctedVector.y,
                z: correctedVector.z
            });
            uiSession.extensionContext.selectionManager.selection.pushVolume({
                action: lastVolumeItem.action,
                volume: newVolume
            });
            const updatedClick = {
                x: lastAnchor.x + correctedVector.x,
                y: lastAnchor.y + correctedVector.y,
                z: lastAnchor.z + correctedVector.z
            };
            return updatedClick;
        };
        this.moveBlockCursorManually = (uiSession, direction) => {
            const rotationY = uiSession.extensionContext.player.getRotation().y;
            const rotationCorrectedVector = getRotationCorrectedDirectionVector(rotationY, direction);
            uiSession.extensionContext.cursor.moveBy(rotationCorrectedVector);
        };
        this.moveAllSelections = (uiSession, anchorPosition, direction) => {
            if (uiSession.extensionContext.selectionManager.selection.isEmpty) {
                return undefined;
            }
            const rotationY = uiSession.extensionContext.player.getRotation().y;
            const correctedVector = getRotationCorrectedDirectionVector(rotationY, direction);
            uiSession.extensionContext.selectionManager.selection.moveBy({
                x: correctedVector.x,
                y: correctedVector.y,
                z: correctedVector.z
            });
            const updatedClick = {
                x: anchorPosition.x + correctedVector.x,
                y: anchorPosition.y + correctedVector.y,
                z: anchorPosition.z + correctedVector.z
            };
            return updatedClick;
        };
        this.shrinkVolume = (uiSession, direction) => {
            const lastVolumeItem = uiSession.extensionContext.selectionManager.selection.peekLastVolume();
            if (!lastVolumeItem) {
                return;
            }
            const lastVolume = lastVolumeItem.volume;
            uiSession.extensionContext.selectionManager.selection.popVolume();
            const rotationY = uiSession.extensionContext.player.getRotation().y;
            const newVolume = shrinkVolumeAlongViewAxis(lastVolume, rotationY, direction, 1);
            uiSession.extensionContext.selectionManager.selection.pushVolume({
                action: lastVolumeItem.action,
                volume: newVolume
            });
        };
        this.growVolume = (uiSession, direction) => {
            const lastVolumeItem = uiSession.extensionContext.selectionManager.selection.peekLastVolume();
            if (!lastVolumeItem) {
                return;
            }
            const lastVolume = lastVolumeItem.volume;
            uiSession.extensionContext.selectionManager.selection.popVolume();
            const rotationY = uiSession.extensionContext.player.getRotation().y;
            const newVolume = growVolumeAlongViewAxis(lastVolume, rotationY, direction, 1);
            uiSession.extensionContext.selectionManager.selection.pushVolume({
                action: lastVolumeItem.action,
                volume: newVolume
            });
        };
        this.bindToolInput = uiSession => {
            const singleClickAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                onExecute: (mouseRay, mouseProps) => {
                    if (mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton) {
                        if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown) {
                            if (mouseRay.rayHit || this.toolCursorProperties.controlMode === server_editor_namespaceObject.CursorControlMode.Fixed) {
                                this.singleClick(uiSession, mouseRay, mouseProps.modifiers.shift, mouseProps.modifiers.ctrl, mouseProps.modifiers.alt);
                            } else {
                                uiSession.extensionContext.selectionManager.selection.clear();
                            }
                        } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonUp) {}
                    }
                }
            });
            this.tool.registerMouseButtonBinding(singleClickAction);
            const keyUpAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    uiSession.extensionContext.cursor.moveBy(vector_utils_Vector3Utils.up);
                }
            });
            const keyDownAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    uiSession.extensionContext.cursor.moveBy(vector_utils_Vector3Utils.down);
                }
            });
            const keyLeftAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.moveBlockCursorManually(uiSession, Direction.Left);
                }
            });
            const keyRightAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.moveBlockCursorManually(uiSession, Direction.Right);
                }
            });
            const keyForwardAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.moveBlockCursorManually(uiSession, Direction.Forward);
                }
            });
            const keyBackAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.moveBlockCursorManually(uiSession, Direction.Back);
                }
            });
            this.tool.registerKeyBinding(keyForwardAction, Controls.Forward, server_editor_namespaceObject.InputModifier.None);
            this.tool.registerKeyBinding(keyBackAction, Controls.Back, server_editor_namespaceObject.InputModifier.None);
            this.tool.registerKeyBinding(keyLeftAction, Controls.Left, server_editor_namespaceObject.InputModifier.None);
            this.tool.registerKeyBinding(keyRightAction, Controls.Right, server_editor_namespaceObject.InputModifier.None);
            this.tool.registerKeyBinding(keyUpAction, Controls.Up, server_editor_namespaceObject.InputModifier.None);
            this.tool.registerKeyBinding(keyDownAction, Controls.Down, server_editor_namespaceObject.InputModifier.None);
            const mouseWheelAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
                onExecute: (mouseRay, mouseProps) => {
                    if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelOut) {
                        if (mouseProps.modifiers.shift) {
                            this.growVolume(uiSession, Direction.Left);
                            this.growVolume(uiSession, Direction.Right);
                        } else if (mouseProps.modifiers.ctrl) {
                            this.growVolume(uiSession, Direction.Forward);
                            this.growVolume(uiSession, Direction.Back);
                        } else if (mouseProps.modifiers.alt) {
                            this.growVolume(uiSession, Direction.Up);
                            this.growVolume(uiSession, Direction.Down);
                        } else if (this.toolCursorProperties.controlMode === server_editor_namespaceObject.CursorControlMode.Fixed) {
                            uiSession.extensionContext.cursor.moveBy(vector_utils_Vector3Utils.forward);
                        }
                    } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelIn) {
                        if (mouseProps.modifiers.shift) {
                            this.shrinkVolume(uiSession, Direction.Left);
                            this.shrinkVolume(uiSession, Direction.Right);
                        } else if (mouseProps.modifiers.ctrl) {
                            this.shrinkVolume(uiSession, Direction.Forward);
                            this.shrinkVolume(uiSession, Direction.Back);
                        } else if (mouseProps.modifiers.alt) {
                            this.shrinkVolume(uiSession, Direction.Up);
                            this.shrinkVolume(uiSession, Direction.Down);
                        } else if (this.toolCursorProperties.controlMode === server_editor_namespaceObject.CursorControlMode.Fixed) {
                            uiSession.extensionContext.cursor.moveBy(vector_utils_Vector3Utils.back);
                        }
                    }
                }
            });
            this.tool.registerMouseWheelBinding(mouseWheelAction);
            const moveSelectionUpAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveTopSelection(uiSession, this.lastAnchorPosition, Direction.Up);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveSelectionDownAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveTopSelection(uiSession, this.lastAnchorPosition, Direction.Down);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveSelectionLeftAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveTopSelection(uiSession, this.lastAnchorPosition, Direction.Left);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveSelectionRightAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveTopSelection(uiSession, this.lastAnchorPosition, Direction.Right);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveSelectionForwardAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveTopSelection(uiSession, this.lastAnchorPosition, Direction.Forward);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveSelectionBackAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveTopSelection(uiSession, this.lastAnchorPosition, Direction.Back);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            this.tool.registerKeyBinding(moveSelectionForwardAction, Controls.Forward, server_editor_namespaceObject.InputModifier.Alt);
            this.tool.registerKeyBinding(moveSelectionBackAction, Controls.Back, server_editor_namespaceObject.InputModifier.Alt);
            this.tool.registerKeyBinding(moveSelectionLeftAction, Controls.Left, server_editor_namespaceObject.InputModifier.Alt);
            this.tool.registerKeyBinding(moveSelectionRightAction, Controls.Right, server_editor_namespaceObject.InputModifier.Alt);
            this.tool.registerKeyBinding(moveSelectionUpAction, Controls.Up, server_editor_namespaceObject.InputModifier.Alt);
            this.tool.registerKeyBinding(moveSelectionDownAction, Controls.Down, server_editor_namespaceObject.InputModifier.Alt);
            const moveAllSelectionUpAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveAllSelections(uiSession, this.lastAnchorPosition, Direction.Up);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveAllSelectionDownAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveAllSelections(uiSession, this.lastAnchorPosition, Direction.Down);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveAllSelectionLeftAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveAllSelections(uiSession, this.lastAnchorPosition, Direction.Left);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveAllSelectionRightAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveAllSelections(uiSession, this.lastAnchorPosition, Direction.Right);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveAllSelectionForwardAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveAllSelections(uiSession, this.lastAnchorPosition, Direction.Forward);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            const moveAllSelectionBackAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const updatedAnchor = this.moveAllSelections(uiSession, this.lastAnchorPosition, Direction.Back);
                    if (updatedAnchor) {
                        this.lastAnchorPosition = updatedAnchor;
                    }
                }
            });
            this.tool.registerKeyBinding(moveAllSelectionForwardAction, Controls.Forward, server_editor_namespaceObject.InputModifier.Alt | server_editor_namespaceObject.InputModifier.Control);
            this.tool.registerKeyBinding(moveAllSelectionBackAction, Controls.Back, server_editor_namespaceObject.InputModifier.Alt | server_editor_namespaceObject.InputModifier.Control);
            this.tool.registerKeyBinding(moveAllSelectionLeftAction, Controls.Left, server_editor_namespaceObject.InputModifier.Alt | server_editor_namespaceObject.InputModifier.Control);
            this.tool.registerKeyBinding(moveAllSelectionRightAction, Controls.Right, server_editor_namespaceObject.InputModifier.Alt | server_editor_namespaceObject.InputModifier.Control);
            this.tool.registerKeyBinding(moveAllSelectionUpAction, Controls.Up, server_editor_namespaceObject.InputModifier.Alt | server_editor_namespaceObject.InputModifier.Control);
            this.tool.registerKeyBinding(moveAllSelectionDownAction, Controls.Down, server_editor_namespaceObject.InputModifier.Alt | server_editor_namespaceObject.InputModifier.Control);
            const keySelectAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const blockLocation = uiSession.extensionContext.cursor.getPosition();
                    const ray = {
                        location: vector_utils_Vector3Utils.zero,
                        direction: vector_utils_Vector3Utils.zero,
                        cursorBlockLocation: blockLocation,
                        rayHit: false
                    };
                    this.singleClick(uiSession, ray, false, false, false);
                }
            });
            this.tool.registerKeyBinding(keySelectAction, Controls.Select, server_editor_namespaceObject.InputModifier.None);
            const keySelectMultipleAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const blockLocation = uiSession.extensionContext.cursor.getPosition();
                    const ray = {
                        location: vector_utils_Vector3Utils.zero,
                        direction: vector_utils_Vector3Utils.zero,
                        cursorBlockLocation: blockLocation,
                        rayHit: false
                    };
                    this.singleClick(uiSession, ray, false, true, false);
                }
            });
            this.tool.registerKeyBinding(keySelectMultipleAction, Controls.Select, server_editor_namespaceObject.InputModifier.Control);
            const keySelectAndExtendAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    const blockLocation = uiSession.extensionContext.cursor.getPosition();
                    const ray = {
                        location: vector_utils_Vector3Utils.zero,
                        direction: vector_utils_Vector3Utils.zero,
                        cursorBlockLocation: blockLocation,
                        rayHit: false
                    };
                    this.singleClick(uiSession, ray, true, false, false);
                }
            });
            this.tool.registerKeyBinding(keySelectAndExtendAction, Controls.Select, server_editor_namespaceObject.InputModifier.Shift);
            const keyGrowUpAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.growVolume(uiSession, Direction.Up);
                }
            });
            this.tool.registerKeyBinding(keyGrowUpAction, Controls.Up, server_editor_namespaceObject.InputModifier.Shift);
            const keyGrowDownAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.growVolume(uiSession, Direction.Down);
                }
            });
            this.tool.registerKeyBinding(keyGrowDownAction, Controls.Down, server_editor_namespaceObject.InputModifier.Shift);
            const keyGrowForwardAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.growVolume(uiSession, Direction.Forward);
                }
            });
            this.tool.registerKeyBinding(keyGrowForwardAction, Controls.Forward, server_editor_namespaceObject.InputModifier.Shift);
            const keyGrowBackAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.growVolume(uiSession, Direction.Back);
                }
            });
            this.tool.registerKeyBinding(keyGrowBackAction, Controls.Back, server_editor_namespaceObject.InputModifier.Shift);
            const keyGrowLeftAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.growVolume(uiSession, Direction.Left);
                }
            });
            this.tool.registerKeyBinding(keyGrowLeftAction, Controls.Left, server_editor_namespaceObject.InputModifier.Shift);
            const keyGrowRightAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.growVolume(uiSession, Direction.Right);
                }
            });
            this.tool.registerKeyBinding(keyGrowRightAction, Controls.Right, server_editor_namespaceObject.InputModifier.Shift);
            const keyShrinkUpAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.shrinkVolume(uiSession, Direction.Up);
                }
            });
            this.tool.registerKeyBinding(keyShrinkUpAction, Controls.Up, server_editor_namespaceObject.InputModifier.Control);
            const keyShrinkDownAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.shrinkVolume(uiSession, Direction.Down);
                }
            });
            this.tool.registerKeyBinding(keyShrinkDownAction, Controls.Down, server_editor_namespaceObject.InputModifier.Control);
            const keyShrinkForwardAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.shrinkVolume(uiSession, Direction.Forward);
                }
            });
            this.tool.registerKeyBinding(keyShrinkForwardAction, Controls.Forward, server_editor_namespaceObject.InputModifier.Control);
            const keyShrinkBackAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.shrinkVolume(uiSession, Direction.Back);
                }
            });
            this.tool.registerKeyBinding(keyShrinkBackAction, Controls.Back, server_editor_namespaceObject.InputModifier.Control);
            const keyShrinkLeftAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.shrinkVolume(uiSession, Direction.Left);
                }
            });
            this.tool.registerKeyBinding(keyShrinkLeftAction, Controls.Left, server_editor_namespaceObject.InputModifier.Control);
            const keyShrinkRightAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    this.shrinkVolume(uiSession, Direction.Right);
                }
            });
            this.tool.registerKeyBinding(keyShrinkRightAction, Controls.Right, server_editor_namespaceObject.InputModifier.Control);
        };
        this.onTickRefresh = (uiSession, tool) => {
            let ticks = 0;
            this.tickRefreshHandle = server_namespaceObject.system.run((() => {
                if (uiSession.extensionContext.selectionManager === undefined) {
                    return;
                }
                if (!this.settingsObject) {
                    uiSession.log.error("Pane settings object not defined, unable to refresh values for selection.");
                    return;
                }
                if (ticks++ % TicksRefreshRate === 0) {
                    ticks = 0;
                    let x = 0, y = 0, z = 0;
                    let sx = 0, sy = 0, sz = 0;
                    const selection = uiSession.extensionContext.selectionManager.selection;
                    const lastVolumeItem = selection.peekLastVolume(server_namespaceObject.CompoundBlockVolumePositionRelativity.Absolute);
                    if (lastVolumeItem) {
                        const lastVolume = lastVolumeItem.volume;
                        const bounds = server_namespaceObject.BlockVolumeUtils.getBoundingBox(lastVolume);
                        const boundSize = server_namespaceObject.BoundingBoxUtils.getSpan(bounds);
                        x = bounds.min.x;
                        y = bounds.min.y;
                        z = bounds.min.z;
                        sx = boundSize.x;
                        sy = boundSize.y;
                        sz = boundSize.z;
                        if (!this.originPropertyItem?.enable) {
                            if (this.originPropertyItem) {
                                this.originPropertyItem.enable = true;
                            }
                        }
                        if (!this.sizePropertyItem?.enable) {
                            if (this.sizePropertyItem) {
                                this.sizePropertyItem.enable = true;
                            }
                        }
                    } else {
                        if (this.originPropertyItem?.enable) {
                            if (this.originPropertyItem) {
                                this.originPropertyItem.enable = false;
                            }
                        }
                        if (this.sizePropertyItem?.enable) {
                            if (this.sizePropertyItem) {
                                this.sizePropertyItem.enable = false;
                            }
                        }
                    }
                    if (this.settingsObject.origin.x !== x || this.settingsObject.origin.y !== y || this.settingsObject.origin.z !== z || this.settingsObject.size.x !== sx || this.settingsObject.size.y !== sy || this.settingsObject.size.z !== sz) {
                        this.settingsObject.origin.x = Math.trunc(x);
                        this.settingsObject.origin.y = Math.trunc(y);
                        this.settingsObject.origin.z = Math.trunc(z);
                        this.settingsObject.size.x = Math.trunc(sx);
                        this.settingsObject.size.y = Math.trunc(sy);
                        this.settingsObject.size.z = Math.trunc(sz);
                    }
                }
                if (uiSession.toolRail.selectedOptionId === tool.id) {
                    this.tickRefreshHandle = server_namespaceObject.system.run((() => this.onTickRefresh(uiSession, tool)));
                }
            }));
        };
        this.addSettingsPane = uiSession => {
            this.pane.addDropdown(this.settingsObject, "selectionMode", {
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.selectionMode"),
                titleAltText: "Mode",
                enable: true,
                dropdownItems: [ {
                    displayAltText: "Freeform",
                    displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.selectionMode.mouseAndKeyboard"),
                    value: SelectionCursorMode.Freeform
                }, {
                    displayAltText: "Fixed Distance",
                    displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.selectionMode.fixedDistance"),
                    value: SelectionCursorMode.FixedDistance
                }, {
                    displayAltText: "Adjacent Face",
                    displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.selectionMode.adjacent"),
                    value: SelectionCursorMode.AdjacentFace
                } ],
                onChange: (_obj, _property, _oldValue, _newValue) => {
                    const oldVal = _oldValue;
                    const newVal = _newValue;
                    let cursorControlMode = server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse;
                    let cursorTargetMode = server_editor_namespaceObject.CursorTargetMode.Block;
                    if (oldVal !== newVal) {
                        switch (newVal) {
                          case SelectionCursorMode.Freeform:
                            cursorControlMode = server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse;
                            cursorTargetMode = server_editor_namespaceObject.CursorTargetMode.Block;
                            break;

                          case SelectionCursorMode.FixedDistance:
                            cursorControlMode = server_editor_namespaceObject.CursorControlMode.Fixed;
                            cursorTargetMode = server_editor_namespaceObject.CursorTargetMode.Block;
                            break;

                          case SelectionCursorMode.AdjacentFace:
                            cursorControlMode = server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse;
                            cursorTargetMode = server_editor_namespaceObject.CursorTargetMode.Face;
                            break;

                          default:
                            uiSession.log.error(`Unknown value from selection mode drop-down`);
                            return;
                        }
                        this.toolCursorProperties = uiSession.extensionContext.cursor.getProperties();
                        this.toolCursorProperties.controlMode = cursorControlMode;
                        this.toolCursorProperties.targetMode = cursorTargetMode;
                        uiSession.extensionContext.cursor.setProperties(this.toolCursorProperties);
                    }
                }
            });
            const onOriginOrSizeChange = (_obj, _property, _oldValue, _newValue) => {
                if (_oldValue === _newValue) {
                    return;
                }
                const selection = uiSession.extensionContext.selectionManager.selection;
                const lastVolume = selection.peekLastVolume(server_namespaceObject.CompoundBlockVolumePositionRelativity.Absolute);
                if (lastVolume) {
                    const volumeOrigin = selection.getVolumeOrigin();
                    const min = {
                        x: this.settingsObject.origin.x - volumeOrigin.x,
                        y: this.settingsObject.origin.y - volumeOrigin.y,
                        z: this.settingsObject.origin.z - volumeOrigin.z
                    };
                    const max = {
                        x: min.x + this.settingsObject.size.x - 1,
                        y: min.y + this.settingsObject.size.y - 1,
                        z: min.z + this.settingsObject.size.z - 1
                    };
                    selection.popVolume();
                    try {
                        selection.pushVolume({
                            action: server_namespaceObject.CompoundBlockVolumeAction.Add,
                            volume: {
                                from: min,
                                to: max
                            }
                        });
                    } catch {
                        selection.pushVolume(lastVolume);
                    }
                }
            };
            const subPaneTransform = this.pane.createPropertyPane({
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.transformPane.title"),
                titleAltText: "Transform"
            });
            this.originPropertyItem = subPaneTransform.addVector3(this.settingsObject, "origin", {
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.transformPane.origin"),
                titleAltText: "Origin",
                enable: true,
                minX: Number.MIN_SAFE_INTEGER,
                minY: Number.MIN_SAFE_INTEGER,
                minZ: Number.MIN_SAFE_INTEGER,
                onChange: onOriginOrSizeChange
            });
            this.sizePropertyItem = subPaneTransform.addVector3(this.settingsObject, "size", {
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.transformPane.size"),
                titleAltText: "Size",
                enable: true,
                minX: 1,
                minY: 1,
                minZ: 1,
                maxX: 100,
                maxY: 100,
                maxZ: 100,
                onChange: onOriginOrSizeChange
            });
            const subPaneFill = this.pane.createPropertyPane({
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.fillPane.title"),
                titleAltText: "Fill Selection"
            });
            subPaneFill.addBlockPicker(this.settingsObject, "block", {
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.fillPane.blockType"),
                titleAltText: "Block Type"
            });
            subPaneFill.addButton(this.executeFillAction, {
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.fillPane.fillAction"),
                titleAltText: "Fill Selection"
            });
            this.pane.addDivider();
            const actionClearSelection = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    uiSession.extensionContext.selectionManager.selection.clear();
                }
            });
            this.pane.addButton(actionClearSelection, {
                titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.deselect"),
                titleAltText: "Deselect",
                variant: "secondary"
            });
            this.tool.bindPropertyPane(this.pane);
        };
        this.addTool = uiSession => {
            const tool = uiSession.toolRail.addTool({
                displayAltText: "Selection (CTRL + S)",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.toolRail.title"),
                icon: "pack://textures/editor/marquee.png?filtering=point",
                tooltipAltText: "Selection Tool",
                tooltipStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.toolRail.description")
            });
            tool.onModalToolActivation.subscribe((eventData => {
                if (eventData.isActiveTool) {
                    uiSession.extensionContext.cursor.setProperties(this.toolCursorProperties);
                    this.onTickRefresh(uiSession, tool);
                }
            }));
            return tool;
        };
        this.bindGlobalActivationShortcut = (uiSession, storage) => {
            const toggleAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    uiSession.toolRail.setSelectedOptionId(this.tool.id, true);
                }
            });
            const deselectAction = uiSession.actionManager.createAction({
                actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
                onExecute: () => {
                    uiSession.extensionContext.selectionManager.selection.clear();
                }
            });
            uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, toggleAction, server_editor_namespaceObject.KeyboardKey.KEY_S, server_editor_namespaceObject.InputModifier.Control);
            uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, this.executeFillAction, server_editor_namespaceObject.KeyboardKey.KEY_F, server_editor_namespaceObject.InputModifier.Control);
            uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, deselectAction, server_editor_namespaceObject.KeyboardKey.KEY_D, server_editor_namespaceObject.InputModifier.Control);
            storage.coreMenuItems?.edit.addItem({
                name: "menuBar.edit.quickFill",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.quickFill")
            }, this.executeFillAction);
            storage.coreMenuItems?.edit.addItem({
                name: "menuBar.edit.deselect",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.deselect")
            }, deselectAction);
        };
        this.performFillOperation = async (context, fillType) => {
            const player = context.player;
            const dimension = player.dimension;
            if (context.selectionManager.selection.isEmpty) {
                this.uiSession.log.warning("No selection available to fill");
                return;
            }
            context.transactionManager.openTransaction("Select-Fill");
            const bounds = context.selectionManager.selection.getBoundingBox();
            try {
                context.transactionManager.trackBlockChangeArea(bounds.min, bounds.max);
            } catch (e) {
                this.uiSession.log.warning(`Unable to fill selection. ${stringFromException(e)}`);
                context.transactionManager.discardOpenTransaction();
                return;
            }
            await (0, server_editor_namespaceObject.executeLargeOperation)(context.selectionManager.selection, (blockLocation => {
                const block = dimension.getBlock(blockLocation);
                if (block) {
                    block.isWaterlogged = false;
                    block.setType(fillType);
                }
            })).catch((e => {
                this.uiSession.log.error(e.message);
                context.transactionManager.discardOpenTransaction();
            })).then((() => {
                context.transactionManager.commitOpenTransaction();
            }));
        };
        const storage = uiSession.scratchStorage;
        if (!storage) {
            throw new Error("Can not instantiate Selection functionality without valid CoreEditor storage.");
        }
        this.tool = this.addTool(uiSession);
        this.pane = uiSession.createPropertyPane({
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("selectionTool.settingsPane.title"),
            titleAltText: "Selection"
        });
        this.settingsObject = (0, server_editor_namespaceObject.bindDataSource)(this.pane, {
            selectionMode: SelectionCursorMode.Freeform,
            origin: {
                x: 0,
                y: 0,
                z: 0
            },
            size: {
                x: 0,
                y: 0,
                z: 0
            },
            block: MinecraftBlockTypes.Stone
        });
        this.toolCursorProperties = {
            outlineColor: {
                red: 1,
                green: 1,
                blue: 0,
                alpha: 1
            },
            controlMode: server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse,
            targetMode: server_editor_namespaceObject.CursorTargetMode.Block,
            visible: true
        };
        this.lastAnchorPosition = {
            x: 0,
            y: 0,
            z: 0
        };
        this.executeFillAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                this.performFillOperation(uiSession.extensionContext, this.settingsObject.block).catch((e => uiSession.log.error(e.message)));
            }
        });
        this.addSettingsPane(uiSession);
        this.bindToolInput(uiSession);
        this.bindGlobalActivationShortcut(uiSession, storage);
        uiSession.toolRail.setSelectedOptionId(this.tool.id, true);
    }
    teardown() {
        this.uiSession.log.debug("Shutting down minecraft::selection behavior\n");
        if (this.tickRefreshHandle !== undefined) {
            server_namespaceObject.system.clearRun(this.tickRefreshHandle);
            this.tickRefreshHandle = undefined;
        }
        this.fnUnregisterToolBindings();
        this.uiSession.extensionContext.selectionManager.selection.clear();
    }
}

class UndoRedoBehavior {
    constructor(uiSession, coreMenuItems) {
        const undoAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                uiSession.extensionContext.transactionManager.undo();
            }
        });
        const redoAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                uiSession.extensionContext.transactionManager.redo();
            }
        });
        coreMenuItems.edit.addItem({
            name: "menuBar.edit.undo",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.undo")
        }, undoAction);
        coreMenuItems.edit.addItem({
            name: "menuBar.edit.redo",
            displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit.redo")
        }, redoAction);
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, undoAction, server_editor_namespaceObject.KeyboardKey.KEY_Z, server_editor_namespaceObject.InputModifier.Control);
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalEditor, redoAction, server_editor_namespaceObject.KeyboardKey.KEY_Y, server_editor_namespaceObject.InputModifier.Control);
    }
    teardown() {}
}

class PlayerCountBehavior {
    constructor(uiSession) {
        const statusBarItem = uiSession.createStatusBarItem(server_editor_namespaceObject.EditorStatusBarAlignment.Right, 30);
        uiSession.eventSubscriptionCache.subscribeToBedrockEvent("playerJoin", (() => this.updateStatusBarText(statusBarItem, server_namespaceObject.world.getAllPlayers().length + 1)));
        uiSession.eventSubscriptionCache.subscribeToBedrockEvent("playerLeave", (() => this.updateStatusBarText(statusBarItem, server_namespaceObject.world.getAllPlayers().length)));
        this.updateStatusBarText(statusBarItem, server_namespaceObject.world.getAllPlayers().length);
    }
    updateStatusBarText(statusBarItem, playerCount) {
        statusBarItem.text = `Connected Players: ${playerCount}`;
    }
    teardown() {}
}

function createCoreUI(uiSession) {
    if (!uiSession.scratchStorage) {
        throw new Error("Core UI initialization order incorrect");
    }
    const player = uiSession.extensionContext.player;
    const exportAsWorldAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            player.runCommandAsync("project export world").catch((_ => uiSession.log.error("Unable to export project as world due to unknown error.")));
        }
    });
    const showUISettingsAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.builtInUIManager.updateUISettingsPanelVisibility(true);
        }
    });
    const pauseScreenAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.builtInUIManager.navigateToPauseScreen();
        }
    });
    const showLoggingPaneAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.builtInUIManager.updateLogPanelVisibility(true);
        }
    });
    const pauseMobsAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            server_namespaceObject.world.getDimension("overworld").runCommandAsync("simulationtype editor").catch((_ => uiSession.log.error("Unable to pause mobs due to unknown error.")));
        }
    });
    const unpauseMobsAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            server_namespaceObject.world.getDimension("overworld").runCommandAsync("simulationtype game").catch((_ => uiSession.log.error("Unable to unpause mobs due to unknown error.")));
        }
    });
    const overworldAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            const rotation = player.getRotation();
            player.teleport(player.location, {
                dimension: server_namespaceObject.world.getDimension("overworld"),
                rotation,
                keepVelocity: false
            });
        }
    });
    const netherAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            const rotation = player.getRotation();
            player.teleport(player.location, {
                dimension: server_namespaceObject.world.getDimension("nether"),
                rotation,
                keepVelocity: false
            });
        }
    });
    const endAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.extensionContext.transactionManager.openTransaction("Transaction dimension change");
            const rotation = player.getRotation();
            player.teleport(player.location, {
                dimension: server_namespaceObject.world.getDimension("the_end"),
                rotation,
                keepVelocity: false
            });
            uiSession.extensionContext.transactionManager.commitOpenTransaction();
        }
    });
    const turnOnDaylightCycleAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            server_namespaceObject.world.getDimension("overworld").runCommandAsync("alwaysday false").then((() => uiSession.log.info("Daylight cycle on"))).catch((_ => uiSession.log.error("Unable to turn on daylight cycle due to unknown error.")));
        }
    });
    const turnOffDaylightCycleAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            server_namespaceObject.world.getDimension("overworld").runCommandAsync("alwaysday true").then((() => uiSession.log.info("Daylight cycle off"))).catch((_ => uiSession.log.error("Unable to turn off daylight cycle due to unknown error.")));
        }
    });
    const quickStartAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.builtInUIManager.updateWelcomePanelVisibility(true);
        }
    });
    const documentationAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.builtInUIManager.navigateToDocumentation();
        }
    });
    const feedbackAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            uiSession.builtInUIManager.navigateToFeedback();
        }
    });
    uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, pauseScreenAction, server_editor_namespaceObject.KeyboardKey.KEY_Q, server_editor_namespaceObject.InputModifier.Control);
    uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, showLoggingPaneAction, server_editor_namespaceObject.KeyboardKey.KEY_H, server_editor_namespaceObject.InputModifier.Control);
    const help = uiSession.createMenu({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help")
    });
    const worldOptions = uiSession.createMenu({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions")
    });
    const view = uiSession.createMenu({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.view"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.view")
    });
    const edit = uiSession.createMenu({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.edit")
    });
    const file = uiSession.createMenu({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file")
    });
    const exportMenu = file.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.export"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.export")
    });
    exportMenu.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.export.world"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.export.world")
    }, exportAsWorldAction);
    file.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.settings"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.settings")
    }, showUISettingsAction);
    file.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.pauseScreen"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.file.pauseScreen")
    }, pauseScreenAction);
    view.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.view.logging"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.view.logging")
    }, showLoggingPaneAction);
    const actors = worldOptions.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.actors"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.actors")
    });
    actors.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.pause.pauseActors"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.pause.pauseActors")
    }, pauseMobsAction);
    actors.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.pause.unpauseActors"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.pause.unpauseActors")
    }, unpauseMobsAction);
    const changeDimension = worldOptions.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension")
    });
    changeDimension.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension.overworld"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension.overworld")
    }, overworldAction);
    changeDimension.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension.nether"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension.nether")
    }, netherAction);
    changeDimension.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension.end"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.changeDimension.end")
    }, endAction);
    const daylightCycle = worldOptions.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.daylightCycle"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.daylightCycle")
    });
    daylightCycle.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.daylightCycle.turnOnDaylightCycle"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.daylightCycle.turnOnDaylightCycle")
    }, turnOnDaylightCycleAction);
    daylightCycle.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.daylightCycle.turnOffDaylightCycle"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.worldOptions.daylightCycle.turnOffDaylightCycle")
    }, turnOffDaylightCycleAction);
    help.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help.quickStart"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help.quickStart")
    }, quickStartAction);
    help.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help.documentation"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help.documentation")
    }, documentationAction);
    help.addItem({
        name: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help.feedback"),
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("menuBar.help.feedback")
    }, feedbackAction);
    file.show();
    edit.show();
    worldOptions.show();
    help.show();
    return {
        file,
        edit,
        view,
        worldOptions,
        help
    };
}

function registerCoreEditorExtension() {
    (0, server_editor_namespaceObject.registerEditorExtension)("CoreEditor", (uiSession => {
        uiSession.log.debug(`Initializing ${uiSession.extensionContext.extensionName} extension`);
        uiSession.scratchStorage = {};
        uiSession.toolRail.show();
        uiSession.scratchStorage.coreMenuItems = createCoreUI(uiSession);
        const transactions = new UndoRedoBehavior(uiSession, uiSession.scratchStorage.coreMenuItems);
        const selectBehavior = new SelectionBehavior(uiSession);
        uiSession.scratchStorage.clipboard = new ClipboardBehavior(uiSession, uiSession.scratchStorage.coreMenuItems, selectBehavior.toolId);
        uiSession.scratchStorage.deleteBehavior = new DeleteBehavior(uiSession, uiSession.scratchStorage.coreMenuItems);
        uiSession.scratchStorage.playerCountBehavior = new PlayerCountBehavior(uiSession);
        uiSession.log.debug("CoreEditor Extension Initialized\n");
        return [ selectBehavior, uiSession.scratchStorage.clipboard, uiSession.scratchStorage.deleteBehavior, uiSession.scratchStorage.playerCountBehavior, transactions ];
    }), (uiSession => {
        uiSession.log.debug(`Shutting down ${uiSession.extensionContext.extensionName} Extension\n`);
    }), {
        description: "Minecraft Core Editor Built-in Extensions",
        notes: "https://github.com/Mojang/minecraft-editor"
    });
}

function addCubeBrushSettingsPane(uiSession, tool) {
    const pane = uiSession.createPropertyPane({
        titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushSettings.pane"),
        titleAltText: "Brush"
    });
    const settings = (0, server_editor_namespaceObject.bindDataSource)(pane, {
        size: 3,
        hollow: false,
        face: false,
        block: MinecraftBlockTypes.Stone
    });
    const onExecuteBrush = () => {
        if (uiSession.scratchStorage === undefined) {
            uiSession.log.error("Brush storage was not initialized.");
            return;
        }
        const previewSelection = uiSession.scratchStorage.previewSelection;
        const player = uiSession.extensionContext.player;
        const targetBlock = player.dimension.getBlock(uiSession.extensionContext.cursor.getPosition());
        if (targetBlock === undefined) {
            return;
        }
        const rotationY = uiSession.extensionContext.player.getRotation().y;
        const directionRight = getRotationCorrectedDirectionVector(rotationY, Direction.Right);
        const directionForward = getRotationCorrectedDirectionVector(rotationY, Direction.Back);
        const relativeDirection = server_namespaceObject.Vector.add(server_namespaceObject.Vector.add(directionRight, directionForward), server_namespaceObject.Vector.up);
        const sizeHalf = Math.floor(settings.size / 2);
        let fromOffset = server_namespaceObject.Vector.multiply(relativeDirection, -sizeHalf);
        const toOffset = server_namespaceObject.Vector.multiply(relativeDirection, settings.size - 1);
        const isEven = settings.size % 2 === 0;
        if (isEven) {
            fromOffset = server_namespaceObject.Vector.add(fromOffset, server_namespaceObject.Vector.up);
        }
        const location = targetBlock.location;
        const from = {
            x: location.x + fromOffset.x,
            y: location.y + fromOffset.y,
            z: location.z + fromOffset.z
        };
        const to = {
            x: from.x + toOffset.x,
            y: from.y + toOffset.y,
            z: from.z + toOffset.z
        };
        const blockVolume = {
            from,
            to
        };
        const bounds = server_namespaceObject.BlockVolumeUtils.getBoundingBox(blockVolume);
        if (uiSession.scratchStorage.lastVolumePlaced) {
            if (server_namespaceObject.BoundingBoxUtils.equals(uiSession.scratchStorage.lastVolumePlaced, bounds)) {
                return;
            }
        }
        previewSelection.pushVolume({
            action: server_namespaceObject.CompoundBlockVolumeAction.Add,
            volume: blockVolume
        });
        uiSession.scratchStorage.lastVolumePlaced = bounds;
        const boundSize = server_namespaceObject.BoundingBoxUtils.getSpan(bounds);
        if (settings.hollow && boundSize.x > 2 && boundSize.y > 2 && boundSize.z > 2) {
            const subtractBlockVolume = {
                from: {
                    x: from.x + relativeDirection.x,
                    y: from.y + 1,
                    z: from.z + relativeDirection.z
                },
                to: {
                    x: to.x - relativeDirection.x,
                    y: to.y - 1,
                    z: to.z - relativeDirection.z
                }
            };
            previewSelection.pushVolume({
                action: server_namespaceObject.CompoundBlockVolumeAction.Subtract,
                volume: subtractBlockVolume
            });
        }
    };
    pane.addNumber(settings, "size", {
        titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushSettings.size"),
        titleAltText: "Brush Size",
        min: 1,
        max: 16,
        showSlider: true
    });
    pane.addBool(settings, "hollow", {
        titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushSettings.hollow"),
        titleAltText: "Hollow"
    });
    pane.addBool(settings, "face", {
        titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushSettings.face"),
        titleAltText: "Face Mode",
        onChange: (_obj, _property, _oldValue, _newValue) => {
            if (uiSession.scratchStorage === undefined) {
                uiSession.log.error("Brush storage was not initialized.");
                return;
            }
            uiSession.scratchStorage.toolCursorProperties.targetMode = settings.face ? server_editor_namespaceObject.CursorTargetMode.Face : server_editor_namespaceObject.CursorTargetMode.Block;
            uiSession.extensionContext.cursor.setProperties(uiSession.scratchStorage.toolCursorProperties);
        }
    });
    pane.addBlockPicker(settings, "block", {
        titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushSettings.block"),
        titleAltText: "Block Type"
    });
    tool.bindPropertyPane(pane);
    const toggleHollowShortcut = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
        onExecute: () => {
            settings.hollow = !settings.hollow;
        }
    });
    tool.registerKeyBinding(toggleHollowShortcut, server_editor_namespaceObject.KeyboardKey.KEY_H, server_editor_namespaceObject.InputModifier.Control);
    const executeExampleMouseButtonAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
        onExecute: async (mouseRay, mouseProps) => {
            if (uiSession.scratchStorage === undefined) {
                uiSession.log.error("Brush storage was not initialized.");
                return;
            }
            if (mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.LeftButton) {
                if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonDown) {
                    uiSession.extensionContext.transactionManager.openTransaction("Transaction group cube brush");
                    uiSession.scratchStorage.previewSelection.clear();
                    onExecuteBrush();
                } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.ButtonUp) {
                    try {
                        uiSession.extensionContext.transactionManager.trackBlockChangeSelection(uiSession.scratchStorage.previewSelection);
                    } catch (e) {
                        uiSession.log.warning(`Unable to execute brush. ${stringFromException(e)}`);
                        uiSession.extensionContext.transactionManager.discardOpenTransaction();
                        return;
                    }
                    const player = uiSession.extensionContext.player;
                    const dimension = player.dimension;
                    await (0, server_editor_namespaceObject.executeLargeOperation)(uiSession.scratchStorage.previewSelection, (blockLocation => {
                        const block = dimension.getBlock(blockLocation);
                        if (block) {
                            block.isWaterlogged = false;
                            block.setType(settings.block);
                        }
                    })).catch((e => {
                        uiSession.log.error(e.message);
                        uiSession.extensionContext.transactionManager.discardOpenTransaction();
                        uiSession.scratchStorage?.previewSelection.clear();
                    })).then((() => {
                        uiSession.extensionContext.transactionManager.commitOpenTransaction();
                        uiSession.scratchStorage?.previewSelection.clear();
                    }));
                }
            }
        }
    });
    tool.registerMouseButtonBinding(executeExampleMouseButtonAction);
    const executeBrushRayAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
        onExecute: (mouseRay, mouseProps) => {
            if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.DragStart) {} else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.Drag) {
                onExecuteBrush();
            } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.DragEnd) {}
        }
    });
    tool.registerMouseDragBinding(executeBrushRayAction);
    const executeBrushSizeAction = uiSession.actionManager.createAction({
        actionType: server_editor_namespaceObject.ActionTypes.MouseRayCastAction,
        onExecute: (mouseRay, mouseProps) => {
            if (mouseProps.mouseAction === server_editor_namespaceObject.MouseActionType.Wheel) {
                if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelOut) {
                    if (settings.size < 16) {
                        settings.size++;
                    }
                } else if (mouseProps.inputType === server_editor_namespaceObject.MouseInputType.WheelIn) {
                    if (settings.size > 1) {
                        settings.size--;
                    }
                }
            }
        }
    });
    tool.registerMouseWheelBinding(executeBrushSizeAction);
    return settings;
}

function addCubeBrushTool(uiSession, storage) {
    const tool = uiSession.toolRail.addTool({
        displayAltText: "Brush (CTRL + B)",
        displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushTool.title"),
        icon: "pack://textures/editor/Cube.png?filtering=point",
        tooltipAltText: "Left mouse click or drag-to-paint",
        tooltipStringId: (0, server_editor_namespaceObject.getLocalizationId)("toolRail.cubeBrushTool.description")
    });
    tool.onModalToolActivation.subscribe((eventData => {
        if (eventData.isActiveTool) {
            uiSession.extensionContext.cursor.setProperties(storage.toolCursorProperties);
        }
        uiSession.scratchStorage?.previewSelection?.clear();
    }));
    return tool;
}

function registerCubeBrushExtension() {
    (0, server_editor_namespaceObject.registerEditorExtension)("CubeBrush", (uiSession => {
        uiSession.log.debug(`Initializing ${uiSession.extensionContext.extensionName} extension`);
        const cursorProperties = {
            outlineColor: {
                red: 1,
                green: 1,
                blue: 0,
                alpha: 1
            },
            controlMode: server_editor_namespaceObject.CursorControlMode.KeyboardAndMouse,
            targetMode: server_editor_namespaceObject.CursorTargetMode.Block,
            visible: true,
            fixedModeDistance: 5
        };
        const previewSelection = uiSession.extensionContext.selectionManager.create();
        previewSelection.visible = true;
        previewSelection.setOutlineColor({
            red: 0,
            green: .5,
            blue: .5,
            alpha: .2
        });
        previewSelection.setFillColor({
            red: 0,
            green: 0,
            blue: .5,
            alpha: .1
        });
        const storage = {
            toolCursorProperties: cursorProperties,
            previewSelection
        };
        uiSession.scratchStorage = storage;
        const cubeBrushTool = addCubeBrushTool(uiSession, storage);
        addCubeBrushSettingsPane(uiSession, cubeBrushTool);
        const brushToggleAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                uiSession.toolRail.setSelectedOptionId(cubeBrushTool.id, true);
            }
        });
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, brushToggleAction, server_editor_namespaceObject.KeyboardKey.KEY_B, server_editor_namespaceObject.InputModifier.Control);
        return [];
    }), (uiSession => {
        uiSession.log.debug(`Shutting down ${uiSession.extensionContext.extensionName} extension`);
    }), {
        description: "Activate cube brush from tool rail."
    });
}

function registerGrappleExtension() {
    (0, server_editor_namespaceObject.registerEditorExtension)("Grapple", (uiSession => {
        uiSession.log.debug(`Initializing ${uiSession.extensionContext.extensionName} extension`);
        const op = {
            start: new server_namespaceObject.Vector(0, 0, 0),
            end: new server_namespaceObject.Vector(0, 0, 0),
            viewX: 0,
            viewY: 0,
            step: 1 / 20 / .3,
            progress: 0,
            subject: undefined,
            previous: new server_namespaceObject.Vector(0, 0, 0)
        };
        const onGrappleTick = () => {
            if (op.subject) {
                op.progress += op.step;
                const endLoc = {
                    x: op.end.x,
                    y: op.end.y,
                    z: op.end.z
                };
                if (op.progress >= 1) {
                    const rotation = op.subject.getRotation();
                    op.subject.teleport(endLoc, {
                        dimension: op.subject.dimension,
                        rotation,
                        keepVelocity: false
                    });
                    op.subject = undefined;
                } else {
                    const current = server_namespaceObject.Vector.lerp(op.start, op.end, op.progress);
                    const block = op.subject?.dimension.getBlock(current);
                    if (block?.isSolid) {
                        op.progress = 1;
                        op.end = op.previous;
                        const rotation = op.subject.getRotation();
                        op.subject.teleport(op.previous, {
                            dimension: op.subject.dimension,
                            rotation,
                            keepVelocity: false
                        });
                        op.subject = undefined;
                        return;
                    }
                    op.subject?.teleport({
                        x: current.x,
                        y: current.y,
                        z: current.z
                    }, {
                        dimension: op.subject.dimension,
                        facingLocation: endLoc,
                        keepVelocity: false
                    });
                    server_namespaceObject.system.run(onGrappleTick);
                }
            }
        };
        const grappleAction = uiSession.actionManager.createAction({
            actionType: server_editor_namespaceObject.ActionTypes.NoArgsAction,
            onExecute: () => {
                const me = uiSession.extensionContext.player;
                const headLocation = me.getHeadLocation();
                op.start = new server_namespaceObject.Vector(Math.floor(headLocation.x), Math.floor(headLocation.y), Math.floor(headLocation.z));
                op.progress = 0;
                op.subject = me;
                let viewVector;
                const cursor = uiSession.extensionContext.cursor;
                if (cursor.isVisible && cursor.getProperties().controlMode !== server_editor_namespaceObject.CursorControlMode.Fixed) {
                    const cursorPos = cursor.getPosition();
                    const cursorVec = new server_namespaceObject.Vector(cursorPos.x, cursorPos.y, cursorPos.z);
                    viewVector = server_namespaceObject.Vector.subtract(cursorVec, op.start).normalized();
                } else {
                    viewVector = me.getViewDirection();
                }
                const raycastOptions = {
                    includeLiquidBlocks: false,
                    includePassableBlocks: true,
                    maxDistance: 1e3
                };
                const insideBlock = me.dimension.getBlock(op.start);
                if (insideBlock?.isSolid) {
                    return;
                }
                const blockHit = me.dimension.getBlockFromRay(op.start, viewVector, raycastOptions);
                if (!blockHit) {
                    uiSession.log.warning(`Failed to hit anything with a ray-cast -- aborting grapple operation`);
                    return;
                }
                const block = blockHit.block;
                let oneStepBack = server_namespaceObject.Vector.subtract(block.location, viewVector);
                let iterations = 0;
                while (Math.floor(oneStepBack.x) === block.location.x && Math.floor(oneStepBack.y) === block.location.y && Math.floor(oneStepBack.z) === block.location.z) {
                    oneStepBack = server_namespaceObject.Vector.subtract(oneStepBack, viewVector);
                    if (++iterations > 5) {
                        break;
                    }
                }
                op.end = new server_namespaceObject.Vector(Math.floor(oneStepBack.x), Math.floor(oneStepBack.y), Math.floor(oneStepBack.z));
                op.previous = op.start;
                op.viewX = viewVector.x;
                op.viewY = viewVector.y;
                server_namespaceObject.system.run(onGrappleTick);
            }
        });
        uiSession.inputManager.registerKeyBinding(server_editor_namespaceObject.EditorInputContext.GlobalToolMode, grappleAction, server_editor_namespaceObject.KeyboardKey.KEY_G, server_editor_namespaceObject.InputModifier.None);
        return [];
    }), (uiSession => {
        uiSession.log.debug(`Shutting down ${uiSession.extensionContext.extensionName} extension`);
    }));
}

const DimensionIds = {
    "minecraft:overworld": 0,
    "minecraft:nether": -1,
    "minecraft:the_end": 1
};

const PlayerPosition_TicksRefreshRate = 5;

function getDimensionName(dimensionId) {
    for (const key in DimensionIds) {
        const value = DimensionIds[key];
        if (value === dimensionId) {
            return key;
        }
    }
    return "minecraft:overworld";
}

function movePlayer(location, extensionContext, dimensionId = Number.MIN_SAFE_INTEGER) {
    const player = extensionContext.player;
    const targetDimension = dimensionId !== Number.MIN_SAFE_INTEGER ? server_namespaceObject.world.getDimension(getDimensionName(dimensionId)) : player.dimension;
    const rotation = player.getRotation();
    player.teleport(location, {
        dimension: targetDimension,
        rotation,
        keepVelocity: false
    });
}

const updateStatusBarText = (statusBarItem, location) => {
    statusBarItem.text = `Pos (${Math.floor(location.x)},${Math.floor(location.y)},${Math.floor(location.z)})`;
};

function registerPlayerPositionExtension() {
    (0, server_editor_namespaceObject.registerEditorExtension)("PlayerPosition", (uiSession => {
        uiSession.log.debug(`Initializing ${uiSession.extensionContext.extensionName} extension`);
        uiSession.scratchStorage = {
            isDisposed: false,
            latestRunId: -1
        };
        const player = uiSession.extensionContext.player;
        let currentLocation = player.location;
        const pane = uiSession.createPropertyPane({
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("playerPositionExtension.pane"),
            titleAltText: "Player Settings"
        });
        const playerPosition = (0, server_editor_namespaceObject.bindDataSource)(pane, {
            position: {
                x: 0,
                y: 0,
                z: 0
            },
            dimensionId: DimensionIds[player.dimension.id]
        });
        const subPaneDimension = pane.createPropertyPane({
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("playerPositionExtension.worldSettings"),
            titleAltText: "World Settings"
        });
        subPaneDimension.addDropdown(playerPosition, "dimensionId", {
            titleStringId: (0, server_editor_namespaceObject.getLocalizationId)("playerPositionExtension.dimension"),
            titleAltText: "Dimension",
            dropdownItems: [ {
                displayAltText: "Overworld",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("playerPositionExtension.overworld"),
                value: DimensionIds["minecraft:overworld"]
            }, {
                displayAltText: "Nether",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("playerPositionExtension.nether"),
                value: DimensionIds["minecraft:nether"]
            }, {
                displayAltText: "The End",
                displayStringId: (0, server_editor_namespaceObject.getLocalizationId)("playerPositionExtension.theEnd"),
                value: DimensionIds["minecraft:the_end"]
            } ],
            onChange: (_obj, _property, _oldValue, _newValue) => {
                movePlayer(player.location, uiSession.extensionContext, playerPosition.dimensionId);
            }
        });
        const positionStatusItem = uiSession.createStatusBarItem(server_editor_namespaceObject.EditorStatusBarAlignment.Left, 30);
        updateStatusBarText(positionStatusItem, currentLocation);
        let ticks = 0;
        const onTick = () => {
            if (ticks++ % PlayerPosition_TicksRefreshRate === 0) {
                ticks = 0;
                const playerLoc = vector_utils_Vector3Utils.floor(player.location);
                if (!vector_utils_Vector3Utils.equals(playerLoc, currentLocation)) {
                    currentLocation = playerLoc;
                    updateStatusBarText(positionStatusItem, currentLocation);
                }
            }
            if (uiSession.scratchStorage && !uiSession.scratchStorage.isDisposed) {
                uiSession.scratchStorage.latestRunId = server_namespaceObject.system.run(onTick);
            }
        };
        uiSession.scratchStorage.latestRunId = server_namespaceObject.system.run(onTick);
        return [];
    }), (uiSession => {
        if (uiSession.scratchStorage && uiSession.scratchStorage.latestRunId !== -1) {
            uiSession.scratchStorage.isDisposed = true;
            server_namespaceObject.system.clearRun(uiSession.scratchStorage.latestRunId);
        }
        uiSession.log.debug(`Shutting down ${uiSession.extensionContext.extensionName} extension`);
    }), {
        description: "Keeps track of player position and allow to modify it into the pane."
    });
}

registerCoreEditorExtension();

registerPlayerPositionExtension();

registerGrappleExtension();

registerCubeBrushExtension();