#include <amxmodx>
#include <amxmisc>
#include <authemu>

new const VERSION[] = "1.0";
new const g_szCfgFile[] = "authemu.ini";

enum
{
	SECTION_NONE,
	SECTION_LOG,
	SECTION_PUNISH
};

const TASK_PUNISH_ID = 548678;

new g_iPunishDetect, g_iLogDetect, g_iPunishTime;
new g_szPunishReason[64], g_szPunishString[192], g_szLogString[192];

public plugin_init()
{
	register_plugin("AuthEmu API", VERSION, "Dev-MS Team");

	register_concmd("aemuinfo", "cmdClientInfo", ADMIN_BAN, "<name or #userid>");
	register_concmd("aemulist", "cmdClientList", ADMIN_BAN);

	ReadCfg();
}

public client_disconnected(id)
{
	remove_task(id + TASK_PUNISH_ID);
}

public aemu_dac_query(const id, const DAC_QueryType:type)
{
	switch (type)
	{
		case DAC_QUERY_DETECT:
		{
			new iDacReason = aemu_dac_get_reason();

			if (g_iLogDetect)
			{
				new szModulePath[128], szModuleHash[32]

				aemu_dac_get_module(szModulePath, sizeof(szModulePath), true);
				formatex(szModuleHash, charsmax(szModuleHash), "%X", aemu_dac_get_module_hash());

				LogDetect(id, iDacReason, szModulePath, szModuleHash);
			}

			if (g_iPunishDetect && iDacReason < 10)
			{
				remove_task(id + TASK_PUNISH_ID);
				set_task(10.0, "TaskPunishPlayer", id + TASK_PUNISH_ID);
			}
		}
	}

	return PLUGIN_CONTINUE;
}

public TaskPunishPlayer(id)
{
	id -= TASK_PUNISH_ID;

	PunishPlayer(id);
}

public cmdClientInfo(id, level, cid)
{
	if (!cmd_access(id, level, cid, 2))
		return PLUGIN_HANDLED;

	new arg[32];
	read_argv(1, arg, charsmax(arg));
	new player = cmd_target(id, arg, CMDTARGET_NO_BOTS);

	if (!player)
		return PLUGIN_HANDLED

	// It's authemu client?
	if (!is_user_authemu(player))
	{
		console_print(id, "  clientinfo: This target:(%i) isn't it authemu client.", player);
		return PLUGIN_HANDLED;
	}

	// Print client info
	console_print(id, "^nClient info:");

	new szDate[64], szTag[64], szUIDHash[11];
	format_time(szDate, charsmax(szDate), "%X %b %d %Y", aemu_get_clientinfo(player, aci_lasttime_upd));
	aemu_get_clientinfo(player, aci_tag, szTag, charsmax(szTag));
	aemu_get_clientinfo(player, aci_unique_id, szUIDHash, charsmax(szUIDHash));

	console_print(id, "  Build: %i (%X) (%s) - %s", aemu_get_clientinfo(player, aci_build), aemu_get_clientinfo(player, aci_hash), szDate, szTag);
	console_print(id, "  Steam: %s", aemu_get_clientinfo(player, aci_steam) ? "Yes" : "No");
	console_print(id, "  Beta:  %s", aemu_get_clientinfo(player, aci_beta) ? "Yes" : "No");
	console_print(id, "  UID:   %s", szUIDHash);

	// Print desktop screen info
	console_print(id, "^nScreen info:");

	new wide, tall;
	aemu_get_desk_screeninfo(player, wide, tall);
	console_print(id, "  %ix%i (Desktop)", wide, tall);

	aemu_get_game_screeninfo(player, wide, tall);
	console_print(id, "  %ix%i (Game)", wide, tall);

	// Print OS info
	console_print(id, "^nOS info:");
	console_print(id, "  Type %i", aemu_get_clientinfo(player, aci_OS_type));

	new szOSName[32];
	aemu_get_clientinfo(player, aci_OS_name, szOSName, charsmax(szOSName));
	console_print(id, "  Name: %s", szOSName);
	console_print(id, "  Build %i", aemu_get_clientinfo(player, aci_OS_build));
	console_print(id, "  Major %i", aemu_get_clientinfo(player, aci_OS_majorVersion));
	console_print(id, "  Minor %i", aemu_get_clientinfo(player, aci_OS_minorVersion));

	return PLUGIN_HANDLED;
}

public cmdClientList(id, level, cid)
{
	if (!cmd_access(id, level, cid, 1))
		return PLUGIN_HANDLED;

	new szName[32], szIp[22], szTime[6];
	console_print(id, "^n^n------------------------------------------------------------------------------^n");
	console_print(id, "%-2s %-32s %-6s %-5s %-21s %s", "#", "Name", "Userid", "Time", "IP", "Authemu");
	for (new i = 1; i <= get_maxplayers(); i++)
	{
		if (!is_user_connecting(i) && !is_user_connected(i))
			continue;

		get_user_name(i, szName, charsmax(szName));
		get_user_ip(i, szIp, charsmax(szIp));
		get_user_play_time(i, szTime, charsmax(szTime));

		console_print(id, "%-2i %-32s %-6i %-5s %-21s %s", i, szName, get_user_userid(i), szTime, szIp, is_user_authemu(i) ? "yes" : "no");
	}

	console_print(id, "^n------------------------------------------------------------------------------^n^n");
	return PLUGIN_HANDLED;
}

stock PunishPlayer(const id)
{
	new szUserId[10], szSteam[33], szIp[17], szTime[10], szPunishString[128];

	formatex(szUserId, charsmax(szUserId), "#%d", get_user_userid(id));

	get_user_authid(id, szSteam, charsmax(szSteam));
	get_user_ip(id, szIp, charsmax(szIp), 1);

	num_to_str(g_iPunishTime, szTime, charsmax(szTime));

	copy(szPunishString, charsmax(szPunishString), g_szPunishString);

	replace_string(szPunishString, charsmax(szPunishString), "[userid]", szUserId);
	replace_string(szPunishString, charsmax(szPunishString), "[steam]", szSteam);
	replace_string(szPunishString, charsmax(szPunishString), "[ip]", szIp);
	replace_string(szPunishString, charsmax(szPunishString), "[reason]", g_szPunishReason);
	replace_string(szPunishString, charsmax(szPunishString), "[time]", szTime);

	server_cmd("%s", szPunishString);
}

stock LogDetect(const id, iDacReason, szModulePath[], szModuleHash[])
{
	new szFile[32], szDacReason[10], szName[32], szSteam[33], szIp[17], szUniqId[65], szLogString[512];

	get_user_name(id, szName, charsmax(szName));
	get_user_authid(id, szSteam, charsmax(szSteam));
	get_user_ip(id, szIp, charsmax(szIp), 1);

	formatex(szDacReason, charsmax(szDacReason), "%i", iDacReason);
	copy(szLogString, charsmax(szLogString), g_szLogString);

	aemu_get_clientinfo(id, aci_unique_id, szUniqId);

	replace_string(szLogString, charsmax(szLogString), "[name]", szName);
	replace_string(szLogString, charsmax(szLogString), "[steam]", szSteam);
	replace_string(szLogString, charsmax(szLogString), "[ip]", szIp);
	replace_string(szLogString, charsmax(szLogString), "[uniqId]", szUniqId);
	replace_string(szLogString, charsmax(szLogString), "[reason]", szDacReason);
	replace_string(szLogString, charsmax(szLogString), "[module]", szModulePath);
	replace_string(szLogString, charsmax(szLogString), "[hash]", szModuleHash);

	get_time("AuthEmu_%Y%m%d.log", szFile, charsmax(szFile));
	log_to_file(szFile, "%s", szLogString);
}

stock get_user_play_time(id, dest[], const length)
{
	new iMinutes = get_user_time(id) / 60;
	new iSeconds = get_user_time(id) % 60;

	new minutes[3], seconds[3], temp[2];
	num_to_str(iMinutes, temp, sizeof(temp));

	if (iMinutes >= 10)
	{
		minutes[0] = temp[0];
		minutes[1] = temp[1];
	}
	else
	{
		minutes[0] = '0';
		minutes[1] = temp[0];
	}

	minutes[2] = '^0';

	num_to_str(iSeconds, temp, sizeof(temp));
	if (iSeconds >= 10)
	{
		seconds[0] = temp[0];
		seconds[1] = temp[1];
	}
	else
	{
		seconds[0] = '0';
		seconds[1] = temp[0];
	}

	seconds[2] = '^0';

	formatex(dest, length, "%s:%s", minutes, seconds);
}

stock ReadCfg()
{
	new iSection, szKey[128], szValue[1024];
	new szFile[250], szConfigDir[64], szTemp[1024];

	get_localinfo("amxx_configsdir", szConfigDir, charsmax(szConfigDir));
	formatex(szFile, charsmax(szFile), "%s/%s", szConfigDir, g_szCfgFile);

	new fHandle = fopen(szFile, "rt");

	while (!feof(fHandle))
	{
		fgets(fHandle, szTemp, charsmax(szTemp));
		trim(szTemp);

		if (szTemp[0] == '[')
		{
			GetCurrentSection(szTemp, iSection);
			continue;
		}

		if (!szTemp[0] || szTemp[0] == ';' || szTemp[0] == '/') continue;

		strtok(szTemp, szKey, charsmax(szKey), szValue, charsmax(szValue), '=');
		trim(szKey);
		trim(szValue);

		switch (iSection)
		{
			case SECTION_LOG:
			{
				if (equal(szKey, "LOG_DETECT"))
					g_iLogDetect = str_to_num(szValue);
				else if (equal(szKey, "LOG_STRING"))
					copy(g_szLogString, charsmax(g_szLogString), szValue);
			}
			case SECTION_PUNISH:
			{
				if (equal(szKey, "PUNISH"))
					g_iPunishDetect = str_to_num(szValue);

				else if (equal(szKey, "REASON"))
					copy(g_szPunishReason, charsmax(g_szPunishReason), szValue);

				else if (equal(szKey, "TIME"))
					g_iPunishTime = str_to_num(szValue);

				else if (equal(szKey, "CMD"))
					copy(g_szPunishString, charsmax(g_szPunishString), szValue);
			}
		}
	}

	fclose(fHandle);
}

stock GetCurrentSection(szTemp[1024], &iSection)
{
	if (contain(szTemp, "LOG") != -1)
		iSection = SECTION_LOG;
	else if (contain(szTemp, "PUNISH") != -1)
		iSection = SECTION_PUNISH;
}
