#pragma semicolon 1

#define TOGGLE_PLUGINS
#define PLAY_SOUND

#include <amxmodx>
#include <hamsandwich>
#include <reapi>

#define TASK_ID_TIMER 1
#define TASK_ID_FINISH 2

enum _:ITEM {
	WeaponIdType:ITEM_ID,
	ITEM_TITLE[32]
};

new const ITEMS[][ITEM] = {
	{WEAPON_M4A1, "M4A1"},
	{WEAPON_AK47, "AK-47"},
	{WEAPON_MP5N, "МP5"},
	{WEAPON_SG550, "SG-550"},
	{WEAPON_FAMAS, "Famas"},
	{WEAPON_SCOUT, "SCOUT"},
	{WEAPON_XM1014, "XM1014"},
	{WEAPON_M3, "M3"},
};


#if defined PLAY_SOUND
new const SOUNDS[][] = { 
	"sound/rww/RoundStart.mp3",

};
#endif

#if defined TOGGLE_PLUGINS
new const PLUGINS[][] = {
	"test.amxx"
};
#endif

enum {
	SPAWN,
	ON_SPAWN_EQUIP,
	HAS_RESTRICT_ITEM,
	DROP_PLAYER_ITEM,
	ADD_PLAYER_ITEM,
	DEAD_PLAYER_WEAPONS,
	GIVE_C4,
	KILLED,

	HOOK_CHAIN_LAST // DO NOT EDIT
};

enum {
	GAME_PLAYER_EQUIP,
	PLAYE_WEAPON_STRIP,
	ARMOURY_ENTITY,

	HAM_HOOKS_LAST // DO NOT EDIT
};

new HookChain:roundEndPre, HookChain:addAccount;
new HookChain:hookChains[HOOK_CHAIN_LAST], HamHook:hamForwards[HAM_HOOKS_LAST];

new mp_round_infinite, round_infinite[32];
new mp_forcerespawn, forcerespawn;
new mp_respawn_immunitytime, respawn_immunitytime;
new csstats_pause, aes_track_pause;
new warmUpTime, warmUpMode, warmUpReward;

new bool:enabled = false;
new timer, hudSync, hudSyncStats;
#if defined PLAY_SOUND
new sounds[sizeof(SOUNDS)], soundsNum = 0;
#endif
new item, WeaponIdType:itemId, itemName[32], itemTitle[32];
new kills[MAX_PLAYERS + 1];

#if defined PLAY_SOUND
public plugin_precache() {
	for (new i = 0; i < sizeof(SOUNDS); i++) {
		if (file_exists(SOUNDS[i], true)) {
			precache_generic(SOUNDS[i]);
			sounds[soundsNum++] = i;
		}
	}
}
#endif

public plugin_init() {
	register_plugin("[ReAPI] WurmUp", "0.3", "F@nt0M & h1k3");

	roundEndPre = RegisterHookChain(RG_RoundEnd, "RoundEnd_Pre", false);
	addAccount = RegisterHookChain(RG_CBasePlayer_AddAccount, "CBasePlayer_AddAccount_Pre", false);

	hookChains[SPAWN] = RegisterHookChain(RG_CBasePlayer_Spawn, "CBasePlayer_Spawn_Post", true);
	hookChains[ON_SPAWN_EQUIP] = RegisterHookChain(RG_CBasePlayer_OnSpawnEquip, "CBasePlayer_OnSpawnEquip_Pre", false);
	hookChains[HAS_RESTRICT_ITEM] = RegisterHookChain(RG_CBasePlayer_HasRestrictItem, "CBasePlayer_HasRestrictItem_Pre", false);
	hookChains[DROP_PLAYER_ITEM] = RegisterHookChain(RG_CBasePlayer_DropPlayerItem, "CBasePlayer_DropPlayerItem_Pre", false);
	hookChains[ADD_PLAYER_ITEM] = RegisterHookChain(RG_CBasePlayer_AddPlayerItem, "CBasePlayer_AddPlayerItem_Pre", false);
	hookChains[DEAD_PLAYER_WEAPONS] = RegisterHookChain(RG_CSGameRules_DeadPlayerWeapons, "CSGameRules_DeadPlayerWeapons_Pre", false);
	hookChains[GIVE_C4] = RegisterHookChain(RG_CSGameRules_GiveC4, "CSGameRules_GiveC4_Pre", false);
	hookChains[KILLED] = RegisterHookChain(RG_CBasePlayer_Killed, "CBasePlayer_Killed_Post", true);

	hamForwards[GAME_PLAYER_EQUIP] = RegisterHam(Ham_Use, "game_player_equip", "HamHookSupercede", false);
	hamForwards[PLAYE_WEAPON_STRIP] = RegisterHam(Ham_Use, "player_weaponstrip", "HamHookSupercede", false);
	hamForwards[ARMOURY_ENTITY] = RegisterHam(Ham_CS_Restart, "armoury_entity", "HamHookSupercede", false);

	// Toggle_Forwards(false);

	mp_round_infinite = get_cvar_pointer("mp_round_infinite");
	mp_forcerespawn = get_cvar_pointer("mp_forcerespawn");
	mp_respawn_immunitytime = get_cvar_pointer("mp_respawn_immunitytime");
	csstats_pause = get_cvar_pointer("csstats_pause");
	aes_track_pause = get_cvar_pointer("aes_track_pause");

	hudSync = CreateHudSyncObj();
	hudSyncStats = CreateHudSyncObj();

	Hide_ArmouryEntity();
	BuyZone_ToogleSolid(SOLID_NOT);

	warmUpTime = create_cvar("warmup_time", "60", .has_min = true, .min_val = 0.0);
	warmUpMode = create_cvar("warmup_mode", "0", .has_min = true, .min_val = 0.0, .has_max = true, .max_val = 1.0);
	warmUpReward = create_cvar("warmup_reward", "0", .has_min = true, .min_val = 0.0);
}

public plugin_pause() {
	if (!enabled) {
		return;
	}

	Toggle_Cvars(false);
	Toggle_Forwards(false);
#if defined TOGGLE_PLUGINS
	Toggle_Plugins(true);
#endif
	BuyZone_ToogleSolid(SOLID_TRIGGER);

	DisableHookChain(roundEndPre);

	set_member_game(m_bCompleteReset, true);
	set_member_game(m_bGameStarted, true);
	rg_round_end(0.1, WINSTATUS_DRAW, ROUND_GAME_COMMENCE, "");

	Players_GiveItems(true);

	DisableHookChain(addAccount);

	remove_task(TASK_ID_TIMER);
	remove_task(TASK_ID_FINISH);
}

public RoundEnd_Pre(const WinStatus:status, const ScenarioEventEndRound:event) {
	#pragma unused status
	if (event != ROUND_GAME_COMMENCE) {
		return HC_CONTINUE;
	}

	new time = get_pcvar_num(warmUpTime);
	if (time == 0) {
		DisableHookChain(roundEndPre);
		DisableHookChain(addAccount);
		return HC_CONTINUE;
	}

	enabled = true;

	Prepare_Item();

	Toggle_Cvars(true);
#if defined TOGGLE_PLUGINS
	Toggle_Plugins(false);
#endif
	Players_GiveItems(false);

	arrayset(kills, 0, sizeof(kills));
#if defined PLAY_SOUND
	Send_Audio();
#endif
	set_task(1.0, "TaskTimer", TASK_ID_TIMER, .flags = "a", .repeat = time);
	timer = time;
	
	SetHookChainReturn(ATYPE_BOOL, false);
	return HC_SUPERCEDE;
}

public CBasePlayer_AddAccount_Pre(const id, const amount, const RewardType:type) {
	if (get_pcvar_num(warmUpTime) == 0) {
		return HC_CONTINUE;
	}

	switch (type) {
		case RT_PLAYER_RESET:  {
			new reward = get_pcvar_num(warmUpReward);
			if (reward > 0) {
				SetHookChainArg(2, ATYPE_INTEGER, amount + (kills[id] * reward));
			}
		}
		case RT_PLAYER_JOIN: {
			SetHookChainArg(2, ATYPE_INTEGER, 0);
		}
		case RT_ENEMY_KILLED: {
			SetHookChainArg(2, ATYPE_INTEGER, 1);
		}
	}
	return HC_CONTINUE;
}

public CBasePlayer_Spawn_Post(const id) {
	if (is_user_alive(id)) {
		Player_GiveItem(id);
	}
}

public CBasePlayer_OnSpawnEquip_Pre(const id) {
	return HC_SUPERCEDE;
}

public CBasePlayer_HasRestrictItem_Pre() {
	SetHookChainReturn(ATYPE_BOOL, true);
	return HC_SUPERCEDE;
}

public CBasePlayer_DropPlayerItem_Pre() {
	SetHookChainReturn(ATYPE_INTEGER, 0);
	return HC_SUPERCEDE;
}

public CBasePlayer_AddPlayerItem_Pre() {
	SetHookChainReturn(ATYPE_INTEGER, 0);
	return HC_SUPERCEDE;
}

public CSGameRules_DeadPlayerWeapons_Pre() {
	SetHookChainReturn(ATYPE_INTEGER, GR_PLR_DROP_GUN_NO);
}

public CSGameRules_GiveC4_Pre() {
	return HC_SUPERCEDE;
}

public CBasePlayer_Killed_Post(const id, const killer) {
	if (id != killer && is_user_connected(killer)) {
		kills[killer]++;
	}
}

public HamHookSupercede() {
	return HAM_SUPERCEDE;
}

public TaskTimer() {
	timer--;
	if (timer > 0) {
		set_hudmessage(135, 206, 235, .x = -1.0, .y = 0.08, .holdtime = 0.9, .channel = -1);
		ShowSyncHudMsg(0, hudSync, "Разминка на %s!^nРестарт через %d сек", itemTitle, timer);

		if (csstats_pause || aes_track_pause) {
			set_hudmessage(255, 0, 0, .x = -1.0, .y = 0.05, .holdtime = 0.9, .channel = -1);
			ShowSyncHudMsg(0, hudSyncStats, "[Статистика Отключена]");
		}
	} else {
		BuyZone_ToogleSolid(SOLID_TRIGGER);
		Toggle_Cvars(false);
#if defined TOGGLE_PLUGINS
		Toggle_Plugins(true);
#endif
		Toggle_Forwards(false);
		Players_GiveItems(true);
		set_task(0.2, "TaskFinish", TASK_ID_FINISH);

		DisableHookChain(roundEndPre);
		set_member_game(m_bCompleteReset, true);
		set_member_game(m_bGameStarted, true);
		rg_round_end(0.1, WINSTATUS_DRAW, ROUND_GAME_COMMENCE, "");
	}
}

public TaskFinish() {
	set_hudmessage(135, 206, 235, .x = -1.0, .y = 0.08, .holdtime = 5.0, .channel = -1);
	ShowSyncHudMsg(0, hudSync, "Разминка окончена!");

	if (csstats_pause || aes_track_pause) {
		set_hudmessage(255, 0, 0, .x = -1.0, .y = 0.05, .holdtime = 5.0, .channel = -1);
		ShowSyncHudMsg(0, hudSyncStats, "[Статистика Включена]");
	}

	DisableHookChain(addAccount);
	enabled = false;
}

Toggle_Forwards(const bool:enable) {
	for (new i = 0; i < HOOK_CHAIN_LAST; i++) {
		if (enable) {
			EnableHookChain(hookChains[i]);
		} else {
			DisableHookChain(hookChains[i]);
		}
	}
	for (new i = 0; i < HAM_HOOKS_LAST; i++) {
		if (enable) {
			EnableHamForward(hamForwards[i]);
		} else {
			DisableHamForward(hamForwards[i]);
		}
	}
}

Toggle_Cvars(const bool:enable) {
	if (enable) {
		get_pcvar_string(mp_round_infinite, round_infinite, charsmax(round_infinite));
		set_pcvar_string(mp_round_infinite, "1");

		forcerespawn = get_pcvar_num(mp_forcerespawn);
		set_pcvar_num(mp_forcerespawn, 3);

		respawn_immunitytime = get_pcvar_num(mp_respawn_immunitytime);
		set_pcvar_num(mp_respawn_immunitytime, 3);

		if (csstats_pause) {
			set_pcvar_num(csstats_pause, 1);
		}

		if (aes_track_pause) {
			set_pcvar_num(aes_track_pause, 1);
		}
	} else {
		set_pcvar_string(mp_round_infinite, round_infinite);
		set_pcvar_num(mp_forcerespawn, forcerespawn);
		set_pcvar_num(mp_respawn_immunitytime, respawn_immunitytime);

		if (csstats_pause) {
			set_pcvar_num(csstats_pause, 0);
		}

		if (aes_track_pause) {
			set_pcvar_num(aes_track_pause, 0);
		}
	}
}

#if defined TOGGLE_PLUGINS
Toggle_Plugins(const bool:enable) {
	for (new i = 0; i < sizeof(PLUGINS); i++) {
		if (enable) {
			unpause("ac", PLUGINS[i]);
		} else {
			pause("ac", PLUGINS[i]);
		}
	}
}
#endif

Players_GiveItems(const bool:defaultItems) {
	new players[MAX_PLAYERS], num;
	get_players(players, num, "ah");
	for (new i = 0, player; i < num; i++) {
		player = players[i];

		rg_remove_all_items(player);
		if (defaultItems) {
			rg_give_default_items(player);
		} else {
			Player_GiveItem(player);
		}
	}
}

Player_GiveItem(const id) {
	DisableHookChain(HookChain:hookChains[ADD_PLAYER_ITEM]);
	rg_give_item(id, "weapon_knife", GT_APPEND);
	new ent = rg_give_item(id, itemName, GT_APPEND);
	if (ent > 0) {
		rg_set_user_bpammo(id, itemId, rg_get_iteminfo(ent, ItemInfo_iMaxAmmo1));
	}
	EnableHookChain(HookChain:hookChains[ADD_PLAYER_ITEM]);
}

Hide_ArmouryEntity() {
	new ent = NULLENT;
	while ((ent = rg_find_ent_by_class(ent, "armoury_entity"))) {
		if(get_member(ent, m_Armoury_iCount) > 0) {
			set_entvar(ent, var_effects, get_entvar(ent, var_effects) | EF_NODRAW);
			set_entvar(ent, var_solid, SOLID_NOT);
			set_member(ent, m_Armoury_iCount, 0);
		}
	}
}

BuyZone_ToogleSolid(const solid) {
	new ent = NULLENT;
	while ((ent = rg_find_ent_by_class(ent, "func_buyzone"))) {
		set_entvar(ent, var_solid, solid);
	}
}

Prepare_Item() {
	new lastItemStr[3], lastItem;
	if (get_localinfo("warmup_last_item", lastItemStr, charsmax(lastItemStr))) {
		lastItem = str_to_num(lastItemStr);
	} else {
		lastItem = -1;
	}

	switch (get_pcvar_num(warmUpMode)) {
		case 1: {
			item = (lastItem + 1) % sizeof(ITEMS);
		}

		default: {
			new tries = 0;
			do {
				item = random(100) % sizeof(ITEMS);
			} while (item == lastItem && tries < sizeof(ITEMS));
		}
	}

	itemId = ITEMS[item][ITEM_ID];
	rg_get_weapon_info(itemId, WI_NAME, itemName, charsmax(itemName));
	copy(itemTitle, charsmax(itemTitle), ITEMS[item][ITEM_TITLE]);

	num_to_str(item, lastItemStr, charsmax(lastItemStr));
	set_localinfo("warmup_last_item", lastItemStr);
}

#if defined PLAY_SOUND
Send_Audio() {
	if (soundsNum > 0) {
		new sound = (soundsNum > 1) ? sounds[random(100) % soundsNum] : 0;
		client_cmd(0, "mp3 play ^"%s^"", SOUNDS[sound]);
	}
}
#endif