// Copyright © 2017 Vaqtincha

/**
*	Credits:
*
*	- s1lent - for original plugin "Items Restrict"
*/

/* Default restrict flags:
	"a" = buying
	"b" = touching
	"c" = equipping
*/
new const DEFAULT_FLAGS[4] = "abc"
// #define DEBUG_INFO


#include <amxmodx>
#include <reapi>


#define PL_VERSION 				"0.0.4"


#define IsValidFlag(%1)  		(RESTRICT_FLAG_BUY <= %1 <= RESTRICT_FLAG_ALL) // (%1 < 1 || %1 > 7 )
#define IsValidItem(%1)  		(ITEM_SHIELDGUN <= %1 <= ITEM_BATTERY && %1 != ITEM_GLOCK)
#define IsRestrictedItem(%1)	(g_bitItemFlags[%1] != RESTRICT_FLAG_NONE)
#define HasFlag(%1,%2)			(g_bitItemFlags[%1] & (1 << any:%2)) // %1 ItemId, %2 ItemRestType

#define IsValidAmmo(%1) 			(1 <= %1 < MAX_AMMO_SLOTS)
#define GetAmmoType(%1) 			rg_get_weapon_info(%1, WI_AMMO_TYPE)
#define IsRestrictedAmmo(%1)		(g_bitRestrictedAmmo & (1 << %1))
#define PlayerHasMaxAmmo(%1,%2)		(get_member(%1, m_rgAmmo, %2) >= g_iMaxAmmoDefault[%2])

enum
{
	RESTRICT_FLAG_NONE 	= 0,
	RESTRICT_FLAG_BUY 	= (1 << any:ITEM_TYPE_BUYING), 	// a = 1
	RESTRICT_FLAG_TOUCH = (1 << any:ITEM_TYPE_TOUCHED),	// b = 2
	RESTRICT_FLAG_EQUIP = (1 << any:ITEM_TYPE_EQUIPPED) // c = 4
}

const RESTRICT_FLAG_ALL = (RESTRICT_FLAG_BUY | RESTRICT_FLAG_TOUCH | RESTRICT_FLAG_EQUIP) // abc = 7

const MAX_AMMO_SLOTS = 15 - 4

new HookChain:g_hookHasRestrictItem, HookChain:g_hookBuyGunAmmo
new Trie:g_tItemNames, Trie:g_tAmmoNames

new bool:g_bHasRestrictItem, g_iICounter
new bool:g_bBuyGunAmmo, g_iACounter

new g_bitItemFlags[any:ITEM_BATTERY + 1]
new g_bitRestrictedAmmo

new const g_iMaxAmmoDefault[MAX_AMMO_SLOTS] = { 
	-1, 30, 90, 200, 90, 32, 100, 100, 35, 52, 120 //, 2, 1, 1, 1
}

new const g_szValidItemNames[any:ITEM_BATTERY + 1][] = 
{
	// [weapons]
	"shield",
	"p228",
	"", 		// unused
	"scout",
	"hegren",	// hegrenade
	"xm1014",
	"c4",
	"mac10",
	"aug",
	"smoke",	// smokegrenade
	"elite",
	"fiveseven",
	"ump45",
	"sg550",
	"galil",
	"famas",
	"usp",
	"glock",	// glock18
	"awp",
	"mp5",		// mp5navy
	"m249",
	"m3",
	"m4a1",
	"tmp",
	"g3sg1",
	"flash",	// flashbang
	"deagle",
	"sg552",
	"ak47",
	"knife",
	"p90",
	// [items]
	"nvgs",		// nightvision
	"defuser",	
	"vest",		// kevlar
	"vesthelm",	// helmet
	"longjump",
	"soda",		
	"healthkit",
	"antidote",
	"battery"
}

new const g_szValidAmmoNames[MAX_AMMO_SLOTS][] = {
	"",
	"338Magnum",	// 1
	"762Nato",		// 2
	"556NatoBox",	// 3
	"556Nato",		// 4
	"buckshot",		// 5
	"45acp",		// 6
	"57mm",			// 7
	"50AE",			// 8
	"357SIG",		// 9
	"9mm"			// 10
	// ,"Flashbang", 	// 11
	// "HEGrenade",		// 12
	// "SmokeGrenade",	// 14
	// "C4"				// 15
}

public plugin_init()
{
	register_plugin("Items Restrict Ultimate", PL_VERSION, "Vaqtincha")

	register_concmd("amx_rest", "ConCmd_ManageItem", ADMIN_CFG, "- add/remove item to/from list")
	register_concmd("amx_restrict", "ConCmd_ManageItem", ADMIN_CFG, "- add/remove item to/from list")
	register_concmd("amx_restammo", "ConCmd_ManageAmmo", ADMIN_CFG, "- add/remove ammo to/from list")
	register_concmd("amx_restrictammo", "ConCmd_ManageAmmo", ADMIN_CFG, "- add/remove ammo to/from list")

	DisableHookChain(g_hookHasRestrictItem = RegisterHookChain(RG_CBasePlayer_HasRestrictItem, "CBasePlayer_HasRestrictItem", .post = false))
	DisableHookChain(g_hookBuyGunAmmo = RegisterHookChain(RG_BuyGunAmmo, "BuyGunAmmo", .post = false))

	g_tItemNames = TrieCreate()
	g_tAmmoNames = TrieCreate()

	for(new ItemID:iItemId = ITEM_SHIELDGUN; iItemId <= ITEM_BATTERY; iItemId++)
	{
		TrieSetCell(g_tItemNames, g_szValidItemNames[iItemId], iItemId)
	}

	for(new iAmmoId = 1; iAmmoId < MAX_AMMO_SLOTS; iAmmoId++)
	{
		strtolower(g_szValidAmmoNames[iAmmoId])
		TrieSetCell(g_tAmmoNames, g_szValidAmmoNames[iAmmoId], iAmmoId)
	}
}

public plugin_cfg()
{
	// admin.sma: set_task(6.1, "delayed_load") map extra config loading
	set_task(6.2, "MapExtraCfgLoaded") 
}

public MapExtraCfgLoaded() 
{
	I_CheckForward()
	A_CheckForward()
}

public plugin_end()
{
	if(g_tItemNames) {
		TrieDestroy(g_tItemNames)
	}
	if(g_tAmmoNames) {
		TrieDestroy(g_tAmmoNames)
	}
}

public BuyGunAmmo(const pPlayer, const pWeapon, const bool:blinkMoney)
{
	if(pWeapon <= 0)
		return HC_CONTINUE

	new iAmmoId = GetAmmoType(get_member(pWeapon, m_iId))

	if(IsValidAmmo(iAmmoId) && IsRestrictedAmmo(iAmmoId) && !PlayerHasMaxAmmo(pPlayer, iAmmoId))
	{
		client_print(pPlayer, print_center, "* Ammo %s is restricted! *", g_szValidAmmoNames[iAmmoId])
		
		SetHookChainReturn(ATYPE_INTEGER, false)
		return HC_SUPERCEDE
	}

	return HC_CONTINUE
}

public CBasePlayer_HasRestrictItem(const pPlayer, const ItemID:iItemId, const ItemRestType:iRestType)
{
	if(!IsValidItem(iItemId) || !IsRestrictedItem(iItemId))
		return HC_CONTINUE	

	if(HasFlag(iItemId, iRestType))
	{
		if(iRestType == ITEM_TYPE_BUYING) {
			client_print(pPlayer, print_center, "* Item %s is restricted! *", g_szValidItemNames[iItemId])
		}

		// return true, let's restrict up this item
		SetHookChainReturn(ATYPE_INTEGER, true)
		return HC_SUPERCEDE
	}
	
	return HC_CONTINUE
}

public ConCmd_ManageAmmo(const pPlayer, const level)
{
	if(pPlayer > 0 && !(get_user_flags(pPlayer) & level))
		return PLUGIN_HANDLED
	
	new szCommand[5], szAmmoName[12], iNumArgs = read_argc()

	read_argv(1, szCommand, charsmax(szCommand))
	if(iNumArgs == 2 && equali(szCommand, "list"))
	{
#if defined DEBUG_INFO
		console_print(pPlayer, "^nBuyGunAmmo Forward: %sABLED | Counter: %d | Bits: %d", g_bBuyGunAmmo ? "EN" : "DIS", g_iACounter, g_bitRestrictedAmmo)
#endif
		console_print(pPlayer, "^nRestricted ammo:^n %-4.5s %-10.11s", "id", "name")
		for(new iAmmoId = 1; iAmmoId < MAX_AMMO_SLOTS; iAmmoId++)
		{
			if(IsRestrictedAmmo(iAmmoId)) {
				console_print(pPlayer, " %-4.5d %-10.11s", iAmmoId, g_szValidAmmoNames[iAmmoId])
			}
		}
		return PLUGIN_HANDLED
	}
	else if(iNumArgs < 3)
	{
		console_print(pPlayer, "[Restrict] USAGE: amx_restrictammo <on|off> <ammoname|ammoid>")
		return PLUGIN_HANDLED
	}

	read_argv(2, szAmmoName, charsmax(szAmmoName))
	strtolower(szAmmoName)
	if(RestrictAmmo(szAmmoName, szCommand[1])) {
		A_CheckForward()
	}

	return PLUGIN_HANDLED
}

public ConCmd_ManageItem(const pPlayer, const level)
{
	if(pPlayer > 0 && !(get_user_flags(pPlayer) & level))
		return PLUGIN_HANDLED

	new szCommand[5], szItemName[12], szFlags[4], iNumArgs = read_argc()

	read_argv(1, szCommand, charsmax(szCommand))
	if(iNumArgs == 2 && equali(szCommand, "list"))
	{
#if defined DEBUG_INFO
		console_print(pPlayer,"^nHasRestrictItem Forward: %sABLED | Counter: %d", g_bHasRestrictItem ? "EN" : "DIS", g_iICounter)
		console_print(pPlayer, "^nRestricted items:^n %-4.5s %-10.11s %-6.7s %-5.6s", "id", "name", "flags", "bits")
#else
		console_print(pPlayer, "^nRestricted items:^n %-4.5s %-10.11s %-6.7s", "id", "name", "flags")
#endif
		for(new ItemID:iItemId = ITEM_SHIELDGUN; iItemId <= ITEM_BATTERY; iItemId++)
		{
			if(!IsValidItem(iItemId) || !IsRestrictedItem(iItemId))
				continue
	
			get_flags(g_bitItemFlags[iItemId], szFlags, charsmax(szFlags))
#if defined DEBUG_INFO
			console_print(pPlayer, " %-4.5d %-10.11s %-6.7s %-5.6d", iItemId, g_szValidItemNames[iItemId], szFlags, g_bitItemFlags[iItemId])
#else				
			console_print(pPlayer, " %-4.5d %-10.11s %-6.7s", iItemId, g_szValidItemNames[iItemId], szFlags)
#endif
		}
		return PLUGIN_HANDLED
	}
	else if(iNumArgs < 3)
	{
		console_print(pPlayer, "[Restrict] USAGE: amx_restrict <on|off> <itemname|itemid> <flags>")
		console_print(pPlayer, 
			"^nOptional restrict flags: (^"%s^" by default)	\
			 ^n ^"a^" = buying 								\
			 ^n ^"b^" = touching 							\
			 ^n ^"c^" = equipping", DEFAULT_FLAGS
		)
		return PLUGIN_HANDLED
	}
	
	read_argv(2, szItemName, charsmax(szItemName))
	if(iNumArgs == 4) {
		read_argv(3, szFlags, charsmax(szFlags)) // optional
	}

	strtolower(szItemName)
	if(RestrictItem(szItemName, szFlags[0] ? szFlags : DEFAULT_FLAGS, szCommand[1], bool:(iNumArgs == 4))) {
		I_CheckForward()
	}

	return PLUGIN_HANDLED
}

bool:RestrictItem(const szItemName[], const szFlags[], const ch, const bool:bitSet)
{
	new ItemID:iItemId = ITEM_NONE
	if(is_str_num(szItemName)) // add by item index
	{
		iItemId = any:str_to_num(szItemName)
		if(!IsValidItem(iItemId)) {
			server_print("[Restrict] ERROR: Invalid item id ^"%d^"", iItemId)
			return false
		}
	}
	else if(!szItemName[0] || !TrieGetCell(g_tItemNames, szItemName, iItemId)) // add by item name
	{
		server_print("[Restrict] ERROR: Invalid item name ^"%s^"", szItemName)
		return false
	}
	
	new iFlags = read_flags(szFlags)
	if(ch == 'n') // on
	{
		if(!IsValidFlag(iFlags)) {
			server_print("[Restrict] WARNING: Wrong flags ^"%s^" trying to set item ^"%s^"", szFlags, g_szValidItemNames[iItemId])
			server_print("[Restrict] INFO: Allowed flags ^"abc^"")
			return false
		}

		if((g_bitItemFlags[iItemId] & iFlags) == iFlags) {
			server_print("[Restrict] WARNING: Item ^"%s^" already restricted with this flags!", g_szValidItemNames[iItemId])
			return false
		}
		
		if(g_bitItemFlags[iItemId] == RESTRICT_FLAG_NONE) {
			g_iICounter++
		}

		g_bitItemFlags[iItemId] |= iFlags // set: g_bitItemFlags[iItemId] = iFlags
#if defined DEBUG_INFO
		server_print("[Restrict] INFO: Restrict item ^"%s^" id ^"%d^" with flags ^"%s^" bits ^"%d^" itembits ^"%d^"", g_szValidItemNames[iItemId], iItemId, szFlags, iFlags, g_bitItemFlags[iItemId])
#else
		server_print("[Restrict] INFO: Restrict item ^"%s^" with flags ^"%s^"", g_szValidItemNames[iItemId], szFlags)
#endif
		return true
	}
	else if(ch == 'f') // off
	{
		if(!IsRestrictedItem(iItemId)) {
			server_print("[Restrict] WARNING: Item ^"%s^" not restricted!", g_szValidItemNames[iItemId])
			return false
		}

		if(!bitSet)	// "amx_restrict off awp" = clear all bits 7 (flags "abc")
		{
			g_bitItemFlags[iItemId] = RESTRICT_FLAG_NONE
			server_print("[Restrict] INFO: Unrestrict item ^"%s^" id ^"%d^"", g_szValidItemNames[iItemId], iItemId)
		}
		else		// "amx_restrict off awp b" = clear bit 2 (flag "b" only)
		{
			if(!IsValidFlag(iFlags))
			{
				server_print("[Restrict] WARNING: Wrong flags ^"%s^" trying to unset item ^"%s^"", szFlags, g_szValidItemNames[iItemId])
				server_print("[Restrict] INFO: Allowed flags ^"abc^"")
				return false
			}
			if((g_bitItemFlags[iItemId] & iFlags) != iFlags)
			{
				server_print("[Restrict] WARNING: Item ^"%s^" not restricted with this flags!", g_szValidItemNames[iItemId])
				return false
			}

			g_bitItemFlags[iItemId] &= ~iFlags
#if defined DEBUG_INFO
			server_print("[Restrict] INFO: Unset item ^"%s^" flags ^"%s^" bits ^"%d^" itembits ^"%d^"", g_szValidItemNames[iItemId], szFlags, iFlags, g_bitItemFlags[iItemId])
#else
			server_print("[Restrict] INFO: Unset item ^"%s^" flags ^"%s^"", g_szValidItemNames[iItemId], szFlags)
#endif
		}

		if(g_bitItemFlags[iItemId] == RESTRICT_FLAG_NONE) {
			--g_iICounter
		}
		return true
	}
	return false
}

bool:RestrictAmmo(const szAmmoName[], const ch)
{
	new iAmmoId
	if(is_str_num(szAmmoName)) 	// add by ammo index
	{
		iAmmoId = str_to_num(szAmmoName)
		if(!IsValidAmmo(iAmmoId)) {
			server_print("[Restrict] ERROR: Invalid ammo id ^"%d^"", iAmmoId)
			return false
		}
	}
	else if(!szAmmoName[0] || !TrieGetCell(g_tAmmoNames, szAmmoName, iAmmoId)) // add by ammo name
	{
		server_print("[Restrict] ERROR: Invalid ammo name ^"%s^"", szAmmoName)
		return false
	}

	if(ch == 'n') // on
	{
		if(IsRestrictedAmmo(iAmmoId)) {
			server_print("[Restrict] WARNING: Ammo ^"%s^" already restricted!", g_szValidAmmoNames[iAmmoId])
			return false
		}
		
		server_print("[Restrict] INFO: Restrict ammo ^"%s^" id ^"%d^"", g_szValidAmmoNames[iAmmoId], iAmmoId)
		
		g_bitRestrictedAmmo |= (1 << iAmmoId)
		g_iACounter++

		return true
	}
	else if(ch == 'f') // off
	{
		if(!IsRestrictedAmmo(iAmmoId)) {
			server_print("[Restrict] WARNING: Ammo ^"%s^" not restricted!", g_szValidAmmoNames[iAmmoId])
			return false
		}
	
		server_print("[Restrict] INFO: Unrestrict ammo ^"%s^" id ^"%d^"", g_szValidAmmoNames[iAmmoId], iAmmoId)
		g_bitRestrictedAmmo &= ~(1 << iAmmoId)
		--g_iACounter

		return true
	}

	return false
}

I_CheckForward()
{
	if(g_iICounter > 0 && !g_bHasRestrictItem)
	{
		EnableHookChain(g_hookHasRestrictItem)
		g_bHasRestrictItem = true
#if defined DEBUG_INFO
		server_print("[Restrict] INFO: HasRestrictItem Forward: ENABLED!")
#endif
	}
	else if(g_iICounter <= 0 && g_bHasRestrictItem)
	{
		DisableHookChain(g_hookHasRestrictItem)
		g_bHasRestrictItem = false
		g_iICounter = 0
#if defined DEBUG_INFO
		server_print("[Restrict] INFO: HasRestrictItem Forward: DISABLED!")
#endif
	}
}

A_CheckForward()
{
	if(g_iACounter > 0 && !g_bBuyGunAmmo)
	{
		EnableHookChain(g_hookBuyGunAmmo)
		g_bBuyGunAmmo = true
#if defined DEBUG_INFO
		server_print("[Restrict] INFO: BuyGunAmmo Forward: ENABLED!")
#endif
	}
	else if(g_iACounter <= 0 && g_bBuyGunAmmo)
	{
		DisableHookChain(g_hookBuyGunAmmo)
		g_bBuyGunAmmo = false
		g_iACounter = 0
#if defined DEBUG_INFO
		server_print("[Restrict] INFO: BuyGunAmmo Forward: DISABLED!")
#endif
	}
}


