CREATE TABLE `csstats_maps` (
	`id`	INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT UNIQUE,
	`session_id`	INTEGER NOT NULL DEFAULT 0,
	`player_id`	INTEGER NOT NULL DEFAULT 0,
	`map`	TEXT NOT NULL,
	`skill`	REAL NOT NULL DEFAULT 0.0,
	`kills`	INTEGER NOT NULL DEFAULT 0,
	`deaths`	INTEGER NOT NULL DEFAULT 0,
	`hs`	INTEGER NOT NULL DEFAULT 0,
	`tks`	INTEGER NOT NULL DEFAULT 0,
	`shots`	INTEGER NOT NULL DEFAULT 0,
	`hits`	INTEGER NOT NULL DEFAULT 0,
	`dmg`	INTEGER NOT NULL DEFAULT 0,
	`bombdef`	INTEGER NOT NULL DEFAULT 0,
	`bombdefused`	INTEGER NOT NULL DEFAULT 0,
	`bombplants`	INTEGER NOT NULL DEFAULT 0,
	`bombexplosions`	INTEGER NOT NULL DEFAULT 0,
	`h_0`	INTEGER NOT NULL DEFAULT 0,
	`h_1`	INTEGER NOT NULL DEFAULT 0,
	`h_2`	INTEGER NOT NULL DEFAULT 0,
	`h_3`	INTEGER NOT NULL DEFAULT 0,
	`h_4`	INTEGER NOT NULL DEFAULT 0,
	`h_5`	INTEGER NOT NULL DEFAULT 0,
	`h_6`	INTEGER NOT NULL DEFAULT 0,
	`h_7`	INTEGER NOT NULL DEFAULT 0,
	`connection_time`	INTEGER NOT NULL DEFAULT 0,
	`connects`	INTEGER NOT NULL DEFAULT 0,
	`roundt`	INTEGER NOT NULL DEFAULT 0,
	`wint`	INTEGER NOT NULL DEFAULT 0,
	`roundct`	INTEGER NOT NULL DEFAULT 0,
	`winct`	INTEGER NOT NULL DEFAULT 0,
	`assists`	INTEGER NOT NULL DEFAULT 0,
	`first_join`	TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
	`last_join`	TIMESTAMP NOT NULL DEFAULT '0000-00-00 00:00:00'
);

CREATE TRIGGER `map_stats_insert` AFTER UPDATE ON `csstats` WHEN (SELECT 1 FROM `csstats_maps` WHERE `player_id` = NEW.`id` AND `session_id` = NEW.`session_id`) IS NULL
BEGIN
		INSERT INTO `csstats_maps` (
			`player_id`,
			`session_id`,
			`map`,
			`skill`,
			`kills`,
			`deaths`,
			`hs`,
			`tks`,
			`shots`,
			`hits`,
			`dmg`,
			`bombdef`,
			`bombdefused`,
			`bombplants`,
			`bombexplosions`,
			`h_0`,
			`h_1`,
			`h_2`,
			`h_3`,
			`h_4`,
			`h_5`,
			`h_6`,
			`h_7`,
			`connection_time`,
			`connects`,
			`roundt`,
			`wint`,
			`roundct`,
			`winct`,
			`assists`,
			`last_join`
		) VALUES (
			NEW.`id`,
			NEW.`session_id`,
			NEW.`session_map`,
			NEW.`skill` - OLD.`skill`,
			NEW.`kills` - OLD.`kills`,
			NEW.`deaths` - OLD.`deaths`,
			NEW.`hs`  - OLD.`hs`,
			NEW.`tks` - OLD.`tks`,
			NEW.`shots` - OLD.`shots`,
			NEW.`hits` - OLD.`hits`,
			NEW.`dmg` - OLD.`dmg`,
			NEW.`bombdef` - OLD.`bombdef`,
			NEW.`bombdefused` - OLD.`bombdefused`,
			NEW.`bombplants` - OLD.`bombplants`,
			NEW.`bombexplosions` - OLD.`bombexplosions`,
			NEW.`h_0` - OLD.`h_0`,
			NEW.`h_1` - OLD.`h_1`,
			NEW.`h_2` - OLD.`h_2`,
			NEW.`h_3` - OLD.`h_3`,
			NEW.`h_4` - OLD.`h_4`,
			NEW.`h_5` - OLD.`h_5`,
			NEW.`h_6` - OLD.`h_6`,
			NEW.`h_7` - OLD.`h_7`,
			NEW.`connection_time` - OLD.`connection_time`,
			NEW.`connects` - OLD.`connects`,
			NEW.`roundt` - OLD.`roundt`,
			NEW.`wint` - OLD.`wint`,
			NEW.`roundct` - OLD.`roundct`,
			NEW.`winct` - OLD.`winct`,
			NEW.`assists` - OLD.`assists`,
			CURRENT_TIMESTAMP
		);
END;

CREATE TRIGGER `map_stats_update` AFTER UPDATE ON `csstats` WHEN (SELECT 1 FROM `csstats_maps` WHERE `player_id` = NEW.`id` AND `session_id` = NEW.`session_id`) IS NOT NULL
BEGIN
		UPDATE `csstats_maps` SET
			`skill` = `skill` + (NEW.`skill` - OLD.`skill`),
			`kills` = `kills` + (NEW.`kills` - OLD.`kills`),
			`deaths` = `deaths` + (NEW.`deaths` - OLD.`deaths`),
			`hs` = `hs` + (NEW.`hs`  - OLD.`hs`),
			`tks` = `tks` + (NEW.`tks` - OLD.`tks`),
			`shots` = `shots`+ (NEW.`shots` - OLD.`shots`),
			`hits` = `hits` + (NEW.`hits` - OLD.`hits`),
			`dmg` = `dmg` + (NEW.`dmg` - OLD.`dmg`),
			`bombdef` = `bombdef` + (NEW.`bombdef` - OLD.`bombdef`),
			`bombdefused` = `bombdefused` + (NEW.`bombdefused` - OLD.`bombdefused`),
			`bombplants` = `bombplants` + (NEW.`bombplants` - OLD.`bombplants`),
			`bombexplosions` = `bombexplosions` + (NEW.`bombexplosions` - OLD.`bombexplosions`),
			`h_0` = `h_0` + (NEW.`h_0` - OLD.`h_0`),
			`h_1` = `h_1` + (NEW.`h_1` - OLD.`h_1`),
			`h_2` = `h_2` + (NEW.`h_2` - OLD.`h_2`),
			`h_3` = `h_3` + (NEW.`h_3` - OLD.`h_3`),
			`h_4` = `h_4` + (NEW.`h_4` - OLD.`h_4`),
			`h_5` = `h_5` + (NEW.`h_5` - OLD.`h_5`),
			`h_6` = `h_6` + (NEW.`h_6` - OLD.`h_6`),
			`h_7` = `h_7` + (NEW.`h_7` - OLD.`h_7`),
			`connection_time` = `connection_time` + (NEW.`connection_time` - OLD.`connection_time`),
			`connects` = `connects` + (NEW.`connects` - OLD.`connects`),
			`roundt` = `roundt` + (NEW.`roundt` - OLD.`roundt`),
			`wint` = `wint` + (NEW.`wint` - OLD.`wint`),
			`roundct` = `roundct` + (NEW.`roundct` - OLD.`roundct`),
			`winct` = `winct` + (NEW.`winct` - OLD.`winct`),
			`assists` = `assists` + (NEW.`assists` - OLD.`assists`),
			`last_join` = CURRENT_TIMESTAMP
		WHERE `player_id` = NEW.`id` AND `session_id` = NEW.`session_id`;
END;